/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.jreport;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import jet.datasource.JRUserDataSource;
import jet.datasource.JRUserDataSourceException;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.db.Connector;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.adapter.DBFactory;
import jet.server.db.core.ConnectorManager;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.MemResultSet;
import jet.server.log.ServiceLogger;

public class UDS4RptProfile
implements JRUserDataSource {
    private Connector BIGINT;
    private DBAdapter DOUBLE;
    private Connection INTEGER = null;
    private Statement QOIV = null;
    private ResultSet VARCHAR = null;
    private SimpleDateFormat add = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public void releaseResultSet() throws JRUserDataSourceException {
        if (this.VARCHAR != null) {
            try {
                this.VARCHAR.close();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
        }
        if (this.QOIV != null) {
            try {
                this.QOIV.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        if (this.INTEGER != null) {
            try {
                this.INTEGER.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ResultSet getResultSet(String string) throws JRUserDataSourceException {
        block16: {
            Object v0;
            Properties properties = UDS4RptProfile.BIGINT(string);
            String string2 = properties.getProperty("jdbc.driver");
            String string3 = properties.getProperty("jdbc.url");
            String string4 = properties.getProperty("jdbc.user");
            String string5 = properties.getProperty("jdbc.password");
            this.BIGINT = ConnectorManager.newInstance().getConnector(string2, string3, string4, string5);
            try {
                this.DOUBLE = DBFactory.create(this.BIGINT);
            }
            catch (InstantiationException instantiationException) {
                throw new JRUserDataSourceException(instantiationException.getMessage());
            }
            this.INTEGER = this.BIGINT.getConnection(10000L);
            this.QOIV = this.INTEGER.createStatement();
            this.QOIV.setEscapeProcessing(true);
            this.VARCHAR = this.query(properties);
            Object var9_9 = null;
            try {
                try {
                    this.QOIV.close();
                    v0 = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var12_15 = v0;
            try {
                this.INTEGER.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block16;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new JRUserDataSourceException(exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var9_10 = null;
                try {
                    try {
                        this.QOIV.close();
                        v1 = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                        v1 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var12_16 = v1;
                try {
                    this.INTEGER.close();
                }
                catch (Exception exception2) {
                    ServiceLogger.logError(exception2, 3);
                }
                throw throwable;
            }
        }
        return this.VARCHAR;
    }

    private static Properties BIGINT(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(16);
        Properties properties = new Properties();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("&", n)) != -1) {
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
        arrayList.add(string.substring(n));
        n = 0;
        while (n < arrayList.size()) {
            String string2 = (String)arrayList.get(n);
            n2 = string2.indexOf("=");
            if (n2 != -1) {
                properties.setProperty(string2.substring(0, n2), string2.substring(n2 + 1));
            }
            ++n;
        }
        return properties;
    }

    private ResultSet query(Properties properties) throws Exception {
        ResultSet resultSet = null;
        String string = properties.getProperty("query");
        Timestamp timestamp = new Timestamp(this.add.parse(properties.getProperty("start.time")).getTime());
        Timestamp timestamp2 = new Timestamp(this.add.parse(properties.getProperty("end.time")).getTime());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE TASKCONTEXT.TS_TSK_SUBMIT >= ").append(this.DOUBLE.formatValue(timestamp)).append(" AND TASKCONTEXT.TS_TSK_COMPLETE <= ").append(this.DOUBLE.formatValue(timestamp2));
        String string2 = stringBuffer.substring(0);
        stringBuffer.delete(0, stringBuffer.length());
        if (string.equalsIgnoreCase("QueryStat")) {
            stringBuffer.append("SELECT  COUNT(ID) AS NC_TSK_TOTALS,SUM(VI_TSK_STATUS) AS NC_TSK_SUCCESSFUL,SUM(VI_TSK_TYPE) AS NC_TSK_SCHEDULE,SUM(TC_TSK_TOTAL) AS SUM_TSKTIME_TOTAL,MAX(TC_TSK_TOTAL) AS MAX_TSKTIME_TOTAL,MIN(TC_TSK_TOTAL) AS MIN_TSKTIME_TOTAL,SUM(NC_RPT_FORMATS*NC_RPT_PAGES) AS SUM_PGS_TOTALS,MAX(NC_RPT_FORMATS*NC_RPT_PAGES) AS MAX_PGS_TOTALS,MIN(NC_RPT_FORMATS*NC_RPT_PAGES) AS MIN_PGS_TOTALS,SUM(TC_ENG_TOTAL) AS SUM_ENGTIME_TOTAL,MAX(TC_ENG_TOTAL) AS MAX_ENGTIME,MIN(TC_ENG_TOTAL) AS MIN_ENGTIME,SUM(TC_TSK_WAITED) AS SUM_TSKTIME_WAITED,MAX(TC_TSK_WAITED) AS MAX_TSKTIME_WAITED,MIN(TC_TSK_WAITED) AS MIN_TSKTIME_WAITED,SUM(NC_ENG_CONCURRENT) AS SUM_ENG_CONCURRENT,MAX(NC_ENG_CONCURRENT) AS MAX_ENG_CONCURRENT,MIN(NC_ENG_CONCURRENT) AS MIN_ENG_CONCURRENT,SUM(NC_QUE_LENGTH) AS SUM_QUE_LENGTH,MAX(NC_QUE_LENGTH) AS MAX_QUE_LENGTH,MIN(NC_QUE_LENGTH) AS MIN_QUE_LENGTH FROM TASKCONTEXT").append(string2);
            resultSet = this.QOIV.executeQuery(stringBuffer.toString());
            Field[] fieldArray = new Field[]{new FieldImpl("NC_TSK_TOTALS", JDBCType.INTEGER, 0, 0), new FieldImpl("NC_TSK_SUCCESSFUL", JDBCType.INTEGER, 0, 0), new FieldImpl("NC_TSK_SCHEDULE", JDBCType.INTEGER, 0, 0), new FieldImpl("SUM_TSKTIME_TOTAL", JDBCType.BIGINT, 0, 0), new FieldImpl("MAX_TSKTIME_TOTAL", JDBCType.BIGINT, 0, 0), new FieldImpl("MIN_TSKTIME_TOTAL", JDBCType.BIGINT, 0, 0), new FieldImpl("SUM_PGS_TOTALS", JDBCType.BIGINT, 0, 0), new FieldImpl("MAX_PGS_TOTALS", JDBCType.BIGINT, 0, 0), new FieldImpl("MIN_PGS_TOTALS", JDBCType.BIGINT, 0, 0), new FieldImpl("SUM_ENGTIME_TOTAL", JDBCType.BIGINT, 0, 0), new FieldImpl("MAX_ENGTIME", JDBCType.BIGINT, 0, 0), new FieldImpl("MIN_ENGTIME", JDBCType.BIGINT, 0, 0), new FieldImpl("SUM_TSKTIME_WAITED", JDBCType.BIGINT, 0, 0), new FieldImpl("MAX_TSKTIME_WAITED", JDBCType.BIGINT, 0, 0), new FieldImpl("MIN_TSKTIME_WAITED", JDBCType.BIGINT, 0, 0), new FieldImpl("SUM_ENG_CONCURRENT", JDBCType.BIGINT, 0, 0), new FieldImpl("MAX_ENG_CONCURRENT", JDBCType.BIGINT, 0, 0), new FieldImpl("MIN_ENG_CONCURRENT", JDBCType.BIGINT, 0, 0), new FieldImpl("SUM_QUE_LENGTH", JDBCType.BIGINT, 0, 0), new FieldImpl("MAX_QUE_LENGTH", JDBCType.BIGINT, 0, 0), new FieldImpl("MIN_QUE_LENGTH", JDBCType.BIGINT, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            if (resultSet.next()) {
                FieldValue[] fieldValueArray = new FieldValue[21];
                fieldValueArray[0] = fieldArray[0].createFieldValue();
                fieldValueArray[0].setValue(new Integer(resultSet.getInt("NC_TSK_TOTALS")));
                fieldValueArray[1] = fieldArray[1].createFieldValue();
                fieldValueArray[1].setValue(new Integer(resultSet.getInt("NC_TSK_SUCCESSFUL")));
                fieldValueArray[2] = fieldArray[2].createFieldValue();
                fieldValueArray[2].setValue(new Integer(resultSet.getInt("NC_TSK_SCHEDULE")));
                fieldValueArray[3] = fieldArray[3].createFieldValue();
                fieldValueArray[3].setValue(new Long(resultSet.getLong("SUM_TSKTIME_TOTAL")));
                fieldValueArray[4] = fieldArray[4].createFieldValue();
                fieldValueArray[4].setValue(new Long(resultSet.getLong("MAX_TSKTIME_TOTAL")));
                fieldValueArray[5] = fieldArray[5].createFieldValue();
                fieldValueArray[5].setValue(new Long(resultSet.getLong("MIN_TSKTIME_TOTAL")));
                fieldValueArray[6] = fieldArray[6].createFieldValue();
                fieldValueArray[6].setValue(new Long(resultSet.getLong("SUM_PGS_TOTALS")));
                fieldValueArray[7] = fieldArray[7].createFieldValue();
                fieldValueArray[7].setValue(new Long(resultSet.getLong("MAX_PGS_TOTALS")));
                fieldValueArray[8] = fieldArray[8].createFieldValue();
                fieldValueArray[8].setValue(new Long(resultSet.getLong("MIN_PGS_TOTALS")));
                fieldValueArray[9] = fieldArray[9].createFieldValue();
                fieldValueArray[9].setValue(new Long(resultSet.getLong("SUM_ENGTIME_TOTAL")));
                fieldValueArray[10] = fieldArray[10].createFieldValue();
                fieldValueArray[10].setValue(new Long(resultSet.getLong("MAX_ENGTIME")));
                fieldValueArray[11] = fieldArray[11].createFieldValue();
                fieldValueArray[11].setValue(new Long(resultSet.getLong("MIN_ENGTIME")));
                fieldValueArray[12] = fieldArray[12].createFieldValue();
                fieldValueArray[12].setValue(new Long(resultSet.getLong("SUM_TSKTIME_WAITED")));
                fieldValueArray[13] = fieldArray[13].createFieldValue();
                fieldValueArray[13].setValue(new Long(resultSet.getLong("MAX_TSKTIME_WAITED")));
                fieldValueArray[14] = fieldArray[14].createFieldValue();
                fieldValueArray[14].setValue(new Long(resultSet.getLong("MIN_TSKTIME_WAITED")));
                fieldValueArray[15] = fieldArray[15].createFieldValue();
                fieldValueArray[15].setValue(new Long(resultSet.getLong("SUM_ENG_CONCURRENT")));
                fieldValueArray[16] = fieldArray[16].createFieldValue();
                fieldValueArray[16].setValue(new Long(resultSet.getLong("MAX_ENG_CONCURRENT")));
                fieldValueArray[17] = fieldArray[17].createFieldValue();
                fieldValueArray[17].setValue(new Long(resultSet.getLong("MIN_ENG_CONCURRENT")));
                fieldValueArray[18] = fieldArray[18].createFieldValue();
                fieldValueArray[18].setValue(new Long(resultSet.getLong("SUM_QUE_LENGTH")));
                fieldValueArray[19] = fieldArray[19].createFieldValue();
                fieldValueArray[19].setValue(new Long(resultSet.getLong("MAX_QUE_LENGTH")));
                fieldValueArray[20] = fieldArray[20].createFieldValue();
                fieldValueArray[20].setValue(new Long(resultSet.getLong("MIN_QUE_LENGTH")));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            }
            resultSet.close();
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("GroupOfTskTime")) {
            stringBuffer.append(" SELECT 'Time Cost for Waiting' AS ITEM_NAME, SUM(TC_TSK_WAITED) AS ITEM_VALUE ").append(" FROM TASKCONTEXT").append(string2).append(" UNION ALL").append(" SELECT 'Running Time' AS ITEM_NAME, SUM(TC_ENG_TOTAL) AS ITEM_VALUE ").append(" FROM TASKCONTEXT").append(string2).append(" UNION ALL").append(" SELECT 'Other' AS ITEM_NAME, SUM(TC_TSK_OTHER) AS ITEM_VALUE ").append(" FROM TASKCONTEXT").append(string2);
            resultSet = this.QOIV.executeQuery(stringBuffer.toString());
            Field[] fieldArray = new Field[]{new FieldImpl("ITEM_NAME", JDBCType.VARCHAR, 32, 0), new FieldImpl("ITEM_VALUE", JDBCType.BIGINT, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            while (resultSet.next()) {
                FieldValue[] fieldValueArray = new FieldValue[]{fieldArray[0].createFieldValue(), fieldArray[1].createFieldValue()};
                fieldValueArray[0].setValue(resultSet.getString("ITEM_NAME"));
                fieldValueArray[1].setValue(new Long(resultSet.getLong("ITEM_VALUE")));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            }
            resultSet.close();
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("GroupOfEngTime")) {
            stringBuffer.append(" SELECT 'Loading Time' AS ITEM_NAME, SUM(TC_ENG_LOAD) AS ITEM_VALUE ").append(" FROM TASKCONTEXT").append(string2).append(" UNION ALL").append(" SELECT 'Exporting Time' AS ITEM_NAME, SUM(TC_ENG_EXPORT) AS ITEM_VALUE ").append(" FROM TASKCONTEXT").append(string2).append(" UNION ALL").append(" SELECT 'Other' AS ITEM_NAME, SUM(TC_ENG_OTHER) AS ITEM_VALUE ").append(" FROM TASKCONTEXT").append(string2);
            resultSet = this.QOIV.executeQuery(stringBuffer.toString());
            Field[] fieldArray = new Field[]{new FieldImpl("ITEM_NAME", JDBCType.VARCHAR, 32, 0), new FieldImpl("ITEM_VALUE", JDBCType.BIGINT, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            while (resultSet.next()) {
                FieldValue[] fieldValueArray = new FieldValue[]{fieldArray[0].createFieldValue(), fieldArray[1].createFieldValue()};
                fieldValueArray[0].setValue(resultSet.getString("ITEM_NAME"));
                fieldValueArray[1].setValue(new Long(resultSet.getLong("ITEM_VALUE")));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            }
            resultSet.close();
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("DistOfTasks")) {
            int n = 10;
            stringBuffer.append("SELECT MAX(TC_ENG_TOTAL) AS MAX_ENGTIME, ").append(" MIN(TC_ENG_TOTAL) AS MIN_ENGTIME ").append(" FROM TASKCONTEXT").append(string2);
            resultSet = this.QOIV.executeQuery(stringBuffer.toString());
            resultSet.next();
            long l = resultSet.getLong("MAX_ENGTIME");
            long l2 = resultSet.getLong("MIN_ENGTIME");
            int n2 = (int)((l - l2) / (long)(n - 1));
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            int n3 = 0;
            while (n3 < n) {
                lArray[n3] = l2 + (long)(n3 * n2);
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append("SELECT COUNT(ID) AS NC_TSK_INRANGE ");
                stringBuffer.append(" FROM TASKCONTEXT").append(string2);
                stringBuffer.append(" AND TC_ENG_TOTAL BETWEEN ").append(lArray[n3]).append(" AND ").append(lArray[n3] + (long)n2);
                resultSet = this.QOIV.executeQuery(stringBuffer.substring(0));
                resultSet.next();
                nArray[n3] = resultSet.getInt("NC_TSK_INRANGE");
                ++n3;
            }
            resultSet.close();
            Field[] fieldArray = new Field[]{new FieldImpl("ENG_TIME", JDBCType.DOUBLE, 0, 0), new FieldImpl("RPT_COUNT", JDBCType.INTEGER, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            int n4 = 0;
            while (n4 < n) {
                FieldValue[] fieldValueArray = new FieldValue[]{fieldArray[0].createFieldValue(), fieldArray[1].createFieldValue()};
                fieldValueArray[0].setValue(new Double((float)lArray[n4] / 1000.0f));
                fieldValueArray[1].setValue(new Integer(nArray[n4]));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
                ++n4;
            }
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("QueryTopNFreq")) {
            stringBuffer.append(" SELECT");
            stringBuffer.append(" TASKCONTEXT.VS_RPT_NAME");
            stringBuffer.append(",COUNT(TASKCONTEXT.ID) AS ACCESSCOUNT");
            stringBuffer.append(" FROM TASKCONTEXT").append(string2);
            stringBuffer.append(" GROUP BY TASKCONTEXT.VS_RPT_NAME");
            if ("jet.server.db.adapter.AccessDriver".equals(properties.getProperty("jdbc.driver"))) {
                stringBuffer.append(" ORDER BY COUNT(TASKCONTEXT.ID) DESC");
            } else {
                stringBuffer.append(" ORDER BY ACCESSCOUNT DESC");
            }
            int n = Integer.parseInt(properties.getProperty("top.n", "10"));
            this.QOIV.setMaxRows(n);
            resultSet = this.QOIV.executeQuery(stringBuffer.toString());
            Field[] fieldArray = new Field[]{new FieldImpl("REPORT", JDBCType.VARCHAR, 254, 0), new FieldImpl("ACCESSCOUNT", JDBCType.INTEGER, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            while (resultSet.next()) {
                FieldValue[] fieldValueArray = new FieldValue[2];
                fieldValueArray[0] = fieldArray[0].createFieldValue();
                fieldValueArray[0].setValue(resultSet.getObject("VS_RPT_NAME"));
                fieldValueArray[1] = fieldArray[1].createFieldValue();
                fieldValueArray[1].setValue(resultSet.getObject("ACCESSCOUNT"));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            }
            resultSet.close();
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("ProportionOfFreq")) {
            stringBuffer.append(" SELECT COUNT(ID) AS COUNT_TOTAL ").append(" FROM TASKCONTEXT").append(string2);
            resultSet = this.QOIV.executeQuery(stringBuffer.toString());
            resultSet.next();
            int n = resultSet.getInt("COUNT_TOTAL");
            resultSet.close();
            int n5 = this.DOUBLE(string2, properties);
            int n6 = Integer.parseInt(properties.getProperty("top.n"));
            Field[] fieldArray = new Field[]{new FieldImpl("ITEM_NAME", JDBCType.VARCHAR, 16, 0), new FieldImpl("ITEM_VALUE", JDBCType.INTEGER, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            FieldValue[] fieldValueArray = new FieldValue[2];
            fieldValueArray[0] = fieldArray[0].createFieldValue();
            fieldValueArray[0].setValue("Top " + n6);
            fieldValueArray[1] = fieldArray[1].createFieldValue();
            fieldValueArray[1].setValue(new Integer(n5));
            ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            fieldValueArray = new FieldValue[2];
            fieldValueArray[0] = fieldArray[0].createFieldValue();
            fieldValueArray[0].setValue("Other");
            fieldValueArray[1] = fieldArray[1].createFieldValue();
            fieldValueArray[1].setValue(new Integer(n - n5));
            ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            return this.VARCHAR;
        }
        return null;
    }

    private int DOUBLE(String string, Properties properties) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT");
        stringBuffer.append(" TASKCONTEXT.VS_RPT_NAME");
        stringBuffer.append(",COUNT(TASKCONTEXT.ID) AS ACCESSCOUNT");
        stringBuffer.append(" FROM TASKCONTEXT").append(string);
        stringBuffer.append(" GROUP BY TASKCONTEXT.VS_RPT_NAME");
        if ("jet.server.db.adapter.AccessDriver".equals(properties.getProperty("jdbc.driver"))) {
            stringBuffer.append(" ORDER BY COUNT(TASKCONTEXT.ID) DESC");
        } else {
            stringBuffer.append(" ORDER BY ACCESSCOUNT DESC");
        }
        int n = Integer.parseInt(properties.getProperty("top.n"));
        this.QOIV.setMaxRows(n);
        ResultSet resultSet = this.QOIV.executeQuery(stringBuffer.toString());
        int n2 = 0;
        while (resultSet.next()) {
            n2 += resultSet.getInt("ACCESSCOUNT");
        }
        return n2;
    }
}

