/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rc;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.rc.ActionProcessor;
import jet.server.rc.HomeProcessor;
import jet.server.rc.RealmProcessor;
import jet.server.userman.AclEntryImpl;
import jet.server.userman.AclImpl;
import jet.server.userman.PermissionImpl;
import jet.server.userman.Permissions;
import jet.server.userman.Realm;
import jet.server.userman.Resource;
import jet.server.userman.User;
import jet.server.userman.UserDataToolkit;
import jet.util.MiscTools;

public class AclProcessor
extends ActionProcessor {
    public static String IDS_LIST_ACL = "ListAcl";
    public static String IDS_NEW_ACL = "NewAcl";
    public static String IDS_ADD_ACL_MEMBER = "AddAclMember";
    public static String IDS_EDIT_ACL = "EditAcl";
    public static String IDS_REQUEST_NEW_ACL = "RequestNewAcl";
    public static String IDS_REQUEST_EDIT_ACL = "RequestEditAcl";
    public static String IDS_REMOVE_ACL = "RemoveAcl";
    public static String IDS_REMOVE_ACL_MEMBER = "RemoveAclMember";
    public static String IDS_REQUEST_REMOVE_ACL = "RequestRemoveAcl";
    public static String IDS_LIST_PERMISSION = "ListPermission";
    public static String IDS_ADD_PERMISSION = "AddPermission";
    public static String IDS_APPLY_PERMISSION = "ApplyPermission";
    public static String IDS_REQUEST_ADD_PERMISSION = "RequestAddPermission";
    public static String IDS_DELETE_PERMISSION = "DeletePermission";
    public static String IDS_REQUEST_EDIT_ACL_MEMBER = "EditAclMember";
    public static String IDS_REQUEST_EDIT_MEMBER_PERMISSION = "EditMemberPermission";

    public AclProcessor() {
        this.actions.addElement(IDS_LIST_ACL);
        this.actions.addElement(IDS_NEW_ACL);
        this.actions.addElement(IDS_ADD_ACL_MEMBER);
        this.actions.addElement(IDS_EDIT_ACL);
        this.actions.addElement(IDS_REQUEST_NEW_ACL);
        this.actions.addElement(IDS_REQUEST_EDIT_ACL);
        this.actions.addElement(IDS_REMOVE_ACL);
        this.actions.addElement(IDS_REMOVE_ACL_MEMBER);
        this.actions.addElement(IDS_REQUEST_REMOVE_ACL);
        this.actions.addElement(IDS_LIST_PERMISSION);
        this.actions.addElement(IDS_ADD_PERMISSION);
        this.actions.addElement(IDS_APPLY_PERMISSION);
        this.actions.addElement(IDS_REQUEST_ADD_PERMISSION);
        this.actions.addElement(IDS_DELETE_PERMISSION);
        this.actions.addElement(IDS_REQUEST_EDIT_ACL_MEMBER);
        this.actions.addElement(IDS_REQUEST_EDIT_MEMBER_PERMISSION);
    }

    public void processEvent(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        super.processEvent(string, properties, httpServletRequest, httpServletResponse);
        if (string.equalsIgnoreCase(IDS_LIST_ACL)) {
            this.IDS_EDIT_ACL(null);
        } else if (string.equalsIgnoreCase(IDS_NEW_ACL)) {
            this.IDS_LIST_PERMISSION();
        } else if (string.equalsIgnoreCase(IDS_ADD_ACL_MEMBER)) {
            this.IDS_ADD_PERMISSION();
        } else if (string.equalsIgnoreCase(IDS_EDIT_ACL)) {
            this.IDS_LIST_ACL();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_NEW_ACL)) {
            this.IDS_NEW_ACL();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_EDIT_ACL)) {
            this.IDS_LIST_REALM();
        } else if (string.equalsIgnoreCase(IDS_REMOVE_ACL)) {
            this.IDS_REMOVE_ACL_MEMBER();
        } else if (string.equalsIgnoreCase(IDS_REMOVE_ACL_MEMBER)) {
            this.IDS_ADD_ACL_MEMBER();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_REMOVE_ACL)) {
            this.IDS_REMOVE_ACL();
        } else if (string.equalsIgnoreCase(IDS_LIST_PERMISSION)) {
            this.IDS_REQUEST_ADD_PERMISSION();
        } else if (string.equalsIgnoreCase(IDS_ADD_PERMISSION)) {
            this.IDS_REQUEST_EDIT_ACL(false);
        } else if (string.equalsIgnoreCase(IDS_APPLY_PERMISSION)) {
            this.IDS_REQUEST_EDIT_ACL(true);
        } else if (string.equalsIgnoreCase(IDS_REQUEST_ADD_PERMISSION)) {
            this.IDS_REQUEST_EDIT_ACL_MEMBER();
        } else if (string.equalsIgnoreCase(IDS_DELETE_PERMISSION)) {
            this.IDS_REQUEST_EDIT_MEMBER_PERMISSION();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_EDIT_ACL_MEMBER)) {
            this.IDS_APPLY_PERMISSION();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_EDIT_MEMBER_PERMISSION)) {
            this.IDS_DELETE_PERMISSION();
        }
    }

    private void IDS_ADD_ACL_MEMBER() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = HttpUtil.decodeEsc(this.getPropertyIgnoreCase("acl"));
        String string3 = null;
        Enumeration enumeration = this.request.getParameterNames();
        try {
            String[] stringArray;
            Realm realm = Realm.get(string);
            AclImpl aclImpl = (AclImpl)realm.getAcl(string2);
            while (enumeration.hasMoreElements()) {
                stringArray = HttpUtil.decodeEsc((String)enumeration.nextElement());
                if (!stringArray.startsWith("delete_")) continue;
                String string4 = stringArray.substring("delete_".length());
                Enumeration enumeration2 = aclImpl.entries();
                while (enumeration2.hasMoreElements()) {
                    AclEntry aclEntry = (AclEntry)enumeration2.nextElement();
                    if (!aclEntry.getPrincipal().getName().equalsIgnoreCase(string4)) continue;
                    aclImpl.removeEntry(null, aclEntry);
                }
            }
            try {
                UserDataToolkit.saveAclProperties(aclImpl);
            }
            catch (IOException iOException) {
                string3 = "Save ACL properties file failed!";
                ServiceLogger.logError(iOException);
            }
            if (string3 != null) {
                stringArray = new String[]{"realm", string, "ACL", string2};
                this.printMessage(stringArray, string3, this.action);
            }
            this.IDS_APPLY_PERMISSION();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    private void IDS_ADD_PERMISSION() throws IOException {
        String string;
        Enumeration enumeration = this.request.getParameterNames();
        String string2 = this.request.getParameter("realm");
        if (string2 == null) {
            string2 = this.getPropertyIgnoreCase("realm");
        }
        if ((string = HttpUtil.decodeEsc(this.request.getParameter("acl"))) == null) {
            string = this.getPropertyIgnoreCase("acl");
        }
        String string3 = null;
        try {
            String[] stringArray;
            Realm realm = Realm.get(string2);
            AclImpl aclImpl = (AclImpl)realm.getAcl(string);
            while (enumeration.hasMoreElements()) {
                stringArray = HttpUtil.decodeEsc((String)enumeration.nextElement());
                if (!stringArray.startsWith("add_")) continue;
                String string4 = stringArray.substring("add_".length());
                String string5 = string4.substring(string4.indexOf("_") + 1);
                AclEntryImpl aclEntryImpl = new AclEntryImpl(string5);
                aclEntryImpl.setRealmName(string2);
                aclImpl.addEntry(null, aclEntryImpl);
            }
            try {
                UserDataToolkit.saveAclProperties(aclImpl);
            }
            catch (IOException iOException) {
                string3 = "Save ACL properties file failed!";
                ServiceLogger.logError(iOException);
            }
            if (string3 != null) {
                stringArray = new String[]{"realm", string2, "ACL", string};
                this.printMessage(stringArray, string3, this.action);
            }
            this.IDS_APPLY_PERMISSION();
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string3 = "Realm " + string2 + " does not exist!";
            this.action = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string3 = "Realm " + string2 + " is invalid!";
            this.action = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchAclException noSuchAclException) {
            string3 = "ACL " + string + " does not exist!";
            this.action = IDS_LIST_ACL;
            ServiceLogger.logError(noSuchAclException);
        }
        catch (NotOwnerException notOwnerException) {
            string3 = "NotOwnerException:" + (Object)((Object)notOwnerException);
            ServiceLogger.logError(notOwnerException);
        }
    }

    private void IDS_APPLY_PERMISSION() throws IOException {
        String[] stringArray;
        String string = "";
        String string2 = this.request.getParameter("realm");
        String string3 = this.request.getParameter("acl");
        if (string2 == null) {
            string2 = this.getPropertyIgnoreCase("realm");
        }
        if (string3 == null) {
            string3 = HttpUtil.decodeEsc(this.getPropertyIgnoreCase("acl"));
        }
        String string4 = null;
        try {
            String string5;
            Object object;
            Object object2;
            stringArray = (String[])Realm.get(string2);
            AclImpl aclImpl = (AclImpl)stringArray.getAcl(string3);
            string = string + "<script>";
            string = string + "NS4 = (document.layers) ? 1 : 0;";
            string = string + "function init(){";
            string = string + "    if (!NS4){";
            string = string + "        show();";
            string = string + "    }";
            string = string + "}";
            string = string + "function show() {";
            string = string + "    if (allList.style.visibility == \"hidden\")";
            string = string + "        allList.style.visibility = \"visible\";";
            string = string + "    else ";
            string = string + "        allList.style.visibility = \"hidden\";";
            string = string + "}";
            string = string + "</script>";
            string = string + "<html>";
            string = string + "<head>";
            string = string + "<title>Edit Group Members</title>";
            string = string + "</head>";
            string = string + "<body onLoad=\"init()\">";
            string = string + "<table width=100% border=0>";
            string = string + "  <tbody>";
            string = string + "    <tr>";
            string = string + "      <td width=32%><strong><font face=Arial>Edit ACL Members</font></strong></td>";
            string = string + "      <td width=68%>";
            string = string + "        <p align=right><font face=Arial><small>Selected Realm:[" + string2 + "] &nbsp;ACL:[" + string3 + "]</small></font></p>";
            string = string + "      </td>";
            string = string + "    </tr>";
            string = string + "  </tbody>";
            string = string + "</table>";
            string = string + "<hr>";
            string = string + "<p align=left><font face=Arial>Member list:</font></p>";
            string = string + "<form >";
            string = string + "<table border=1 width=100% bordercolor=#C0C0C0 cellspacing=0 cellpadding=0 bordercolorlight=#C0C0C0 bordercolordark=#C0C0C0>";
            string = string + "  <tr>";
            string = string + "    <td width=62 bgcolor=#5095ba align=center><font color=#FFFFFF face=Arial><b style=\"font-size=12px\">&nbsp;</b></font></td>";
            string = string + "    <td width=151 bgcolor=#5095ba><font color=#FFFFFF face=Arial><b style=\"font-size=12px\">&nbsp;Name</b></font></td>";
            string = string + "    <td width=172 bgcolor=#5095ba><font color=#FFFFFF face=Arial><b style=\"font-size=12px\">&nbsp;Type</b></font></td>";
            string = string + "    <td width=305 bgcolor=#5095ba>&nbsp;</td>";
            string = string + "  </tr>";
            Enumeration enumeration = aclImpl.entries();
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                object2 = (AclEntry)enumeration.nextElement();
                if (object2.getPrincipal() == null || vector.contains(object = object2.getPrincipal().getName())) continue;
                vector.addElement((String)object);
                string5 = "Unknow";
                Principal principal = object2.getPrincipal();
                if (principal instanceof User) {
                    string5 = "User";
                } else if (principal instanceof Group) {
                    string5 = "Group";
                }
                string = string + "  <tr>";
                string = string + "    <td width=62 align=center>";
                string = string + "      <font face=Arial size=2><input type=checkbox name=delete_" + HttpUtil.encodeEsc((String)object) + " value=ON></font></td>";
                string = string + "    <td width=151><font face=Arial size=2>&nbsp;" + (String)object + "</font></td>";
                string = string + "    <td width=172><font face=Arial size=2>&nbsp;" + string5 + "</font></td>";
                string = string + "    <td width=305><font face=Arial size=2>&nbsp;<a href=" + IDS_REQUEST_EDIT_MEMBER_PERMISSION + "?realm=" + string2 + "&acl=" + HttpUtil.encodeEsc(string3) + "&member=" + string5 + "_" + HttpUtil.encodeEsc((String)object) + ">Permissions</a></font></td>";
                string = string + "  </tr>";
            }
            string = string + "  <tr>";
            string = string + "    <td width=\"100%\" colspan=\"4\">";
            string = string + "      <p align=right><input type=submit value=Delete name=button" + IDS_REMOVE_ACL_MEMBER + "></td>";
            string = string + "  </tr>";
            string = string + "</table>";
            string = string + "<p align=left><a onclick=\"show()\"><font face=Arial size=2>&nbsp;<img border=0 src=" + this.getImage("create") + " width=18 height=13>Add member</font></a></p>";
            string = string + "<div ID=allList>";
            string = string + "<form >";
            string = string + " <input type=\"hidden\" name=\"realm\" value=\"" + string2 + "\">";
            string = string + " <input type=\"hidden\" name=\"acl\" value=\"" + string3 + "\">";
            string = string + "<table border=1 width=100% bordercolor=#C0C0C0 cellspacing=0 cellpadding=0 bordercolorlight=#C0C0C0 bordercolordark=#C0C0C0>";
            string = string + "  <tr>";
            string = string + "    <td width=6% bgcolor=#5095ba><font color=#FFFFFF face=Arial><b>&nbsp;</b></font></td>";
            string = string + "    <td width=60% bgcolor=#5095ba><font color=#FFFFFF face=Arial size=2><b>&nbsp;Name</b></font></td>";
            string = string + "    <td width=34% bgcolor=#5095ba><font color=#FFFFFF face=Arial size=2><b>&nbsp;Type</b></font></td>";
            string = string + "  </tr>";
            object2 = stringArray.getUsers();
            while (object2.hasMoreElements()) {
                object = (User)object2.nextElement();
                if (vector.contains(object.getName())) continue;
                string = string + "  <tr>";
                string = string + "    <td width=6% align=center>";
                string = string + "      <font face=Arial size=2><input type=checkbox name=add_User_" + HttpUtil.encodeEsc(object.getName()) + " value=ON></font></td>";
                string = string + "    <td width=60%><font face=Arial size=2>&nbsp;" + object.getName() + "</font></td>";
                string = string + "    <td width=34%><font face=Arial size=2>&nbsp;User</font></td>";
                string = string + "  </tr>";
            }
            object = stringArray.getGroups();
            while (object.hasMoreElements()) {
                string5 = (Group)object.nextElement();
                if (vector.contains(string5.getName())) continue;
                string = string + "  <tr>";
                string = string + "    <td width=6% align=center>";
                string = string + "      <font face=Arial size=2><input type=checkbox name=add_Group_" + HttpUtil.encodeEsc(string5.getName()) + " value=ON></font></td>";
                string = string + "    <td width=60%><font face=Arial size=2>&nbsp;" + string5.getName() + "</font></td>";
                string = string + "    <td width=34%><font face=Arial size=2>&nbsp;Group</font></td>";
                string = string + "  </tr>";
            }
            string = string + "  <tr><td width=\"100%\" colspan=\"3\">";
            string = string + "      <p align=right><input type=submit value=Add name=button" + IDS_ADD_ACL_MEMBER + ">";
            string = string + "  </td></tr>";
            string = string + "</table>";
            string = string + "</form>";
            string = string + "</div>";
            string = string + "</body>";
            string = string + "</html>";
            this.writeResponse(string);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string4 = "Realm " + string2 + " does not exist!";
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string4 = "Realm " + string2 + " is invalid!";
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchAclException noSuchAclException) {
            string4 = "ACL " + string3 + " is invalid!";
            ServiceLogger.logError(noSuchAclException);
        }
        if (string4 != null) {
            stringArray = new String[]{"realm", string2, "ACL", string3};
            this.printMessage(stringArray, string4, this.action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_DELETE_PERMISSION() throws IOException {
        String[] stringArray;
        String string;
        String string2;
        String string3 = HttpUtil.decodeEsc(this.request.getParameter("member"));
        if (string3 == null) {
            string3 = this.getPropertyIgnoreCase("member");
        }
        if ((string2 = this.getPropertyIgnoreCase("memberName")) == null) {
            string2 = string3.substring(string3.indexOf("_") + 1);
        }
        String string4 = string3.substring(0, string3.indexOf("_"));
        String string5 = this.request.getParameter("realm");
        if (string5 == null) {
            string5 = this.getPropertyIgnoreCase("realm");
        }
        if ((string = this.request.getParameter("acl")) == null) {
            string = this.getPropertyIgnoreCase("acl");
        }
        String string6 = null;
        String string7 = IDS_LIST_PERMISSION;
        try {
            Object object;
            Object object2;
            Object object3;
            User user;
            String[] stringArray2 = stringArray = Realm.get(string5);
            synchronized (stringArray2) {
                user = string3.startsWith("User") ? stringArray.getUser(string2) : stringArray.getGroup(string2);
            }
            Acl acl = stringArray.getAcl(string);
            Vector vector = new Vector();
            Vector<String> vector2 = new Vector<String>();
            Acl acl2 = acl;
            synchronized (acl2) {
                object3 = acl.entries();
                while (object3.hasMoreElements()) {
                    AclEntryImpl aclEntryImpl = (AclEntryImpl)object3.nextElement();
                    if (aclEntryImpl.getPrincipal() != user) continue;
                    object2 = aclEntryImpl.isNegative() ? vector2 : vector;
                    object = aclEntryImpl.permissions();
                    while (object.hasMoreElements()) {
                        String string8 = ((PermissionImpl)object.nextElement()).getName();
                        ((Vector)object2).addElement(string8);
                    }
                }
            }
            object3 = "";
            object3 = (String)object3 + "<input type=\"hidden\" name=\"realm\" value=\"" + string5 + "\">";
            object3 = (String)object3 + "<input type=\"hidden\" name=\"member\" value=\"" + string3 + "\">";
            object3 = (String)object3 + "<input type=\"hidden\" name=\"memberName\" value=\"" + string2 + "\">";
            object3 = (String)object3 + "<input type=\"hidden\" name=\"ACL\" value=\"" + string + "\">";
            object3 = (String)object3 + " <table border=\"0\" width=\"100%\">";
            object3 = (String)object3 + "  <tr>";
            object3 = (String)object3 + "   <td width=\"43%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Edit User's Permissions</font></strong></td>";
            object3 = (String)object3 + "   <td width=\"57%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string5 + "] &nbsp;";
            object3 = (String)object3 + "   ACL: [" + string + "]&nbsp; " + string4 + ":[" + string2 + "]</font></small></td>";
            object3 = (String)object3 + "  </tr>";
            object3 = (String)object3 + " </table>";
            object3 = (String)object3 + " <hr>";
            object3 = (String)object3 + "<table>";
            int n = 0;
            object2 = Permissions.elements();
            while (object2.hasMoreElements()) {
                object = ((PermissionImpl)object2.nextElement()).getName();
                int n2 = 0;
                if (vector.contains(object) == vector2.contains(object)) {
                    n2 = 2;
                } else if (vector2.contains(object)) {
                    n2 = 1;
                }
                object3 = (String)object3 + "  <tr>";
                object3 = (String)object3 + "   <td width=\"27%\" height=\"22\" align=\"right\" valign=\"top\"><u><small><font face=\"Arial\">" + (String)object + ":</font></small></u></td>";
                object3 = (String)object3 + "   <td width=\"73%\" valign=\"top\" align=\"left\" height=\"22\">";
                object3 = (String)object3 + "    <input type=\"radio\" name=\"" + n + "\" value=\"allow\" " + (n2 == 0 ? "checked" : "") + ">Allow&nbsp;&nbsp;&nbsp; ";
                object3 = (String)object3 + "    <input type=\"radio\" name=\"" + n + "\" value=\"deny\" " + (n2 == 1 ? "checked" : "") + ">Deny &nbsp;&nbsp; ";
                object3 = (String)object3 + "    <input type=\"radio\" name=\"" + n + "\" value=\"none\" " + (n2 == 2 ? "checked" : "") + ">None</td>";
                object3 = (String)object3 + "  </tr>";
                ++n;
            }
            object3 = (String)object3 + "  <tr>";
            object3 = (String)object3 + "   <td width=\"27%\" height=\"39\" align=\"right\" valign=\"top\"></td>";
            object3 = (String)object3 + "   <td width=\"73%\" valign=\"bottom\" align=\"left\" height=\"39\">";
            object3 = (String)object3 + "   <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_ADD_PERMISSION + "\">";
            object3 = (String)object3 + "   <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_REQUEST_EDIT_ACL_MEMBER + "\"></td>";
            object3 = (String)object3 + "  </tr>";
            object3 = (String)object3 + " </table>";
            this.writeResponse((String)object3);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string6 = "Realm " + string5 + " does not exist!";
            string7 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string6 = "Realm " + string5 + " is invalid!";
            string7 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchAclException noSuchAclException) {
            string6 = "ACL " + string + " does not exist!";
            string7 = IDS_LIST_ACL;
            ServiceLogger.logError(noSuchAclException);
        }
        catch (NoSuchUserException noSuchUserException) {
            string6 = "User " + string2 + " does not exist!";
            ServiceLogger.logError(noSuchUserException);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            string6 = "Group " + string2 + " does not exist!";
            ServiceLogger.logError(noSuchGroupException);
        }
        if (string6 != null) {
            stringArray = new String[]{"realm", string5, "ACL", string};
            this.printMessage(stringArray, string6, string7);
        }
    }

    private void IDS_EDIT_ACL(String string) throws IOException {
        String string2 = null;
        String string3 = string == null ? this.getCurEditRealm() : string;
        try {
            Realm realm = Realm.get(string3);
            String string4 = "";
            string4 = string4 + "<html>";
            string4 = string4 + "<head>";
            string4 = string4 + "<title>ACL List</title>";
            string4 = string4 + "</head>";
            string4 = string4 + "<body>";
            string4 = string4 + "<table width=100% border=0>";
            string4 = string4 + "  <tbody>";
            string4 = string4 + "    <tr>";
            string4 = string4 + "      <td width=32%><strong><font face=Arial>&nbsp; ACL List</font></strong></td>";
            string4 = string4 + "      <td width=68%>";
            string4 = string4 + "        <p align=right><small><font face=Arial>Selected Realm: [" + string3 + "]</font></small></p>";
            string4 = string4 + "      </td>";
            string4 = string4 + "    </tr>";
            string4 = string4 + "  </tbody>";
            string4 = string4 + "</table>";
            string4 = string4 + "<hr>";
            string4 = string4 + "<p align=left><font face=Arial size=2>&nbsp;<a href=" + IDS_REQUEST_NEW_ACL + "?realm=" + string3 + "><img border=0 src=" + this.getImage("create") + " width=18 height=13>Create a new ACL</a></font></p>";
            string4 = string4 + " <input type=\"hidden\" name=\"realm\" value=\"" + string3 + "\">";
            string4 = string4 + "<table border=1 width=100% bordercolor=#C0C0C0 cellspacing=0 cellpadding=0 bordercolordark=#C0C0C0 bordercolorlight=#C0C0C0>";
            Enumeration enumeration = realm.getAclNames();
            string4 = string4 + "<tr bgcolor=\"#5095ba\">";
            string4 = string4 + "    <td><font color=\"#FFFFFF\" size=2>&nbsp;<font face=\"Arial\"><strong>Name</strong></font></font></td>";
            string4 = string4 + "    <td width = \"40%\"><font color=\"#FFFFFF\" size=2>&nbsp;<font face=\"Arial\"><strong>Members</strong></font></font></td>";
            string4 = string4 + "    <td align=\"center\">&nbsp;</td>";
            string4 = string4 + "  </tr>";
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                string4 = string4 + "  <tr>";
                string4 = string4 + "    <td><font size=2 face=Arial>&nbsp;" + string5 + "</a></font></td>";
                string4 = string4 + "    <td><font size=2 face=Arial>&nbsp;<a href=" + IDS_REQUEST_EDIT_ACL_MEMBER + "?realm=" + string3 + "&acl=" + HttpUtil.encodeEsc(string5) + ">ACL Members</a></font></td>";
                if (!string5.equalsIgnoreCase("adminAcl") && !string5.equalsIgnoreCase("rootAcl")) {
                    string4 = string4 + "    <td width=50 align=center><font size=2 face=Arial><a href=" + IDS_REQUEST_REMOVE_ACL + "?realm=" + string3 + "&acl=" + HttpUtil.encodeEsc(string5) + ">Delete</a></font></td>";
                }
                string4 = string4 + "  </tr>";
            }
            string4 = string4 + "</table>";
            string4 = string4 + "</body>";
            string4 = string4 + "</html>";
            this.writeResponse(string4);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string2 = "Realm " + string3 + " does not exist!";
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string2 = "Realm " + string3 + " is invalid!";
            ServiceLogger.logError(badRealmException);
        }
        if (string2 != null) {
            this.printMessage(string2, HomeProcessor.IDS_REQUEST_HOME);
        }
    }

    private void IDS_LIST_ACL() throws IOException {
        String string;
        String string2;
        String string3;
        block10: {
            string3 = this.getPropertyIgnoreCase("realm");
            String string4 = this.getPropertyIgnoreCase("ACL");
            String string5 = this.getPropertyIgnoreCase("oldAcl");
            string2 = null;
            string = IDS_LIST_ACL;
            if (string4.trim().equals("")) {
                string2 = "ACL name cannot be blank!";
                string = IDS_LIST_ACL;
            } else {
                try {
                    Realm realm = Realm.get(string3);
                    AclImpl aclImpl = null;
                    try {
                        aclImpl = (AclImpl)realm.getAcl(string5);
                        aclImpl.setName(null, string4);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    if (aclImpl == null) break block10;
                    try {
                        UserDataToolkit.saveAclProperties(aclImpl);
                    }
                    catch (IOException iOException) {
                        string2 = "Save ACL properties file failed!";
                        ServiceLogger.logError(iOException);
                    }
                    this.logManageSuccessEvent("create ACL " + realm.getName() + ":" + string4);
                    this.IDS_EDIT_ACL(string3);
                }
                catch (NoSuchRealmException noSuchRealmException) {
                    string2 = "Realm " + string3 + " does not exist!";
                    ServiceLogger.logError(noSuchRealmException);
                }
                catch (BadRealmException badRealmException) {
                    string2 = "Realm " + string3 + " is invalid!";
                    ServiceLogger.logError(badRealmException);
                }
            }
        }
        if (string2 != null) {
            this.printMessage(new String[]{"realm", string3}, string2, string);
        }
    }

    private void IDS_LIST_PERMISSION() throws IOException {
        String string;
        String string2;
        String string3;
        block14: {
            string3 = this.getPropertyIgnoreCase("realm");
            String string4 = this.getPropertyIgnoreCase("ACL");
            string2 = null;
            string = IDS_LIST_ACL;
            String string5 = "!#$%^&*()<>[]=\\/|\"?. {}:;\t\n";
            if (string4.trim().equals("")) {
                string2 = "ACL name cannot be blank!";
                string = IDS_LIST_ACL;
            } else if (MiscTools.containChar((String)string4, (String)string5)) {
                string2 = JSvrResource.getMessage("SVR_43", "\"!#$%^&*()<>[]=\\/|\"?. {}:;\"");
                string = IDS_LIST_ACL;
            } else {
                try {
                    Realm realm = Realm.get(string3);
                    AclImpl aclImpl = null;
                    try {
                        if (realm.isAclExist(string4)) {
                            string2 = "ACL " + string4 + " already exists!";
                            string = IDS_LIST_ACL;
                        } else {
                            aclImpl = (AclImpl)realm.makeAcl(string4, null);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    if (aclImpl == null) break block14;
                    try {
                        UserDataToolkit.saveAclProperties(aclImpl);
                    }
                    catch (IOException iOException) {
                        string2 = "Save ACL properties file failed!";
                        ServiceLogger.logError(iOException);
                    }
                    this.logManageSuccessEvent("create ACL " + realm.getName() + ":" + string4);
                    this.IDS_EDIT_ACL(string3);
                }
                catch (NoSuchRealmException noSuchRealmException) {
                    string2 = "Realm " + string3 + " does not exist!";
                    ServiceLogger.logError(noSuchRealmException);
                }
                catch (BadRealmException badRealmException) {
                    string2 = "Realm " + string3 + " is invalid!";
                    ServiceLogger.logError(badRealmException);
                }
            }
        }
        if (string2 != null) {
            this.printMessage(new String[]{"realm", string3}, string2, string);
        }
    }

    private void IDS_LIST_REALM() throws IOException {
        String string = this.request.getParameter("realm");
        String string2 = HttpUtil.decodeEsc(this.request.getParameter("acl"));
        String string3 = "";
        string3 = string3 + "<input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
        string3 = string3 + "<input type=\"hidden\" name=\"oldAcl\" value=\"" + string2 + "\">";
        string3 = string3 + " <table border=\"0\" width=\"100%\">";
        string3 = string3 + "  <tr>";
        string3 = string3 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; New ACL</font></strong></td>";
        string3 = string3 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "]</font></small></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + " </table>";
        string3 = string3 + " <hr>";
        string3 = string3 + " <table border=\"0\" width=\"100%\" height=\"60\">";
        string3 = string3 + "  <tr>";
        string3 = string3 + "   <td width=\"14%\" align=\"right\" valign=\"top\" height=\"1\"><u><small><font face=\"Arial\">ACL";
        string3 = string3 + "   Name:</font></small></u></td>";
        string3 = string3 + "   <td width=\"86%\" valign=\"top\" align=\"left\" height=\"1\">";
        string3 = string3 + "   <input type=\"text\" name=\"ACL\" size=\"20\" value=" + string2 + "></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + "  <tr>";
        string3 = string3 + "   <td width=\"14%\" height=\"37\"></td>";
        string3 = string3 + "   <td width=\"86%\" valign=\"bottom\" align=\"left\" height=\"37\">";
        string3 = string3 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_EDIT_ACL + "\">";
        string3 = string3 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_ACL + "\"></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + " </table>";
        this.writeResponse(string3);
    }

    private void IDS_NEW_ACL() throws IOException {
        String string = this.request.getParameter("realm");
        String string2 = "";
        string2 = string2 + " <table border=\"0\" width=\"100%\">";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; New ACL</font></strong></td>";
        string2 = string2 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "]</font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + " </table>";
        string2 = string2 + " <hr>";
        string2 = string2 + " <table border=\"0\" width=\"100%\" height=\"60\">";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"14%\" align=\"right\" valign=\"top\" height=\"1\"><u><small><font face=\"Arial\">ACL";
        string2 = string2 + "   Name:</font></small></u></td>";
        string2 = string2 + "   <td width=\"86%\" valign=\"top\" align=\"left\" height=\"1\">";
        string2 = string2 + " <input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
        string2 = string2 + "   <input type=\"text\" name=\"ACL\" size=\"20\" maxlength=\"32\"></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"14%\" height=\"37\"></td>";
        string2 = string2 + "   <td width=\"86%\" valign=\"bottom\" align=\"left\" height=\"37\">";
        string2 = string2 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_NEW_ACL + "\">";
        string2 = string2 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_ACL + "\"></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + " </table>";
        this.writeResponse(string2);
    }

    private void IDS_REMOVE_ACL() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("ACL");
        if (string2.equals("rootAcl") || string2.equals("adminAcl")) {
            String string3 = "ACL " + string2 + " cannot be deleted!";
            this.printMessage(new String[]{"realm", string}, string3, IDS_LIST_ACL);
        } else {
            String string4 = "  Do you confirm to delete ACL \"" + string2 + "\"?";
            String[] stringArray = new String[]{"realm", string, "ACL", string2};
            String[] stringArray2 = new String[]{" Yes ", IDS_REMOVE_ACL, " No ", IDS_LIST_ACL};
            this.printMessage(stringArray, string4, stringArray2);
        }
    }

    private void IDS_REMOVE_ACL_MEMBER() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("ACL");
        String string3 = null;
        String string4 = IDS_LIST_ACL;
        try {
            Realm realm = Realm.get(string);
            Enumeration enumeration = realm.getResources();
            while (enumeration.hasMoreElements()) {
                Resource resource = (Resource)enumeration.nextElement();
                if (!resource.getAclName().equalsIgnoreCase(string2)) continue;
                string3 = JSvrResource.getMessage("SVR_46", string2);
                this.logManageFailEvent("delete ACL " + string + ":" + string2);
                break;
            }
            if (string3 == null) {
                realm.deleteAcl(string2);
                UserDataToolkit.deleteAclData(string, string2);
                this.logManageSuccessEvent("delete ACL " + string + ":" + string2);
                this.IDS_EDIT_ACL(string);
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string3 = "Realm " + string + " does not exist!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string3 = "Realm " + string + " is invalid!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchAclException noSuchAclException) {
            string3 = "ACL " + string2 + " does not exist!";
            ServiceLogger.logError(noSuchAclException);
        }
        if (string3 != null) {
            this.printMessage(new String[]{"realm", string}, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_REQUEST_ADD_PERMISSION() throws IOException {
        String[] stringArray;
        String string = this.getPropertyIgnoreCase("member");
        String string2 = this.getPropertyIgnoreCase("realm");
        String string3 = this.getPropertyIgnoreCase("ACL");
        String string4 = null;
        String string5 = IDS_LIST_ACL;
        try {
            String string6;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            stringArray = Realm.get(string2);
            Acl acl = stringArray.getAcl(string3);
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Acl acl2 = acl;
            synchronized (acl2) {
                object5 = acl.entries();
                while (object5.hasMoreElements()) {
                    object4 = (AclEntryImpl)object5.nextElement();
                    Principal principal = null;
                    try {
                        principal = ((AclEntryImpl)object4).getPrincipal();
                        if (principal == null) {
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                        return;
                    }
                    object3 = ((AclEntryImpl)object4).isNegative() ? JSvrResource.getDlgText("AclManagePanel", "deny") : JSvrResource.getDlgText("AclManagePanel", "allow");
                    object2 = null;
                    try {
                        if (stringArray.getUser(principal.getName()) != null) {
                            if (!hashtable2.containsKey(principal.getName())) {
                                hashtable2.put(principal.getName(), new Vector());
                            }
                            object2 = (Vector)hashtable2.get(principal.getName());
                        }
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        if (!hashtable.containsKey(principal.getName())) {
                            hashtable.put(principal.getName(), new Vector());
                        }
                        object2 = (Vector)hashtable.get(principal.getName());
                    }
                    object = ((AclEntryImpl)object4).permissions();
                    while (object.hasMoreElements()) {
                        string6 = ((PermissionImpl)object.nextElement()).getName();
                        ((Vector)object2).addElement(string6 + "(" + (String)object3 + ")");
                    }
                }
            }
            object5 = "";
            object5 = (String)object5 + "<input type=\"hidden\" name=\"realm\" value=\"" + string2 + "\">";
            object5 = (String)object5 + "<input type=\"hidden\" name=\"ACL\" value=\"" + string3 + "\">";
            object5 = (String)object5 + " <table border=\"0\" width=\"100%\">";
            object5 = (String)object5 + "  <tr>";
            object5 = (String)object5 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Permissions</font></strong></td>";
            object5 = (String)object5 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string2 + "] &nbsp;";
            object5 = (String)object5 + "   ACL: [" + string3 + "]</font></small></td>";
            object5 = (String)object5 + "  </tr>";
            object5 = (String)object5 + " </table>";
            object5 = (String)object5 + " <hr>";
            object5 = (String)object5 + " <div align=\"center\"><center><table border=\"1\" width=\"93%\">";
            object5 = (String)object5 + "  <tr>";
            object5 = (String)object5 + "   <td width=\"100%\"><font face=\"Arial\"><small><strong>Note</strong>: <em>1. The members";
            object5 = (String)object5 + "   enclosed in square brackets &quot;[]&quot; are groups.</small><br>";
            object5 = (String)object5 + "   <small>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 2. Click on Refresh image button to update";
            object5 = (String)object5 + "   permissions list according to the selected user/group.</small></em></font></td>";
            object5 = (String)object5 + "  </tr>";
            object5 = (String)object5 + " </table>";
            object5 = (String)object5 + " </center></div><p>&nbsp;</p>";
            object5 = (String)object5 + " <table border=\"0\" width=\"100%\" height=\"60\">";
            object5 = (String)object5 + "  <tr>";
            object5 = (String)object5 + "   <td width=\"21%\" align=\"right\" valign=\"top\" height=\"1\"><u><small><font face=\"Arial\">Users";
            object5 = (String)object5 + "   &amp; Groups:</font></small></u></td>";
            object5 = (String)object5 + "   <td width=\"79%\" valign=\"top\" align=\"left\" height=\"1\"><select name=\"member\" size=\"5\">";
            object4 = null;
            boolean bl = string == null;
            object3 = hashtable2.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = bl || string != null && string.equals(object2) ? "selected" : "";
                object5 = (String)object5 + "<option " + (String)object + " value=\"" + (String)object2 + "\">" + (String)object2 + "</option>";
                bl = false;
                if (((String)object).length() <= 0) continue;
                object4 = (Vector)hashtable2.get(object2);
            }
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string6 = "[" + (String)object + "]";
                String string7 = bl || string != null && string.equals(string6) ? "selected" : "";
                object5 = (String)object5 + "<option " + string7 + " value=\"" + string6 + "\">" + string6 + "</option>";
                bl = false;
                if (string7.length() <= 0) continue;
                object4 = (Vector)hashtable.get(object);
            }
            object5 = (String)object5 + "   </select></td>";
            object5 = (String)object5 + "  </tr>";
            object5 = (String)object5 + "  <tr>";
            object5 = (String)object5 + "   <td width=\"21%\" height=\"37\" align=\"right\" valign=\"top\"><u><small><font face=\"Arial\">Permissions";
            object5 = (String)object5 + "   of The Selected User/Group:</font></small></u></td>";
            object5 = (String)object5 + "   <td width=\"79%\" valign=\"bottom\" align=\"left\" height=\"37\"><select name=\"permission\" size=\"5\">";
            if (object4 != null) {
                int n = 0;
                while (n < ((Vector)object4).size()) {
                    string6 = (String)((Vector)object4).elementAt(n);
                    object5 = (String)object5 + "<option " + (n == 0 ? "selected" : "") + " value=\"" + string6 + "\">" + string6 + "</option>";
                    ++n;
                }
            }
            object5 = (String)object5 + "   </select></td>";
            object5 = (String)object5 + "  </tr>";
            object5 = (String)object5 + "  <tr>";
            object5 = (String)object5 + "   <td width=\"21%\" height=\"37\"></td>";
            object5 = (String)object5 + "   <td width=\"79%\" valign=\"bottom\" align=\"left\" height=\"37\">";
            object5 = (String)object5 + "    <input  type=\"submit\" value=\" Refresh \" name=\"button" + IDS_LIST_PERMISSION + "\">";
            object5 = (String)object5 + "    <input  type=\"submit\" value=\" Add \" name=\"button" + IDS_REQUEST_ADD_PERMISSION + "\">";
            if (object4 != null && ((Vector)object4).size() > 0) {
                object5 = (String)object5 + "    <input  type=\"submit\" value=\"Delete\" name=\"button" + IDS_DELETE_PERMISSION + "\">";
            }
            object5 = (String)object5 + "    <input  type=\"submit\" value=\"Close\" name=\"button" + IDS_LIST_ACL + "\">";
            object5 = (String)object5 + "   </td>";
            object5 = (String)object5 + "  </tr>";
            object5 = (String)object5 + " </table>";
            this.writeResponse((String)object5);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string4 = "Realm " + string2 + " does not exist!";
            string5 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string4 = "Realm " + string2 + " is invalid!";
            string5 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchAclException noSuchAclException) {
            string4 = "ACL " + string3 + " does not exist!";
            ServiceLogger.logError(noSuchAclException);
        }
        if (string4 != null) {
            stringArray = new String[]{"realm", string2, "ACL", string3};
            this.printMessage(stringArray, string4, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_REQUEST_EDIT_ACL(boolean bl) throws IOException {
        String[] stringArray;
        String string = this.getPropertyIgnoreCase("memberName");
        String string2 = this.getPropertyIgnoreCase("realm");
        String string3 = this.getPropertyIgnoreCase("ACL");
        String string4 = null;
        String string5 = IDS_LIST_PERMISSION;
        String string6 = string;
        try {
            Acl acl;
            stringArray = Realm.get(string2);
            Acl acl2 = acl = stringArray.getAcl(string3);
            synchronized (acl2) {
                Object object;
                AclEntryImpl aclEntryImpl = null;
                Enumeration enumeration = acl.entries();
                while (enumeration.hasMoreElements()) {
                    aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
                    if (aclEntryImpl.getPrincipal() == null || !aclEntryImpl.getPrincipal().getName().equalsIgnoreCase(string6)) continue;
                    acl.removeEntry(null, (AclEntry)aclEntryImpl);
                }
                AclEntryImpl aclEntryImpl2 = new AclEntryImpl(string6);
                aclEntryImpl2.setRealmName(string2);
                boolean bl2 = true;
                int n = 0;
                Enumeration enumeration2 = Permissions.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (PermissionImpl)enumeration2.nextElement();
                    if (this.getPropertyIgnoreCase("" + n).equals("allow")) {
                        aclEntryImpl2.addPermission((Permission)object);
                        bl2 = false;
                    }
                    ++n;
                }
                object = new AclEntryImpl(string6);
                ((AclEntryImpl)object).setRealmName(string2);
                ((AclEntryImpl)object).setNegativePermissions();
                boolean bl3 = true;
                n = 0;
                Enumeration enumeration3 = Permissions.elements();
                while (enumeration3.hasMoreElements()) {
                    PermissionImpl permissionImpl = (PermissionImpl)enumeration3.nextElement();
                    if (this.getPropertyIgnoreCase("" + n).equals("deny")) {
                        ((AclEntryImpl)object).addPermission(permissionImpl);
                        bl3 = false;
                    }
                    ++n;
                }
                if (!bl2) {
                    acl.addEntry(null, (AclEntry)aclEntryImpl2);
                }
                if (!bl3) {
                    acl.addEntry(null, (AclEntry)object);
                }
            }
            try {
                UserDataToolkit.saveAclProperties((AclImpl)acl);
            }
            catch (IOException iOException) {
                string4 = "Save ACL properties file failed!";
                ServiceLogger.logError(iOException);
            }
            this.logManageSuccessEvent("add permission to ACL " + string2 + ":" + string3 + System.getProperty("line.separator") + ((AclImpl)acl).listPermissions());
            if (bl) {
                this.IDS_DELETE_PERMISSION();
            } else {
                this.IDS_APPLY_PERMISSION();
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string4 = "Realm " + string2 + " does not exist!";
            string5 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string4 = "Realm " + string2 + " is invalid!";
            string5 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchAclException noSuchAclException) {
            string4 = "ACL " + string3 + " does not exist!";
            string5 = IDS_LIST_ACL;
            ServiceLogger.logError(noSuchAclException);
        }
        catch (NotOwnerException notOwnerException) {
            string4 = "NotOwnerException:" + (Object)((Object)notOwnerException);
            ServiceLogger.logError(notOwnerException);
        }
        if (string4 != null) {
            stringArray = new String[]{"realm", string2, "ACL", string3};
            this.printMessage(stringArray, string4, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_REQUEST_EDIT_ACL_MEMBER() throws IOException {
        String[] stringArray;
        String string = this.getPropertyIgnoreCase("member");
        String string2 = this.getPropertyIgnoreCase("realm");
        String string3 = this.getPropertyIgnoreCase("ACL");
        String string4 = null;
        String string5 = IDS_LIST_PERMISSION;
        try {
            String string6;
            Object object;
            Enumeration enumeration;
            String[] stringArray2;
            Object object2;
            User user;
            String[] stringArray3 = stringArray = Realm.get(string2);
            synchronized (stringArray3) {
                if (string == null || string.length() == 0) {
                    string = (String)stringArray.getUserNames().nextElement();
                }
                user = !string.startsWith("[") ? stringArray.getUser(string) : stringArray.getGroup(string.substring(1, string.length() - 1));
            }
            Acl acl = stringArray.getAcl(string3);
            Vector vector = new Vector();
            String[] stringArray4 = new Vector();
            Acl acl2 = acl;
            synchronized (acl2) {
                object2 = acl.entries();
                while (object2.hasMoreElements()) {
                    AclEntryImpl aclEntryImpl = (AclEntryImpl)object2.nextElement();
                    if (aclEntryImpl.getPrincipal() != user) continue;
                    stringArray2 = aclEntryImpl.isNegative() ? stringArray4 : vector;
                    enumeration = aclEntryImpl.permissions();
                    while (enumeration.hasMoreElements()) {
                        object = ((PermissionImpl)enumeration.nextElement()).getName();
                        stringArray2.addElement(object);
                    }
                }
            }
            object2 = "";
            object2 = (String)object2 + "<input type=\"hidden\" name=\"realm\" value=\"" + string2 + "\">";
            object2 = (String)object2 + "<input type=\"hidden\" name=\"ACL\" value=\"" + string3 + "\">";
            object2 = (String)object2 + " <table border=\"0\" width=\"100%\">";
            object2 = (String)object2 + "  <tr>";
            object2 = (String)object2 + "   <td width=\"43%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Edit User's Permissions</font></strong></td>";
            object2 = (String)object2 + "   <td width=\"57%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string2 + "] &nbsp;";
            object2 = (String)object2 + "   ACL: [" + string3 + "]</font></small></td>";
            object2 = (String)object2 + "  </tr>";
            object2 = (String)object2 + " </table>";
            object2 = (String)object2 + " <hr>";
            object2 = (String)object2 + " <div align=\"center\"><center><table border=\"1\" width=\"94%\">";
            object2 = (String)object2 + "  <tr>";
            object2 = (String)object2 + "   <td width=\"100%\"><small><font face=\"Arial\"><strong>Note</strong>: <em>1. The members";
            object2 = (String)object2 + "   enclosed in square blanckets &quot;[]&quot; are groups.<br>";
            object2 = (String)object2 + "   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 2. Click on Refresh image button to update";
            object2 = (String)object2 + "   permissions according to the selected user/group.</em></font></small></td>";
            object2 = (String)object2 + "  </tr>";
            object2 = (String)object2 + " </table>";
            object2 = (String)object2 + " </center></div><p>&nbsp;</p>";
            object2 = (String)object2 + " <table border=\"0\" width=\"100%\" height=\"59\">";
            object2 = (String)object2 + "  <tr>";
            object2 = (String)object2 + "   <td width=\"27%\" align=\"right\" valign=\"top\" height=\"1\"><u><small><font face=\"Arial\">Users";
            object2 = (String)object2 + "   &amp; Groups:</font></small></u></td>";
            object2 = (String)object2 + "   <td width=\"73%\" valign=\"top\" align=\"left\" height=\"1\"><select name=\"member\" size=\"5\">";
            boolean bl = string == null;
            stringArray2 = stringArray;
            synchronized (stringArray2) {
                enumeration = stringArray.getUserNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    string6 = bl || string != null && string.equals(object) ? "selected" : "";
                    object2 = (String)object2 + "<option " + string6 + " value=\"" + (String)object + "\">" + (String)object + "</option>";
                    bl = false;
                }
                object = stringArray.getGroupNames();
                while (object.hasMoreElements()) {
                    string6 = "[" + (String)object.nextElement() + "]";
                    String string7 = bl || string != null && string.equals(string6) ? "selected" : "";
                    object2 = (String)object2 + "<option " + string7 + " value=\"" + string6 + "\">" + string6 + "</option>";
                    bl = false;
                }
            }
            object2 = (String)object2 + "   </select></td>";
            object2 = (String)object2 + "  </tr>";
            object2 = (String)object2 + "  <tr>";
            object2 = (String)object2 + "   <td width=\"27%\" height=\"34\" align=\"left\" valign=\"bottom\"><u><small><font face=\"Arial\"><p";
            object2 = (String)object2 + "   align=\"right\">Permissions:</font></small></u></td>";
            object2 = (String)object2 + "   <td width=\"73%\" valign=\"bottom\" align=\"left\" height=\"34\">";
            object2 = (String)object2 + "    <input  type=\"image\" src=\"" + this.getImage("btnrefreshdn") + "\" name=\"image" + IDS_REQUEST_ADD_PERMISSION + "\" width=\"42\" height=\"42\" alt=\"btnrefreshdn.gif (1262 bytes)\"></td>";
            object2 = (String)object2 + "  </tr>";
            int n = 0;
            object = Permissions.elements();
            while (object.hasMoreElements()) {
                string6 = ((PermissionImpl)object.nextElement()).getName();
                int n2 = 0;
                if (vector.contains(string6) == stringArray4.contains(string6)) {
                    n2 = 2;
                } else if (stringArray4.contains(string6)) {
                    n2 = 1;
                }
                object2 = (String)object2 + "  <tr>";
                object2 = (String)object2 + "   <td width=\"27%\" height=\"22\" align=\"right\" valign=\"top\"><u><small><font face=\"Arial\">" + string6 + ":</font></small></u></td>";
                object2 = (String)object2 + "   <td width=\"73%\" valign=\"top\" align=\"left\" height=\"22\">";
                object2 = (String)object2 + "    <input type=\"radio\" name=\"" + n + "\" value=\"allow\" " + (n2 == 0 ? "checked" : "") + ">Allow&nbsp;&nbsp;&nbsp; ";
                object2 = (String)object2 + "    <input type=\"radio\" name=\"" + n + "\" value=\"deny\" " + (n2 == 1 ? "checked" : "") + ">Deny &nbsp;&nbsp; ";
                object2 = (String)object2 + "    <input type=\"radio\" name=\"" + n + "\" value=\"none\" " + (n2 == 2 ? "checked" : "") + ">None</td>";
                object2 = (String)object2 + "  </tr>";
                ++n;
            }
            object2 = (String)object2 + "  <tr>";
            object2 = (String)object2 + "   <td width=\"27%\" height=\"39\" align=\"right\" valign=\"top\"></td>";
            object2 = (String)object2 + "   <td width=\"73%\" valign=\"bottom\" align=\"left\" height=\"39\">";
            object2 = (String)object2 + "   <input  type=\"submit\" value=\"Apply\" name=\"button" + IDS_APPLY_PERMISSION + "\">";
            object2 = (String)object2 + "   <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_ADD_PERMISSION + "\">";
            object2 = (String)object2 + "   <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_PERMISSION + "\"></td>";
            object2 = (String)object2 + "  </tr>";
            object2 = (String)object2 + " </table>";
            this.writeResponse((String)object2);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string4 = "Realm " + string2 + " does not exist!";
            string5 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string4 = "Realm " + string2 + " is invalid!";
            string5 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchAclException noSuchAclException) {
            string4 = "ACL " + string3 + " does not exist!";
            string5 = IDS_LIST_ACL;
            ServiceLogger.logError(noSuchAclException);
        }
        catch (NoSuchUserException noSuchUserException) {
            string4 = "User " + string + " does not exist!";
            ServiceLogger.logError(noSuchUserException);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            string4 = "Group " + string.substring(1, string.length() - 1) + " does not exist!";
            ServiceLogger.logError(noSuchGroupException);
        }
        if (string4 != null) {
            stringArray = new String[]{"realm", string2, "ACL", string3};
            this.printMessage(stringArray, string4, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_REQUEST_EDIT_MEMBER_PERMISSION() throws IOException {
        String[] stringArray;
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("ACL");
        String string3 = this.getPropertyIgnoreCase("member");
        String string4 = this.getPropertyIgnoreCase("permission");
        String string5 = null;
        String string6 = IDS_LIST_PERMISSION;
        String string7 = string3.startsWith("[") ? string3.substring(1, string3.length() - 1) : string3;
        try {
            Acl acl;
            Object object;
            String[] stringArray2 = stringArray = Realm.get(string);
            synchronized (stringArray2) {
                object = string3.startsWith("[") ? stringArray.getGroup(string7) : stringArray.getUser(string7);
            }
            String string8 = string4;
            string8 = string8.substring(0, string8.indexOf("("));
            boolean bl = string4.endsWith(JSvrResource.getDlgText("AclManagePanel", "deny") + ")");
            Acl acl2 = acl = stringArray.getAcl(string2);
            synchronized (acl2) {
                Enumeration enumeration = acl.entries();
                while (enumeration.hasMoreElements()) {
                    AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
                    if (aclEntryImpl.getPrincipal() == null || !aclEntryImpl.getPrincipal().equals(object) || aclEntryImpl.isNegative() != bl) continue;
                    aclEntryImpl.removePermission(Permissions.getPermission(string8));
                    if (aclEntryImpl.permissions().hasMoreElements()) continue;
                    acl.removeEntry((Principal)object, (AclEntry)aclEntryImpl);
                }
            }
            try {
                UserDataToolkit.saveAclProperties((AclImpl)acl);
            }
            catch (IOException iOException) {
                string5 = "Save ACL properties file failed!";
                ServiceLogger.logError(iOException);
            }
            this.logManageSuccessEvent("delete permission from ACL " + string + ":" + string2 + System.getProperty("line.separator") + ((AclImpl)acl).listPermissions());
            this.IDS_REQUEST_ADD_PERMISSION();
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string5 = "Realm " + string + " does not exist!";
            string6 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            string5 = "Realm " + string + " is invalid!";
            string6 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError(badRealmException);
        }
        catch (NoSuchAclException noSuchAclException) {
            string5 = "ACL " + string2 + " does not exist!";
            string6 = IDS_LIST_ACL;
            ServiceLogger.logError(noSuchAclException);
        }
        catch (NoSuchUserException noSuchUserException) {
            string5 = "User " + string3 + " does not exist!";
            ServiceLogger.logError(noSuchUserException);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            string5 = "Group " + string3.substring(1, string3.length() - 1) + " does not exist!";
            ServiceLogger.logError(noSuchGroupException);
        }
        catch (NotOwnerException notOwnerException) {
            string5 = "NotOwnerException: " + (Object)((Object)notOwnerException);
            ServiceLogger.logError(notOwnerException);
        }
        if (string5 != null) {
            stringArray = new String[]{"realm", string, "ACL", string2, "member", string3};
            this.printMessage(stringArray, string5, string6);
        }
    }
}

