/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resource;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;
import jet.JSvrResource;
import jet.server.api.exception.UnknownMIMEType;
import jet.server.log.ServiceLogger;
import jet.server.resource.AliasNode;
import jet.server.resource.AliasRoot;
import jet.server.resource.ResourceTreeMan;
import jet.server.resource.RptResourceManager;
import jet.server.resource.RptResourceNode;
import jet.server.resource.RptResourceRoot;
import jet.server.resource.RscNodeInterface;
import jet.server.util.MIMETypeTable;
import jet.util.WildcardMatcher;

public class JRptUtil {
    public static Vector getRptFiles(File file, MIMETypeTable mIMETypeTable) throws IOException {
        String string = new File(file.getCanonicalPath()).getParent();
        File file2 = new File(string);
        String[] stringArray = null;
        String[] stringArray2 = mIMETypeTable.getExts("application/x-jrreport");
        Vector<String> vector = new Vector<String>();
        if (stringArray2 != null) {
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                stringArray = file2.list((FilenameFilter)new WildcardMatcher("*" + stringArray2[n2], true, 2));
                if (stringArray != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        vector.addElement(stringArray[n3]);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return vector;
    }

    public static Vector getRptFiles(File file, String string) throws IOException {
        String string2 = new File(file.getCanonicalPath()).getParent();
        File file2 = new File(string2);
        if (file.isDirectory()) {
            file2 = file;
        }
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        if (string != null && (stringArray = file2.list((FilenameFilter)new WildcardMatcher("*." + string, true, 2))) != null) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        return vector;
    }

    public static String getRptFilesDir(File file) throws IOException {
        String string = new File(file.getCanonicalPath()).getParent();
        return string;
    }

    public static boolean isRptBelongsToCat(String string, String string2, MIMETypeTable mIMETypeTable) {
        try {
            String string3;
            String string4;
            if (mIMETypeTable.mimeCheck("application/x-jrreport", string2) && (string4 = new File(string).getParent()).equals(string3 = new File(string2).getParent())) {
                return true;
            }
        }
        catch (UnknownMIMEType unknownMIMEType) {
            ServiceLogger.logError(unknownMIMEType, 3);
        }
        return false;
    }

    public static boolean isRptBelongsToCat(File file, String string, MIMETypeTable mIMETypeTable) throws UnknownMIMEType {
        if (mIMETypeTable.mimeCheck("application/x-jrreport", string)) {
            try {
                File file2 = new File(new File(file.getCanonicalPath()).getParent(), string);
                if (file2.exists() && !file2.isDirectory()) {
                    return true;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public static String checkNewName(RptResourceNode rptResourceNode, String string) {
        String string2 = null;
        if (!rptResourceNode.getText().equals(string)) {
            if (!rptResourceNode.isEditable()) {
                string2 = JSvrResource.getMessage("RSCEDITOR_ERROR9");
            } else if (!(rptResourceNode instanceof RptResourceRoot) && ((RptResourceNode)rptResourceNode.getParent()).getRscByName(string) != null) {
                string2 = JSvrResource.getMessage("RSCEDITOR_ERROR10");
            }
        }
        return string2;
    }

    public static String checkNewRealPath(RptResourceManager rptResourceManager, RptResourceNode rptResourceNode, String string, MIMETypeTable mIMETypeTable) {
        String string2;
        block9: {
            if (string.equals("")) {
                return null;
            }
            string2 = null;
            File file = new File(string);
            if (file.exists()) {
                try {
                    if (mIMETypeTable.mimeCheck("application/x-jrreport", string)) {
                        File file2 = new File(string);
                        try {
                            String string3 = file2.getCanonicalPath();
                            RptResourceNode rptResourceNode2 = (RptResourceNode)rptResourceNode.getParent();
                            if (rptResourceNode2 == null) break block9;
                            String string4 = rptResourceNode2.getRealPath();
                            if (rptResourceNode2.isCatNode() && !JRptUtil.isRptBelongsToCat(string4, string3, mIMETypeTable)) {
                                string2 = JSvrResource.getMessage("RSCEDITOR_ERROR11");
                            }
                            break block9;
                        }
                        catch (IOException iOException) {
                            string2 = JSvrResource.getMessage("RSCEDITOR_ERROR11");
                        }
                        break block9;
                    }
                    RptResourceNode rptResourceNode3 = (RptResourceNode)rptResourceNode.getParent();
                    if (rptResourceNode3 != null && rptResourceNode3.isCatNode()) {
                        string2 = JSvrResource.getMessage("RSCEDITOR_ERROR12");
                    }
                }
                catch (UnknownMIMEType unknownMIMEType) {
                    string2 = JSvrResource.getMessage("RSCEDITOR_ERROR5", unknownMIMEType.getMessage());
                }
            }
        }
        return string2;
    }

    public static String canCreateNew(RscNodeInterface rscNodeInterface) {
        String string = null;
        if (rscNodeInterface instanceof RptResourceNode) {
            RptResourceNode rptResourceNode = (RptResourceNode)rscNodeInterface;
            RptResourceNode rptResourceNode2 = (RptResourceNode)rptResourceNode.getParent();
            if (rscNodeInterface.isJRptNode() && rptResourceNode2 != null && rptResourceNode2.isCatNode()) {
                string = JSvrResource.getMessage("RSCEDITOR_ERROR4");
            }
        }
        return string;
    }

    public static String checkAliasNewName(AliasNode aliasNode, String string) {
        if (aliasNode.getText().equals(string)) {
            return null;
        }
        String string2 = null;
        if (!aliasNode.isEditable()) {
            string2 = JSvrResource.getMessage("ALIASEDITOR_ERROR7");
        } else if (!(aliasNode instanceof AliasRoot) && ((AliasNode)aliasNode.getParent()).hasNode(string)) {
            string2 = JSvrResource.getMessage("ALIASEDITOR_ERROR8");
        }
        return string2;
    }

    public static String checkAliasNewMappings(RptResourceManager rptResourceManager, AliasNode aliasNode, String string) {
        block13: {
            int n;
            Object object;
            RptResourceNode rptResourceNode;
            if (string == null || string.trim().length() == 0) {
                return null;
            }
            ResourceTreeMan resourceTreeMan = rptResourceManager.getResourceTreeMan();
            RptResourceNode rptResourceNode2 = resourceTreeMan.getResourceNode(string);
            AliasNode aliasNode2 = (AliasNode)aliasNode.getParent();
            if (aliasNode2 != null && (rptResourceNode = resourceTreeMan.getResourceNode((String)(object = aliasNode2.getResourceName()))) != null && rptResourceNode.isCatNode()) {
                if (rptResourceNode2 == null || rptResourceNode2.getParent() != rptResourceNode) {
                    return JSvrResource.getMessage("ALIASEDITOR_ERROR10");
                }
                return null;
            }
            if (rptResourceNode2 == null || !rptResourceNode2.isCatNode()) break block13;
            object = aliasNode.getSubNodes();
            int n2 = n = object == null ? 0 : ((Vector)object).size();
            if (n > 0) {
                int n3;
                Vector vector = rptResourceNode2.getRscNodes();
                int n4 = n3 = vector == null ? 0 : vector.size();
                if (n3 > 0) {
                    Vector<String> vector2 = new Vector<String>(n3);
                    int n5 = 0;
                    while (n5 < n3) {
                        vector2.addElement(((RptResourceNode)vector.elementAt(n5)).getFullName());
                        ++n5;
                    }
                    int n6 = 0;
                    while (n6 < n) {
                        AliasNode aliasNode3 = (AliasNode)((Vector)object).elementAt(n6);
                        String string2 = aliasNode3.getResourceName();
                        if (string2 != null && string2.trim().length() > 0 && !vector2.contains(string2)) {
                            return JSvrResource.getMessage("ALIASEDITOR_ERROR12", new String[]{string, aliasNode3.getText(), string2});
                        }
                        if (aliasNode3.numberOfSubNodes() > 0) {
                            return JSvrResource.getMessage("ALIASEDITOR_ERROR13", string);
                        }
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n) {
                        AliasNode aliasNode4 = (AliasNode)((Vector)object).elementAt(n7);
                        String string3 = aliasNode4.getResourceName();
                        if (string3 != null && string3.trim().length() > 0) {
                            return JSvrResource.getMessage("ALIASEDITOR_ERROR12", new String[]{string, aliasNode4.getText(), string3});
                        }
                        if (aliasNode4.numberOfSubNodes() > 0) {
                            return JSvrResource.getMessage("ALIASEDITOR_ERROR13", string);
                        }
                        ++n7;
                    }
                }
            }
        }
        return null;
    }

    public static String canCreateNewSubAlias(RptResourceManager rptResourceManager, AliasNode aliasNode) {
        AliasNode aliasNode2 = (AliasNode)aliasNode.getParent();
        if (aliasNode2 == null) {
            return null;
        }
        String string = aliasNode2.getResourceName();
        if (string == null) {
            return null;
        }
        RptResourceNode rptResourceNode = rptResourceManager.getResourceTreeMan().getResourceNode(string);
        if (rptResourceNode == null || !rptResourceNode.isCatNode()) {
            return null;
        }
        return JSvrResource.getMessage("ALIASEDITOR_ERROR11", aliasNode.getFullName());
    }

    public static boolean refersToCatNode(ResourceTreeMan resourceTreeMan, AliasNode aliasNode) {
        RptResourceNode rptResourceNode;
        String string = aliasNode.getResourceName();
        return string != null && (rptResourceNode = resourceTreeMan.getResourceNode(string)) != null && rptResourceNode.isCatNode();
    }

    public static Vector getValidRptNodesName(RptResourceNode rptResourceNode, String string, MIMETypeTable mIMETypeTable) {
        Vector<String> vector = null;
        Vector vector2 = rptResourceNode.getRscNodes();
        if (vector2 != null) {
            int n = vector2.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                RptResourceNode rptResourceNode2 = (RptResourceNode)vector2.elementAt(n2);
                String string2 = rptResourceNode2.getRealPath();
                if (string2 == null || JRptUtil.isRptBelongsToCat(string, string2, mIMETypeTable)) {
                    if (vector == null) {
                        vector = new Vector<String>(1);
                    }
                    vector.addElement(rptResourceNode2.getName());
                }
                --n2;
            }
        }
        return vector;
    }

    public static boolean arrangeCatSubNodes(RptResourceNode rptResourceNode, Vector vector, Vector[] vectorArray) {
        RptResourceNode rptResourceNode2;
        boolean bl = false;
        if (vector != null) {
            Vector vector2 = rptResourceNode.getRscNodes();
            if (vector2 != null) {
                int n = vector2.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    rptResourceNode2 = (RptResourceNode)vector2.elementAt(n2);
                    if (!vector.contains(rptResourceNode2.getName())) {
                        rptResourceNode.remove(rptResourceNode2);
                        bl = true;
                    }
                    --n2;
                }
            }
        } else {
            bl = rptResourceNode.removeAllRscNodes();
        }
        if (vectorArray != null) {
            int n = vectorArray[0].size();
            int n3 = 0;
            while (n3 < n) {
                rptResourceNode2 = new RptResourceNode((String)vectorArray[0].elementAt(n3), (String)vectorArray[1].elementAt(n3), false);
                rptResourceNode.insert(rptResourceNode2, -1);
                bl = true;
                ++n3;
            }
        }
        return bl;
    }
}

