/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetSet;
import jet.controls.JetString;
import jet.cs.CSUtil;
import jet.server.schedule.TimeLaunchableObj;

public abstract class JetLch
extends JetSet {
    protected JetString uid = new JetString((JetObject)this, "uid");
    protected JetString taskId = new JetString((JetObject)this, "taskId");
    protected JetNumber timeout = new JetNumber((JetObject)this, "timeout");
    protected JetString timezone = new JetString((JetObject)this, "timezone");
    protected JetBoolean isEnabled = new JetBoolean((JetObject)this, "isEnabled");
    protected JetLch next = null;

    public JetLch() {
    }

    public JetLch(TimeLaunchableObj timeLaunchableObj, Vector vector) {
        this.uid.set(timeLaunchableObj.getUid());
        this.timeout.set(timeLaunchableObj.getTimeoutValue());
        Properties properties = timeLaunchableObj.getTask();
        if (properties != null) {
            properties.remove("jrs.schd_props");
            String string = (String)properties.get("jrs.param_file");
            if (string != null) {
                properties.put("jrs.param_file", CSUtil.getFileNameOnly(string));
            }
            this.taskId.set(timeLaunchableObj.getTaskId());
            properties.put("jrs.task_id", timeLaunchableObj.getTaskId());
            vector.addElement(properties);
        }
        this.isEnabled.set(timeLaunchableObj.isEnabled());
    }

    public long getTimeoutValue() {
        return this.timeout.longValue();
    }

    public String getTaskId() {
        return this.taskId.get();
    }

    public String getUid() {
        return this.uid.get();
    }

    public String getTimeZone() {
        String string = this.timezone.get();
        return string != null && string.trim().length() > 0 ? string : null;
    }

    protected JetLch getNext() {
        return this.next;
    }

    protected TimeLaunchableObj createNextLaunchableObj(Hashtable hashtable) {
        TimeLaunchableObj timeLaunchableObj = null;
        Vector vector = this.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e != null && e instanceof JetLch) {
                this.next = (JetLch)((Object)e);
                if (this.next != null && hashtable != null) {
                    timeLaunchableObj = this.next.createLaunchableObj(hashtable);
                }
            }
            ++n2;
        }
        return timeLaunchableObj;
    }

    public abstract TimeLaunchableObj createLaunchableObj(Hashtable var1);

    public abstract Hashtable toHashtable(Hashtable var1);

    public abstract void init(Hashtable var1) throws Exception;
}

