/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import jet.cs.CSUtil;
import jet.server.api.ServerInfo;
import jet.server.api.custom.schedule.ExtParameterGenerator;
import jet.server.api.custom.schedule.ParameterGenerator;
import jet.server.api.exception.GenerateParameterException;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTUtil;

public class ParameterManager {
    public static boolean usedParamGen(Properties properties) {
        Object object = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            object = enumeration.nextElement();
            if (!(object instanceof String) || !(string2 = (String)object).startsWith("jrs.param$") || (string = properties.getProperty(string2)) == null || !string.startsWith("jrs.param_gen$")) continue;
            return true;
        }
        return false;
    }

    public static Properties getParameterValue(Properties properties, ServerInfo serverInfo) throws GenerateParameterException {
        if (properties == null || properties.size() == 0) {
            return null;
        }
        CSUtil.evalExpressionValues(properties);
        Properties properties2 = ParameterManager.generateParameterValue(properties, serverInfo);
        return properties2;
    }

    public static Properties generateParameterValue(Properties properties, ServerInfo serverInfo) throws GenerateParameterException {
        Properties properties2 = new Properties();
        if (properties != null && properties.size() != 0) {
            Object object;
            Object object2;
            Hashtable hashtable = new Hashtable();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = properties.get(object2);
                if (object instanceof String && object.toString().startsWith("jrs.param_gen$")) {
                    String string = object.toString().substring("jrs.param_gen$".length());
                    Object object3 = hashtable.get(object);
                    if (object3 == null) {
                        try {
                            Class<?> clazz = Class.forName(string);
                            object3 = clazz.newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ServiceLogger.logError(classNotFoundException);
                            throw new GenerateParameterException(classNotFoundException);
                        }
                        catch (InstantiationException instantiationException) {
                            instantiationException.printStackTrace();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                        }
                        if (object3 != null && (object3 instanceof ParameterGenerator || object3 instanceof ExtParameterGenerator)) {
                            if (object3 instanceof ParameterGenerator) {
                                ((ParameterGenerator)object3).initByReportContext(serverInfo);
                            } else if (object3 instanceof ExtParameterGenerator) {
                                ((ExtParameterGenerator)object3).initByReportContext(serverInfo);
                            }
                            hashtable.put(string, object3);
                        } else {
                            ServiceLogger.logError(0x189111, string, 1);
                            throw new GenerateParameterException(600022, (Object[])new String[]{string}, null);
                        }
                    }
                    if (object3 instanceof ParameterGenerator) {
                        object = ((ParameterGenerator)object3).getParameterValue((String)object2);
                    } else if (object3 instanceof ExtParameterGenerator) {
                        object = ((ExtParameterGenerator)object3).getParameterValue((String)object2);
                    }
                    if (object == null) {
                        throw new GenerateParameterException(600023, (Object[])new String[]{object2, string}, null);
                    }
                }
                properties2.put(object2, object);
            }
            if (!hashtable.isEmpty()) {
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    ((ParameterGenerator)hashtable.get(object)).close();
                    hashtable.remove(object);
                }
            }
            hashtable = null;
        }
        return properties2;
    }

    public static Properties getParameterValue(File file, ServerInfo serverInfo) throws GenerateParameterException {
        Properties properties = ParameterManager.loadDyncParamFile(file);
        return ParameterManager.getParameterValue(properties, serverInfo);
    }

    public static String createParameterFile(File file, ServerInfo serverInfo) throws GenerateParameterException {
        String string = null;
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        String string2 = file.getParent();
        String string3 = CSUtil.getNameWithoutExt(file.getName());
        string3 = string3 + "_";
        Properties properties = ParameterManager.getParameterValue(file, serverInfo);
        try {
            ParameterManager.append(properties);
            string = JRTUtil.createParamFile(SchdTools.createTempFile(string2, string3, ".param"), properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new GenerateParameterException(exception);
        }
        return string;
    }

    public static Properties loadDyncParamFile(File file) throws GenerateParameterException {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
            throw new GenerateParameterException(iOException);
        }
        return properties;
    }

    public static String getParamValues(String string, ServerInfo serverInfo) throws GenerateParameterException {
        String string2 = null;
        Properties properties = ParameterManager.convertParamValuesToProp(string);
        string2 = ParameterManager.QOIV(ParameterManager.getParameterValue(properties, serverInfo));
        return string2;
    }

    public static String getParamValueString(File file, ServerInfo serverInfo) throws GenerateParameterException {
        return ParameterManager.QOIV(ParameterManager.getParameterValue(file, serverInfo));
    }

    public static Properties convertParamValuesToProp(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            properties.put(string2.substring(0, string2.indexOf("=")), string2.substring(string2.indexOf("=") + 1));
        }
        return properties;
    }

    private static String QOIV(Properties properties) {
        String string = properties.toString();
        if (string.startsWith("{")) {
            string = string.substring(1);
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static void append(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("jrs.param$")) continue;
            String string2 = properties.getProperty(string);
            properties.remove(string);
            properties.put("jrs.param$" + string, string2);
        }
    }
}

