/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.Schedulable;
import jet.server.schedule.ExeTimeInfo;
import jet.server.schedule.JetLch;
import jet.server.schedule.JetReptLch;
import jet.server.schedule.Repeatable;
import jet.server.schedule.Scheduler;
import jet.server.schedule.TimeLaunchableObj;

public class RepeatLaunchableObj
extends TimeLaunchableObj
implements Repeatable {
    private long LINE = 0L;
    private boolean QOIV = true;
    private Schedulable addCallee = null;

    public RepeatLaunchableObj(Properties properties, Schedulable schedulable) {
        super(properties, new ExeTimeInfo(schedulable.getNextTime().getTime(), schedulable.getTimeZone(), 0L, false));
        this.addCallee = schedulable;
    }

    public Schedulable getSchedule() {
        return this.addCallee;
    }

    public long getExeTime() {
        return this.getExeTime(true);
    }

    public long getExeTime(boolean bl) {
        if (bl) {
            this.updateExeTime();
        }
        return super.getExeTime();
    }

    public boolean isSuccessful() {
        return this.QOIV;
    }

    public void setSuccessful(boolean bl) {
        this.QOIV = bl;
    }

    public boolean isExeTimeExpired() {
        return super.getExeTime() <= System.currentTimeMillis();
    }

    public void updateExeTime() {
        if (this.isExeTimeExpired()) {
            Date date = this.addCallee.getNextTime();
            if (date != null) {
                this.setExeTime(date.getTime());
            } else {
                this.scheduler.removeLaunchableObj(this);
            }
        }
    }

    public long getWakenTime() {
        return this.getExeTime();
    }

    private long LINE() {
        Date date;
        if (this.isExeTimeExpired() && (date = this.addCallee.getNextTime()) != null) {
            this.setExeTime(date.getTime());
        }
        return super.getExeTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(long l) {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.getTask().setProperty("jrs.next_exe_time", String.valueOf(this.LINE()));
            this.scheduler.instantLaunch(this);
            Object var4_2 = null;
            if (this.scheduler != null) {
                Vector vector;
                this.updateExeTime();
                if (!this.isExeTimeExpired() && (vector = this.scheduler.getRepeatables()).contains(this)) {
                    Scheduler.timer.addCallee(this);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.scheduler != null) {
                Vector vector;
                this.updateExeTime();
                if (!this.isExeTimeExpired() && (vector = this.scheduler.getRepeatables()).contains(this)) {
                    Scheduler.timer.addCallee(this);
                }
            }
            throw throwable;
        }
    }

    public boolean isLaunchEvenIfExpired() {
        return false;
    }

    public long getLastExeTime() {
        return this.LINE;
    }

    public void setLastExeTime(long l) {
        this.LINE = l;
    }

    public JetLch createJetLaunchable(Vector vector) {
        return new JetReptLch(this, vector);
    }

    public int getLaunchType() {
        return 8;
    }

    public String getTimeZone() {
        return this.addCallee == null ? CSUtil.getDefaultTimeZone() : this.addCallee.getTimeZone();
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.launch_type", String.valueOf(8));
        properties2.put("jrs.last_exe_time", String.valueOf(this.getLastExeTime()));
        properties2.put("jrs.is_successful", String.valueOf(this.QOIV));
        properties2.put("jrs.is_enabled", String.valueOf(this.isEnabled));
        if (this.addCallee != null) {
            properties2 = this.addCallee.toProperties(properties2);
        }
        return properties2;
    }

    public String toString() {
        return super.toString() + ":schedule=\"" + this.addCallee + "\"";
    }

    public static String filterRepeatLaunchableScriptItems(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector();
        CSUtil.appendScript(vector, hashtable, "jrs.launch_type", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_enabled", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_successful", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.timezone", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_after", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_minute", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_before", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_minute", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.days_id", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_weekday", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.week", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.weekdays", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_hourly", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hours", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.at_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_minutely", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.minutes", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_between", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_pm", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hour2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.min2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_pm2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.next_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_stat", true, bl);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append((String)vector.get(n)).append(CSUtil.LINE);
            ++n;
        }
        return stringBuffer.toString();
    }
}

