/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.bursting;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.dataengine.api.DSException;
import jet.dataengine.api.JDataEngine;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.util.IParseParametersForQuery;
import jet.dataengine.util.ParseParametersForQueryFactory;
import jet.exception.InvalidParameterException;
import jet.formula.JavaFormula;
import jet.formula.ParamDesc;
import jet.jetc.ReadFailureException;
import jet.rptservice.api.RawDataQueryCreator;
import jet.rptservice.api.exception.JRScheduleException;
import jet.universe.JetUUniverse;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.universe.tools.UniverseTools;

public class RawDataQueryCreatorImpl
implements RawDataQueryCreator {
    private JetUUniverse CreateParseParametersForQuery;
    private String QOIV;
    private String addElement;
    private String[] addParameterValue;
    private String contains;
    private java.util.Date createDataSourceQuery;
    private Properties elementAt;
    private boolean equalsIgnoreCase;

    RawDataQueryCreatorImpl(JetUUniverse jetUUniverse, String string, String string2, String[] stringArray, String string3, java.util.Date date, Properties properties, boolean bl) {
        this.CreateParseParametersForQuery = jetUUniverse;
        this.QOIV = string;
        this.addElement = string2;
        this.addParameterValue = stringArray;
        this.contains = string3;
        this.createDataSourceQuery = date;
        this.elementAt = properties;
        this.equalsIgnoreCase = bl;
    }

    public JRawDataQuery createRawDataQuery(JDataEngine jDataEngine, int n, ISortExpression iSortExpression) throws DSException, JRScheduleException {
        JDataSourceQuery jDataSourceQuery = jDataEngine.createDataSourceQuery(n);
        jDataSourceQuery.setCatalog(this.CreateParseParametersForQuery);
        jDataSourceQuery.setDataSourceName(this.QOIV);
        jDataSourceQuery.setQueryName(this.addElement);
        jDataSourceQuery.setOption(this.CreateParseParametersForQuery());
        jDataSourceQuery.setMappingNames(this.addParameterValue);
        jDataSourceQuery.setJavaFormula(this.QOIV());
        jDataSourceQuery.setBatchRun(true);
        try {
            jDataSourceQuery.setParameterValues(this.addElement());
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new JRScheduleException((Throwable)invalidParameterException);
        }
        jDataSourceQuery.setSpecialFields(this.createDataSourceQuery());
        if (iSortExpression != null) {
            jDataSourceQuery.setSorter(iSortExpression);
        }
        return jDataSourceQuery;
    }

    private RawDataQueryOption CreateParseParametersForQuery() throws DSException {
        RawDataQueryOption rawDataQueryOption = new RawDataQueryOption();
        rawDataQueryOption.setEngineInfo(null);
        rawDataQueryOption.setErrorlisteners(null);
        rawDataQueryOption.setFastPass(false);
        boolean bl = false;
        rawDataQueryOption.setLazyRun(bl);
        rawDataQueryOption.setMaxRecords(-1L);
        rawDataQueryOption.setMaxPageNumber(-1L);
        rawDataQueryOption.setRecordsPerPage(-1L);
        rawDataQueryOption.setSingleThread(this.equalsIgnoreCase);
        rawDataQueryOption.setNoRecord(false);
        return rawDataQueryOption;
    }

    private JavaFormula QOIV() throws JRScheduleException {
        JavaFormula javaFormula = null;
        try {
            javaFormula = this.CreateParseParametersForQuery.loadJavaFormula(this.QOIV);
        }
        catch (ReadFailureException readFailureException) {
            throw new JRScheduleException(220009, (Object[])new String[]{this.QOIV}, (Throwable)readFailureException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JRScheduleException(220009, (Object[])new String[]{this.QOIV}, (Throwable)fileNotFoundException);
        }
        catch (GenerateFormulasCodeException generateFormulasCodeException) {
            throw new JRScheduleException(220009, (Object[])new String[]{this.QOIV}, (Throwable)generateFormulasCodeException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRScheduleException(220009, (Object[])new String[]{this.QOIV}, (Throwable)classNotFoundException);
        }
        catch (IOException iOException) {
            throw new JRScheduleException(220009, (Object[])new String[]{this.QOIV}, (Throwable)iOException);
        }
        catch (InstantiationException instantiationException) {
            throw new JRScheduleException(220009, (Object[])new String[]{this.QOIV}, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JRScheduleException(220009, (Object[])new String[]{this.QOIV}, (Throwable)illegalAccessException);
        }
        catch (LoadJavaFormulaException loadJavaFormulaException) {
            throw new JRScheduleException(220009, (Object[])new String[]{this.QOIV}, (Throwable)loadJavaFormulaException);
        }
        return javaFormula;
    }

    private ParameterValueList addElement() throws DSException, InvalidParameterException {
        Vector vector = this.addParameterValue();
        if (vector == null) {
            return null;
        }
        ParameterValueList parameterValueList = new ParameterValueList();
        int n = 0;
        while (n < vector.size()) {
            ParamDesc paramDesc = (ParamDesc)vector.elementAt(n);
            this.contains(paramDesc, this.elementAt);
            parameterValueList.addParameterValue(paramDesc);
            ++n;
        }
        return parameterValueList;
    }

    private Vector addParameterValue() throws DSException {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        String[] stringArray = null;
        IParseParametersForQuery iParseParametersForQuery = ParseParametersForQueryFactory.CreateParseParametersForQuery((JetUUniverse)this.CreateParseParametersForQuery, (String)this.QOIV, (String)this.addElement);
        if (iParseParametersForQuery.isSQLQuery()) {
            stringArray = iParseParametersForQuery.getParameterNamesInSqlQueryByWherePortionString(null, null);
        } else if (iParseParametersForQuery.isProcedureQuery()) {
            stringArray = iParseParametersForQuery.getParameterNamesInProcedureQuery();
        } else if (iParseParametersForQuery.isUDSQuery()) {
            stringArray = iParseParametersForQuery.getParameterNamesInUDSQuery();
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toUpperCase();
            if (!vector2.contains(string)) {
                vector2.addElement(string);
                vector.addElement(UniverseTools.getParamDesc((String)string, (JetUUniverse)this.CreateParseParametersForQuery, (String)this.QOIV));
            }
            ++n;
        }
        return vector;
    }

    private void contains(ParamDesc paramDesc, Properties properties) throws InvalidParameterException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String string = paramDesc.getName();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.equalsIgnoreCase(string)) continue;
            paramDesc.value = string2 = (String)properties.get(string3);
            paramDesc.setValue(string2, Locale.getDefault());
            break;
        }
    }

    private SpecialFields createDataSourceQuery() {
        SpecialFields specialFields = new SpecialFields();
        specialFields.setUserName(new DbChar(this.contains));
        java.util.Date date = new java.util.Date();
        specialFields.setModifiedDate(new DbDate(new Date(this.createDataSourceQuery.getTime())));
        specialFields.setModifiedTime(new DbTime(new Time(this.createDataSourceQuery.getTime())));
        specialFields.setPrintDate(new DbDate(new Date(date.getTime())));
        specialFields.setPrintTime(new DbTime(new Time(date.getTime())));
        return specialFields;
    }
}

