/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.bursting;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.dataengine.api.DataBlock;
import jet.server.ServerEnv;
import jet.server.intf.engine.EngineContext;
import jet.server.jrc.JRTaskManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.bursting.BurstingTaskUtil;
import jet.server.schedule.bursting.SubBurstingTaskController;
import jet.server.schedule.bursting.SubBurstingTaskThread;
import jet.server.schedule.bursting.SubTaskControllerListener;
import jet.server.schedule.bursting.SubTaskThreadListener;
import jet.server.schedule.jrtasks.PublishRptTask;

public class SubBurstingTaskControllerImpl
extends UnicastRemoteObject
implements SubBurstingTaskController,
SubTaskThreadListener {
    private EngineContext QOIV;
    private Properties append;
    private JRTaskManager clear;
    private boolean clone;
    private SubBurstingTaskThread[] containsKey;
    private Hashtable createSubTask = new Hashtable();
    private SubTaskControllerListener get;
    private StringBuffer getMessage = new StringBuffer();
    private boolean getRMIServerFixedPort = false;
    private String getSharedDataBlockNumber = "";
    private boolean getSharedDataSetName = false;
    private String[] length = null;

    public SubBurstingTaskControllerImpl(EngineContext engineContext, Properties properties, JRTaskManager jRTaskManager, String[] stringArray, boolean bl) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.QOIV = engineContext;
        this.append = properties;
        this.clear = jRTaskManager;
        this.clone = bl;
        this.length = stringArray;
    }

    public void createSubTasks() throws RemoteException {
        this.QOIV();
        int n = 0;
        while (n < this.containsKey.length) {
            Properties properties = (Properties)this.append.clone();
            properties.remove("jrs.is_bursting_task");
            properties.remove("jrs.task_id");
            PublishRptTask publishRptTask = BurstingTaskUtil.createSubTask(properties, this.clear, this.QOIV, this.clone, false);
            this.containsKey[n] = new SubBurstingTaskThread(publishRptTask);
            ++n;
        }
    }

    private void QOIV() {
        this.containsKey = new SubBurstingTaskThread[2];
    }

    public void startSubTasks() {
        int n = 0;
        while (n < this.containsKey.length) {
            this.containsKey[n].I(n, this);
            this.containsKey[n].start();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subTaskFinished(int n, String string, boolean bl, String string2) {
        if (this.getSharedDataSetName) {
            return;
        }
        boolean bl2 = false;
        if (string.length() != 0) {
            if (this.getMessage.length() > 0) {
                this.getMessage.append(",");
            }
            this.getMessage.append(string);
        }
        if (bl) {
            this.getRMIServerFixedPort = true;
            this.getSharedDataBlockNumber = this.getSharedDataBlockNumber + "\r\n" + string2;
        }
        ServiceLogger.logDebug(6600207, new Object[]{new Integer(n), string, new Boolean(bl)}, 6);
        SubBurstingTaskThread[] subBurstingTaskThreadArray = this.containsKey;
        synchronized (subBurstingTaskThreadArray) {
            this.containsKey[n] = null;
            int n2 = 0;
            while (n2 < this.containsKey.length) {
                if (this.containsKey[n2] != null) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
        }
        if (!bl2) {
            ServiceLogger.logDebug(5600208, 5);
            this.quit();
            try {
                this.get.subTasksFinished(this.getMessage.length() > 0, this.getMessage.toString(), this.getRMIServerFixedPort, this.getSharedDataBlockNumber);
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(2600200, remoteException.getMessage(), 2);
                ServiceLogger.logError(remoteException, 3);
            }
            this.get = null;
        }
    }

    private void quit() {
        this.QOIV = null;
        this.append.clear();
        this.append = null;
        this.clear = null;
        this.containsKey = null;
        this.createSubTask.clear();
        this.createSubTask = null;
    }

    public void addListener(SubTaskControllerListener subTaskControllerListener) throws RemoteException {
        this.get = subTaskControllerListener;
    }

    public DataBlock[] getSharedData(String string) throws RemoteException, Exception {
        if (this.createSubTask.containsKey(string)) {
            return (DataBlock[])this.createSubTask.get(string);
        }
        DataBlock[] dataBlockArray = this.append(string);
        this.createSubTask.put(string, dataBlockArray);
        return dataBlockArray;
    }

    private DataBlock[] append(String string) throws RemoteException, Exception {
        DataBlock[] dataBlockArray = null;
        int n = this.QOIV.getSharedDataBlockNumber(string);
        ServiceLogger.logDebug(6600205, new Integer(n), 6);
        dataBlockArray = new DataBlock[n];
        int n2 = 0;
        while (n2 < n) {
            dataBlockArray[n2] = this.clear(string, n2);
            ServiceLogger.logDebug(6600206, new Integer(n2), 6);
            ++n2;
        }
        return dataBlockArray;
    }

    private DataBlock clear(String string, int n) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        String string2 = this.QOIV.getSharedDataSetName(string, n);
        if (string2 != null) {
            byte[] byArray;
            while ((byArray = this.QOIV.readSharedDataBlock(string, n, n2)).length != 0) {
                byteArrayOutputStream.write(byArray);
                n2 += byArray.length;
            }
            DataBlock dataBlock = new DataBlock(new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), string2);
            return dataBlock;
        }
        return null;
    }

    public String[] getSelectedSchemas() {
        return this.length;
    }

    public void stop() throws RemoteException {
        int n = 0;
        while (n < this.containsKey.length) {
            if (this.containsKey[n] != null) {
                this.containsKey[n].stopExec();
                this.containsKey[n] = null;
            }
            ++n;
        }
        this.getSharedDataSetName = true;
        this.quit();
    }
}

