/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import guitools.toolkit.JDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.JCliResource;
import jet.ReportEnv;
import jet.bean.ExcelParameter;
import jet.bean.ExportInfo;
import jet.bean.HtmlParameter;
import jet.bean.JREngine;
import jet.bean.PDFParameter;
import jet.bean.PSParameter;
import jet.bean.RtfParameter;
import jet.bean.TextParameter;
import jet.bean.XmlParameter;
import jet.cs.CSUtil;
import jet.datastream.Communicator;
import jet.exception.EngingPreinitException;
import jet.export.print.JReportSwingPrinter;
import jet.rptengine.EngineListener;
import jet.security.PageACL;
import jet.server.ServerEnv;
import jet.server.api.PageSecurityException;
import jet.server.api.RptServerException;
import jet.server.api.ServerInfo;
import jet.server.api.TaskListenerException;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTask;
import jet.server.schedule.jrtasks.RunningReportSheets;
import jet.util.EngineErrorListener;

public class ExportTask
extends JRTask
implements EngineListener,
EngineErrorListener {
    protected String result = null;
    protected String rstFile = null;
    protected String htmlFile = null;
    protected String pdfFile = null;
    protected String txtFile = null;
    protected String xlsFile = null;
    protected String psFile = null;
    protected String rtfFile = null;
    protected String xmlFile = null;
    protected String sheet = null;
    protected boolean isNormalText = false;
    protected boolean isCsv = false;
    protected boolean isTab = false;
    protected boolean isRepeat = false;
    protected String delimiter = " ";
    public int charWidth = -1;
    public int charHeight = -1;
    public boolean isQuoteMark = true;
    public boolean hasHeadFoot = true;
    public boolean forWindows = true;
    public boolean bTxtCompress = false;
    protected boolean isChartApplet = true;
    protected boolean isMultiFiles = true;
    protected boolean embeddedCSS = true;
    protected boolean hasHyperlink = true;
    protected boolean hasPageNumber = true;
    protected boolean drilldown = false;
    protected boolean useSection508 = false;
    protected boolean useHtmlTable = false;
    protected boolean useScope = false;
    protected boolean useTable = false;
    protected boolean relFontSize = false;
    protected int browser = 0;
    protected int overflow = 0;
    protected int chartFormat = -1;
    public boolean noMarginHtml = false;
    protected int htmResolution = -1;
    public boolean isDhtml = false;
    protected boolean noMarginPdf = false;
    protected boolean printModePdf = false;
    protected int compressImagePdf = -1;
    protected boolean isGifTrans = false;
    protected boolean isToc = false;
    protected boolean isDrilldown = false;
    protected String pdfPassword = null;
    protected boolean noMarginPs = false;
    protected boolean noMarginRtf = false;
    protected boolean isOnlyData = false;
    protected String xsdFile = null;
    protected int isWordWrapXls = 0;
    protected boolean excel2000 = false;
    protected boolean hasShapes = true;
    protected boolean excelLayout = true;
    protected boolean excelAdvanced = false;
    protected String printHeader = null;
    protected String printFooter = null;
    protected boolean printGridlines = false;
    protected String uid = null;
    protected String rhost = null;
    private Object[] QOIV = new Object[]{null, null, null, null, null, null, null, null};
    protected boolean errId = false;
    protected boolean isThrowExcp = false;
    protected JREngine jrengine = null;
    protected Throwable thrdThrow = null;
    protected String errmsg = null;
    protected boolean isHtmlBodyStream = false;
    protected String htmlExportPath = null;
    protected OutputStream htmlBodyOut = null;
    protected OutputStream cssOut = null;
    protected String htmlNavNlsLanguage = null;

    private String QOIV(String string) {
        File file;
        String string2 = string;
        String string3 = ServerEnv.getResourceRoot();
        if (string3.endsWith(File.separator)) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if ((string3 = string3 + string2.replace('/', File.separator.charAt(0))).endsWith(File.separator)) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (!(file = new File(string3)).exists()) {
            file.mkdirs();
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String TEMP_FILE_SUFF(String string, String string2) throws Exception {
        File file;
        String string3 = null;
        String string4 = string;
        int n = CSUtil.parseInt(string2, 1);
        if (string == null || string.trim().length() == 0) {
            string4 = this.getJRTaskManager().getResourceManager().getTempDir();
        } else if (n == 0) {
            if (!string4.startsWith("/")) {
                throw new Exception(JCliResource.getMessage("CS_ERR_67", new String[]{string4, string}));
            }
            string4 = this.getJRTaskManager().getResourceManager().getRealPath(this.uid, string);
            if (string4 == null || string4.length() == 0) {
                string4 = this.QOIV(string);
            }
        }
        if (string4 == null) throw new Exception(JCliResource.getMessage("CS_ERR_35", string));
        if (!string4.endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        if (!(file = new File(string4)).exists()) throw new Exception(JCliResource.getMessage("CS_ERR_34", new String[]{string4, string}));
        string3 = file.getCanonicalPath();
        if (!file.isDirectory()) {
            int n2 = string3.lastIndexOf(CSUtil.fileSep);
            if (n2 < 0) throw new Exception(JCliResource.getMessage("CS_ERR_33", new String[]{string4, string}));
            string3 = string3.substring(0, n2);
        }
        if (string3.endsWith(CSUtil.fileSep)) return string3;
        return string3 + CSUtil.fileSep;
    }

    private String WARNING(String string, String string2, String string3) throws IOException {
        return File.createTempFile(string2, string3, new File(string)).getName();
    }

    public void init(Properties properties) throws Exception {
        Object object;
        Object object2;
        String string;
        super.init(properties);
        this.uid = (String)properties.get("jrs.uid");
        this.rhost = (String)properties.get("jrs.remote_host");
        String string2 = SchdTools.getTempFilePrefix();
        this.result = (String)properties.get("jrs.result");
        if (CSUtil.getBoolean((String)properties.get("jrs.rst"), false)) {
            string = this.TEMP_FILE_SUFF(properties.getProperty("jrs.rst_dir"), properties.getProperty("jrs.rst_dir_type"));
            this.rstFile = this.WARNING(string, string2, SchdTools.TEMP_FILE_SUFF);
            if (this.rstFile != null) {
                this.rstFile = string + this.rstFile;
            }
        }
        this.htmlFile = (String)properties.get("jrs.html");
        if (this.htmlFile != null) {
            string = this.TEMP_FILE_SUFF(properties.getProperty("jrs.html_dir"), properties.getProperty("jrs.html_dir_type"));
            object2 = (String)properties.get("jrs.html_temp_dir");
            if (object2 != null) {
                object = new File(string + (String)object2);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                this.htmlFile = string + (String)object2 + File.separator + this.htmlFile;
            } else {
                this.htmlFile = string + this.htmlFile;
            }
            this.isMultiFiles = CSUtil.getBoolean((String)properties.get("jrs.is_multi_files"), true);
            this.embeddedCSS = CSUtil.getBoolean((String)properties.get("jrs.embedded_css"), false);
            this.isChartApplet = CSUtil.getBoolean((String)properties.get("jrs.is_applet_chart"), false);
            this.hasHyperlink = CSUtil.getBoolean((String)properties.get("jrs.has_hyperlink"), true);
            this.hasPageNumber = CSUtil.getBoolean((String)properties.get("jrs.has_page_number"), true);
            this.useTable = CSUtil.getBoolean((String)properties.get("jrs.use_table"), false);
            this.drilldown = CSUtil.getBoolean((String)properties.get("jrs.drilldown"), false);
            this.useSection508 = CSUtil.getBoolean((String)properties.get("jrs.use_section508_output"), false);
            this.useHtmlTable = CSUtil.getBoolean((String)properties.get("jrs.use_html_table"), false);
            this.useScope = CSUtil.getBoolean((String)properties.get("jrs.use_scope"), false);
            this.relFontSize = CSUtil.getBoolean((String)properties.get("jrs.relative_font_size"), false);
            this.browser = CSUtil.parseInt((String)properties.get("jrs.web_browser"), 0);
            this.overflow = CSUtil.parseInt((String)properties.get("jrs.text_overflow"), 1);
            this.chartFormat = CSUtil.parseInt((String)properties.get("jrs.format_chart"), -1);
            this.noMarginHtml = CSUtil.getBoolean((String)properties.get("jrs.no_margin_html"), false);
            this.htmResolution = CSUtil.parseInt((String)properties.get("jrs.html_resolution"), -1);
            this.isDhtml = CSUtil.getBoolean((String)properties.get("jrs.is_dhtml"), false);
            this.isHtmlBodyStream = CSUtil.getBoolean((String)properties.get("jrs.htm_is_body_stream"), false);
            if (this.isHtmlBodyStream) {
                this.htmlExportPath = properties.getProperty("jrs.html_export_path");
                this.htmlBodyOut = (OutputStream)properties.get("jrs.html_body_outstream");
                this.cssOut = (OutputStream)properties.get("jrs.html_css_outstream");
            }
            try {
                object = HttpUtil.getHttpRptServer().getUserPreferenceManager().getUserPreference(this.uid);
                boolean bl = CSUtil.getBoolean(((Properties)object).getProperty("enable_setting_display_language"), false);
                if (bl) {
                    this.htmlNavNlsLanguage = ((Properties)object).getProperty("locale_nls");
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            this.htmlNavNlsLanguage = this.htmlNavNlsLanguage == null ? Locale.getDefault().toString() : this.htmlNavNlsLanguage;
        }
        string = this.TEMP_FILE_SUFF(properties.getProperty("jrs.pdf_dir"), properties.getProperty("jrs.pdf_dir_type"));
        this.pdfFile = CSUtil.getBoolean((String)properties.get("jrs.pdf"), false) ? this.WARNING(string, string2, ".pdf") : (String)properties.get("jrs.pdf");
        if (this.pdfFile != null) {
            object2 = (String)properties.get("jrs.pdf_temp_dir");
            if (object2 != null) {
                object = new File(string + (String)object2);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                this.pdfFile = object + File.separator + this.pdfFile;
            } else {
                this.pdfFile = string + this.pdfFile;
            }
            this.noMarginPdf = CSUtil.getBoolean((String)properties.get("jrs.no_margin_pdf"), false);
            this.printModePdf = CSUtil.getBoolean((String)properties.get("jrs.print_mode_pdf"), false);
            this.compressImagePdf = CSUtil.parseInt((String)properties.get("jrs.compress_image_pdf"), -1);
            this.isGifTrans = CSUtil.getBoolean((String)properties.get("jrs.gif_transparent_pdf"), false);
            this.isToc = CSUtil.getBoolean((String)properties.get("jrs.toc_pdf"), false);
            this.isDrilldown = CSUtil.getBoolean((String)properties.get("jrs.drilldown_pdf"), false);
            this.pdfPassword = (String)properties.get("jrs.password_pdf");
        }
        if (CSUtil.getBoolean((String)properties.get("jrs.text"), false)) {
            this.isNormalText = CSUtil.getBoolean((String)properties.get("jrs.is_norm_txt"), true);
            this.delimiter = (String)properties.get("jrs.delimiter");
            object2 = (String)properties.get("jrs.is_text_delimiter");
            if (object2 != null) {
                if (((String)object2).equals("jrs.is_csv")) {
                    this.isCsv = true;
                    this.delimiter = ",";
                } else if (((String)object2).equals("jrs.is_tab")) {
                    this.isTab = true;
                } else if (((String)object2).equals("jrs.delimiter")) {
                    this.delimiter = (String)properties.get("jrs.delimiter");
                }
            }
            string = this.TEMP_FILE_SUFF(properties.getProperty("jrs.text_dir"), properties.getProperty("jrs.text_dir_type"));
            this.txtFile = this.WARNING(string, string2, !this.isNormalText && this.isCsv ? ".csv" : ".txt");
            if (this.txtFile != null) {
                this.txtFile = string + this.txtFile;
            }
            this.isRepeat = CSUtil.getBoolean((String)properties.get("jrs.is_repeat"), false);
            this.charWidth = CSUtil.parseInt((String)properties.get("jrs.udchar_width"), -1);
            this.charHeight = CSUtil.parseInt((String)properties.get("jrs.udchar_height"), -1);
            this.isQuoteMark = CSUtil.getBoolean((String)properties.get("jrs.is_quotemark"), false);
            this.hasHeadFoot = CSUtil.getBoolean((String)properties.get("jrs.hasHeadFoot"), false);
            this.forWindows = CSUtil.getBoolean((String)properties.get("jrs.txt_windows"), false);
            this.bTxtCompress = CSUtil.getBoolean((String)properties.get("jrs.txt_compress"), false);
        }
        if (CSUtil.getBoolean((String)properties.get("jrs.excel"), false)) {
            string = this.TEMP_FILE_SUFF(properties.getProperty("jrs.excel_dir"), properties.getProperty("jrs.excel_dir_type"));
            this.xlsFile = this.WARNING(string, string2, ".xls");
            if (this.xlsFile != null) {
                this.xlsFile = string + this.xlsFile;
            }
            this.isWordWrapXls = CSUtil.parseInt((String)properties.get("jrs.is_wordwrap"), 0);
            this.excel2000 = CSUtil.getBoolean((String)properties.get("jrs.excel2000"), false);
            this.hasShapes = CSUtil.getBoolean((String)properties.get("jrs.has_shapes"), false);
            this.excelLayout = CSUtil.getBoolean((String)properties.get("jrs.excel_layout"), false);
            this.excelAdvanced = CSUtil.getBoolean((String)properties.get("jrs.excel_advanced"), false);
            this.printHeader = (String)properties.get("jrs.print_header");
            this.printFooter = (String)properties.get("jrs.print_footer");
            this.printGridlines = CSUtil.getBoolean((String)properties.get("jrs.print_gridlines"), false);
        }
        if (CSUtil.getBoolean((String)properties.get("jrs.ps"), false)) {
            string = this.TEMP_FILE_SUFF(properties.getProperty("jrs.ps_dir"), properties.getProperty("jrs.ps_dir_type"));
            this.psFile = this.WARNING(string, string2, ".ps");
            if (this.psFile != null) {
                this.psFile = string + this.psFile;
            }
            this.noMarginPs = CSUtil.getBoolean((String)properties.get("jrs.no_margin_ps"), false);
        }
        this.rtfFile = (String)properties.get("jrs.rtf");
        if (this.rtfFile != null) {
            string = this.TEMP_FILE_SUFF(properties.getProperty("jrs.rtf_dir"), properties.getProperty("jrs.rtf_dir_type"));
            object2 = (String)properties.get("jrs.rtf_temp_dir");
            if (object2 != null) {
                object = new File(string + (String)object2);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                this.rtfFile = object + File.separator + this.rtfFile;
            } else {
                this.rtfFile = string + this.rtfFile;
            }
            this.noMarginRtf = CSUtil.getBoolean((String)properties.get("jrs.no_margin_rtf"), false);
        }
        this.xmlFile = (String)properties.get("jrs.xml");
        if (this.xmlFile != null) {
            string = this.TEMP_FILE_SUFF(properties.getProperty("jrs.xml_dir"), properties.getProperty("jrs.xml_dir_type"));
            object2 = (String)properties.get("jrs.xml_temp_dir");
            if (object2 != null) {
                object = new File(string + (String)object2);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                this.xmlFile = object + File.separator + this.xmlFile;
            } else {
                this.xmlFile = string + this.xmlFile;
            }
            this.isOnlyData = CSUtil.getBoolean((String)properties.get("jrs.is_only_data"), false);
            this.xsdFile = (String)properties.get("jrs.xsdfile");
        }
        if (((RunningReportSheets)(object2 = new RunningReportSheets(properties))).hasReportSheets() && (object = ((RunningReportSheets)object2).getAllReportSheets()) != null && object.hasMoreElements()) {
            this.sheet = (String)object.nextElement();
        }
        this.setServerInfo(properties);
    }

    public String getUid() {
        return this.uid;
    }

    public String getRemoteHost() {
        return this.rhost;
    }

    public Object[] getExportList() {
        return this.QOIV;
    }

    public void run() {
        try {
            this.export();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
    }

    public String getRunTaskKey() {
        String string = this.getId();
        return this.getClass().getName() + "@" + this.hashCode() + "#ID=" + string + "(" + string + ")";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void export() throws Throwable {
        block137: {
            block138: {
                if (this.hasListener) {
                    try {
                        ServiceLogger.logDebug(6600043, this.listenerClass, 6);
                    }
                    catch (Throwable var1_1) {
                        JDebug.WARNING((Throwable)var1_1);
                    }
                    if (!this.taskListener.beforeRun(this.serverInfo)) {
                        try {
                            ServiceLogger.logDebug(6600073, 6);
                        }
                        catch (Throwable var1_2) {
                            JDebug.WARNING((Throwable)var1_2);
                        }
                        throw new TaskListenerException(196609, (Object[])new String[]{this.listenerClass}, null);
                    }
                }
                try {
                    ServiceLogger.logDebug(6600036, this, 6);
                }
                catch (Throwable var1_3) {
                    JDebug.WARNING((Throwable)var1_3);
                }
                try {
                    this.jrengine = new JREngine(ReportEnv.getuid(), ReportEnv.gp(), "89Sfdswer470eGs190dfew324C", false);
                    this.jrengine.setAllowFFP(this.addEngineListener());
                    ServiceLogger.logEngine(4600226, new Object[]{this.getRunTaskKey(), this.jrengine}, 4);
                    this.jrengine.setSingleThread(ServerEnv.getEngineSingleThread());
                    this.jrengine.setPriority(ServerEnv.getEnginePriority());
                    this.jrengine.setUserName(this.getUid());
                    if (this.getRemoteHost() != null) {
                        this.jrengine.setClientName(this.getRemoteHost());
                    }
                    this.jrengine.setThrowException(true);
                    this.jrengine.addEngineListener((EngineErrorListener)this);
                    this.jrengine.setServerInfo((ServerInfo)this.serverInfo);
                    var1_5 = false;
                    var2_9 = new File(CSUtil.removeExtName(this.result) + ".pgn");
                    try {
                        ServiceLogger.logDebug(6600074, var2_9, 6);
                    }
                    catch (Throwable var3_11) {
                        JDebug.WARNING((Throwable)var3_11);
                    }
                    if (var2_9.exists()) {
                        try {
                            ServiceLogger.logDebug(6600075, var2_9, 6);
                        }
                        catch (Throwable var3_12) {
                            JDebug.WARNING((Throwable)var3_12);
                        }
                        var3_13 = new PageACL();
                        var3_13.read((InputStream)new FileInputStream(var2_9));
                        var4_37 /* !! */  = this.jrengine.getPages(var3_13);
                        try {
                            ServiceLogger.logDebug(6600076, (Object)var4_37 /* !! */ , 6);
                        }
                        catch (Throwable var5_48) {
                            JDebug.WARNING((Throwable)var5_48);
                        }
                        if (var4_37 /* !! */  == null) {
                            throw new PageSecurityException(196610);
                        }
                        if (var4_37 /* !! */ .length == 0) {
                            throw new PageSecurityException(196611);
                        }
                        this.jrengine.setPageNumbers(var4_37 /* !! */ );
                        var1_5 = true;
                    }
                    if (this.rstFile != null && !var1_5) {
                        try {
                            ServiceLogger.logEngine(6600077, new Object[]{this.result, this.rstFile, this.sheet}, 6);
                        }
                        catch (Throwable var3_14) {
                            JDebug.WARNING((Throwable)var3_14);
                        }
                        var3_15 = this.jrengine.exportToRst(this.result, this.rstFile);
                        try {
                            if (var3_15) {
                                ServiceLogger.logEngine(6600078, new Object[]{String.valueOf(var3_15), this.result, this.rstFile, this.sheet}, 6);
                            } else {
                                ServiceLogger.logEngine(6600079, new Object[]{String.valueOf(var3_15), this.jrengine.getReason(), this.result, this.rstFile, this.sheet}, 6);
                            }
                        }
                        catch (Throwable var4_38) {
                            JDebug.WARNING((Throwable)var4_38);
                        }
                        if (!var3_15) {
                            this.appendError("\n" + JCliResource.getMessage("CS_ERR_25") + " " + this.jrengine.getReason());
                        } else {
                            this.QOIV[0] = this.rstFile;
                        }
                    }
                    if (this.txtFile != null) {
                        var3_16 = ' ';
                        var4_39 = true;
                        if (this.delimiter != null && this.delimiter.length() > 0) {
                            var3_16 = this.delimiter.charAt(0);
                        } else {
                            var4_39 = false;
                        }
                        try {
                            ServiceLogger.logEngine(6600080, new Object[]{this.result, this.txtFile, this.sheet, String.valueOf(this.isNormalText), String.valueOf(this.isRepeat), String.valueOf(var3_16), String.valueOf(this.charWidth), String.valueOf(this.charHeight), String.valueOf(this.bTxtCompress), String.valueOf(this.isQuoteMark), String.valueOf(this.forWindows), String.valueOf(this.hasHeadFoot)}, 6);
                        }
                        catch (Throwable var5_49) {
                            JDebug.WARNING((Throwable)var5_49);
                        }
                        var5_51 = false;
                        if (this.sheet == null) {
                            var5_51 = this.jrengine.exportToText(this.result, this.txtFile, this.isNormalText, this.isRepeat, var3_16, this.charWidth, this.charHeight, this.bTxtCompress, -1, this.isQuoteMark, this.hasHeadFoot, this.forWindows);
                        } else {
                            var6_54 /* !! */  = new TextParameter();
                            var6_54 /* !! */ .setNormalTextFile(this.isNormalText);
                            var6_54 /* !! */ .setRepeat(this.isRepeat);
                            if (this.isTab) {
                                var3_16 = HttpUtil.decodeEsc("%09").charAt(0);
                                var6_54 /* !! */ .setDelimiter(var3_16);
                            } else if (var4_39) {
                                var6_54 /* !! */ .setDelimiter(var3_16);
                            }
                            var6_54 /* !! */ .setUDCHWidth(this.charWidth);
                            var6_54 /* !! */ .setUDCHHeight(this.charHeight);
                            var6_54 /* !! */ .setCompress(this.bTxtCompress);
                            var6_54 /* !! */ .setUseQuoteMark(this.isQuoteMark);
                            var6_54 /* !! */ .setHasHeadFoot(this.hasHeadFoot);
                            var6_54 /* !! */ .setForWinExport(this.forWindows);
                            var7_57 = new ExportInfo();
                            var7_57.setRstName(this.result);
                            var7_57.setFileName(this.txtFile);
                            var7_57.setReportName(this.sheet);
                            var5_51 = this.jrengine.exportToText(var7_57, var6_54 /* !! */ );
                        }
                        if (!var5_51) {
                            this.appendError("\n" + JCliResource.getMessage("CS_ERR_26") + " " + this.jrengine.getReason());
                        } else {
                            this.QOIV[3] = this.txtFile;
                        }
                        try {
                            if (var5_51) {
                                ServiceLogger.logEngine(6600081, new Object[]{String.valueOf(var5_51), this.result, this.txtFile, this.sheet, String.valueOf(this.isNormalText), String.valueOf(this.isRepeat), String.valueOf(var3_16), String.valueOf(this.charWidth), String.valueOf(this.charHeight), String.valueOf(this.bTxtCompress), String.valueOf(this.isQuoteMark), String.valueOf(this.forWindows), String.valueOf(this.hasHeadFoot)}, 6);
                            } else {
                                ServiceLogger.logEngine(6600082, new Object[]{String.valueOf(var5_51), this.jrengine.getReason(), this.result, this.txtFile, this.sheet, String.valueOf(this.isNormalText), String.valueOf(this.isRepeat), String.valueOf(var3_16), String.valueOf(this.charWidth), String.valueOf(this.charHeight), String.valueOf(this.bTxtCompress), String.valueOf(this.isQuoteMark), String.valueOf(this.forWindows), String.valueOf(this.hasHeadFoot)}, 6);
                            }
                        }
                        catch (Throwable var6_55) {
                            JDebug.WARNING((Throwable)var6_55);
                        }
                    }
                    if (this.pdfFile != null) {
                        try {
                            ServiceLogger.logEngine(6600083, new Object[]{this.result, this.pdfFile, this.sheet, String.valueOf(this.noMarginPdf), String.valueOf(this.printModePdf), String.valueOf(this.compressImagePdf), String.valueOf(this.isGifTrans), String.valueOf(this.isToc), String.valueOf(this.isDrilldown), this.pdfPassword}, 6);
                        }
                        catch (Throwable var3_17) {
                            JDebug.WARNING((Throwable)var3_17);
                        }
                        var3_19 = false;
                        if (this.sheet == null) {
                            var3_19 = this.jrengine.exportToPdf(this.result, this.pdfFile, this.noMarginPdf, this.printModePdf, this.compressImagePdf, this.isGifTrans, this.isToc, this.isDrilldown, this.pdfPassword);
                        } else {
                            var4_37 /* !! */  = (int[])new PDFParameter();
                            var4_37 /* !! */ .setNoMargin(this.noMarginPdf);
                            var4_37 /* !! */ .setImageCompressRatio(this.compressImagePdf);
                            var4_37 /* !! */ .setToc(this.isToc);
                            var4_37 /* !! */ .setDrill(this.isDrilldown);
                            var4_37 /* !! */ .setIsSimPrintMode(this.printModePdf);
                            var4_37 /* !! */ .setPassword(this.pdfPassword);
                            var5_52 = new ExportInfo();
                            var5_52.setRstName(this.result);
                            var5_52.setFileName(this.pdfFile);
                            var5_52.setReportName(this.sheet);
                            var3_19 = this.jrengine.exportToPDF((ExportInfo)var5_52, (PDFParameter)var4_37 /* !! */ );
                        }
                        if (!var3_19) {
                            this.appendError("\n" + JCliResource.getMessage("CS_ERR_27") + " " + this.jrengine.getReason());
                        } else {
                            this.QOIV[2] = this.jrengine.getAllPdfFile();
                        }
                        try {
                            if (var3_19) {
                                ServiceLogger.logEngine(6600084, new Object[]{String.valueOf(var3_19), this.result, this.pdfFile, this.sheet}, 6);
                            } else {
                                ServiceLogger.logEngine(6600085, new Object[]{String.valueOf(var3_19), this.jrengine.getReason(), this.result, this.pdfFile, this.sheet}, 6);
                            }
                        }
                        catch (Throwable var4_40) {
                            JDebug.WARNING((Throwable)var4_40);
                        }
                    }
                    if (this.htmlFile != null) {
                        try {
                            ServiceLogger.logEngine(6600086, new Object[]{this.result, this.htmlFile, this.sheet, String.valueOf(this.isChartApplet), String.valueOf(this.isMultiFiles), String.valueOf(this.embeddedCSS), String.valueOf(this.hasHyperlink), String.valueOf(this.hasPageNumber), String.valueOf(this.drilldown), String.valueOf(this.useSection508), String.valueOf(this.useHtmlTable), String.valueOf(this.useScope), String.valueOf(this.useTable), String.valueOf(this.relFontSize), String.valueOf(this.browser), String.valueOf(this.overflow), String.valueOf(this.htmResolution), String.valueOf(this.noMarginHtml)}, 6);
                        }
                        catch (Throwable var3_20) {
                            JDebug.WARNING((Throwable)var3_20);
                        }
                        if (this.isDhtml) {
                            var3_22 = this.jrengine.exportToDhtml(this.result, this.htmlFile, this.isChartApplet, this.isMultiFiles, this.useTable, this.hasHyperlink, this.hasPageNumber, this.relFontSize == false, this.browser, this.drilldown, this.noMarginHtml, null, this.htmResolution, this.overflow);
                        } else if (this.sheet == null && !this.isHtmlBodyStream) {
                            var3_22 = this.jrengine.exportToHtml(this.result, this.htmlFile, this.isChartApplet, this.isMultiFiles, this.useTable, this.hasHyperlink, this.hasPageNumber, this.relFontSize == false, this.browser, this.drilldown, this.noMarginHtml, null, this.htmResolution, this.overflow, this.chartFormat);
                        } else {
                            var4_37 /* !! */  = (int[])new HtmlParameter();
                            var4_37 /* !! */ .setIsExportAppletChart(this.isChartApplet);
                            var4_37 /* !! */ .setExportImageType(this.chartFormat);
                            var4_37 /* !! */ .setIsExportToMultiFiles(this.isMultiFiles);
                            var4_37 /* !! */ .setEmbededCSS(this.embeddedCSS);
                            var4_37 /* !! */ .setIsTableFormatHtml(this.useTable);
                            var4_37 /* !! */ .setHasHyperlink(this.hasHyperlink);
                            var4_37 /* !! */ .setHasPageNumber(this.hasPageNumber);
                            var4_37 /* !! */ .setIsAbsoluteFontSize(this.relFontSize == false);
                            var4_37 /* !! */ .setBrowserType(this.browser);
                            var4_37 /* !! */ .setIsIncludeDrillDownFile(this.drilldown);
                            var4_37 /* !! */ .setIsSect508Html(this.useSection508);
                            var4_37 /* !! */ .setUseHtmlTable(this.useHtmlTable);
                            var4_37 /* !! */ .setUseScope(this.useScope);
                            var4_37 /* !! */ .setIsNoMargin(this.noMarginHtml);
                            var4_37 /* !! */ .setResolution(this.htmResolution);
                            var4_37 /* !! */ .setOverflowType(this.overflow);
                            var5_52 = this.htmlNavNlsLanguage.split("_", 3);
                            var6_54 /* !! */  = NLSUtil.getHtmlNavNLS(new Locale(var5_52[0], var5_52.length > 1 ? var5_52[1] : ""));
                            var4_37 /* !! */ .setNLSProperties((Properties)var6_54 /* !! */ );
                            var7_57 = new ExportInfo();
                            var7_57.setRstName(this.result);
                            var7_57.setFileName(this.htmlFile);
                            var7_57.setReportName(this.sheet);
                            if (this.isHtmlBodyStream) {
                                var7_57.setStream(this.htmlBodyOut);
                                var3_22 = this.jrengine.exportHtmlBodyToStream(var7_57, this.cssOut, (HtmlParameter)var4_37 /* !! */ , this.htmlExportPath);
                            } else {
                                var3_22 = this.jrengine.exportToHtml(var7_57, (HtmlParameter)var4_37 /* !! */ );
                            }
                        }
                        if (!var3_22) {
                            this.appendError("\n" + JCliResource.getMessage("CS_ERR_28") + " " + this.jrengine.getReason());
                        } else {
                            this.QOIV[1] = this.jrengine.getAllHtmlFile();
                        }
                        try {
                            if (var3_22) {
                                ServiceLogger.logEngine(6600087, new Object[]{String.valueOf(var3_22), this.result, this.htmlFile, this.sheet, String.valueOf(this.isChartApplet), String.valueOf(this.isMultiFiles), String.valueOf(this.hasHyperlink), String.valueOf(this.hasPageNumber), String.valueOf(this.drilldown), String.valueOf(this.useTable), String.valueOf(this.relFontSize), String.valueOf(this.browser), String.valueOf(this.overflow), String.valueOf(this.htmResolution), String.valueOf(this.noMarginHtml)}, 6);
                            } else {
                                ServiceLogger.logEngine(6600088, new Object[]{String.valueOf(var3_22), this.jrengine.getReason(), this.result, this.htmlFile, this.sheet, String.valueOf(this.isChartApplet), String.valueOf(this.isMultiFiles), String.valueOf(this.hasHyperlink), String.valueOf(this.hasPageNumber), String.valueOf(this.drilldown), String.valueOf(this.useTable), String.valueOf(this.relFontSize), String.valueOf(this.browser), String.valueOf(this.overflow), String.valueOf(this.htmResolution), String.valueOf(this.noMarginHtml)}, 6);
                            }
                        }
                        catch (Throwable var4_41) {
                            JDebug.WARNING((Throwable)var4_41);
                        }
                    }
                    if (this.xlsFile != null) {
                        try {
                            ServiceLogger.logEngine(6600089, new Object[]{this.result, this.xlsFile, this.sheet, String.valueOf(this.isWordWrapXls), String.valueOf(this.excel2000), String.valueOf(this.hasShapes), String.valueOf(this.excelLayout), String.valueOf(this.excelAdvanced), this.printHeader, this.printFooter, String.valueOf(this.printGridlines)}, 6);
                        }
                        catch (Throwable var3_23) {
                            JDebug.WARNING((Throwable)var3_23);
                        }
                        var3_25 = false;
                        var4_37 /* !! */  = (int[])new ExcelParameter();
                        var4_37 /* !! */ .setWordWrapType(this.isWordWrapXls);
                        var4_37 /* !! */ .setBiff8(this.excel2000);
                        var4_37 /* !! */ .setParam(this.hasShapes ? 1 : 0);
                        var4_37 /* !! */ .setNewExcelLayout(this.excelLayout);
                        if (this.excelAdvanced) {
                            var4_37 /* !! */ .setPrintPageHeaderAndFooter(this.printHeader, this.printFooter);
                            var4_37 /* !! */ .setPrintGridlinesAble(this.printGridlines);
                        }
                        var5_52 = new ExportInfo();
                        var5_52.setRstName(this.result);
                        var5_52.setFileName(this.xlsFile);
                        var5_52.setReportName(this.sheet);
                        var3_25 = this.jrengine.exportToXls((ExportInfo)var5_52, (ExcelParameter)var4_37 /* !! */ );
                        if (!var3_25) {
                            this.appendError("\n" + JCliResource.getMessage("CS_ERR_29") + " " + this.jrengine.getReason());
                        } else {
                            this.QOIV[4] = this.xlsFile;
                        }
                        try {
                            if (var3_25) {
                                ServiceLogger.logEngine(6600090, new Object[]{String.valueOf(var3_25), this.result, this.xlsFile, this.sheet, String.valueOf(this.isWordWrapXls), String.valueOf(this.excel2000), String.valueOf(this.hasShapes)}, 6);
                            } else {
                                ServiceLogger.logEngine(6600091, new Object[]{String.valueOf(var3_25), this.jrengine.getReason(), this.result, this.xlsFile, this.sheet, String.valueOf(this.isWordWrapXls), String.valueOf(this.excel2000), String.valueOf(this.hasShapes)}, 6);
                            }
                        }
                        catch (Throwable var6_56) {
                            JDebug.WARNING((Throwable)var6_56);
                        }
                    }
                    if (this.psFile != null) {
                        try {
                            ServiceLogger.logEngine(6600092, new Object[]{this.result, this.psFile, this.sheet, String.valueOf(this.noMarginPs)}, 6);
                        }
                        catch (Throwable var3_26) {
                            JDebug.WARNING((Throwable)var3_26);
                        }
                        var3_28 = false;
                        if (this.sheet == null) {
                            var3_28 = this.jrengine.exportToPS(this.result, this.psFile, this.noMarginPs);
                        } else {
                            var4_37 /* !! */  = (int[])new PSParameter();
                            var4_37 /* !! */ .setNoMargin(this.noMarginPs);
                            var5_52 = new ExportInfo();
                            var5_52.setRstName(this.result);
                            var5_52.setFileName(this.psFile);
                            var5_52.setReportName(this.sheet);
                            var3_28 = this.jrengine.exportToPS((ExportInfo)var5_52, (PSParameter)var4_37 /* !! */ );
                        }
                        if (!var3_28) {
                            this.appendError("\n" + JCliResource.getMessage("CS_ERR_30") + " " + this.jrengine.getReason());
                        } else {
                            this.QOIV[5] = this.psFile;
                        }
                        try {
                            if (var3_28) {
                                ServiceLogger.logEngine(6600093, new Object[]{String.valueOf(var3_28), this.result, this.psFile, this.sheet, String.valueOf(this.noMarginPs)}, 6);
                            } else {
                                ServiceLogger.logEngine(6600094, new Object[]{String.valueOf(var3_28), this.jrengine.getReason(), this.result, this.psFile, this.sheet, String.valueOf(this.noMarginPs)}, 6);
                            }
                        }
                        catch (Throwable var4_42) {
                            JDebug.WARNING((Throwable)var4_42);
                        }
                    }
                    if (this.rtfFile != null) {
                        try {
                            ServiceLogger.logEngine(6600095, new Object[]{this.result, this.rtfFile, this.sheet, String.valueOf(this.noMarginRtf)}, 6);
                        }
                        catch (Throwable var3_29) {
                            JDebug.WARNING((Throwable)var3_29);
                        }
                        var3_31 = false;
                        if (this.sheet == null) {
                            var3_31 = this.jrengine.exportToRtf(this.result, this.rtfFile, this.noMarginRtf);
                        } else {
                            var4_37 /* !! */  = (int[])new RtfParameter();
                            var4_37 /* !! */ .setNoMargin(this.noMarginRtf);
                            var5_52 = new ExportInfo();
                            var5_52.setRstName(this.result);
                            var5_52.setFileName(this.rtfFile);
                            var5_52.setReportName(this.sheet);
                            var3_31 = this.jrengine.exportToRtf((ExportInfo)var5_52, (RtfParameter)var4_37 /* !! */ );
                        }
                        if (!var3_31) {
                            this.appendError("\n" + JCliResource.getMessage("CS_ERR_62") + " " + this.jrengine.getReason());
                        } else {
                            this.QOIV[6] = this.jrengine.getAllRtfFile();
                        }
                        try {
                            if (var3_31) {
                                ServiceLogger.logEngine(6600096, new Object[]{String.valueOf(var3_31), this.result, this.rtfFile, this.sheet, String.valueOf(this.noMarginRtf)}, 6);
                            } else {
                                ServiceLogger.logEngine(6600097, new Object[]{String.valueOf(var3_31), this.jrengine.getReason(), this.result, this.rtfFile, this.sheet, String.valueOf(this.noMarginRtf)}, 6);
                            }
                        }
                        catch (Throwable var4_43) {
                            JDebug.WARNING((Throwable)var4_43);
                        }
                    }
                    if (this.xmlFile != null) {
                        try {
                            ServiceLogger.logEngine(6600098, new Object[]{this.result, this.xmlFile, this.sheet, String.valueOf(this.isOnlyData), this.xsdFile}, 6);
                        }
                        catch (Throwable var3_32) {
                            JDebug.WARNING((Throwable)var3_32);
                        }
                        var3_34 = false;
                        if (this.sheet == null) {
                            var3_34 = this.jrengine.exportToXML(this.result, this.xmlFile, this.isOnlyData, this.xsdFile);
                        } else {
                            var4_37 /* !! */  = (int[])new XmlParameter();
                            var4_37 /* !! */ .setOnlyData(this.isOnlyData);
                            var4_37 /* !! */ .setSchemaFile(this.xsdFile);
                            var5_52 = new ExportInfo();
                            var5_52.setRstName(this.result);
                            var5_52.setFileName(this.xmlFile);
                            var5_52.setReportName(this.sheet);
                            var3_34 = this.jrengine.exportToXML((ExportInfo)var5_52, (XmlParameter)var4_37 /* !! */ );
                        }
                        if (!var3_34) {
                            this.appendError("\n" + JCliResource.getMessage("CS_ERR_64") + " " + this.jrengine.getReason());
                        } else {
                            this.QOIV[7] = this.jrengine.getAllXMLFile();
                        }
                        try {
                            if (var3_34) {
                                ServiceLogger.logEngine(6600099, new Object[]{String.valueOf(var3_34), this.result, this.xmlFile, this.sheet, String.valueOf(this.isOnlyData), this.xsdFile}, 6);
                            } else {
                                ServiceLogger.logEngine(6600100, new Object[]{String.valueOf(var3_34), this.jrengine.getReason(), this.result, this.xmlFile, this.sheet, String.valueOf(this.isOnlyData), this.xsdFile}, 6);
                            }
                        }
                        catch (Throwable var4_44) {
                            JDebug.WARNING((Throwable)var4_44);
                        }
                    }
                    if (this.ifPrint) {
                        var3_35 = this.jrengine.getCommunicator(this.result, this.jrengine.getPageNumbers());
                        try {
                            ServiceLogger.logEngine(6600101, new Object[]{var3_35, this.printer, this.jrengine}, 6);
                        }
                        catch (Throwable var4_45) {
                            JDebug.WARNING((Throwable)var4_45);
                        }
                        if (var3_35 != null) {
                            JReportSwingPrinter.printInSameProcess(null, (Communicator)var3_35, null, (boolean)false, null, (boolean)true, null, (int)this.useJDK, (boolean)true, (boolean)true, null, (Vector)this.printAttr, (String)this.printer);
                        }
                        try {
                            ServiceLogger.logEngine(6600102, new Object[]{var3_35, this.jrengine}, 6);
                        }
                        catch (Throwable var4_46) {
                            JDebug.WARNING((Throwable)var4_46);
                        }
                    }
                    this.jrengine.exit();
                    ServiceLogger.logEngine(6600103, this.jrengine, 6);
                    break block137;
                }
                catch (Throwable var1_6) {
                    try {
                        ServiceLogger.logDebug(SchdTools.getStackTraceString(var1_6), 6);
                    }
                    catch (Throwable var2_10) {
                        JDebug.WARNING((Throwable)var2_10);
                    }
                    if (this.jrengine != null) {
                        // empty if block
                    }
                    if (var1_6 instanceof ThreadDeath) {
                        this.jrengine = null;
                        throw var1_6;
                    }
                    if (var1_6 instanceof EngingPreinitException && ((EngingPreinitException)var1_6).getException() instanceof OutOfMemoryError) {
                        var1_7 = ((EngingPreinitException)var1_6).getException();
                    }
                    if (!(var1_7 instanceof OutOfMemoryError)) break block138;
                    if (this.jrengine != null) {
                        this.jrengine.stopReport();
                        this.jrengine.exit();
                        ServiceLogger.logEngine(6600104, this.jrengine, 4);
                        this.jrengine = null;
                    }
                    System.gc();
                    var3_36 = Runtime.getRuntime();
                    var4_47 = 0;
                    ** while (var3_36.freeMemory() < 1000000L)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        System.gc();
                        if (var4_47++ > 5) break;
                        Thread.currentThread().wait(1000L);
                    }
                    catch (Exception var5_53) {
                        ServiceLogger.logError(var5_53, 3);
                    }
                    continue;
                }
            }
            this.appendError(SchdTools.getStackTraceString(var1_7));
            if (this.isThrowExcp) {
                this.jrengine = null;
                throw var1_7;
            }
        }
        this.jrengine = null;
        if (ServerEnv.exeGC) {
            System.gc();
        }
        if (this.thrdThrow != null) {
            this.appendError(SchdTools.getStackTraceString(this.thrdThrow));
            if (this.isThrowExcp) {
                throw this.thrdThrow;
            }
        }
        if (this.isThrowExcp && this.getErrorMsg() != null) {
            throw new RptServerException(this.getErrorMsg());
        }
        try {
            ServiceLogger.logDebug(6600040, this, 6);
        }
        catch (Throwable var1_8) {
            JDebug.WARNING((Throwable)var1_8);
        }
        if (this.hasListener && this.taskListener != null) {
            this.taskListener.afterRun(this.serverInfo);
        }
    }

    public void appendError(String string) {
        this.errId = true;
        this.errmsg = this.errmsg != null ? this.errmsg + "\r\n" + string : string;
        ServiceLogger.logError(this + "\r\n" + string);
    }

    public boolean hasError() {
        return this.errId;
    }

    public void setThrow(boolean bl) {
        this.isThrowExcp = bl;
    }

    public void started() {
    }

    public void finished() {
    }

    public void ThreadException(Thread thread, Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            return;
        }
        this.thrdThrow = throwable;
    }

    public void noteError(Thread thread, Throwable throwable, int n, String string) {
        if (throwable instanceof ThreadDeath) {
            return;
        }
        this.thrdThrow = throwable;
    }

    public void notifyReceiver(EngineErrorListener engineErrorListener) {
    }

    public String toString() {
        return super.toString() + "\r\nresult=" + this.result + "\r\nrst file=" + this.rstFile + "\r\nhtml file=" + this.htmlFile + "\r\npdf file=" + this.pdfFile + "\r\ntxt file=" + this.txtFile + "\r\nis Normal Text=" + this.isNormalText + "\r\nxls file=" + this.xlsFile + "\r\nps file=" + this.psFile + "\r\nrtf file=" + this.rtfFile + "\r\nxml file=" + this.xmlFile;
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.result", this.result);
        if (this.errmsg != null) {
            properties2.put("jrs.error", this.errmsg);
        }
        return properties2;
    }

    public String getErrorMsg() {
        return this.errmsg;
    }

    public void stopExec() {
        this.stopExec(false);
    }

    public void stopExec(boolean bl) {
        if (this.jrengine != null && !bl) {
            this.jrengine.exit();
            ServiceLogger.logEngine(6600005, this.jrengine, 4);
        }
    }

    private boolean addEngineListener() {
        if (this.rstFile != null) {
            return false;
        }
        if (this.htmlFile != null) {
            return false;
        }
        if (this.pdfFile != null) {
            return false;
        }
        if (this.xlsFile != null) {
            return false;
        }
        if (this.psFile != null) {
            return false;
        }
        if (this.rtfFile != null) {
            return false;
        }
        if (this.xmlFile != null) {
            return false;
        }
        return this.txtFile != null && !this.isNormalText;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

