/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import guitools.toolkit.JDebug;
import java.io.File;
import java.sql.Connection;
import java.util.Date;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.cs.CustomTaskManager;
import jet.server.api.RptServerException;
import jet.server.api.TaskListenerException;
import jet.server.api.UserTask;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.JRTask;

public class UserTaskProxy
extends JRTask {
    UserTask QOIV;
    protected String uid = null;
    protected String taskName = null;
    protected String cat = null;
    protected String rpt = null;
    protected int catVerNum = 0;
    protected int rptVerNum = 0;
    protected String lang = null;
    protected String coun = null;
    protected String enc = null;
    protected int fromEncoding = 2;
    protected int toEncoding = 0;
    protected boolean hasConvertEncoding = false;
    protected boolean hasStyle = false;
    protected String styleGroup = null;
    protected String paramFile = null;
    protected String paramValues = null;
    protected String namedWherePortion = null;
    protected String wherePortion = null;
    protected String whereClause = null;
    protected String dbUser = null;
    protected String dbPswd = null;
    protected String dbJdbcUrl = null;
    protected String dbJdbcDriver = null;
    protected String rhost = null;
    protected String eqID = null;
    protected Connection userDbConnection = null;
    protected boolean dbGetSupportInfo = false;
    protected boolean hasPreferredServer = false;
    protected String preferredServerName = null;
    protected int launchType = 0;
    protected String taskClass = null;
    protected String run_task_id = null;
    protected boolean deleteParamFile = false;
    protected String taskID = null;
    protected Date subTime = null;
    protected String displayStr = null;

    public UserTaskProxy(UserTask userTask) {
        this.QOIV = userTask;
    }

    public void init(Properties properties) throws Exception {
        Object object;
        super.init(properties);
        this.uid = (String)properties.get("jrs.uid");
        this.taskName = (String)properties.get("jrs.schedule_name");
        if (this.taskName == null) {
            this.taskName = (String)properties.get("jrs.task_name");
        }
        this.rhost = (String)properties.get("jrs.remote_host");
        this.eqID = (String)properties.get("jrs.ext_qrybl_id");
        this.lang = (String)properties.get("jrs.rpt_language");
        this.coun = (String)properties.get("jrs.rpt_country");
        this.enc = (String)properties.get("jrs.rpt_encoding");
        this.hasStyle = CSUtil.getBoolean((String)properties.get("jrs.has_style"), false);
        this.styleGroup = (String)properties.get("jrs.style_group");
        this.hasConvertEncoding = CSUtil.getBoolean((String)properties.get("jrs.has_convert_enc"), false);
        this.fromEncoding = CSUtil.parseInt((String)properties.get("jrs.from_encoding"), 2);
        this.toEncoding = CSUtil.parseInt((String)properties.get("jrs.to_encoding"), 0);
        this.paramValues = (String)properties.get("jrs.param_values");
        this.namedWherePortion = (String)properties.get("jrs.named_wp");
        this.wherePortion = (String)properties.get("jrs.wp");
        this.whereClause = (String)properties.get("jrs.wc");
        this.cat = (String)properties.get("jrs.catalog");
        this.catVerNum = CSUtil.parseInt((String)properties.get("jrs.cat_version"), 0);
        this.rptVerNum = CSUtil.parseInt((String)properties.get("jrs.rpt_version"), 0);
        this.preferredServerName = (String)properties.get("jrs.the_name_of_preferred_server");
        if (this.preferredServerName != null) {
            this.hasPreferredServer = this.preferredServerName.length() > 0;
        }
        this.deleteParamFile = CSUtil.getBoolean((String)properties.get("jrs.del_param_file"), false);
        this.dbJdbcUrl = (String)properties.get("jrs.jdbc_url");
        this.dbJdbcDriver = (String)properties.get("jrs.jdbc_driver");
        if (!CSUtil.getBoolean((String)properties.get("jrs.use_def_db_user"), false)) {
            this.dbUser = (String)properties.get("jrs.db_user");
            this.dbPswd = (String)properties.get("jrs.db_pswd");
            if (CSUtil.getBoolean((String)properties.get("jrs.use_new_db_pswd"), false)) {
                this.dbPswd = (String)properties.get("jrs.new_db_pswd");
            }
        }
        if ((object = properties.get("jrs.jdbc_connection_object")) != null && object instanceof Connection) {
            this.userDbConnection = (Connection)object;
        }
        this.dbGetSupportInfo = CSUtil.getBoolean((String)properties.get("jrs.jdbc_get_support_info"), false);
        this.rpt = (String)properties.get("jrs.report");
        if (this.rpt != null) {
            this.getParameterFile(properties);
        }
        this.taskID = (String)properties.get("jrs.task_id");
        this.launchType = CSUtil.parseInt((String)properties.get("jrs.launch_type"));
        this.taskClass = (String)properties.get("jrs.task_class");
        long l = CSUtil.parseLong((String)properties.get("jrs.submit_time"));
        this.subTime = new Date(l);
        this.run_task_id = SchdTools.getIdBase();
        this.displayStr = (String)properties.get("jrs.user_task_display_name");
        CustomTaskManager.registerCustomTask(this.displayStr, this.getTaskClass(), null);
    }

    protected void getParameterFile(Properties properties) throws Exception {
        String string = JRTUtil.getRealPath(this.uid, this.rpt, this.getJRTaskManager().getResourceManager());
        File file = new File(string);
        if (string == null || string.trim().length() == 0 || !file.exists()) {
            throw new RptServerException(196624, (Object[])new String[]{this.uid, this.cat, this.rpt}, null);
        }
        if (JRTUtil.hasParameter(properties)) {
            this.paramFile = JRTUtil.getParamFile(properties);
            if (this.paramFile == null) {
                this.paramFile = JRTUtil.createParamFile(SchdTools.createTempFile(this.getJRTaskManager().getResourceManager().getHistDir(), CSUtil.getNameWithoutExt(string) + "_", ".param"), properties);
            }
        }
    }

    public void run() {
        if (this.QOIV != null) {
            try {
                this.beforeRun();
                this.QOIV.run();
                this.afterRun();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
    }

    public void stopExec() {
        if (this.QOIV != null) {
            this.QOIV.stopExec();
        }
    }

    public void stopExec(boolean bl) {
    }

    public boolean hasError() {
        if (this.QOIV != null) {
            return this.QOIV.hasError();
        }
        return false;
    }

    public String getErrorMsg() {
        if (this.QOIV != null) {
            return this.QOIV.getErrorMsg();
        }
        return null;
    }

    protected void beforeRun() throws Exception {
        if (this.hasListener) {
            ServiceLogger.logDebug(6600043, new Object[]{this.listenerClass}, 6);
            this.serverInfo.getTaskProperties().remove("jrs.is_successful");
            if (!this.taskListener.beforeRun(this.serverInfo)) {
                ServiceLogger.logDebug(6600042, 6);
                TaskListenerException taskListenerException = new TaskListenerException(196609, (Object[])new String[]{this.listenerClass}, null);
                throw taskListenerException;
            }
        }
    }

    protected void logDebug(String string, int n) {
        try {
            if (ServiceLogger.isLoggable(4, n)) {
                ServiceLogger.logDebug(string, n);
            }
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
    }

    protected void logError(String string, int n) {
        try {
            if (ServiceLogger.isLoggable(2, n)) {
                ServiceLogger.logError(string, n);
            }
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
    }

    protected void afterRun() throws Exception {
        if (this.hasListener && this.taskListener != null) {
            this.taskListener.afterRun(this.serverInfo);
        }
    }

    public String toString() {
        return super.toString() + "\r\nuser=" + this.uid + "\r\nremote host=" + this.rhost + "\r\nJRExternalQueryRunner=" + this.eqID + "\r\ntask name=" + this.taskName + "\r\nPublishType=" + this.getPublishType() + "\r\ntaskClass=" + this.taskClass + "\r\ncatalog=" + this.cat + "\r\nreport=" + this.rpt + "\r\nreport language=" + this.lang + "\r\nreport country=" + this.coun + "\r\nreport encoding=" + this.enc + "\r\nreport encoding before converting=" + this.fromEncoding + "\r\nreport encoding after converting=" + this.toEncoding + "\r\nreport style group=" + this.styleGroup + "\r\nparameter file=" + this.paramFile + "\r\nstring of parameter values=" + this.paramValues + "\r\nwhere clause=" + this.whereClause + "\r\nnamed where portion=" + this.namedWherePortion + "\r\nwhere portion=" + this.wherePortion + "\r\ndbJdbcUrl=" + this.dbJdbcUrl + "\r\ndbJdbcDriver=" + this.dbJdbcDriver + "\r\ndbGetSupportInfo=" + this.dbGetSupportInfo + "\r\nuserDbConnection=" + this.userDbConnection;
    }

    public Properties toProperties(Properties properties) {
        String string;
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.task_id", this.getId());
        if (this.uid != null) {
            properties2.put("jrs.uid", this.uid);
        }
        if (this.taskName != null) {
            properties2.put("jrs.schedule_name", this.taskName);
        }
        if (this.dbUser != null) {
            properties2.put("jrs.db_user", this.dbUser);
        }
        if (this.dbPswd != null) {
            properties2.put("jrs.db_pswd", this.dbPswd);
        }
        if (this.dbJdbcUrl != null) {
            properties2.put("jrs.jdbc_url", this.dbJdbcUrl);
        }
        if (this.dbJdbcDriver != null) {
            properties2.put("jrs.jdbc_driver", this.dbJdbcDriver);
        }
        if (this.dbGetSupportInfo) {
            properties2.put("jrs.jdbc_get_support_info", "true");
        }
        if (this.cat != null) {
            properties2.put("jrs.catalog", this.cat);
        }
        if (this.rpt != null) {
            properties2.put("jrs.report", this.rpt);
        }
        if (this.lang != null) {
            properties2.put("jrs.rpt_language", this.lang);
        }
        if (this.coun != null) {
            properties2.put("jrs.rpt_country", this.coun);
        }
        if (this.enc != null) {
            properties2.put("jrs.rpt_encoding", this.enc);
        }
        properties2.put("jrs.has_style", String.valueOf(this.hasStyle));
        if (this.styleGroup != null) {
            properties2.put("jrs.style_group", this.styleGroup);
        }
        properties2.put("jrs.has_convert_enc", String.valueOf(this.hasConvertEncoding));
        properties2.put("jrs.from_encoding", String.valueOf(this.fromEncoding));
        properties2.put("jrs.to_encoding", String.valueOf(this.toEncoding));
        if (this.rhost != null) {
            properties2.put("jrs.remote_host", this.rhost);
        }
        if (this.eqID != null) {
            properties2.put("jrs.ext_qrybl_id", this.eqID);
        }
        if (this.paramFile != null) {
            properties2.put("jrs.param_file", this.paramFile);
        }
        if (this.paramValues != null) {
            properties2.put("jrs.param_values", this.paramValues);
        }
        if (this.namedWherePortion != null) {
            properties2.put("jrs.named_wp", this.namedWherePortion);
        }
        if (this.wherePortion != null) {
            properties2.put("jrs.wp", this.wherePortion);
        }
        if (this.whereClause != null) {
            properties2.put("jrs.wc", this.whereClause);
        }
        if ((string = this.getErrorMsg()) != null) {
            properties2.put("jrs.error", string);
        }
        if (this.getSubmitTime() != null) {
            properties2.put("jrs.submit_time", String.valueOf(this.getSubmitTime()));
        }
        return properties2;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public int getLaunchType() {
        return this.launchType;
    }

    public String getTaskClass() {
        return this.QOIV.getClass().getName();
    }

    public Date getSubmitTime() {
        return this.subTime;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTaskName() {
        if (this.taskName != null) {
            return this.taskName;
        }
        if (this.displayStr != null) {
            return this.displayStr;
        }
        return this.getTaskClass();
    }

    public String getRemoteHost() {
        return this.rhost;
    }

    public String getDBUser() {
        return this.dbUser;
    }

    public String getDBPassword() {
        return this.dbPswd;
    }

    public String getDBJdbcUrl() {
        return this.dbJdbcUrl;
    }

    public String getDBJdbcDriver() {
        return this.dbJdbcDriver;
    }

    public Connection getUserDBConnection() {
        return this.userDbConnection;
    }

    public boolean isGetJDBCSupportInfo() {
        return this.dbGetSupportInfo;
    }

    public String getCatalog() {
        return this.cat;
    }

    public String getReport() {
        return this.rpt;
    }

    public String getLanguage() {
        return this.lang;
    }

    public String getCountry() {
        return this.coun;
    }

    public String getEncoding() {
        return this.enc;
    }

    public int getFromEncoding() {
        return this.fromEncoding;
    }

    public int getToEncoding() {
        return this.toEncoding;
    }

    public boolean hasConvertEncoding() {
        return this.hasConvertEncoding;
    }

    public boolean hasStyleGroup() {
        return this.hasStyle;
    }

    public String getStyleGroup() {
        return this.styleGroup;
    }

    public String getParamFile() {
        return this.paramFile;
    }

    public String getParamValues() {
        return this.paramValues;
    }

    public String getNamedWherePortion() {
        return this.namedWherePortion;
    }

    public String getWherePortion() {
        return this.wherePortion;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public String getRunTaskId() {
        return this.run_task_id;
    }

    public String getPublishType() {
        return "User Task";
    }
}

