/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import java.rmi.RemoteException;
import java.util.Properties;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.TooManyReportsException;
import jet.server.jrc.engine.JREngineManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.ViewRptTask;

public class ViewTestRptTask
extends ViewRptTask {
    protected long time = -1L;

    public void init(Properties properties) throws Exception {
        super.init(properties);
        String string = SchdTools.getTempFilePrefix();
        this.rstNm = SchdTools.getTempFileName(this.rstLoc, string, null);
        this.isRealDir = true;
        this.QOIV();
        this.setServerInfo(properties);
    }

    protected void exportToDisk() throws Exception {
    }

    private void QOIV() throws Exception {
        String string = this.getRealCat();
        String string2 = this.getRealRpt();
        String string3 = this.rstNm;
        String string4 = null;
        if (this.rstNm == null || this.rstNm.trim().length() == 0) {
            string3 = null;
            string4 = CSUtil.getNameWithoutExt(string2);
        }
        if (string3 == null) {
            string3 = SchdTools.getTempFileName(this.rstLoc, string4 + "_", null);
        }
        this.htmDir = this.rstLoc;
        this.htmName = string3;
        if (string3 == null) {
            throw new Exception(JCliResource.getMessage("CS_ERR_47"));
        }
        this.tmpRst = this.checkRealDir(this.rstLoc, this.isRealDir);
        if (this.tmpRst != null) {
            this.tmpRst = this.tmpRst + string3;
        }
    }

    public void exit() {
        block11: {
            try {
                System.out.println("task exit=" + this.time);
                this.getJRTaskManager().delToMonitorRunningReport(this.getId());
                this.getJRTaskManager().decRptTaskRef(this);
                this.addRunTimeValueToProperties(this.serverInfo.getTaskProperties());
                if (this.engineContext == null) break block11;
                try {
                    if (this.hasListener && this.taskListener != null) {
                        String string = this.engineContext.getLocalHost();
                        String string2 = this.engineContext.getLocalPort();
                        boolean bl = this.engineContext.isLocal();
                        Properties properties = this.serverInfo.getTaskProperties();
                        if (properties == null) {
                            properties = new Properties();
                        }
                        if (string != null) {
                            properties.put("jrs.exec_host", string);
                        }
                        if (string2 != null) {
                            properties.put("jrs.exec_port", string2);
                        }
                        properties.put("jrs.is_local", bl + "");
                        this.taskListener.afterRun(this.serverInfo);
                    }
                }
                catch (RemoteException remoteException) {
                    throw remoteException;
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
                try {
                    this.engineExit();
                }
                catch (RptServerException rptServerException) {
                    ServiceLogger.logError(rptServerException);
                }
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
            }
        }
    }

    protected void afterRun() throws RemoteException {
        super.afterRun();
        this.time = System.currentTimeMillis() - this.time;
    }

    public long getRunTime() {
        return this.time;
    }

    public void createReportEngine(boolean bl) throws TooManyReportsException {
        try {
            this.manager = this.getJRTaskManager().getEngineManager();
            this.time = System.currentTimeMillis();
            this.engineContext = ((JREngineManager)this.manager).createTestReportEngine();
            if (this.engineContext != null) {
                this.runName = this.engineContext.getLocalHost();
                this.runPort = this.engineContext.getLocalPort();
            }
            if (this.runName == null || this.runName.trim().length() == 0) {
                this.runName = ServerEnv.getLocalHostName();
            }
            if (this.runPort == null || this.runPort.trim().length() == 0) {
                this.runPort = String.valueOf(ServerEnv.getActiveRMIPort());
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.task_class", this.getClass().getName());
        return properties2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

