/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.rmi.NotBoundException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import jet.JCliResource;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.RemoteFileService;
import jet.server.api.ResourceManager;
import jet.server.api.RptServerException;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.http.SendFileAuthorizorFactory;
import jet.server.api.http.TooManyTimesException;
import jet.server.intf.jrs.ExResourceManager;
import jet.server.intf.version.PlsResultManager;
import jet.server.intf.version.RemotePlsResultManager;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.version.PlsResultManagerImpl;
import jet.server.jrrmisvr.ServiceLogger;
import jet.server.jrserver.JRResourceManager;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.http.JRStringBufferPrintWriter;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.SchdTools;
import jet.server.util.HtmlEncoder;
import jet.server.util.ServerUtil;

public class SendFileServlet
extends HttpServlet {
    private String C = null;
    private boolean QOIV = false;
    private String append = null;
    private String charAt = null;
    private PlsResultManager checkLogin = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            String string = this.getInitParameter("isConvertedServletPath");
            if (string != null && string.equalsIgnoreCase("true")) {
                this.QOIV = true;
            }
            if ((string = this.getInitParameter("output_encoding")) != null && string.length() > 0) {
                try {
                    "1".getBytes(string);
                    this.append = string;
                }
                catch (Throwable throwable) {
                    jet.server.log.ServiceLogger.logError(throwable);
                    jet.server.log.ServiceLogger.logError(2680001, this.append, 2);
                }
            }
            this.C = this.getInitParameter("auth_scheme");
            if (this.C != null) {
                this.C = this.C.trim();
                if (this.C.equalsIgnoreCase("Digest")) {
                    this.C = "Digest";
                } else if (this.C.equalsIgnoreCase("Basic")) {
                    this.C = "Basic";
                } else {
                    this.C = HttpUtil.getAuthScheme();
                    if (this.C == null) {
                        this.C = "Basic";
                        jet.server.log.ServiceLogger.logError(2680002, "Basic", 2);
                    }
                }
            } else {
                this.C = HttpUtil.getAuthScheme();
                if (this.C == null) {
                    this.C = "Basic";
                    jet.server.log.ServiceLogger.logError(2680002, "Basic", 2);
                }
            }
        }
        catch (ServletException servletException) {
            jet.server.log.ServiceLogger.logError(servletException);
        }
        catch (Throwable throwable) {
            jet.server.log.ServiceLogger.logError(throwable);
        }
        jet.server.log.ServiceLogger.logEvent(4680003, new Object[]{this.C, String.valueOf(this.QOIV), "output_encoding", this.append}, 4);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.action(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.action(httpServletRequest, httpServletResponse);
    }

    private void action(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        block49: {
            Object object;
            Object object2;
            String string;
            long l = System.currentTimeMillis();
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            if (httpRptServer == null) {
                HttpUtil.initEnv(System.getProperties());
                httpRptServer = HttpUtil.getHttpRptServer();
            }
            if (this.checkLogin == null) {
                if (HttpUtil.isRemoteServer()) {
                    string = System.getProperty("jrs.remote.host");
                    int n = CSUtil.parseInt(System.getProperty("jrs.remote.rmiport"), 1129);
                    try {
                        object2 = (RemotePlsResultManager)RemoteObjectFactory.getRemoteObject(string, n, "PlsResultManager");
                        this.checkLogin = new PlsResultManagerImpl((RemotePlsResultManager)object2, true, false, HttpUtil.getRemoteFileService());
                    }
                    catch (NotBoundException notBoundException) {
                        ServiceLogger.logError(notBoundException);
                    }
                } else {
                    this.checkLogin = UserDataToolkit.getPlsResultManager();
                }
            }
            if ((string = httpServletRequest.getPathInfo()) != null && !string.equals("/META-INF/services/javax.print.PrintServiceLookup")) {
                try {
                    httpRptServer.getHttpUserSessionManager().removeExpiredUserSessions(httpServletRequest);
                }
                catch (Throwable throwable) {
                    jet.server.log.ServiceLogger.logError(throwable);
                }
            }
            try {
                object = httpRptServer.getHttpUserSessionManager().getUserSession(httpServletRequest);
                if (object != null) {
                    object.refreshLastAccessTime();
                }
            }
            catch (Throwable throwable) {
                jet.server.log.ServiceLogger.logError(throwable);
            }
            try {
                boolean bl;
                object = this.getPathInfo(httpServletRequest);
                object2 = HttpUtil.getParameters(httpServletRequest);
                String string2 = (String)((Properties)object2).get("jrs.cmd");
                if (string2 != null) {
                    string2 = string2.trim().toLowerCase();
                }
                jet.server.log.ServiceLogger.logEvent(6680004, new Object[]{string2, object, object2}, 6);
                if (string2 != null && string2.equalsIgnoreCase("jrs.wait_user")) {
                    if ((String)((Properties)object2).get("B2") != null) {
                        SendFileServlet.elementAt(httpServletRequest, httpServletResponse, JCliResource.getMessage("CS_MSG_151"));
                        return;
                    }
                    object = (String)((Properties)object2).get("path");
                }
                if ((String)((Properties)object2).get("left") != null) {
                    this.charAt = (String)((Properties)object2).get("left");
                }
                if (!(bl = httpRptServer.getHttpUserSessionManager().checkLogin(httpServletRequest, httpServletResponse, httpRptServer.getResourceManager().getRealm(), (Properties)object2)) && !((String)object).startsWith("/help/")) {
                    httpRptServer.getHttpUserSessionManager().sendUnauthorizedResponse(httpServletRequest, httpServletResponse, this.C, httpRptServer.getResourceManager().getRealm());
                    return;
                }
                if (string2 != null && string2.equalsIgnoreCase("jrs.wait_user")) {
                    SendFileServlet.elementAt(httpServletRequest, httpServletResponse, JCliResource.getMessage("CS_MSG_152"));
                    return;
                }
                if (string2 != null && string2.length() > 0) {
                    UserSession userSession = httpRptServer.getHttpUserSessionManager().getUserSession(httpServletRequest);
                    if (!httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(userSession.getRealm(), userSession.getUserID(), (String)object, string2)) {
                        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_4") + (String)object);
                        return;
                    }
                    this.append(string2, (Properties)object2, httpServletRequest, httpServletResponse, httpRptServer);
                    break block49;
                }
                if (HttpUtil.isRemoteServer()) {
                    this.containsKey(httpServletRequest, httpServletResponse, (String)object, (Properties)object2, httpRptServer);
                    if (((String)object).startsWith("/history/") && ((Properties)object2).get("jrs.result_type") != null) {
                        this.setResultVersionViewed(httpServletRequest, (Hashtable)object2);
                    }
                    return;
                }
                Object object3 = object;
                jet.server.log.ServiceLogger.logDebug(6680005, object, 6);
                File file = this.C(httpServletRequest, httpServletResponse, (String)object3, (Properties)object2, httpRptServer);
                jet.server.log.ServiceLogger.logDebug(6680006, file, 6);
                if (file == null) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, HtmlEncoder.encode((String)object3) + "not found!");
                    return;
                }
                boolean bl2 = JRRptServer.hasPageSecurity(file.getPath());
                if (bl2) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
                    return;
                }
                String string3 = ((String)object).toLowerCase();
                int n = string3.indexOf("/result/");
                if (n >= 0) {
                    string3 = ((String)object).substring(n + "/result/".length());
                }
                String string4 = file.getName();
                String string5 = "";
                n = string4.lastIndexOf(46);
                if (n > 0) {
                    string5 = string4.substring(n);
                }
                String string6 = httpRptServer.getResourceManager().getMIMEType(string5);
                jet.server.log.ServiceLogger.logDebug(6680007, string6, 6);
                httpServletResponse.setContentType(string6);
                try {
                    if (ServerUtil.isFileNotModified(file, httpServletRequest, httpServletResponse)) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    jet.server.log.ServiceLogger.logError(throwable);
                }
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentLength((int)file.length());
                if (ServerEnv.hasForce()) {
                    if (string6.toLowerCase().endsWith("excel") && ServerEnv.isForceExcel()) {
                        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + file.getName() + "\"");
                    } else if (string6.toLowerCase().endsWith("pdf") && ServerEnv.isForcePdf()) {
                        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + file.getName() + "\"");
                    } else if (string6.toLowerCase().endsWith("rtf") && ServerEnv.isForceRtf()) {
                        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + file.getName() + "\"");
                    } else if (string6.toLowerCase().endsWith("postscript") && ServerEnv.isForcePs()) {
                        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + file.getName() + "\"");
                    } else if (string6.toLowerCase().endsWith("xml") && ServerEnv.isForceXml()) {
                        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + file.getName() + "\"");
                    } else if (string6.toLowerCase().endsWith("plain") && ServerEnv.isForceText()) {
                        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + file.getName() + "\"");
                    }
                }
                HttpSession httpSession = httpServletRequest.getSession(false);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[8192];
                try {
                    int n2 = fileInputStream.read(byArray);
                    while (n2 >= 0) {
                        servletOutputStream.write(byArray, 0, n2);
                        n2 = fileInputStream.read(byArray);
                    }
                }
                catch (Throwable throwable) {
                    jet.server.log.ServiceLogger.logError(throwable);
                }
                fileInputStream.close();
                servletOutputStream.close();
                String string7 = httpSession == null ? null : httpSession.getId();
                jet.server.log.ServiceLogger.logAccessSuccessEvent(httpRptServer.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), string7, 5680012, file.getCanonicalPath(), 5);
            }
            catch (TooManyUsersException tooManyUsersException) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, tooManyUsersException.getMessage());
                jet.server.log.ServiceLogger.logError(tooManyUsersException);
            }
            catch (TooManyTimesException tooManyTimesException) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, tooManyTimesException.getMessage());
                jet.server.log.ServiceLogger.logError(tooManyTimesException);
            }
            catch (IOException iOException) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, iOException);
                jet.server.log.ServiceLogger.logError(iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, throwable);
                jet.server.log.ServiceLogger.logError(throwable);
            }
        }
    }

    private void setResultVersionViewed(HttpServletRequest httpServletRequest, Hashtable hashtable) {
        String string = HttpUtil.getUser(httpServletRequest);
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.result");
        int n = CSUtil.parseInt((String)hashtable.get("jrs.rst_version"), -1);
        int n2 = CSUtil.parseInt((String)hashtable.get("jrs.result_type"), -1);
        String string4 = string2 != null ? string2 : string3;
        String string5 = (String)hashtable.get("jrs.report_sheet");
        ResourceManager resourceManager = HttpUtil.getHttpRptServer().getResourceManager();
        ExResourceManager exResourceManager = (ExResourceManager)resourceManager;
        try {
            exResourceManager.setResultVersionViewed(string, string4, n, string5, n2);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            jet.server.log.ServiceLogger.logError(noPrivilegeException, 3);
        }
        catch (UnknownResource unknownResource) {
            jet.server.log.ServiceLogger.logError(unknownResource, 3);
        }
    }

    private File C(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties, HttpRptServer httpRptServer) {
        Object object;
        Object object2;
        String string2;
        String string3 = string;
        String string4 = string.toLowerCase();
        int n = string4.indexOf("/result/");
        if (n >= 0) {
            string3 = string3.substring(n + "/result/".length());
        }
        if ((string2 = (String)properties.get("jrs.temp_file")) == null || string2.length() == 0) {
            string2 = (String)properties.get("jrs.hist_file");
            if (string2 == null || string2.length() == 0) {
                string2 = (String)properties.get("jrs.file");
                if (string2 == null || string2.length() == 0) {
                    string2 = (String)properties.get("file");
                    if (string2 != null && string2.length() >= 0) {
                        string = string2;
                    }
                } else {
                    string = string2;
                }
            } else {
                string = "/history/" + string2;
            }
        } else {
            string = "/result/" + string2;
        }
        if (string.startsWith("/result/")) {
            object2 = (String)properties.get("jrs.result_type");
            if (object2 != null) {
                this.setResultVersionViewed(httpServletRequest, properties);
            }
            if (!string.endsWith("chart.jar")) {
                object = HttpUtil.getTempResultKey(string3);
                if (!httpRptServer.getTempResultOwnerManager().isOwner(HttpUtil.getUser(httpServletRequest), (String)object)) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_45", string));
                    return null;
                }
            }
            if (!((String)(object = httpRptServer.getResourceManager().getTempDir())).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object + string.substring(8);
        } else if (string.startsWith("/history/")) {
            object2 = (String)properties.get("jrs.result_type");
            if (object2 != null) {
                this.setResultVersionViewed(httpServletRequest, properties);
            }
            if (!((String)(object = httpRptServer.getResourceManager().getHistDir())).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object + string.substring(9);
            boolean bl = JRRptServer.hasPageSecurity(string);
            if (bl) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
                return null;
            }
        } else if (string.startsWith("/help/")) {
            object2 = httpRptServer.getServerEnv().getHomePath();
            if (!((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object2 + string.substring(1);
        } else if (string.startsWith("/lib/")) {
            object2 = httpRptServer.getServerEnv().getHomePath();
            if (!((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object2 + string.substring(1);
        } else if (string.startsWith("/javascripts/")) {
            object2 = httpRptServer.getServerEnv().getHomePath();
            if (!((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object2 + string.substring(1);
        } else {
            if (string.startsWith("/report/") || string.startsWith("/catalog/")) {
                try {
                    object2 = string.substring(string.startsWith("/report/") ? 7 : 8);
                    string = httpRptServer.getResourceManager().getPathInfo(HttpUtil.getUser(httpServletRequest), (String)object2).getRealPath();
                    jet.server.log.ServiceLogger.logDebug(6680008, new Object[]{object2, string}, 6);
                }
                catch (RptServerException rptServerException) {
                    jet.server.log.ServiceLogger.logError(rptServerException);
                    return null;
                }
            }
            if (string.startsWith("/realm/")) {
                object2 = httpRptServer.getServerEnv().getHomePath();
                if (!((String)object2).endsWith(File.separator)) {
                    object2 = (String)object2 + File.separator;
                }
                object = string.substring(7);
                string = HttpUtil.getRealmDir() + (String)object;
            } else if (string.startsWith("/folderTree/")) {
                object2 = httpServletRequest.getParameter("xmlFile");
                string = object2;
            } else if (string == null) {
                try {
                    string = httpRptServer.getResourceManager().getPathInfo(HttpUtil.getUser(httpServletRequest), httpServletRequest.getPathInfo()).getRealPath();
                }
                catch (RptServerException rptServerException) {
                    jet.server.log.ServiceLogger.logError(rptServerException);
                    return null;
                }
            }
        }
        jet.server.log.ServiceLogger.logDebug(6680009, string, 6);
        object2 = jet.server.api.SendFileAuthorizorFactory.getInstance();
        if (object2 != null) {
            if (!object2.isAuthorized(HttpUtil.getUser(httpServletRequest), string, httpRptServer)) {
                jet.server.log.ServiceLogger.logDebug(6680010, new Object[]{string, HttpUtil.getUser(httpServletRequest)}, 6);
                return null;
            }
            jet.server.log.ServiceLogger.logDebug(6680010, new Object[]{string, HttpUtil.getUser(httpServletRequest)}, 6);
        } else {
            object = SendFileAuthorizorFactory.getInstance();
            if (!object.isAuthorized(HttpUtil.getUser(httpServletRequest), string, httpRptServer)) {
                jet.server.log.ServiceLogger.logDebug(6680010, new Object[]{string, HttpUtil.getUser(httpServletRequest)}, 6);
                return null;
            }
            jet.server.log.ServiceLogger.logDebug(6680010, new Object[]{string, HttpUtil.getUser(httpServletRequest)}, 6);
        }
        object = new File(string);
        if (!((File)object).exists() || ((File)object).isDirectory()) {
            String string5;
            String string6 = ((File)object).getName();
            if (string6.equalsIgnoreCase("chart.jar") && ((File)(object = new File(string5 = httpRptServer.getServerEnv().getHomePath() + "lib" + File.separator, string6))).exists()) {
                return object;
            }
            return null;
        }
        return object;
    }

    private String getPathInfo(HttpServletRequest httpServletRequest) throws IOException {
        String string = httpServletRequest.getPathInfo();
        if (string == null || string.length() == 0) {
            string = "/";
        } else if (this.QOIV) {
            string = HttpUtil.decodeEsc(string);
        }
        if (string.toLowerCase().indexOf("<script>") != -1 || string.toLowerCase().indexOf("%3cscript%3e") != -1 || string.toLowerCase().indexOf("javascript:") != -1 || string.toLowerCase().indexOf("vbscript:") != -1) {
            string = "/";
        }
        return string;
    }

    private JRStringBufferPrintWriter QOIV(HttpServletResponse httpServletResponse) throws IOException {
        return new JRStringBufferPrintWriter(httpServletResponse, (OutputStream)httpServletResponse.getOutputStream(), this.append);
    }

    private void append(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpRptServer httpRptServer) throws Throwable {
        if (string.equalsIgnoreCase("jrs.get_temp_result")) {
            this.checkLogin(httpServletRequest, httpServletResponse, (String)properties.get("jrs.file"), properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.remove_temp_result")) {
            this.checkRealPath(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.get_ver_rst")) {
            this.close(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.exp_rst")) {
            this.responseExportResult(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.open_pipeline_html")) {
            this.responseOpenPipeLineHtml(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.logout")) {
            this.charAt(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.open_pagelevelsecurity_html")) {
            this.responseOpenPlsHtml(httpServletRequest, httpServletResponse, properties, httpRptServer);
        }
    }

    public void responseOpenPipeLineHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties, HttpRptServer httpRptServer) throws Throwable {
        int n = CSUtil.parseInt((String)properties.get("pgnum"), -1);
        String string = this.decodeEsc(httpServletRequest, true);
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        string = string.substring(0, string.lastIndexOf("/") + 1);
        String string3 = httpRptServer.getFilenames(string2, n);
        string = string + string3;
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.QOIV(httpServletResponse);
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setStatus(301);
        httpServletResponse.setHeader("Location", string);
        httpServletResponse.setHeader("Content-Location", string);
        jRStringBufferPrintWriter.println("<html><head><title>" + JSvrResource.getMessage("SLT_PG_125") + "</title>");
        jRStringBufferPrintWriter.println("</head><body><H1>" + JSvrResource.getMessage("SLT_PG_125") + "</H1>");
        jRStringBufferPrintWriter.println(JSvrResource.getMessage("SLT_PG_126") + ":");
        jRStringBufferPrintWriter.println("<a href=\"" + string + "\">" + string + "</a></body></html>");
        jRStringBufferPrintWriter.close();
    }

    public void responseOpenPlsHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties, HttpRptServer httpRptServer) throws Throwable {
        int n;
        if (properties.containsKey("jrs.rst_version")) {
            this.setResultVersionViewed(httpServletRequest, properties);
        }
        String string = httpServletRequest.getPathInfo();
        String string2 = string.substring("/history/".length());
        String string3 = httpRptServer.getResourceManager().getHistDir();
        String string4 = string3 + string2;
        int n2 = CSUtil.parseInt((String)properties.get("op"), 1);
        int n3 = CSUtil.parseInt(properties.getProperty("pg"), 1);
        int n4 = 0;
        if (n2 == 4) {
            n4 = CSUtil.parseInt(properties.getProperty("pypg"), 1);
        }
        if (n2 == 1) {
            n3 = 1;
        } else if (n2 == 2) {
            n3 = -1;
        }
        String string5 = httpRptServer.getResourceManager().getMIMEType(".html");
        jet.server.log.ServiceLogger.logDebug(6680007, string5, 6);
        httpServletResponse.setContentType(string5);
        httpServletResponse.setStatus(200);
        String string6 = HttpUtil.getUser(httpServletRequest);
        InputStream inputStream = this.checkLogin.getHtmlPage(string6, string4, n3);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) > -1) {
            servletOutputStream.write(byArray, 0, n);
        }
        servletOutputStream.close();
    }

    private void charAt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, HttpRptServer httpRptServer) throws Exception {
        this.logout(httpServletRequest, httpServletResponse, hashtable, httpRptServer);
        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_53"));
    }

    private void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, HttpRptServer httpRptServer) throws Exception {
        httpRptServer.getHttpUserSessionManager().logout(httpServletRequest);
    }

    private void checkLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Hashtable hashtable, HttpRptServer httpRptServer) throws Exception {
        String string2;
        String string3;
        String string4;
        Object object;
        if (string == null) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_43"));
            return;
        }
        boolean bl = string.toLowerCase().endsWith(".html");
        boolean bl2 = false;
        if (!string.trim().equalsIgnoreCase("chart.jar")) {
            object = string;
            if (!APIUtil.getBoolean((String)hashtable.get("jrs.check_fullname"), false)) {
                object = HttpUtil.getTempResultKey(string);
            }
            if (!httpRptServer.getTempResultOwnerManager().isOwner(HttpUtil.getUser(httpServletRequest), (String)object)) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_45", string));
                return;
            }
        } else {
            bl2 = true;
        }
        object = new File(httpRptServer.getResourceManager().getTempDir() + string);
        String string5 = (String)hashtable.get("jrs.html_temp_dir");
        if (string5 != null) {
            object = new File(httpRptServer.getResourceManager().getTempDir() + string5 + File.separator + string);
        }
        if ((string4 = (String)hashtable.get("jrs.pdf_temp_dir")) != null) {
            object = new File(httpRptServer.getResourceManager().getTempDir() + string4 + File.separator + string);
        }
        if ((string3 = (String)hashtable.get("jrs.rtf_temp_dir")) != null) {
            object = new File(httpRptServer.getResourceManager().getTempDir() + string3 + File.separator + string);
        }
        if ((string2 = (String)hashtable.get("jrs.xml_temp_dir")) != null) {
            object = new File(httpRptServer.getResourceManager().getTempDir() + string2 + File.separator + string);
        }
        if (bl) {
            httpServletResponse.setContentType("text/html");
            HttpUtil.sendFile(httpServletRequest, httpServletResponse, (File)object);
            return;
        }
        if (!((File)object).exists()) {
            if (bl2) {
                String string6 = httpRptServer.getServerEnv().getHomePath() + "lib" + File.separator;
                object = new File(string6, string);
                if (!((File)object).exists()) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_29", string));
                    return;
                }
            } else {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_29", string));
                return;
            }
        }
        if (HttpUtil.isJRClient(httpServletRequest, hashtable)) {
            HttpUtil.processPartialRequest(httpServletRequest, httpServletResponse, (File)object, hashtable);
        } else {
            HttpUtil.sendFile(httpServletRequest, httpServletResponse, (File)object);
        }
    }

    private void checkRealPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties, HttpRptServer httpRptServer) throws IOException {
        String string = (String)properties.get("jrs.file");
        httpRptServer.getTempResultOwnerManager().removeOwner(HttpUtil.getUser(httpServletRequest), HttpUtil.getTempResultKey(string));
        String string2 = (String)properties.get("jrs.html_temp_dir");
        String string3 = (String)properties.get("jrs.pdf_temp_dir");
        String string4 = (String)properties.get("jrs.rtf_temp_dir");
        String string5 = (String)properties.get("jrs.xml_temp_dir");
        if (string != null) {
            try {
                File file;
                if (string2 != null) {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir() + string2 + File.separator, string);
                    file = new File(httpRptServer.getResourceManager().getTempDir() + string2);
                    file.delete();
                }
                if (string3 != null) {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir() + string3 + File.separator, string);
                    file = new File(httpRptServer.getResourceManager().getTempDir() + string3);
                    file.delete();
                }
                if (string4 != null) {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir() + string4 + File.separator, string);
                    file = new File(httpRptServer.getResourceManager().getTempDir() + string4);
                    file.delete();
                }
                if (string5 != null) {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir() + string5 + File.separator, string);
                    file = new File(httpRptServer.getResourceManager().getTempDir() + string5);
                    file.delete();
                } else {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir(), string);
                }
            }
            catch (Throwable throwable) {
                jet.server.log.ServiceLogger.logError(throwable);
            }
        }
        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 200, "OK!");
    }

    public void responseExportResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties, HttpRptServer httpRptServer) throws Throwable {
        String string;
        Object object;
        File file = null;
        String string2 = HttpUtil.getUser(httpServletRequest);
        String string3 = (String)properties.get("jrs.file");
        if (string3 != null) {
            file = new File(string3);
        } else {
            string3 = (String)properties.get("jrs.temp_file");
            if (string3 != null) {
                String string4 = string3;
                if (!APIUtil.getBoolean((String)properties.get("jrs.check_fullname"), false)) {
                    string4 = HttpUtil.getTempResultKey(string3);
                }
                if (!httpRptServer.getTempResultOwnerManager().isOwner(string2, string4)) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_56", string3));
                    return;
                }
                file = new File(httpRptServer.getResourceManager().getTempDir() + string3);
            } else {
                string3 = (String)properties.get("jrs.hist_file");
                if (string3 != null) {
                    boolean bl = JRRptServer.hasPageSecurity(string3);
                    if (bl) {
                        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
                        return;
                    }
                    object = httpRptServer.getResourceManager().getHistDir();
                    file = object != null && string3.startsWith((String)object) ? new File(string3) : new File((String)object + string3);
                }
            }
        }
        if (file == null || !file.exists()) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, HttpUtil.getBase(httpServletRequest, true));
            return;
        }
        string3 = HttpUtil.getUser(httpServletRequest);
        if (string3 != null) {
            properties.put("jrs.uid", string3);
        }
        if ((string = httpServletRequest.getRemoteHost()) != null) {
            properties.put("jrs.remote_host", string);
        }
        properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
        properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
        object = httpRptServer.exportResult(string2, file.getCanonicalPath(), properties);
        if (object != null) {
            int n;
            int n2;
            Vector vector;
            string3 = object.getRSTFilename();
            if (string3 != null) {
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((vector = object.getHTMLFilenameList()) != null) {
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 != null) {
                        httpRptServer.getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                    }
                    ++n;
                }
            }
            if ((vector = object.getPDFFilename()) != null) {
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 != null) {
                        httpRptServer.getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                    }
                    ++n;
                }
            }
            if ((string3 = object.getTEXTFilename()) != null) {
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((string3 = object.getExcelFilename()) != null) {
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((string3 = object.getPSFilename()) != null) {
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((vector = object.getRTFFilenameList()) != null) {
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 != null) {
                        httpRptServer.getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                    }
                    ++n;
                }
            }
            if ((vector = object.getXMLFilenameList()) != null) {
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 != null) {
                        httpRptServer.getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                    }
                    ++n;
                }
            }
            httpServletResponse.setStatus(200);
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.QOIV(httpServletResponse);
            String string5 = object.toHttpQueryString();
            jRStringBufferPrintWriter.println(string5);
            jRStringBufferPrintWriter.close();
            jet.server.log.ServiceLogger.logAccessSuccessEvent(httpRptServer.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), SendFileServlet.currentTimeMillis(httpServletRequest), 6680013, string5, 6);
            return;
        }
        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 406, httpServletRequest.getRequestURI());
    }

    private void close(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, HttpRptServer httpRptServer) throws IOException {
        String string = (String)hashtable.get("jrs.file");
        if (string == null) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 406, "The result file was not specified!");
            return;
        }
        JRResourceManager jRResourceManager = (JRResourceManager)httpRptServer.getResourceManager();
        try {
            string = jRResourceManager.checkRealPath(string);
        }
        catch (Exception exception) {
            jet.server.log.ServiceLogger.logError(exception);
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, string + " not found!");
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, string + " not found!");
            return;
        }
        boolean bl = JRRptServer.hasPageSecurity(file.getPath());
        if (bl) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
            return;
        }
        if (hashtable.containsKey("jrs.rst_version")) {
            hashtable.put("jrs.report_sheet", "jrs.rst_result");
            hashtable.put("jrs.result_type", String.valueOf(0));
            this.setResultVersionViewed(httpServletRequest, hashtable);
        }
        HttpUtil.sendFile(httpServletRequest, httpServletResponse, file);
    }

    private void containsKey(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties, HttpRptServer httpRptServer) throws IOException {
        block17: {
            String string2;
            String string3 = string;
            RemoteFileService remoteFileService = HttpUtil.getRemoteFileService();
            if (httpServletRequest.getPathInfo() != null) {
                String string4;
                if (string3.startsWith("/result/")) {
                    String string5;
                    string4 = (String)properties.get("jrs.result_type");
                    if (string4 != null) {
                        this.setResultVersionViewed(httpServletRequest, properties);
                    }
                    if (!(string5 = httpRptServer.getResourceManager().getTempDir()).endsWith(File.separator)) {
                        string5 = string5 + File.separator;
                    }
                    string3 = string3.replace('/', File.separatorChar);
                    string3 = string5 + string3.substring(8);
                } else if (string3.startsWith("/history/")) {
                    string4 = httpRptServer.getResourceManager().getHistDir();
                    if (!string4.endsWith(File.separator)) {
                        string4 = string4 + File.separator;
                    }
                    string3 = string3.replace('/', File.separatorChar);
                    string3 = string3.replace(File.separatorChar, remoteFileService.getRemoteFileSeparator().charAt(0));
                    string3 = string4 + string3.substring(9);
                    boolean bl = JRRptServer.hasPageSecurity(string3);
                    if (bl) {
                        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
                    }
                } else if (string3.startsWith("/folderTree/")) {
                    string3 = httpServletRequest.getParameter("xmlFile");
                }
                string2 = string3;
            } else {
                string2 = this.C(httpServletRequest, httpServletResponse, string3, properties, httpRptServer).getPath();
            }
            string2 = string2.replace(File.separatorChar, remoteFileService.getRemoteFileSeparator().charAt(0));
            try {
                String string6;
                long l = 0L;
                byte[] byArray = new byte[65536];
                InputStream inputStream = null;
                l = remoteFileService.length(string2);
                inputStream = remoteFileService.readFile(string2);
                String string7 = null;
                int n = string2.lastIndexOf(46);
                if (n > 0) {
                    string6 = string2.substring(n).toLowerCase();
                    string7 = HttpUtil.getHttpRptServer().getResourceManager().getMIMEType(string6);
                    if (string7 == null || string7.trim().length() == 0) {
                        string7 = "application/octet-stream";
                    }
                }
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentType(string7);
                httpServletResponse.setContentLength((int)l);
                httpServletResponse.setHeader("Cache-Control", "max-age=1");
                httpServletResponse.setDateHeader("Last-Modified", System.currentTimeMillis());
                string6 = httpServletResponse.getOutputStream();
                int n2 = inputStream.read(byArray, 0, 65536);
                while (n2 >= 0) {
                    if (n2 > 0) {
                        ((OutputStream)((Object)string6)).write(byArray, 0, n2);
                    }
                    n2 = inputStream.read(byArray, 0, 65536);
                }
                inputStream.close();
                ((OutputStream)((Object)string6)).flush();
                ((OutputStream)((Object)string6)).close();
            }
            catch (Exception exception) {
                if (exception.getCause() == null || exception.getCause() instanceof SocketException) break block17;
                jet.server.log.ServiceLogger.logError(exception);
            }
        }
    }

    private static String currentTimeMillis(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        return httpSession.getId();
    }

    public void generateWaitInQueue(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setStatus(200);
        String string = "jrs.wait_user";
        String string2 = JCliResource.getMessage("CS_MSG_147");
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.QOIV(httpServletResponse);
        String string3 = this.getPathInfo(httpServletRequest);
        httpServletResponse.setContentType("text/html");
        this.delete(httpServletRequest, jRStringBufferPrintWriter, string2);
        jRStringBufferPrintWriter.println("<font face=\"Arial\"><small>");
        jRStringBufferPrintWriter.println("<form method=\"POST\" action=\"\\servlet\\sendfile\\\">");
        jRStringBufferPrintWriter.println("<table style=\"font-family:Arial;font-size:10pt;\" border=\"0\" width=\"100%\">");
        jRStringBufferPrintWriter.println("<tr bgcolor=\"#000000\"><td align=\"left\"><b><font color=\"#ECECEC\">" + string2 + "</b></td></tr>");
        jRStringBufferPrintWriter.println("</table>");
        jRStringBufferPrintWriter.print("<input type=hidden name=jrs.cmd value=\"" + string + "\">");
        jRStringBufferPrintWriter.print("<input type=hidden name=path value=\"" + string3 + "\">");
        jRStringBufferPrintWriter.print("<input type=hidden name=\"isWait\" value=\"true\">");
        jRStringBufferPrintWriter.println("<p><input type=\"submit\" value=\"Yes\" name=\"Submit_Btn\">");
        jRStringBufferPrintWriter.println("<input type=\"submit\" value=\"No\" name=\"B2\"></p>");
        jRStringBufferPrintWriter.println("</form>");
        jRStringBufferPrintWriter.println("</small></font>");
        jRStringBufferPrintWriter.println("</body>");
        jRStringBufferPrintWriter.println("</html>");
        jRStringBufferPrintWriter.close();
    }

    private String decodeEsc(HttpServletRequest httpServletRequest, boolean bl) throws Exception {
        return bl ? HttpUtil.getQueryBase(httpServletRequest, !this.QOIV) : HttpUtil.getQueryBaseNoPath(httpServletRequest, !this.QOIV);
    }

    private void delete(HttpServletRequest httpServletRequest, JRStringBufferPrintWriter jRStringBufferPrintWriter, String string) throws Exception {
        this.deleteFile(httpServletRequest, jRStringBufferPrintWriter, string);
    }

    private void deleteFile(HttpServletRequest httpServletRequest, JRStringBufferPrintWriter jRStringBufferPrintWriter, String string) throws Exception {
        jRStringBufferPrintWriter.println("<html>");
        jRStringBufferPrintWriter.println("<head>");
        jRStringBufferPrintWriter.println("<title>" + string + "</title>");
        jRStringBufferPrintWriter.println("</head>");
        if (this.charAt == null) {
            jRStringBufferPrintWriter.println("<body >");
        } else {
            jRStringBufferPrintWriter.println("<body onunload=parent.leftframe.location=\"" + this.charAt + "\">");
        }
    }

    private static void elementAt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        String string2 = string == null ? "" : string;
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("JRS-MESSAGE", CSUtil.replWithEsc(string2));
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setContentType("text/html");
            servletOutputStream.println("<html>");
            servletOutputStream.println("<head>");
            servletOutputStream.println("<title>" + JSvrResource.getMessage("SLT_ERR_66") + "</title>");
            servletOutputStream.println("</head>");
            servletOutputStream.println("<body>");
            servletOutputStream.write(string2.getBytes());
            servletOutputStream.println();
            servletOutputStream.println("</body>");
            servletOutputStream.println("</html>");
        }
        catch (Throwable throwable) {
            jet.server.log.ServiceLogger.logError(throwable);
        }
    }
}

