/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.servlets.JRServlet;
import jet.server.servlets.ServletUtil;
import jet.server.servlets.WebOperation;
import jet.util.AsciiProperties;

public class WebHandler {
    private JRServlet QOIV = null;
    private WebOperation _getCatAndRptNames = null;
    private ExProperties append;
    private String canRead;
    protected Properties redirectProps = new AsciiProperties();
    public static final String JSP_PATH = "jsp_path";
    public static final String HANDLER_QUERY = "web_handler_query";
    public static final String HANDLER_PATH = "web_handler_path";

    public WebHandler(JRServlet jRServlet) {
        this.QOIV = jRServlet;
        this._getCatAndRptNames = new WebOperation(jRServlet);
        try {
            this.append = ServerEnv.getServerProps();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.canRead = this.append.getProperty("httpserver.redirect.propfile", "");
        this.QOIV();
        this._getCatAndRptNames.setRedirectProps(this.redirectProps);
    }

    private void QOIV() {
        File file = new File(this.canRead);
        if (file.exists() && file.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    this.redirectProps.load(new FileInputStream(file));
                }
                catch (IOException iOException) {
                    System.err.println("Could not load redirect properites file");
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }
    }

    public void updateRedirectProps(ServletContext servletContext, HttpServletRequest httpServletRequest) {
        if (servletContext.getAttribute("jreport_redirect_props_updated") == null) {
            this.redirectProps.put(JSP_PATH, httpServletRequest.getContextPath() + "/jinfonet/");
            this._getCatAndRptNames.setRedirectProps(this.redirectProps);
            this._getCatAndRptNames();
            servletContext.setAttribute("jreport_redirect_props_updated", (Object)"true");
        }
    }

    private void _getCatAndRptNames() {
        File file = new File(this.canRead);
        if (file.exists() && file.canWrite()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    Properties properties = new Properties();
                    Object object = null;
                    Enumeration<Object> enumeration = this.redirectProps.keys();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        properties.put(object, this.redirectProps.get(object));
                    }
                    properties.save(new FileOutputStream(file), null);
                }
                catch (IOException iOException) {
                    System.err.println("Could not save redirect properites file");
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }
    }

    public void doCommand(String string, Properties properties, boolean bl, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        String string2;
        if (this.QOIV.getExternalQueriable() != null && (string2 = this.QOIV.getExternalQueriable().getId()) != null) {
            properties.put("jrs.ext_qrybl_id", string2);
        }
        string2 = HttpUtil.getWebAppUrl(httpServletRequest, this.redirectProps.getProperty(JSP_PATH));
        if (string == null || string.length() == 0) {
            if (bl) {
                this._getCatAndRptNames.responseNormalFile(httpServletRequest, httpServletResponse, properties);
            } else {
                this.QOIV.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, JSvrResource.getMessage("SLT_ERR_16"), (Hashtable)properties);
            }
        } else if (string.equalsIgnoreCase("jrs.view_ondemand")) {
            String string3 = (String)properties.get(HANDLER_QUERY);
            if (!string3.startsWith("?")) {
                string3 = "?" + string3;
            }
            string2 = string2 + this.redirectProps.getProperty(string) + string3 + "&" + "jrs.temp_file" + "=" + properties.get("jrs.result");
            httpServletResponse.sendRedirect(string2);
        } else {
            if (this.redirectProps.getProperty(string) != null && this.redirectProps.getProperty(string).length() != 0) {
                String string4;
                String string5 = (String)properties.get("jrs.report");
                String string6 = (String)properties.get("jrs.catalog");
                if ((string5 == null || string6 == null) && (string4 = (String)properties.get(HANDLER_PATH)) != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    ServletUtil._getCatAndRptNames(string4, stringBuffer2, stringBuffer);
                    String string7 = null;
                    String string8 = null;
                    boolean bl2 = false;
                    if (string4.endsWith(".clx") && string4.indexOf(".cat") == -1 && string4.indexOf(".clx") == string4.lastIndexOf(".clx")) {
                        string7 = string4;
                        string8 = string4;
                    } else {
                        if (stringBuffer2 != null && stringBuffer2.toString().trim().length() > 0) {
                            string8 = stringBuffer2.toString();
                        }
                        if (stringBuffer != null && stringBuffer.toString().trim().length() > 0) {
                            string7 = stringBuffer.toString();
                        }
                    }
                    if (string5 == null && string7 != null) {
                        properties.put("jrs.report", string7);
                        bl2 = true;
                    }
                    if (string6 == null && string8 != null) {
                        properties.put("jrs.catalog", string8);
                        bl2 = true;
                    }
                    if (bl2) {
                        properties.remove(HANDLER_QUERY);
                        properties.put(HANDLER_QUERY, CSUtil.makeQuery(properties));
                    }
                }
                if (!(string4 = (String)properties.get(HANDLER_QUERY)).startsWith("?")) {
                    string4 = "?" + string4;
                }
                string2 = string2.endsWith("/") ? string2 + this.redirectProps.getProperty(string) + string4 : string2 + "/" + this.redirectProps.getProperty(string) + string4;
                httpServletResponse.sendRedirect(string2);
                return;
            }
            if (string.equalsIgnoreCase("jrs.restart")) {
                this.QOIV.getServletOperation().responseRestart(httpServletRequest, httpServletResponse, properties);
            } else if (string.equalsIgnoreCase("jrs.stop")) {
                this.QOIV.getServletOperation().responseStop(httpServletRequest, httpServletResponse, properties);
            } else if (string.equalsIgnoreCase("jrs.test_before_deploycat")) {
                this.QOIV.getServletOperation().testBeforeDeployCat(httpServletRequest, httpServletResponse, properties);
            } else if (string.equalsIgnoreCase("jrs.test_before_deployfont")) {
                this.QOIV.getServletOperation().testBeforeDeployFont(httpServletRequest, httpServletResponse, properties);
            } else if (string.equalsIgnoreCase("jrs.after_deployfiles")) {
                this.QOIV.getServletOperation().responseAddDeployFilesToResource(httpServletRequest, httpServletResponse, properties);
            } else if (string.equalsIgnoreCase("jrs.test_before_deploystylegroup")) {
                this.QOIV.getServletOperation().testBeforeDeployStyleGroup(httpServletRequest, httpServletResponse, properties);
            } else if (string.equalsIgnoreCase("jrs.open_pipeline_html")) {
                this._getCatAndRptNames.responseOpenPipeLineHtml(httpServletRequest, httpServletResponse, properties);
            } else if (string.equalsIgnoreCase("jrs.get_ver_rst")) {
                this._getCatAndRptNames.responseViewOnClient(httpServletRequest, httpServletResponse, properties);
            } else {
                this.QOIV.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, JSvrResource.getMessage("SLT_ERR_17", string), (Hashtable)properties);
            }
        }
    }

    public void responseMainFrame(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.sendRedirect(this.redirectProps.getProperty(JSP_PATH) + this.redirectProps.getProperty("jrs.main_frame"));
    }

    public void responseGetDhtmlPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get(HANDLER_QUERY);
        if (!string.startsWith("?")) {
            string = "?" + string;
        }
        httpServletResponse.sendRedirect(this.redirectProps.getProperty(JSP_PATH) + this.redirectProps.getProperty("jrs.get_dhtml_page") + string);
    }

    public boolean responseUnauthSpecialPaths(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        return this._getCatAndRptNames.responseUnauthSpecialPaths(string, properties, httpServletRequest, httpServletResponse);
    }

    public boolean responseSpecialPaths(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        return this._getCatAndRptNames.responseSpecialPaths(string, properties, httpServletRequest, httpServletResponse);
    }
}

