/*
 * Decompiled with CFR 0.152.
 */
package jet.server.tools;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.db.DBManager;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.db.core.DatabaseImpl;

public final class DBMaintain {
    public static void main(String[] stringArray) {
        Object object;
        Properties properties = new Properties();
        int n = stringArray.length;
        if (n < 1) {
            DBMaintain.QOIV();
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            if ("-?".equals(object)) {
                DBMaintain.QOIV();
                return;
            }
            if ("-cleanup".equalsIgnoreCase((String)object)) {
                properties.setProperty("check.systables", "true");
            } else if (((String)object).startsWith("-B0systables:")) {
                properties.setProperty("backup-type", "DB");
                properties.setProperty("backup.systables", ((String)object).substring("-B0systables:".length()));
            } else if (((String)object).startsWith("-Bsystables:")) {
                properties.setProperty("backup.systables", ((String)object).substring("-Bsystables:".length()));
            } else if (((String)object).startsWith("-Bprofiling:")) {
                properties.setProperty("backup.profiling", ((String)object).substring("-Bprofiling:".length()));
            } else if (((String)object).startsWith("-R0systables:")) {
                properties.setProperty("restore-type", "DB");
                properties.setProperty("restore.systables", ((String)object).substring("-R0systables:".length()));
            } else if (((String)object).startsWith("-Rsystables:")) {
                properties.setProperty("restore.systables", ((String)object).substring("-Rsystables:".length()));
            } else if (((String)object).startsWith("-Rprofiling:")) {
                properties.setProperty("restore.profiling", ((String)object).substring("-Rprofiling:".length()));
            } else {
                DBMaintain.QOIV();
                return;
            }
            ++n2;
        }
        DBMaintain dBMaintain = new DBMaintain();
        dBMaintain.checkDBEnv(properties);
        object = DBManager.getDefaultWorkspace();
        Iterator iterator = object.databases().iterator();
        while (iterator.hasNext()) {
            DatabaseImpl databaseImpl = (DatabaseImpl)iterator.next();
            databaseImpl.close();
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        System.exit(0);
    }

    private static void QOIV() {
        DBMaintain.backup("Usage: java jet.server.tools.DBMaintain [options]");
        DBMaintain.backup("Options:");
        DBMaintain.backup("  -?\t\tprint this help message");
        DBMaintain.backup("  -cleanup\tcheck integrality of server data and cleanup invalid data");
        DBMaintain.backup("  -Bsystables:<filename>\r\n\t\tbackup systables database to an appointed file");
        DBMaintain.backup("  -B0systables:<filename>\r\n\t\tbackup systables database without external data");
        DBMaintain.backup("  -Bprofiling:<filename>\r\n\t\tbackup profiling database to an appointed file");
        DBMaintain.backup("  -Rsystables:<filename>\r\n\t\trestore systables database from an appointed file");
        DBMaintain.backup("  -R0systables:<filename>\r\n\t\trestore systables database and exclude external data");
        DBMaintain.backup("  -Rprofiling:<filename>\r\n\t\trestore profiling database from an appointed file");
    }

    private static void backup(String string) {
        System.err.println(string);
    }

    private DBMaintain() {
    }

    void checkDBEnv(Properties properties) {
        Database database;
        System.getProperties().putAll((Map<?, ?>)properties);
        ServerEnv.checkDBEnv();
        Workspace workspace = DBManager.getDefaultWorkspace();
        String string = properties.getProperty("backup.systables");
        if (string != null && string.trim().length() > 0 && workspace != null && (database = workspace.databases("systables")) != null) {
            try {
                String string2 = properties.getProperty("backup-type");
                if (string2 != null) {
                    database.setProperty("backup-type", string2);
                }
                database.backup(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if ((string = properties.getProperty("backup.profiling")) != null && string.trim().length() > 0 && workspace != null && (database = workspace.databases("profiling")) != null) {
            try {
                database.backup(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

