/*
 * Decompiled with CFR 0.152.
 */
package jet.server.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.ResultVersionRecord;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.db.resource.NodeTableImpl;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.Version;
import jet.server.jrc.resource.ReportInfoImpl;
import jet.server.jrc.resource.ResourceToolkit;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.resource.ResultInfoImpl;
import jet.server.schedule.JRResultFiles;
import jet.server.schedule.SchdTools;
import jet.server.tools.migration.DataToolkitV6;
import jet.server.tools.migration.SecurityMigratorV6;
import jet.util.WildcardMatcher;

public class MigrationToV6 {
    DataToolkitV6 I = null;
    SecurityMigratorV6 QOIV = null;
    String add = null;
    String addAliases = null;
    String addAllManager = null;
    String addElement = null;
    String addResource = null;
    String Z = null;
    String C = null;
    String addResult = null;
    Vector B = new Vector();

    public MigrationToV6(String string, String string2) throws Exception {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        this.addResource = string;
        this.add = string2;
        String[] stringArray = this.addResource(string2);
        this.addAliases = stringArray[0];
        this.addAllManager = stringArray[1];
        this.addElement = stringArray[2];
        stringArray = this.addResource(string);
        this.Z = stringArray[0];
        this.C = stringArray[1];
        this.addResult = stringArray[2];
        ResourceToolkit.setReportHome(string2);
        ResourceToolkit.setHistDir(this.addElement);
        ServerEnv.histPath = this.addElement;
        this.QOIV = new SecurityMigratorV6(this.C, this.addAllManager);
        Enumeration enumeration = this.QOIV.getAllRealmNames();
        while (enumeration.hasMoreElements()) {
            this.B.addElement(enumeration.nextElement());
        }
        ServerEnv.realmsPath = this.addAllManager;
        this.I = new DataToolkitV6(string2, this.addAliases, this.addElement);
        this.QOIV.setDataToolkit(this.I);
    }

    public void migrateResource() throws Exception {
        File file = new File(this.C);
        Enumeration enumeration = this.QOIV.getAllRealmNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Properties properties = this.addElement(this.C + string);
            this.I.addAllManager(string, properties);
        }
        if (!this.addResult.equalsIgnoreCase(this.addElement)) {
            this.copyParamFiles();
        }
        if (!this.addResource.equalsIgnoreCase(this.add)) {
            this.QOIV();
        }
    }

    public void migrateAlias() {
        System.out.println("start migrate alias");
        File file = new File(this.C);
        Enumeration enumeration = this.QOIV.getAllRealmNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = this.I.getDataService(string).getUserTable().getAllUsersName();
            Properties properties = this.getAliases(this.C + string, vector);
            ResourceTreeManagerImpl resourceTreeManagerImpl = this.I.getResourceManager(string);
            Properties properties2 = this.addElement(this.C + string);
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                Properties properties3 = (Properties)properties.get(string2);
                if (properties3 != null) {
                    this.addAliases(string2, properties3, properties2, resourceTreeManagerImpl);
                }
                ++n;
            }
            System.out.println("complete migrate alias in realm: " + string);
        }
        System.out.println("migrate alias successfully!");
    }

    public Properties getAliases(String string, Vector vector) {
        Properties properties = new Properties();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            String string3 = string + File.separator + string2 + File.separator + "alias_table.properties";
            ExProperties exProperties = null;
            if (new File(string3).exists()) {
                exProperties = new ExProperties();
                try {
                    exProperties.load(string3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (exProperties != null) {
                properties.put(string2, exProperties);
            }
            ++n;
        }
        return properties;
    }

    public void addAliases(String string, Properties properties, Properties properties2, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        if (properties2 == null || properties2.isEmpty()) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            Properties properties3 = new Properties();
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)properties.get(string2);
            String string4 = (String)properties2.get(string3);
            String string5 = "/USERFOLDERPATH/" + string;
            if (string4 != null && string4.length() != 0) {
                properties3.put(string2, string4);
            }
            if (properties3.isEmpty()) continue;
            Folder folder = null;
            try {
                folder = (Folder)resourceTreeManagerImpl.getNodeByPath(string5);
            }
            catch (UnknownResource unknownResource) {
                System.out.println(unknownResource);
            }
            String string6 = string5;
            Folder folder2 = null;
            try {
                folder2 = (Folder)resourceTreeManagerImpl.getNodeByPath(string6);
            }
            catch (UnknownResource unknownResource) {
                System.out.println(unknownResource);
            }
            if (string2.equals("/")) {
                object = new File(properties3.getProperty(string2));
                ResourceToolkit.importResources((File)object, folder2, true, false, resourceTreeManagerImpl, "JReport_System_User");
            }
            System.out.print(">");
            String string7 = null;
            Folder folder3 = null;
            Node node = null;
            Hashtable<String, String> hashtable = null;
            String string8 = null;
            Enumeration<Object> enumeration2 = properties3.keys();
            while (enumeration2.hasMoreElements()) {
                object = (String)enumeration2.nextElement();
                string7 = properties3.getProperty((String)object);
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, "/");
                folder3 = folder2;
                while (stringTokenizer.hasMoreTokens()) {
                    string8 = stringTokenizer.nextToken();
                    hashtable = new Hashtable<String, String>();
                    hashtable.put("jrs.node_name", string8);
                    try {
                        folder3 = resourceTreeManagerImpl.addSubFolder(folder3, hashtable, string);
                    }
                    catch (NodeExistsException nodeExistsException) {
                        node = folder3.getChild(string8);
                        if (node.getNodeType() == 1) {
                            folder3 = (Folder)node;
                            continue;
                        }
                        folder3 = null;
                        break;
                    }
                    catch (NoPrivilegeException noPrivilegeException) {
                        noPrivilegeException.printStackTrace();
                    }
                }
                if (folder3 != null && folder3 != folder2) {
                    ResourceToolkit.importResources(new File(string7), folder3, true, false, resourceTreeManagerImpl, "JReport_System_User");
                }
                System.out.print(">");
            }
        }
    }

    private void QOIV() {
        WildcardMatcher wildcardMatcher = new WildcardMatcher("*.*", false, 2);
        File file = new File(this.addResource + "font");
        String[] stringArray = file.list((FilenameFilter)wildcardMatcher);
        int n = 0;
        while (n < stringArray.length) {
            SchdTools.copyFile(new File(file, stringArray[n]), new File(this.add + "font", stringArray[n]));
            ++n;
        }
        String string = "*_stl.xsd" + System.getProperty("path.separator") + "*.css";
        wildcardMatcher = new WildcardMatcher(string, false, 2);
        File file2 = new File(this.addResource + "template");
        stringArray = file2.list((FilenameFilter)wildcardMatcher);
        int n2 = 0;
        while (n2 < stringArray.length) {
            SchdTools.copyFile(new File(file2, stringArray[n2]), new File(this.add + ServerEnv.getStyleFolder(), stringArray[n2]));
            ++n2;
        }
    }

    public void migrateSecurity(boolean bl) {
        try {
            this.QOIV.loadSecurityData(bl);
            if (!this.C.equalsIgnoreCase(this.addAllManager)) {
                int n = 0;
                while (n < this.B.size()) {
                    this.copySchedules((String)this.B.elementAt(n));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("!!!error when migrate security data: " + exception.getMessage());
        }
    }

    public void migrateProtections() {
        int n = 0;
        while (n < this.B.size()) {
            String string = (String)this.B.elementAt(n);
            Hashtable hashtable = this.QOIV.getProtections(string);
            ResourceTreeManagerImpl resourceTreeManagerImpl = this.I.getResourceManager(string);
            NodeTableImpl nodeTableImpl = this.I.getDataService(string).getNodeTable();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.equals("<the server>")) continue;
                int n2 = (Integer)hashtable.get(string2);
                try {
                    Node node = resourceTreeManagerImpl.getNodeByPath(string2);
                    if (node == null) continue;
                    nodeTableImpl.updateAcl(node.getID(), n2);
                }
                catch (UnknownResource unknownResource) {
                    System.out.println("!!!error when migrate protection: " + unknownResource.getMessage());
                }
            }
            ++n;
        }
    }

    public void copySchedules(String string) {
        System.out.println("start migrate schedules in realm " + string);
        System.out.print("in migrating");
        File file = new File(this.C + string);
        if (file.exists() && file.isDirectory()) {
            WildcardMatcher wildcardMatcher = new WildcardMatcher(string + ".*", false, 2);
            String[] stringArray = file.list((FilenameFilter)wildcardMatcher);
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(this.addAllManager + string, stringArray[n]);
                SchdTools.copyFile(new File(file, stringArray[n]), file2);
                if (stringArray[n].endsWith(".tsk")) {
                    this.add(file2);
                }
                System.out.print(">");
                ++n;
            }
        }
        System.out.println("\rcomplete schedule migration in realm " + string + " successfully!");
    }

    private void add(File file) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Vector<String> vector = new Vector<String>();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().length() == 0) continue;
                Properties properties = CSUtil.parseQuery(string);
                String string2 = (String)((Hashtable)properties).get("jrs.catalog");
                if (string2 != null && string2.lastIndexOf("/") >= 0) {
                    int n = string2.lastIndexOf("/");
                    String string3 = (String)((Hashtable)properties).get("jrs.report");
                    string3 = string2.substring(0, n) + "/" + string3;
                    ((Hashtable)properties).put("jrs.report", string3);
                    vector.addElement(CSUtil.makeNoHeadQuery(properties));
                    continue;
                }
                vector.addElement(string);
            }
            bufferedReader.close();
            if (vector.size() != 0) {
                int n = vector.size();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n2 = 0;
                while (n2 < n) {
                    bufferedWriter.write((String)vector.elementAt(n2));
                    bufferedWriter.write(System.getProperty("line.separator"));
                    ++n2;
                }
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void copyParamFiles() {
        File file = new File(this.addResult);
        if (file.exists() && file.isDirectory()) {
            WildcardMatcher wildcardMatcher = new WildcardMatcher("*.param", false, 2);
            String[] stringArray = file.list((FilenameFilter)wildcardMatcher);
            int n = 0;
            while (n < stringArray.length) {
                SchdTools.copyFile(new File(file, stringArray[n]), new File(this.addElement, stringArray[n]));
                ++n;
            }
        }
    }

    public void migrateResultVersions(String string, Vector vector) {
        System.out.println("start migrate result versions in realm: " + string);
        Vector<Date> vector2 = new Vector<Date>();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(((ResultVersionRecord)vector.elementAt(n)).getCreatedTime());
            ++n;
        }
        vector = APIUtil.sortAsCol(vector, vector2, true);
        ResourceTreeManagerImpl resourceTreeManagerImpl = this.I.getResourceManager(string);
        ResultVersionRecord resultVersionRecord = null;
        Node node = null;
        System.out.println("result version size: " + vector.size());
        System.out.print("in migrating");
        int n2 = 0;
        while (n2 < vector.size()) {
            block13: {
                block12: {
                    resultVersionRecord = (ResultVersionRecord)vector.elementAt(n2);
                    String string2 = resultVersionRecord.getReportFile();
                    String string3 = resultVersionRecord.getCatalogFile();
                    if (string2.indexOf("/") < 0) {
                        string2 = string3.substring(0, string3.lastIndexOf("/") + 1) + string2;
                    }
                    try {
                        node = resourceTreeManagerImpl.getNodeByPath(string2);
                    }
                    catch (UnknownResource unknownResource) {
                        Folder folder = this.addAliases(resourceTreeManagerImpl, string2.substring(0, string2.lastIndexOf("/")));
                        if (folder == null) break block12;
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("jrs.node_name", string2.substring(string2.lastIndexOf("/") + 1));
                        hashtable.put("jrs.node_type", String.valueOf(0));
                        try {
                            resourceTreeManagerImpl.addResource(folder, hashtable, new ReportInfoImpl(), "JReport_System_User");
                        }
                        catch (Exception exception) {
                            System.err.println("!!!error when add report: " + string2 + "(" + exception.getMessage() + ")");
                            break block13;
                        }
                    }
                }
                ResultInfoImpl resultInfoImpl = this.addAllManager(resultVersionRecord, resourceTreeManagerImpl);
                try {
                    Resource resource;
                    if (node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2) {
                        Version version = resourceTreeManagerImpl.addResult(resource, new Hashtable(), resultInfoImpl, "JReport_System_User");
                    }
                }
                catch (Exception exception) {
                    System.err.println("!!!error when add result version: " + exception.getMessage());
                }
                if (n2 % 400 == 0) {
                    System.out.print("\rin migrating");
                }
                if (n2 % 20 == 0) {
                    System.out.print(">");
                }
            }
            ++n2;
        }
        System.out.print("\r");
        System.out.println("complete result version migration in realm: " + string + " successfully!");
    }

    private Folder addAliases(ResourceTreeManagerImpl resourceTreeManagerImpl, String string) {
        Folder folder = null;
        Node node = null;
        try {
            node = resourceTreeManagerImpl.getNodeByPath(string);
            if (node.getNodeType() == 1) {
                folder = (Folder)node;
            }
        }
        catch (UnknownResource unknownResource) {
            Folder folder2 = this.addAliases(resourceTreeManagerImpl, string.substring(0, string.lastIndexOf("/")));
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("jrs.node_name", string.substring(string.lastIndexOf("/") + 1));
            try {
                folder = resourceTreeManagerImpl.addSubFolder(folder2, hashtable, "JReport_System_User");
            }
            catch (Exception exception) {
                System.err.println("!!!error when add folder " + string);
            }
        }
        return folder;
    }

    private ResultInfoImpl addAllManager(ResultVersionRecord resultVersionRecord, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        Object object;
        File file;
        ResultInfoImpl resultInfoImpl = new ResultInfoImpl();
        int n = -1;
        String string = resultVersionRecord.getCatalogFile();
        if (string != null && string.trim().length() != 0) {
            try {
                Node node = resourceTreeManagerImpl.getNodeByPath(string);
                if (node != null) {
                    n = node.getID();
                }
            }
            catch (UnknownResource unknownResource) {
                System.err.println(unknownResource.getMessage());
            }
        }
        resultInfoImpl.setCatalogReourceId(n);
        String string2 = resultVersionRecord.getReportFile();
        if (string2.indexOf("/") < 0) {
            string2 = string.substring(0, string.lastIndexOf("/") + 1) + string2;
        }
        int n2 = -1;
        try {
            n2 = resourceTreeManagerImpl.getNodeByPath(string2).getID();
        }
        catch (UnknownResource unknownResource) {
            System.err.println(unknownResource.getMessage());
        }
        resultInfoImpl.setReportResourceId(n2);
        resultInfoImpl.setParamFile(resultVersionRecord.getParamFile());
        JRResultFiles jRResultFiles = (JRResultFiles)resultVersionRecord.getAllResultFiles();
        String string3 = jRResultFiles.getSharedPrefix();
        int n3 = string3.lastIndexOf(File.separator);
        String string4 = string3.substring(n3 + 1);
        WildcardMatcher wildcardMatcher = new WildcardMatcher(string4 + "*.*", false, 2);
        String string5 = resourceTreeManagerImpl.getVersionService().getArchivePath("JReport_System_User");
        if (!string5.endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        if ((file = new File(this.addResult + (n3 == -1 ? "" : string3.substring(0, n3)))).exists() && file.isDirectory()) {
            object = file.list((FilenameFilter)wildcardMatcher);
            int n4 = 0;
            while (n4 < ((String[])object).length) {
                SchdTools.copyFile(new File(file, object[n4]), new File(string5, object[n4]));
                ++n4;
            }
        }
        resultInfoImpl.setResultFile(string5 + string4);
        resultInfoImpl.setName(string4);
        resultInfoImpl.setResultFormats(jRResultFiles.getResultFormats());
        object = resultVersionRecord.getExpirationTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (((Date)object).equals(resultVersionRecord.getCreatedTime())) {
            gregorianCalendar.add(1, 100);
            object = gregorianCalendar.getTime();
        } else {
            gregorianCalendar.add(1, 10);
            if (gregorianCalendar.getTime().compareTo((Date)object) > 0) {
                resultInfoImpl.setExpire(true);
            }
        }
        resultInfoImpl.setExpireationTime((Date)object);
        resultInfoImpl.setCreatedTime(resultVersionRecord.getCreatedTime().getTime());
        return resultInfoImpl;
    }

    public void migrateVersionLimit(String string, Hashtable hashtable) {
        ResourceTreeManagerImpl resourceTreeManagerImpl = this.I.getResourceManager(string);
        String string2 = null;
        Node node = null;
        System.out.println("start migrate result limited data in realm: " + string);
        System.out.print("in migrating...");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            int n = (Integer)hashtable.get(string2);
            try {
                Resource resource;
                node = resourceTreeManagerImpl.getNodeByPath(string2);
                if (node == null || node.getNodeType() != 2 || (resource = (Resource)node).getResourceType() != 2) continue;
                Resource resource2 = resource.getResult();
                if (resource2 == null) {
                    resourceTreeManagerImpl.addResult(resource, n, "JReport_System_User");
                    continue;
                }
                resourceTreeManagerImpl.setMaxVersionAmount(resource2, n);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        System.out.println("\rcomplete result limited data in realm: " + string + " successfully!");
    }

    protected void close() {
        this.I.removeAllManager();
    }

    private Properties addElement(String string) {
        String string2 = string + File.separator + "resource.alias";
        ExProperties exProperties = new ExProperties();
        if (!new File(string2).exists()) {
            return null;
        }
        try {
            exProperties.load(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return exProperties;
    }

    private String[] addResource(String string) throws Exception {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        File file = new File(string + "bin" + File.separator + "server.properties");
        ExProperties exProperties = new ExProperties();
        if (file.exists()) {
            exProperties.load(new FileInputStream(file));
            string2 = exProperties.getProperty("resource.share.properties.dir");
            string3 = exProperties.getProperty("resource.share.realm.dir");
            string4 = exProperties.getProperty("resource.share.hist.dir");
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = string + "properties";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (string3 == null || string3.trim().length() == 0) {
            string3 = string + "realm";
        }
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        if (string4 == null || string4.trim().length() == 0) {
            string4 = string + "history";
        }
        if (!string4.endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        String[] stringArray = new String[]{string2, string3, string4};
        return stringArray;
    }
}

