/*
 * Decompiled with CFR 0.152.
 */
package jet.server.trigger;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.server.api.trigger.Trigger;
import jet.server.trigger.ReferencableObj;

public class ExternTriggerImpl
extends ReferencableObj
implements Trigger,
Serializable {
    private static final long serialVersionUID = 4237006944376626377L;
    private String triggerName;
    private String triggerDesc;
    private boolean enable = true;
    private long prevFire = -1L;
    private long nextFire = -1L;
    private int hash;

    public ExternTriggerImpl(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("The trigger name can not be null.");
        }
        Pattern pattern = Pattern.compile("^[\\w_]+$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid trigger name [" + string + "]. Valid name can contains only [a-zA-Z_0-9].");
        }
        this.triggerName = string;
        this.triggerDesc = string2;
        this.hash = this.getName().hashCode();
    }

    public final String getName() {
        return this.triggerName;
    }

    public final String getDescription() {
        return this.triggerDesc;
    }

    public int getType() {
        return 2;
    }

    public final boolean isEnable() {
        return this.enable;
    }

    public final long getPrevFireTime() {
        return this.prevFire;
    }

    public final long getNextFireTime() {
        return this.nextFire;
    }

    public int hashCode() {
        return this.hash;
    }

    protected final void setEnable(boolean bl) {
        this.enable = bl;
    }

    protected final void setPrevFireTime(long l) {
        this.prevFire = l;
    }

    protected final void setNextFireTime(long l) {
        this.nextFire = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append(":").append(this.getDescription());
        return stringBuffer.toString();
    }
}

