/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import guitools.toolkit.JDebug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jet.ReportEnv;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.ResourceInfoException;
import jet.server.log.ServiceLogger;
import jet.server.resource.ResourceInfo;
import jet.server.userman.GroupImpl;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.UserDataToolkit;
import jet.server.userman.UserImpl;

public class ResourceInfoImpl
implements ResourceInfo {
    private String INFO;
    private String QOIV;

    public ResourceInfoImpl(String string) {
        this.INFO = ServerEnv.realmsPath;
        this.setRealmName(string);
    }

    public ResourceInfoImpl(String string, String string2) {
        this.INFO = string;
        this.setRealmName(string2);
    }

    public void setRealmName(String string) {
        this.QOIV = string;
    }

    public String[] getAllUsers(String string) {
        try {
            Enumeration enumeration = UserDataToolkit.authenticator.getUserNames(string);
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            String[] stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new String[0];
        }
    }

    public String[] getUsersFromGroup(String string, String string2) {
        SharedPasswordRealm sharedPasswordRealm = null;
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        try {
            sharedPasswordRealm = (SharedPasswordRealm)Realm.get(string);
            if (sharedPasswordRealm == null) {
                return null;
            }
            GroupImpl groupImpl = (GroupImpl)sharedPasswordRealm.getGroup(string2);
            Enumeration enumeration = sharedPasswordRealm.getUserNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                try {
                    UserImpl userImpl = (UserImpl)sharedPasswordRealm.getUser(string3);
                    if (!groupImpl.isMember(userImpl)) continue;
                    vector.addElement(string3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException);
                }
            }
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError(badRealmException);
        }
        return stringArray;
    }

    public String[] getGroups(String string, String string2) {
        SharedPasswordRealm sharedPasswordRealm = null;
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        try {
            sharedPasswordRealm = (SharedPasswordRealm)Realm.get(string);
            if (sharedPasswordRealm == null) {
                return null;
            }
            Enumeration enumeration = sharedPasswordRealm.getGroupNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                try {
                    GroupImpl groupImpl = (GroupImpl)sharedPasswordRealm.getGroup(string3);
                    UserImpl userImpl = (UserImpl)sharedPasswordRealm.getUser(string2);
                    if (!groupImpl.isMember(userImpl)) continue;
                    vector.addElement(string3);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError(noSuchGroupException);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException);
                }
            }
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError(badRealmException);
        }
        return stringArray;
    }

    public String getDefaultUserName(String string) {
        return "<Default>";
    }

    public void saveAlias(ExProperties exProperties, ExProperties exProperties2, String string, String string2) throws ResourceInfoException {
        try {
            if (string2.equals(this.getDefaultUserName(string))) {
                String string3 = this.INFO + string + File.separator;
                File file = new File(string3);
                if (!file.exists()) {
                    file.mkdirs();
                }
                exProperties.save(string3 + "alias_table_default.properties", null);
                exProperties2.save(string3 + "alias_prop_default.properties", null);
            } else {
                String string4 = this.INFO + string + File.separator + string2 + File.separator;
                File file = new File(string4);
                if (!file.exists()) {
                    file.mkdirs();
                }
                exProperties.save(string4 + "alias_table.properties", null);
                exProperties2.save(string4 + "alias_prop.properties", null);
            }
        }
        catch (IOException iOException) {
            ServiceLogger.logError("Cannot save alias table of user " + string2 + " in realm " + string);
            JDebug.INFO((String)("Cannot save alias table of user " + string2 + " in realm " + string));
        }
    }

    public void saveAliasForGroup(ExProperties exProperties, ExProperties exProperties2, String string, String string2) throws ResourceInfoException {
        try {
            String string3 = this.INFO + string + File.separator + string2 + File.separator;
            File file = new File(string3);
            if (!file.exists()) {
                file.mkdirs();
            }
            exProperties.save(string3 + "alias_table.properties", null);
            exProperties2.save(string3 + "alias_prop.properties", null);
        }
        catch (IOException iOException) {
            ServiceLogger.logError("Cannot save alias table of group " + string2 + " in realm " + string);
            JDebug.INFO((String)("Cannot save alias table of group " + string2 + " in realm " + string));
        }
    }

    public ExProperties getAliasTable(String string, String string2) throws NoSuchUserException {
        ExProperties exProperties = new ExProperties();
        try {
            String string3 = this.INFO + string + File.separator + string2 + File.separator + "alias_table.properties";
            exProperties.load(string3);
        }
        catch (IOException iOException) {
            JDebug.INFO((String)("Cannot get alias table of user " + string2 + " in realm " + string));
        }
        return exProperties;
    }

    public ExProperties getAliasTableForGroup(String string, String string2) throws NoSuchGroupException {
        ExProperties exProperties = new ExProperties();
        try {
            String string3 = this.INFO + string + File.separator + string2 + File.separator + "alias_table.properties";
            exProperties.load(string3);
        }
        catch (IOException iOException) {
            JDebug.INFO((String)("Cannot get alias table of group " + string2 + " in realm " + string));
        }
        return exProperties;
    }

    public ExProperties getAliasPropValue(String string, String string2) throws NoSuchUserException {
        ExProperties exProperties = new ExProperties();
        try {
            String string3 = this.INFO + string + File.separator + string2 + File.separator + "alias_prop.properties";
            exProperties.load(string3);
        }
        catch (IOException iOException) {
            JDebug.INFO((String)("Cannot get alias properties of user " + string2 + " in realm " + string));
        }
        return exProperties;
    }

    public ExProperties getAliasPropValueForGroup(String string, String string2) throws NoSuchGroupException {
        ExProperties exProperties = new ExProperties();
        try {
            String string3 = this.INFO + string + File.separator + string2 + File.separator + "alias_prop.properties";
            exProperties.load(string3);
        }
        catch (IOException iOException) {
            JDebug.INFO((String)("Cannot get alias properties of user " + string2 + " in realm " + string));
        }
        return exProperties;
    }

    public ExProperties getDefaultAliasPropValue(String string) {
        ExProperties exProperties = new ExProperties();
        try {
            String string2 = this.INFO + string + File.separator + "alias_prop_default.properties";
            exProperties.load(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exProperties;
    }

    public ExProperties getDefaultAliasTab(String string) {
        String string2 = this.INFO + string + File.separator;
        String string3 = string2 + "alias_table_default.properties";
        ExProperties exProperties = new ExProperties();
        try {
            exProperties.load(string3);
        }
        catch (IOException iOException) {
            exProperties.setProperty("/", "/");
            JDebug.INFO((String)"Getting default alias table failed!");
            try {
                File file = new File(string2);
                if (!file.exists()) {
                    file.mkdirs();
                }
                exProperties.save(string3, null);
            }
            catch (IOException iOException2) {
                ServiceLogger.logError("Cannot save default alias table.");
                JDebug.INFO((String)"Cannot save default alias table.");
            }
        }
        return exProperties;
    }

    public ExProperties getRscProperties(String string) {
        String string2 = this.INFO + string + File.separator;
        String string3 = "resource.properties";
        ExProperties exProperties = new ExProperties();
        try {
            exProperties.load(string2 + string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JDebug.INFO((String)fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            JDebug.INFO((String)iOException.getMessage());
        }
        return exProperties;
    }

    public ExProperties getResource(String string) {
        String string2 = this.INFO + string + File.separator;
        String string3 = "resource.alias";
        ExProperties exProperties = new ExProperties();
        try {
            exProperties.load(string2 + string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.INFO(string2, string3, exProperties);
        }
        catch (IOException iOException) {
            this.INFO(string2, string3, exProperties);
        }
        if (ServerEnv.getResourceRoot() != null) {
            exProperties.setProperty("/", ServerEnv.getResourceRoot());
        }
        return exProperties;
    }

    public void saveResource(String string, ExProperties exProperties, ExProperties exProperties2) throws ResourceInfoException {
        String string2 = this.INFO + string + File.separator;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string3 = string2 + "resource.alias";
        String string4 = string2 + "resource.properties";
        try {
            exProperties.save(string3, null);
            exProperties2.save(string4, null);
        }
        catch (IOException iOException) {
            throw new ResourceInfoException(iOException.getMessage());
        }
    }

    private void INFO(String string, String string2, ExProperties exProperties) {
        String string3 = ReportEnv.homePath;
        string3 = string3.endsWith(File.separator) ? string3 : string3 + File.separator;
        exProperties.setProperty("/", string3 + "jreports");
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            exProperties.save(string + string2, null);
        }
        catch (IOException iOException) {
            ServiceLogger.logError("Cannot save default resources." + iOException.getMessage());
            JDebug.INFO((String)("Cannot save default resources." + iOException.getMessage()));
        }
    }

    public String getTempPath() {
        return ServerEnv.temporaryPath;
    }
}

