/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import java.io.File;
import java.io.IOException;
import java.security.acl.NotOwnerException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.EncodeExProperties;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.UserMailList;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.log.ServiceLogger;
import jet.server.resource.RptResourceManager;
import jet.server.userman.AclEntryImpl;
import jet.server.userman.AclImpl;
import jet.server.userman.GroupImpl;
import jet.server.userman.PermissionImpl;
import jet.server.userman.Permissions;
import jet.server.userman.Realm;
import jet.server.userman.Resource;
import jet.server.userman.ResourceProtector;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.UserAuthenticator;
import jet.server.userman.UserImpl;
import jet.server.userman.WorldGroupImpl;
import jet.universe.ConvertCat;

public class UserDataToolkit {
    public static final String admin = "admin";
    public static final String guest = "guest";
    public static final String adminGroup = "administrators";
    public static final String worldGroup = "everyone";
    public static final String adminAcl = "adminAcl";
    public static final String rootAcl = "rootAcl";
    public static final String defaultRealm = "defaultRealm";
    public static final String USER_FOLDER_PROP_FILENAME = "folder.properties";
    public static final String PROP_MY = "my";
    public static final String PROP_PUBLIC = "public";
    public static Hashtable htManager = new Hashtable();
    public static UserAuthenticator authenticator = null;
    public static UserMailList mailList = null;
    private static Vector QOIV = new Vector(8);

    public static void setMailList(UserMailList userMailList) {
        mailList = userMailList;
    }

    public static UserMailList getMailList() {
        UserMailList userMailList;
        if (authenticator != null && (userMailList = authenticator.getMailList()) != null) {
            return userMailList;
        }
        return mailList;
    }

    public static boolean isValidName(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void addManager(String string) {
        if (htManager.get(string) == null) {
            ResourceProtector resourceProtector = new ResourceProtector(string);
            RptResourceManager rptResourceManager = null;
            rptResourceManager = new RptResourceManager(resourceProtector.getResourceInfo(), ServerEnv.needSecurity(), ServerEnv.getMimeTypeTable(), string, resourceProtector);
            htManager.put(string, rptResourceManager);
        }
    }

    public static void removeManager(String string) {
        htManager.remove(string);
    }

    public static void removeAllManager() {
        htManager = new Hashtable();
    }

    public static RptResourceManager getManager(String string) {
        return (RptResourceManager)htManager.get(string);
    }

    public static Enumeration getRealmNames() {
        return Realm.list().elements();
    }

    public static void saveRealmProperties(ExProperties exProperties, String string) throws IOException {
        String string2 = ServerEnv.realmsPath + string + File.separator;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        exProperties.save(string2 + "realm.properties", "");
    }

    public static void loadRealmProperties(ExProperties exProperties, String string) throws IOException {
        if (exProperties == null || string == null || string.length() == 0) {
            return;
        }
        String string2 = ServerEnv.realmsPath + string + File.separator + "realm.properties";
        File file = new File(string2);
        if (!file.exists()) {
            return;
        }
        exProperties.load(file);
    }

    public static EncodeExProperties loadRealmProperties(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return null;
        }
        EncodeExProperties encodeExProperties = new EncodeExProperties();
        UserDataToolkit.loadRealmProperties(encodeExProperties, string);
        return encodeExProperties;
    }

    public static void deleteRealmData(String string) {
        if (string.equals("")) {
            return;
        }
        String string2 = ServerEnv.realmsPath + string + File.separator;
        UserDataToolkit.deleteFile(string2);
    }

    public static void saveGroupProperties(GroupImpl groupImpl) throws IOException {
        if (groupImpl.getLdapFlag()) {
            return;
        }
        String string = groupImpl.getRealmName();
        String string2 = groupImpl.getName();
        UserDataToolkit.saveGroupProperties(groupImpl.getProperties(), string, string2);
    }

    public static void saveGroupProperties(ExProperties exProperties, String string, String string2) throws IOException {
        String string3 = ServerEnv.realmsPath + string + File.separator;
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        exProperties.save(string3 + string2 + ".grp", "");
    }

    public static void deleteGroupData(String string, String string2) {
        String string3 = ServerEnv.realmsPath + string + File.separator + string2 + ".grp";
        UserDataToolkit.deleteFile(string3);
    }

    public static void saveAclProperties(AclImpl aclImpl) throws IOException {
        String string = aclImpl.getRealmName();
        String string2 = aclImpl.getName();
        UserDataToolkit.saveAclProperties(aclImpl.getProperties(), string, string2);
    }

    public static void saveAclProperties(ExProperties exProperties, String string, String string2) throws IOException {
        String string3 = ServerEnv.realmsPath + string + File.separator;
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        exProperties.save(string3 + string2 + ".acl", "");
    }

    public static void saveResourceProperties(SharedPasswordRealm sharedPasswordRealm) throws IOException, BadRealmException {
        UserDataToolkit.saveResourceProperties(sharedPasswordRealm.getResourceProperties(), sharedPasswordRealm.getName());
    }

    public static void saveResourceProperties(ExProperties exProperties, String string) throws IOException {
        String string2 = ServerEnv.realmsPath + string + File.separator;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        exProperties.save(string2 + "protection.properties", "");
    }

    public static void deleteAclData(String string, String string2) {
        String string3 = ServerEnv.realmsPath + string + File.separator + string2 + ".acl";
        UserDataToolkit.deleteFile(string3);
    }

    public static void saveUserProperties(UserImpl userImpl) throws IOException {
        if (userImpl.getLdapFlag()) {
            return;
        }
        String string = userImpl.getRealmName();
        String string2 = userImpl.getName();
        UserDataToolkit.saveUserProperties(userImpl.getProperties(), string, string2);
    }

    public static ExProperties checkUserFolderProperties(String string, String string2) throws IOException {
        String string3 = string2.toLowerCase();
        String string4 = ServerEnv.realmsPath + string + File.separator + string3 + File.separator;
        ExProperties exProperties = new ExProperties();
        String string5 = string4 + USER_FOLDER_PROP_FILENAME;
        File file = new File(string5);
        if (!file.exists()) {
            UserDataToolkit.saveUserFolderProperties(UserDataToolkit.getDefaultUserFolderProperties(exProperties, string, string3), string, string3);
        } else {
            exProperties.load(string4 + USER_FOLDER_PROP_FILENAME);
        }
        return exProperties;
    }

    public static ExProperties getDefaultUserFolderProperties(ExProperties exProperties, String string, String string2) throws IOException {
        String string3 = string2.toLowerCase();
        String string4 = ServerEnv.realmsPath + string + File.separator + string3 + File.separator;
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string5 = ServerEnv.getDefaultPublicCatalog();
        String string6 = string4 + PROP_MY;
        ExProperties exProperties2 = exProperties == null ? new ExProperties() : exProperties;
        exProperties2.setProperty(PROP_PUBLIC, string5);
        exProperties2.setProperty(PROP_MY, string6);
        return exProperties2;
    }

    public static void saveUserFolderProperties(ExProperties exProperties, String string, String string2) throws IOException {
        String string3 = string2.toLowerCase();
        String string4 = ServerEnv.realmsPath + string + File.separator + string3 + File.separator;
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        ExProperties exProperties2 = exProperties;
        String string5 = exProperties2.getProperty(PROP_PUBLIC, ServerEnv.getDefaultPublicCatalog());
        String string6 = exProperties2.getProperty(PROP_MY, string4 + PROP_MY);
        exProperties2.save(string4 + USER_FOLDER_PROP_FILENAME, "User Resource");
        File file2 = new File(string6);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        try {
            String string7 = UserDataToolkit.getManager(string).getRealPath(string2, string5);
            if (string7 == null) {
                ServiceLogger.logError("Cannot find realpath of the public catalog \"" + string5 + "\" when saving " + USER_FOLDER_PROP_FILENAME + " for the user \"" + string2 + "\"!");
            }
            string7 = CSUtil.getStdName(string7);
            File file3 = new File(string7);
            String string8 = string6 + File.separator + file3.getName();
            if (!new File(string8).exists()) {
                new ConvertCat(string7, string8).convert();
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    public static void saveUserProperties(ExProperties exProperties, String string, String string2) throws IOException {
        String string3 = string2.toLowerCase();
        String string4 = ServerEnv.realmsPath + string + File.separator + string3 + File.separator;
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        exProperties.save(string4 + "account.properties", "");
        UserDataToolkit.saveUserFolderProperties(UserDataToolkit.getDefaultUserFolderProperties(new ExProperties(), string, string2), string, string2);
    }

    public static void loadUserProperties(ExProperties exProperties, String string, String string2) throws IOException {
        if (exProperties == null || string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return;
        }
        String string3 = ServerEnv.realmsPath + string + File.separator + string2.toLowerCase() + File.separator + "account.properties";
        File file = new File(string3);
        if (!file.exists()) {
            return;
        }
        exProperties.load(file);
    }

    public static EncodeExProperties loadUserProperties(String string, String string2) throws IOException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return null;
        }
        EncodeExProperties encodeExProperties = new EncodeExProperties();
        UserDataToolkit.loadUserProperties(encodeExProperties, string, string2);
        return encodeExProperties;
    }

    public static void deleteUserData(UserImpl userImpl) {
        String string = userImpl.getRealmName();
        String string2 = userImpl.getName();
        String string3 = ServerEnv.realmsPath + string + File.separator + string2 + File.separator;
        UserDataToolkit.deleteFile(string3);
    }

    public static void deleteFile(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray;
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            if ((stringArray = file.list()) != null && stringArray.length > 0) {
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = new File(string + stringArray[n]);
                    if (file2.isDirectory()) {
                        UserDataToolkit.deleteFile(file2.getPath());
                    } else {
                        file2.delete();
                    }
                    ++n;
                }
            }
        }
        file.delete();
    }

    public static void initUserData() {
        try {
            Realm.clearAll();
            SharedPasswordRealm sharedPasswordRealm = new SharedPasswordRealm(defaultRealm);
            Realm.add(sharedPasswordRealm);
            UserDataToolkit.initRealm(sharedPasswordRealm);
            sharedPasswordRealm.save();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            exception.printStackTrace(System.err);
        }
    }

    public static void initRealm(SharedPasswordRealm sharedPasswordRealm) throws NoSuchRealmException, BadRealmException, NoSuchAclException, NotOwnerException, NoSuchUserException, InUseException {
        PermissionImpl permissionImpl;
        Enumeration enumeration;
        AclEntryImpl aclEntryImpl;
        Object object;
        if (!sharedPasswordRealm.isUserExist(admin)) {
            sharedPasswordRealm.createUser(admin, admin);
            object = (UserImpl)sharedPasswordRealm.getUser(admin);
            ((UserImpl)object).setAdministrator();
        }
        if (!sharedPasswordRealm.isUserExist(guest)) {
            sharedPasswordRealm.createUser(guest, "");
        }
        if (!sharedPasswordRealm.isGroupExist(adminGroup)) {
            object = (GroupImpl)sharedPasswordRealm.makeGroup(adminGroup);
            ((GroupImpl)object).addMember((UserImpl)sharedPasswordRealm.getUser(admin));
        }
        if (!sharedPasswordRealm.isGroupExist(worldGroup)) {
            object = (WorldGroupImpl)sharedPasswordRealm.makeGroup(worldGroup);
        }
        if (!sharedPasswordRealm.isAclExist(rootAcl)) {
            object = (AclImpl)sharedPasswordRealm.makeAcl(rootAcl, sharedPasswordRealm.getUser(admin));
            aclEntryImpl = new AclEntryImpl(worldGroup);
            aclEntryImpl.setRealmName(defaultRealm);
            enumeration = Permissions.elements();
            while (enumeration.hasMoreElements()) {
                permissionImpl = (PermissionImpl)enumeration.nextElement();
                String string = permissionImpl.getName();
                if (QOIV.contains(permissionImpl.getName()) || string.equalsIgnoreCase("Set Version Amount")) continue;
                aclEntryImpl.addPermission(permissionImpl);
            }
            ((AclImpl)object).addEntry(sharedPasswordRealm.getUser(admin), aclEntryImpl);
        }
        if (!sharedPasswordRealm.isResourceExist("/")) {
            sharedPasswordRealm.makeResource("/", 0);
        }
        sharedPasswordRealm.getResource("/").setAcl((AclImpl)sharedPasswordRealm.getAcl(rootAcl));
        if (!sharedPasswordRealm.isAclExist(adminAcl)) {
            object = (AclImpl)sharedPasswordRealm.makeAcl(adminAcl, sharedPasswordRealm.getUser(admin));
            aclEntryImpl = new AclEntryImpl(worldGroup);
            aclEntryImpl.setRealmName(defaultRealm);
            enumeration = Permissions.elements();
            while (enumeration.hasMoreElements()) {
                permissionImpl = (PermissionImpl)enumeration.nextElement();
                if (!QOIV.contains(permissionImpl.getName())) continue;
                aclEntryImpl.addPermission(permissionImpl);
            }
            ((AclImpl)object).addEntry(sharedPasswordRealm.getUser(admin), aclEntryImpl);
            aclEntryImpl = new AclEntryImpl(guest);
            aclEntryImpl.setNegativePermissions();
            aclEntryImpl.setRealmName(defaultRealm);
            aclEntryImpl.addPermission(Permissions.getPermission("Delete Schedule"));
            aclEntryImpl.addPermission(Permissions.getPermission("Delete Version"));
            ((AclImpl)object).addEntry(sharedPasswordRealm.getUser(admin), aclEntryImpl);
        }
        if (!sharedPasswordRealm.isResourceExist("<the server>")) {
            sharedPasswordRealm.makeResource("<the server>", 0);
        }
        sharedPasswordRealm.getResource("<the server>").setAcl((AclImpl)sharedPasswordRealm.getAcl(adminAcl));
    }

    public static void compatibleChack(SharedPasswordRealm sharedPasswordRealm) {
        try {
            Object object;
            UserDataToolkit.initRealm(sharedPasswordRealm);
            Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = sharedPasswordRealm.getResources();
            while (enumeration.hasMoreElements()) {
                Resource resource = (Resource)enumeration.nextElement();
                object = resource.getName();
                if (((String)object).endsWith("/*") || ((String)object).endsWith("/-")) {
                    vector.addElement(object);
                    object = ((String)object).substring(0, ((String)object).length() - 2);
                }
                if (((String)object).length() == 0) {
                    object = "/";
                }
                if (sharedPasswordRealm.isResourceExist((String)object) || hashtable.containsKey(object)) continue;
                hashtable.put(object, resource.getAclName());
            }
            int n = 0;
            while (n < vector.size()) {
                sharedPasswordRealm.deleteResource((String)vector.elementAt(n));
                ++n;
            }
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = (String)hashtable.get(string);
                sharedPasswordRealm.makeResource(string, 0);
                sharedPasswordRealm.getResource(string).setAcl(string2);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    static {
        QOIV.addElement("POST Schedule");
        QOIV.addElement("Delete Schedule");
        QOIV.addElement("Enable Schedule");
        QOIV.addElement("Disable Schedule");
        QOIV.addElement("Stop Schedule");
        QOIV.addElement("POST Fonts");
        QOIV.addElement("Export Schedule To Script File");
        QOIV.addElement("Import Schedule From Script File");
    }
}

