/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman.ldap;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import jet.server.intf.security.Role;
import jet.server.log.ServiceLogger;
import jet.server.userman.User;
import jet.server.userman.UserImpl;
import jet.server.userman.ldap.LdapConnection;
import jet.server.userman.ldap.LdapEnvironments;
import jet.server.userman.ldap.LdapToolkit;
import jet.server.userman.ldap.LdapUser;

public class LdapGroup {
    private static Attributes QOIV = null;
    public static String groupCN = "";
    public static String groupMemberType = "";
    public static String groupDN = "";
    public static String groupFilter = "";

    public LdapGroup() {
        groupCN = LdapEnvironments.getProperty("ldaprealm.scheme.group.common_name");
        groupMemberType = LdapEnvironments.getProperty("ldaprealm.scheme.group.member_type");
        groupDN = this.getDN();
        groupFilter = LdapEnvironments.getProperty("ldaprealm.scheme.group.search_filter");
    }

    public String getDN() {
        String string;
        int n;
        String string2 = LdapEnvironments.getProperty("ldaprealm.root");
        String string3 = LdapEnvironments.getProperty("ldaprealm.scheme.group.distinguish_name");
        if (string3 != null && string3.trim().length() > 0 && (n = string3.indexOf("dc")) != -1 && (string = string3.substring(n)).equalsIgnoreCase(string2)) {
            string3 = string3.substring(0, n - 1);
        }
        return string3;
    }

    public void setAttributes(Attributes attributes) {
        QOIV = attributes;
    }

    public boolean hasMembers() {
        try {
            Attribute attribute = QOIV.get(groupMemberType);
            if (attribute != null) {
                attribute.getAll();
            }
        }
        catch (NamingException namingException) {
            return false;
        }
        return true;
    }

    public Vector[] getMembers() {
        Vector[] vectorArray;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        LdapUser ldapUser = new LdapUser();
        String string = "";
        String string2 = "";
        try {
            vectorArray = QOIV.get(groupMemberType);
            if (vectorArray != null) {
                NamingEnumeration<?> namingEnumeration = vectorArray.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    string2 = (String)namingEnumeration.nextElement();
                    if (string2.toUpperCase().indexOf(LdapUser.userDN.toUpperCase()) != -1) {
                        string = this.QOIV(string2, false);
                        if (string == null) continue;
                        string = string.trim();
                        vector.addElement(string);
                        continue;
                    }
                    if (string2.toUpperCase().indexOf(groupDN.toUpperCase()) == -1 || (string = this.QOIV(string2, true)) == null) continue;
                    string = string.trim();
                    vector2.addElement(string);
                }
            }
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
        }
        vectorArray = new Vector[]{vector, vector2};
        return vectorArray;
    }

    public boolean isMember(Principal principal) {
        Vector[] vectorArray = this.getMembers();
        if (!(principal instanceof Role)) {
            Enumeration enumeration = vectorArray[0].elements();
            while (enumeration.hasMoreElements()) {
                Principal principal2 = (Principal)enumeration.nextElement();
                if (!principal2.getName().equals(principal.getName())) continue;
                return true;
            }
            return false;
        }
        Enumeration enumeration = vectorArray[1].elements();
        while (enumeration.hasMoreElements()) {
            Principal principal3 = (Principal)enumeration.nextElement();
            if (!principal3.getName().equals(principal.getName())) continue;
            return true;
        }
        return false;
    }

    private String QOIV(String string, boolean bl) {
        String string2 = null;
        LdapToolkit.getConnection();
        LdapContext ldapContext = LdapConnection.getLdapContext();
        LdapEnvironments ldapEnvironments = LdapToolkit.getEnvironments();
        String string3 = LdapEnvironments.getProperty("ldaprealm.url") + ":" + LdapEnvironments.getProperty("ldaprealm.port") + "/";
        try {
            Attributes attributes = ldapContext.getAttributes(string3 + string);
            string2 = !bl ? (String)attributes.get(LdapUser.userID).get(0) : (String)attributes.get(groupCN).get(0);
            return string2.trim();
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public Enumeration getMemberNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            User user;
            Object e = enumeration.nextElement();
            if (e instanceof UserImpl) {
                user = (User)enumeration.nextElement();
                vector.addElement(user.getName().trim());
                continue;
            }
            user = (Group)enumeration.nextElement();
            vector.addElement(user.getName().trim());
        }
        return vector.elements();
    }

    public int getMemberCount() {
        return QOIV.get(groupMemberType).size();
    }

    public String getName() {
        String string = "";
        try {
            string = (String)QOIV.get(groupCN).get();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
        }
        return string.trim();
    }

    public String getDescription() {
        String string = "";
        try {
            if (QOIV.get("Description") != null) {
                string = (String)QOIV.get("Description").get();
            }
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
        }
        return string;
    }
}

