/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.cs.CSUtil;
import jet.export.mail.mail;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.server.api.RptServerException;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;
import jet.universe.JetUDatabase;
import jet.universe.JetUUniverse;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.UniverseFileException;
import jet.util.Base64Ex;
import server.servlet.http.HttpDate;

public final class ServerUtil {
    public static void sendNormalMail(String string, String string2, String string3, String string4, String string5, Vector vector) throws Exception {
        mail mail2 = new mail(null, null, CSUtil.getUrlEncoding());
        mail2.send(string, string2, string3, string4, string5, false, -1, vector);
    }

    public static String decode(String string) {
        byte[] byArray;
        String string2 = System.getProperty("file.encoding");
        try {
            byArray = Base64Ex.decode(string.getBytes(string2));
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
            return string;
        }
        String string3 = new String(byArray);
        return string3;
    }

    public static String encode(String string) {
        byte[] byArray = new byte[]{};
        String string2 = System.getProperty("file.encoding");
        try {
            byArray = Base64Ex.encode(string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ServiceLogger.logError(unsupportedEncodingException);
            return string;
        }
        String string3 = new String(byArray);
        return string3;
    }

    public static boolean isFileNotModified(File file, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            if (file.exists()) {
                String string = httpServletRequest.getHeader("If-Modified-Since");
                if (string != null) {
                    HttpDate httpDate = new HttpDate();
                    httpDate.parse(string);
                    if (file.lastModified() / 1000L * 1000L <= httpDate.getTime()) {
                        httpServletResponse.setStatus(304);
                        return true;
                    }
                }
                httpServletResponse.setHeader("Last-Modified", new HttpDate(file.lastModified()).toString());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return false;
    }

    public static int getBrowserType(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("User-Agent");
        if (string.lastIndexOf("MSIE") != -1) {
            return 0;
        }
        if (string.lastIndexOf("Netscape") != -1) {
            return 1;
        }
        if (string.lastIndexOf("Firefox") != -1) {
            return 2;
        }
        if (string.lastIndexOf("Mozilla") != -1) {
            return 3;
        }
        return -1;
    }

    public static PrintWriter getResponseWriter(HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter;
        try {
            printWriter = httpServletResponse.getWriter();
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            printWriter = new PrintWriter((OutputStream)servletOutputStream);
        }
        return printWriter;
    }

    public static String getZipFilePath(String string) {
        String string2 = null;
        class Probe {
            Probe() {
            }
        }
        ClassLoader classLoader = new Probe().getClass().getClassLoader();
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            if (uRL instanceof URL) {
                URL uRL2 = uRL;
                string2 = StringUtil.URLDecode(uRL2.getPath());
                String string3 = uRL2.getProtocol();
                if (string3.equalsIgnoreCase("jar") || string3.equalsIgnoreCase("wsjar") || string3.equalsIgnoreCase("zip") || string3.equalsIgnoreCase("war") || string3.equalsIgnoreCase("ear")) {
                    if (string2.startsWith("file:")) {
                        string2 = string2.charAt(7) == ':' ? string2.substring(6) : string2.substring(5);
                    }
                    if ((string2 = string2.substring(0, string2.indexOf(33))).length() >= 3 && string2.charAt(0) == '/' && string2.charAt(2) == ':') {
                        string2 = string2.substring(1);
                    }
                    string2 = string2.replace('/', File.separatorChar);
                } else if (string3.equalsIgnoreCase("jndi")) {
                    int n = string2.lastIndexOf(string);
                    string2 = string2.substring(0, n - 1);
                }
            }
            if (string2 != null) break;
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private static int[] C(int[] var0, int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = var2_2;
            if (var2_2 <= var1_1) break block5;
            var5_5 = var0[(var1_1 + var2_2) / 2];
            ** GOTO lbl18
            {
                ++var3_3;
                do {
                    if (var3_3 < var2_2 && var0[var3_3] < var5_5) continue block0;
                    while (var4_4 > var1_1 && var0[var4_4] > var5_5) {
                        --var4_4;
                    }
                    if (var3_3 > var4_4) continue;
                    var6_6 = var0[var3_3];
                    var0[var3_3] = var0[var4_4];
                    var0[var4_4] = var6_6;
                    ++var3_3;
                    --var4_4;
lbl18:
                    // 3 sources

                } while (var3_3 <= var4_4);
            }
            if (var1_1 < var4_4) {
                ServerUtil.C(var0, var1_1, var4_4);
            }
            if (var3_3 < var2_2) {
                ServerUtil.C(var0, var3_3, var2_2);
            }
        }
        return var0;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] LoadUniverse(String[] var0, int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = var2_2;
            if (var2_2 <= var1_1) break block5;
            var5_5 = var0[(var1_1 + var2_2) / 2];
            ** GOTO lbl18
            {
                ++var3_3;
                do {
                    if (var0[var3_3].compareTo(var5_5) < 0 && var3_3 < var2_2) continue block0;
                    while (var0[var4_4].compareTo(var5_5) > 0 && var4_4 > var1_1) {
                        --var4_4;
                    }
                    if (var3_3 > var4_4) continue;
                    var6_6 = var0[var3_3];
                    var0[var3_3] = var0[var4_4];
                    var0[var4_4] = var6_6;
                    ++var3_3;
                    --var4_4;
lbl18:
                    // 3 sources

                } while (var3_3 <= var4_4);
            }
            if (var1_1 < var4_4) {
                ServerUtil.LoadUniverse(var0, var1_1, var4_4);
            }
            if (var3_3 < var2_2) {
                ServerUtil.LoadUniverse(var0, var3_3, var2_2);
            }
        }
        return var0;
    }

    public static String[] sortStringAarry(String[] stringArray) {
        return ServerUtil.LoadUniverse(stringArray, 0, stringArray.length - 1);
    }

    public static int[] sortIntegerArray(int[] nArray) {
        return ServerUtil.C(nArray, 0, nArray.length - 1);
    }

    public static String reflectClasspath(ClassLoader classLoader, String string) {
        ClassLoader classLoader2 = null;
        class Probe {
            Probe() {
            }
        }
        classLoader2 = classLoader == null ? new Probe().getClass().getClassLoader() : classLoader;
        String string2 = null;
        try {
            Enumeration<URL> enumeration = classLoader2.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                if (uRL instanceof URL) {
                    URL uRL2 = uRL;
                    String string3 = StringUtil.URLDecode(uRL2.getPath());
                    String string4 = uRL2.getProtocol();
                    if (string4.equalsIgnoreCase("jar") || string4.equalsIgnoreCase("wsjar") || string4.equalsIgnoreCase("zip") || string4.equalsIgnoreCase("war") || string4.equalsIgnoreCase("ear")) {
                        if (string3.startsWith("file:")) {
                            string3 = string3.charAt(7) == ':' ? string3.substring(6) : string3.substring(5);
                        }
                        if ((string3 = string3.substring(0, string3.indexOf(33))).length() >= 3 && string3.charAt(0) == '/' && string3.charAt(2) == ':') {
                            string3 = string3.substring(1);
                        }
                        string3 = string3.replace('/', File.separatorChar);
                        string2 = "jar:" + string3;
                    } else if (string4.equalsIgnoreCase("jndi")) {
                        string3 = string3.substring(0, string3.lastIndexOf(string) - 1);
                        string3 = string3.replace('/', File.separatorChar);
                        string2 = "jar:" + string3;
                    } else {
                        if ((string3 = string3.substring(0, string3.length() - string.length())).startsWith("file:")) {
                            string3 = string3.substring("file:".length());
                        }
                        if (string3.length() >= 3 && string3.charAt(0) == '/' && string3.charAt(2) == ':') {
                            string3 = string3.substring(1);
                        }
                        string2 = "file:" + string3;
                    }
                }
                if (string2 == null) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    public static String escapeHTML(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isValidFileName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c) && c != '_' && c != '-' && c != '.' && c != '(' && c != ')' && c != '[' && c != ']' && c != '$') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static List getSizeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 7;
        while (n < 73) {
            arrayList.add(String.valueOf(n));
            ++n;
        }
        return arrayList;
    }

    public static List getFaceList() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        return arrayList;
    }

    public static boolean needCompileFml(String string, String string2) throws ReadFailureException, UniverseFileException {
        boolean bl = false;
        JetUUniverse jetUUniverse = JetUUniverse.LoadUniverse((String)(string + string2));
        if (jetUUniverse.isNeedUpdateFmlFile()) {
            return true;
        }
        Vector vector = jetUUniverse.getAllDatabases();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            JetUDatabase jetUDatabase = (JetUDatabase)iterator.next();
            String string3 = jetUDatabase.getResourceName();
            File file = jetUUniverse.getFMLFile(string3);
            if (file.exists()) {
                if (jetUUniverse.isFMLFileMatch(file, string3) && !jetUDatabase.isNeedGenerateJava()) continue;
                bl = true;
                break;
            }
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean saveCatFml(String string, String string2) throws ReadFailureException, UniverseFileException, WriteFailureException, FMLFileException {
        boolean bl = false;
        JetUUniverse jetUUniverse = JetUUniverse.LoadUniverse((String)(string + string2));
        bl = jetUUniverse.Save(string, string2);
        return bl;
    }

    public static String getLocaleName(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
    }

    public static Locale getLocale(String string) {
        Locale locale = null;
        String string2 = string;
        String string3 = "";
        String string4 = "";
        if (string != null) {
            String[] stringArray = string.split("_", 4);
            string2 = stringArray[0];
            string3 = stringArray.length > 1 ? stringArray[1] : "";
            string4 = stringArray.length > 2 ? stringArray[2] : "";
        }
        locale = new Locale(string2, string3, string4);
        return locale;
    }

    public static Locale getLocale(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return ServerUtil.getLocale(string);
        }
        if (string != null) {
            return new Locale(string, string2);
        }
        return null;
    }

    public static String filterLogSecretInfo(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("jrs\\.db_user=[^&\\W]*", "jrs.db_user=***");
        string = string.replaceAll("jrs\\.db_pswd=[^&\\W]*", "jrs.db_pswd=***");
        return string;
    }

    public static boolean isOOMECause(Throwable throwable) {
        while (throwable != null) {
            List list;
            if (throwable instanceof OutOfMemoryError) {
                return true;
            }
            if (throwable instanceof RptServerException && (list = ((RptServerException)throwable).getEngineErrors()) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Throwable) || !ServerUtil.isOOMECause((Throwable)e)) continue;
                    return true;
                }
            }
            throwable = throwable.getCause();
        }
        return false;
    }
}

