/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.util.ThreadQueueElement;

public class ThreadQueueController {
    private int QOIV = 1;
    private Object add = new Object();
    private List clone;
    private List contains;
    private int continueWaiting;
    private int currentTimeMillis;
    private List dequeue = new ArrayList();
    private List dequeueNotify = new ArrayList();
    QueuePolicy enqueue;

    public ThreadQueueController(int n) {
        this.QOIV = n > 0 ? n : 1;
        this.currentTimeMillis = ServerEnv.getAcceleratedQueueSize();
        if (this.currentTimeMillis < 0 || this.currentTimeMillis >= this.QOIV) {
            this.currentTimeMillis = 0;
        }
        this.continueWaiting = this.QOIV - this.currentTimeMillis;
        this.contains = new ArrayList(this.currentTimeMillis);
        this.clone = new ArrayList(this.continueWaiting);
        int n2 = ServerEnv.getQueuePolicy();
        this.enqueue = n2 == 1 ? new PriorityBasedQueuePolicy(this) : (n2 == 2 ? new DynamicTimeQueuePolicy(this) : (n2 == 3 ? new DynamicCounterQueuePolicy(this) : new FIFOBasedQueuePolicy(this)));
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.logDebug(6600213, new String[]{String.valueOf(this.continueWaiting), String.valueOf(this.currentTimeMillis), String.valueOf(n2)}, 6);
        }
    }

    public synchronized boolean isFullActive() {
        return this.clone.size() + this.contains.size() >= this.QOIV;
    }

    public synchronized boolean isTaskQueueFull(int n) {
        if (this.isFullActive()) {
            return true;
        }
        return this.clone.size() >= this.continueWaiting && this.contains.size() < this.currentTimeMillis && this.enqueue instanceof PriorityBasedQueuePolicy && !((PriorityBasedQueuePolicy)this.enqueue).isInAcceleratedLists(n);
    }

    public synchronized int getActiveAndWaitReportsCount() {
        return this.clone.size() + this.contains.size() + this.dequeue.size() + this.dequeueNotify.size();
    }

    public synchronized int getActiveReportsCount() {
        return this.clone.size() + this.contains.size();
    }

    public synchronized int getWaitReportsCount() {
        return this.dequeue.size() + this.dequeueNotify.size();
    }

    public synchronized int getReadyWaitingReportsCount() {
        return this.dequeueNotify.size();
    }

    public synchronized int getNormalWaitingReportsCount() {
        return this.dequeue.size();
    }

    public synchronized int getAcceleratedRunningReportsCount() {
        return this.contains.size();
    }

    public synchronized int getNormalRunningReportsCount() {
        return this.clone.size();
    }

    public synchronized List getReadyWaitingList() {
        return (List)((ArrayList)this.dequeueNotify).clone();
    }

    public synchronized List getNormalWaitingList() {
        return (List)((ArrayList)this.dequeue).clone();
    }

    public synchronized List getAcceleratedRunningList() {
        return (List)((ArrayList)this.contains).clone();
    }

    public synchronized List getNormalRunningList() {
        return (List)((ArrayList)this.clone).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueUp(ThreadQueueElement[] threadQueueElementArray) {
        int n = 0;
        if (this.QOIV > 0) {
            int n2;
            Object object = this.add;
            synchronized (object) {
                n2 = 0;
                while (n2 < threadQueueElementArray.length) {
                    this.QOIV(threadQueueElementArray[n2]);
                    ++n2;
                }
                while (true) {
                    if (this.add(threadQueueElementArray[0])) {
                        ++n;
                        break;
                    }
                    if (!this.dequeue.contains(threadQueueElementArray[0]) && !this.dequeueNotify.contains(threadQueueElementArray[0])) break;
                    try {
                        this.add.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        ServiceLogger.logError(interruptedException);
                        break;
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        ServiceLogger.logError(illegalMonitorStateException);
                        break;
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                        break;
                    }
                }
            }
            if (n > 0) {
                n2 = 1;
                while (n2 < threadQueueElementArray.length) {
                    if (this.add(threadQueueElementArray[n2])) {
                        ++n;
                    }
                    ++n2;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueUp(ThreadQueueElement threadQueueElement) {
        boolean bl = false;
        if (this.QOIV > 0) {
            Object object = this.add;
            synchronized (object) {
                this.QOIV(threadQueueElement);
                while (true) {
                    if (this.add(threadQueueElement)) {
                        bl = true;
                        break;
                    }
                    if (!this.dequeue.contains(threadQueueElement) && !this.dequeueNotify.contains(threadQueueElement)) break;
                    try {
                        this.add.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        ServiceLogger.logError(interruptedException);
                        break;
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        ServiceLogger.logError(illegalMonitorStateException);
                        break;
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                        break;
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRelease(ThreadQueueElement threadQueueElement) {
        Object object = this.add;
        synchronized (object) {
            ThreadQueueController threadQueueController = this;
            synchronized (threadQueueController) {
                if (this.contains.contains(threadQueueElement)) {
                    this.contains.remove(threadQueueElement);
                } else if (this.clone.contains(threadQueueElement)) {
                    this.clone.remove(threadQueueElement);
                } else if (this.dequeueNotify.contains(threadQueueElement)) {
                    this.dequeueNotify.remove(threadQueueElement);
                } else if (this.dequeue.contains(threadQueueElement)) {
                    this.dequeue.remove(threadQueueElement);
                }
                threadQueueElement.dequeue();
                this.enqueue.dequeueNotify();
            }
            this.add.notifyAll();
        }
    }

    private synchronized void QOIV(ThreadQueueElement threadQueueElement) {
        if (!this.dequeue.contains(threadQueueElement) && !this.dequeueNotify.contains(threadQueueElement)) {
            this.dequeue.add(threadQueueElement);
            threadQueueElement.startWait();
            threadQueueElement.setJoinTime(System.currentTimeMillis());
            threadQueueElement.setAdjustTime(threadQueueElement.getJoinTime());
        }
    }

    private synchronized boolean add(ThreadQueueElement threadQueueElement) {
        if (this.clone.size() + this.contains.size() < this.QOIV) {
            if (this.contains.size() < this.currentTimeMillis && this.enqueue.tryToAccelerated(threadQueueElement)) {
                this.contains.add(threadQueueElement);
                threadQueueElement.enqueue();
                return true;
            }
            if (this.clone.size() < this.continueWaiting && this.enqueue.tryToActive(threadQueueElement)) {
                this.clone.add(threadQueueElement);
                threadQueueElement.enqueue();
                return true;
            }
        }
        this.enqueue.continueWaiting(threadQueueElement);
        return false;
    }

    static List access$000(ThreadQueueController threadQueueController) {
        return threadQueueController.dequeueNotify;
    }

    static List access$100(ThreadQueueController threadQueueController) {
        return threadQueueController.dequeue;
    }

    static int access$200(ThreadQueueController threadQueueController) {
        return threadQueueController.currentTimeMillis;
    }

    private class DynamicCounterQueuePolicy
    extends PriorityBasedQueuePolicy {
        private final int I;
        private int QOIV;
        private final ThreadQueueController this$0;

        DynamicCounterQueuePolicy(ThreadQueueController threadQueueController) {
            this.this$0 = threadQueueController;
            super(threadQueueController);
            this.policy = 3;
            this.I = ServerEnv.getQueuePolicyReadjust();
        }

        public void dequeueNotify() {
            ++this.QOIV;
            if (this.QOIV >= this.I) {
                this.QOIV = 0;
                long l = Long.MAX_VALUE;
                ArrayList<ThreadQueueElement> arrayList = new ArrayList<ThreadQueueElement>();
                if (ThreadQueueController.access$000(this.this$0).size() > 0) {
                    Collections.sort(ThreadQueueController.access$000(this.this$0), this.adjustComparator);
                    int n = 0;
                    int n2 = ThreadQueueController.access$000(this.this$0).size();
                    while (n < n2) {
                        ThreadQueueElement threadQueueElement = (ThreadQueueElement)ThreadQueueController.access$000(this.this$0).get(n);
                        long l2 = threadQueueElement.getAdjustTime();
                        if (l2 > l) break;
                        l = l2;
                        arrayList.add(threadQueueElement);
                        ++n;
                    }
                }
                if (ThreadQueueController.access$100(this.this$0).size() > 0) {
                    Collections.sort(ThreadQueueController.access$100(this.this$0), this.adjustComparator);
                    ThreadQueueElement threadQueueElement = (ThreadQueueElement)ThreadQueueController.access$100(this.this$0).get(0);
                    long l3 = threadQueueElement.getAdjustTime();
                    if (l3 <= l) {
                        if (l3 < l) {
                            arrayList.clear();
                            l = l3;
                        }
                        arrayList.add(threadQueueElement);
                        int n = 1;
                        int n3 = ThreadQueueController.access$100(this.this$0).size();
                        while (n < n3) {
                            threadQueueElement = (ThreadQueueElement)ThreadQueueController.access$100(this.this$0).get(n);
                            l3 = threadQueueElement.getAdjustTime();
                            if (l3 != l) break;
                            arrayList.add(threadQueueElement);
                            ++n;
                        }
                    }
                }
                if (arrayList.size() > 0) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        ThreadQueueElement threadQueueElement = (ThreadQueueElement)iterator.next();
                        int n = threadQueueElement.getPriority();
                        if (n >= 10) continue;
                        threadQueueElement.setPriority(++n);
                    }
                }
            }
        }
    }

    private class DynamicTimeQueuePolicy
    extends PriorityBasedQueuePolicy {
        private long I;
        private final ThreadQueueController this$0;

        DynamicTimeQueuePolicy(ThreadQueueController threadQueueController) {
            this.this$0 = threadQueueController;
            super(threadQueueController);
            this.policy = 2;
            this.I = (long)ServerEnv.getQueuePolicyWaitingTime() * 1000L;
        }

        public void continueWaiting(ThreadQueueElement threadQueueElement) {
            super.continueWaiting(threadQueueElement);
            int n = threadQueueElement.getPriority();
            if (n < 10 && System.currentTimeMillis() - threadQueueElement.getAdjustTime() >= this.I) {
                threadQueueElement.setPriority(++n);
                threadQueueElement.setAdjustTime(System.currentTimeMillis());
            }
        }
    }

    private class PriorityBasedQueuePolicy
    extends FIFOBasedQueuePolicy {
        protected ThreadQueueElementComparator priorityComparator;
        protected ThreadQueueElementComparator adjustComparator;
        private int[] access$200;
        private final ThreadQueueController this$0;

        PriorityBasedQueuePolicy(ThreadQueueController threadQueueController) {
            this.this$0 = threadQueueController;
            super(threadQueueController);
            this.policy = 1;
            if (ThreadQueueController.access$200(threadQueueController) > 0) {
                String string = ServerEnv.getQueueAccelerated();
                this.access$200 = this.I(string);
                if (this.access$200 == null) {
                    string = "10,9";
                    this.access$200 = this.I(string);
                }
            }
            this.priorityComparator = new ThreadQueueElementComparator(this){
                private final PriorityBasedQueuePolicy this$1;
                {
                    this.this$1 = priorityBasedQueuePolicy;
                    super(priorityBasedQueuePolicy);
                }

                public int compareBy(ThreadQueueElement threadQueueElement, ThreadQueueElement threadQueueElement2) {
                    return threadQueueElement2.getPriority() - threadQueueElement.getPriority();
                }
            };
            this.adjustComparator = new ThreadQueueElementComparator(this){
                private final PriorityBasedQueuePolicy this$1;
                {
                    this.this$1 = priorityBasedQueuePolicy;
                    super(priorityBasedQueuePolicy);
                }

                public int compareBy(ThreadQueueElement threadQueueElement, ThreadQueueElement threadQueueElement2) {
                    return (int)(threadQueueElement.getAdjustTime() - threadQueueElement2.getAdjustTime());
                }
            };
        }

        public boolean tryToAccelerated(ThreadQueueElement threadQueueElement) {
            if (this.isInAcceleratedLists(threadQueueElement.getPriority())) {
                return this.isMostEligible(threadQueueElement);
            }
            return false;
        }

        protected boolean isInWaiting(List list, ThreadQueueElement threadQueueElement) {
            Collections.sort(list, this.priorityComparator);
            return super.isInWaiting(list, threadQueueElement);
        }

        public boolean isInAcceleratedLists(int n) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.access$200.length) {
                if (n == this.access$200[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            return bl;
        }

        private int[] I(String string) {
            int[] nArray = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", false);
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                nArray = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return null;
                    }
                    try {
                        nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    ++n2;
                }
            }
            return nArray;
        }

        private abstract class ThreadQueueElementComparator
        implements Comparator {
            private final PriorityBasedQueuePolicy this$1;

            public ThreadQueueElementComparator(PriorityBasedQueuePolicy priorityBasedQueuePolicy) {
                this.this$1 = priorityBasedQueuePolicy;
            }

            public int compare(Object object, Object object2) {
                if (!(object instanceof ThreadQueueElement) || !(object2 instanceof ThreadQueueElement)) {
                    return 0;
                }
                return this.compareBy((ThreadQueueElement)object, (ThreadQueueElement)object2);
            }

            public abstract int compareBy(ThreadQueueElement var1, ThreadQueueElement var2);
        }
    }

    private class FIFOBasedQueuePolicy
    implements QueuePolicy {
        protected int policy;
        private final ThreadQueueController this$0;

        FIFOBasedQueuePolicy(ThreadQueueController threadQueueController) {
            this.this$0 = threadQueueController;
            this.policy = 0;
        }

        public int getPolicy() {
            return this.policy;
        }

        public boolean tryToAccelerated(ThreadQueueElement threadQueueElement) {
            return this.isMostEligible(threadQueueElement);
        }

        public boolean tryToActive(ThreadQueueElement threadQueueElement) {
            return this.isMostEligible(threadQueueElement);
        }

        public void continueWaiting(ThreadQueueElement threadQueueElement) {
        }

        public void dequeueNotify() {
        }

        protected boolean isMostEligible(ThreadQueueElement threadQueueElement) {
            if (this.isInWaiting(ThreadQueueController.access$000(this.this$0), threadQueueElement)) {
                ThreadQueueController.access$000(this.this$0).remove(threadQueueElement);
                return true;
            }
            if (ThreadQueueController.access$000(this.this$0).size() == 0 && this.isInWaiting(ThreadQueueController.access$100(this.this$0), threadQueueElement)) {
                ThreadQueueController.access$100(this.this$0).remove(threadQueueElement);
                return true;
            }
            return false;
        }

        protected boolean isInWaiting(List list, ThreadQueueElement threadQueueElement) {
            int n = list.size();
            return n > 0 && list.get(0) == threadQueueElement;
        }
    }

    private static interface QueuePolicy {
        public static final int FIFO_BASED = 0;
        public static final int STATIC_PRIORITY_BASED = 1;
        public static final int DYNAMIC_WAITING_TIME_BASED = 2;
        public static final int DYNAMIC_COUNTER_BASED = 3;

        public int getPolicy();

        public boolean tryToAccelerated(ThreadQueueElement var1);

        public boolean tryToActive(ThreadQueueElement var1);

        public void continueWaiting(ThreadQueueElement var1);

        public void dequeueNotify();
    }
}

