/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import jet.server.log.ServiceLogger;
import jet.server.util.FormData;
import jet.server.util.MultiPartFormData;
import jet.server.util.ZipTools;

public class UploadFileUtil {
    public static Properties getUploadFileProperties(HttpServletRequest httpServletRequest, String string, boolean bl) throws IOException {
        Properties properties = new Properties();
        MultiPartFormData multiPartFormData = UploadFileUtil.QOIV(httpServletRequest, string);
        if (multiPartFormData != null) {
            Vector vector = UploadFileUtil.append(multiPartFormData);
            properties = UploadFileUtil.close(multiPartFormData);
            if (bl && vector != null && vector.size() > 0) {
                int n = 0;
                while (n < vector.size()) {
                    String string2 = (String)vector.elementAt(n);
                    if ((string2 = UploadFileUtil.delete(string2)) != null) {
                        properties.put("jrs.deploy_from_file", string2);
                        properties.put("jrs.folder_with_contents", "true");
                    }
                    ++n;
                }
            }
            UploadFileUtil.destroy(multiPartFormData, httpServletRequest);
        }
        return properties;
    }

    public static Properties uploadSkinFile(HttpServletRequest httpServletRequest, String string) throws IOException {
        MultiPartFormData multiPartFormData;
        Properties properties = new Properties();
        if (string != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if ((multiPartFormData = UploadFileUtil.QOIV(httpServletRequest, string)) != null) {
            Vector vector = UploadFileUtil.append(multiPartFormData);
            properties = UploadFileUtil.close(multiPartFormData);
            String string2 = null;
            string2 = properties.getProperty("skin_waitting_page");
            if (string2 != null) {
                string2 = "skin" + File.separator + string2;
            } else {
                string2 = properties.getProperty("skin_waitting_statue");
                if (string2 != null) {
                    string2 = "images" + File.separator + string2;
                }
            }
            if (string2 != null) {
                int n = 0;
                while (n < vector.size()) {
                    String string3 = (String)vector.elementAt(n);
                    File file = new File(string3);
                    if (file.exists()) {
                        File file2 = new File(string + string2);
                        if (file2.exists()) {
                            file2.delete();
                        }
                        file.renameTo(file2);
                    }
                    ++n;
                }
            }
            UploadFileUtil.destroy(multiPartFormData, httpServletRequest);
        }
        return properties;
    }

    public static Properties getUploadFileProperties(HttpServletRequest httpServletRequest, String string) throws IOException {
        return UploadFileUtil.getUploadFileProperties(httpServletRequest, string, true);
    }

    private static MultiPartFormData QOIV(HttpServletRequest httpServletRequest, String string) throws IOException {
        String string2 = string;
        String string3 = httpServletRequest.getContentType();
        int n = string3.indexOf("multipart/form-data");
        String string4 = string3.substring(n);
        if ((n = string4.indexOf("boundary=")) >= 0) {
            String string5 = string4.substring(n + 9);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            string2 = UploadFileUtil.add(string2);
            MultiPartFormData multiPartFormData = new MultiPartFormData((InputStream)servletInputStream, string2, string5);
            return multiPartFormData;
        }
        return null;
    }

    private static String add(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        return string + File.separator;
    }

    private static Vector append(MultiPartFormData multiPartFormData) {
        Vector vector = multiPartFormData.getUploadedFiles();
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                FormData formData = (FormData)vector.elementAt(n);
                vector2.add(formData.getFilename());
                ++n;
            }
        }
        return vector2;
    }

    private static Properties close(MultiPartFormData multiPartFormData) {
        Properties properties = new Properties();
        Vector vector = multiPartFormData.getOtherFormData();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                FormData formData = (FormData)vector.elementAt(n);
                if (formData.getName() != null && formData.getName().length() > 0 && formData.getContent() != null) {
                    properties.put(formData.getName(), formData.getContent());
                }
                ++n;
            }
        }
        return properties;
    }

    private static String delete(String string) {
        String string2 = string;
        if (UploadFileUtil.destroy(string2)) {
            string2 = UploadFileUtil.elementAt(string2);
            File file = new File(string2);
            file.mkdir();
            try {
                ZipTools.unzip(string, string2 + File.separator, true);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                return null;
            }
            UploadFileUtil.endsWith(string);
            return string2;
        }
        return null;
    }

    private static boolean destroy(String string) {
        if (string.endsWith(".zip")) {
            return true;
        }
        if (string.endsWith(".tar")) {
            return true;
        }
        if (string.endsWith(".jar")) {
            return true;
        }
        if (string.endsWith(".tgz")) {
            return true;
        }
        if (string.endsWith(".tar.gz")) {
            return true;
        }
        if (string.endsWith(".tar.zip")) {
            return true;
        }
        return string.endsWith(".gzip") || string.endsWith(".gz");
    }

    private static String elementAt(String string) {
        String string2 = string;
        string2 = string2.endsWith(".tar.gz") ? string2.substring(0, string2.length() - ".tar.gz".length()) : (string2.endsWith(".tar.zip") ? string2.substring(0, string2.length() - ".tar.zip".length()) : (string2.endsWith(".gzip") ? string2.substring(0, string2.length() - ".gzip".length()) : (string2.endsWith(".gz") ? string2.substring(0, string2.length() - ".gz".length()) : string2.substring(0, string2.length() - ".zip".length()))));
        return string2;
    }

    private static void endsWith(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }

    private static void destroy(MultiPartFormData multiPartFormData, HttpServletRequest httpServletRequest) throws IOException {
        multiPartFormData.destroy();
        httpServletRequest.getInputStream().close();
    }
}

