/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.nls;

import java.io.File;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jet.cs.util.APIUtil;
import jet.server.api.UserPreferenceManager;
import jet.server.api.http.HttpUtil;
import jet.server.api.rmi.RemoteDispatcherFactory;
import jet.server.log.ServiceLogger;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import jet.server.util.nls.PropertyMessageResourcesFactoryUtils;
import jet.web.dhtml.DHTMLUtil;

public class NlsClientResource {
    private HttpServletRequest QOIV = null;
    private static Hashtable append = null;

    public NlsClientResource(HttpServletRequest httpServletRequest) {
        this.QOIV = httpServletRequest;
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.getAttribute("ServerLanguage") == null) {
            httpSession.setAttribute("ServerLanguage", (Object)this.getLanguage());
        }
        if (append == null) {
            append = new Hashtable();
        }
    }

    public String getLanguage() {
        boolean bl;
        Object object;
        String string = this.QOIV.getParameter("jrs.language");
        if (string != null && string.length() > 0) {
            return string;
        }
        HttpSession httpSession = this.QOIV.getSession();
        string = (String)httpSession.getAttribute("ServerLanguage");
        if (string != null && string.length() > 0) {
            return string;
        }
        String string2 = "";
        UserPreferenceManager userPreferenceManager = null;
        if (System.getProperty("jrs.remote.dispatcher") != null) {
            try {
                object = RemoteDispatcherFactory.getInstance().getDispatchedServer(this.QOIV);
                string2 = object.getHttpUserSessionManager().getUser(this.QOIV);
                userPreferenceManager = object.getUserPreferenceManager();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            if (HttpUtil.getHttpRptServer() == null) {
                HttpUtil.initEnv(System.getProperties());
            }
            string2 = HttpUtil.getUser(this.QOIV);
            userPreferenceManager = HttpUtil.getHttpRptServer().getUserPreferenceManager();
        }
        if (bl = APIUtil.getBoolean(((Properties)(object = userPreferenceManager.getUserPreference(string2))).getProperty("enable_setting_display_language"), false)) {
            string = ((Properties)object).getProperty("locale_nls");
        } else {
            String string3 = this.QOIV.getHeader("Accept-Language");
            if (string3 != null) {
                String[] stringArray = string3.split(",");
                string = stringArray[0];
            } else {
                string = "en";
            }
        }
        return string;
    }

    public Locale getLocale() {
        Locale locale = null;
        String string = this.getLanguage();
        if (string != null && string.length() != 0) {
            string = string.replaceAll("-", "_");
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n = string.indexOf("_");
            if (n > 0) {
                string2 = string.substring(0, n);
                if ((n = (string = string.substring(n + 1)).indexOf("_")) > 0) {
                    string3 = string.substring(0, n);
                    string4 = string.substring(n + 1);
                } else {
                    string3 = string;
                }
            } else {
                string2 = string;
            }
            locale = new Locale(string2, string3, string4);
        } else {
            locale = new Locale("en", "US");
        }
        return locale;
    }

    private PropertyMessageResourcesFactory QOIV(String string) {
        PropertyMessageResourcesFactory propertyMessageResourcesFactory = PropertyMessageResourcesFactoryUtils.getServerResourceFactory(string);
        if (HttpUtil.isStandaloneServer()) {
            String string2 = HttpUtil.getHttpRptServer().getServerEnv().getHomePath() + "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
            propertyMessageResourcesFactory.setLanguagePath(string2);
        }
        return propertyMessageResourcesFactory;
    }

    public PropertyMessageResourcesFactory getServerResourceFactory() {
        PropertyMessageResourcesFactory propertyMessageResourcesFactory = null;
        HttpSession httpSession = this.QOIV.getSession();
        String string = (String)httpSession.getAttribute("DhtmlLanguage");
        String string2 = (String)httpSession.getAttribute("ServerLanguage");
        String string3 = this.getLanguage();
        if (string != null && string.length() > 0) {
            if (append.get(string) != null) {
                propertyMessageResourcesFactory = (PropertyMessageResourcesFactory)append.get(string);
            } else {
                propertyMessageResourcesFactory = this.QOIV(string);
                append.put(string, propertyMessageResourcesFactory);
            }
            httpSession.setAttribute("ServerLanguage", (Object)string);
            httpSession.removeAttribute("DhtmlLanguage");
            return propertyMessageResourcesFactory;
        }
        if (append.get(string3) != null) {
            propertyMessageResourcesFactory = (PropertyMessageResourcesFactory)append.get(string3);
        } else {
            propertyMessageResourcesFactory = this.QOIV(string3);
            append.put(string3, propertyMessageResourcesFactory);
        }
        httpSession.setAttribute("ServerLanguage", (Object)string3);
        if (!string3.equals(string2)) {
            NlsClientResource.append(this.QOIV);
        }
        return propertyMessageResourcesFactory;
    }

    public static void setCurrentLanguage(HttpServletRequest httpServletRequest) {
        NlsClientResource nlsClientResource = new NlsClientResource(httpServletRequest);
        String string = nlsClientResource.getLanguage();
        HttpSession httpSession = nlsClientResource.QOIV.getSession();
        httpSession.setAttribute("DhtmlLanguage", (Object)string);
    }

    private static void append(HttpServletRequest httpServletRequest) {
        DHTMLUtil.setCurrentLanguage(httpServletRequest);
    }
}

