/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml;

import com.jinfonet.util.JDLog;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.JDException;
import jet.datastream.Communicator;
import jet.datastream.DSTOC;
import jet.datastream.TOCNode;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptObject;
import jet.report.chart.JetRptChartPlatform;
import jet.reportLogic.objectInfo.CTHdFldInfo;
import jet.reportLogic.objectInfo.CTSumFldInfo;
import jet.reportLogic.objectInfo.CrosstableInfo;
import jet.rptservice.api.exception.JRScheduleException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.web.dhtml.DHTMLConfig;
import jet.web.dhtml.DHTMLRptSheet;
import jet.web.dhtml.DHTMLService;
import jet.web.dhtml.DHTMLUtil;
import jet.web.dhtml.DHTMLWriter;
import jet.web.dhtml.RptToolkit;
import jet.web.dhtml.URLEncoder;
import jet.webreport.service.builder.ResourceTreeBuilder;
import jet.webreport.service.builder.TOCTreeBuilder;
import jet.webreport.util.JNode;
import util.Node;

public class DHTMLWriterImpl
implements DHTMLWriter {
    private DHTMLService QOIV = null;
    private DHTMLConfig add = null;
    private String append = null;
    private String booleanValue = null;
    private String buildComponentDSTree = null;
    private String buildReportDSTree = null;
    private String buildTOCTree = null;
    private String close = "";
    private boolean convertUnitToPixel = false;
    private boolean currentTimeMillis = false;
    private String ds = null;
    private String encode = null;

    public static DHTMLWriter getInstance(DHTMLService dHTMLService, String string, String string2) {
        DHTMLWriterImpl dHTMLWriterImpl = new DHTMLWriterImpl();
        dHTMLWriterImpl.QOIV = dHTMLService;
        dHTMLWriterImpl.add = dHTMLWriterImpl.QOIV.getDHTMLConfig();
        dHTMLWriterImpl.ds = string;
        dHTMLWriterImpl.encode = string2;
        dHTMLWriterImpl.append = dHTMLWriterImpl.add.getDHTMLCssPath(string, string2);
        dHTMLWriterImpl.booleanValue = dHTMLWriterImpl.add.getDHTMLJsPath(string);
        dHTMLWriterImpl.buildComponentDSTree = dHTMLWriterImpl.add.getDHTMLSkinImagePath(string, string2);
        dHTMLWriterImpl.buildReportDSTree = dHTMLWriterImpl.add.getDHTMLJspUrl(string);
        dHTMLWriterImpl.buildTOCTree = dHTMLWriterImpl.add.getDHTMLServletUrl(string, string2);
        dHTMLWriterImpl.close = dHTMLWriterImpl.add.getDHTMLSkinCssPath(string, string2);
        dHTMLWriterImpl.convertUnitToPixel = dHTMLWriterImpl.add.isNoFrame(string, string2);
        dHTMLWriterImpl.currentTimeMillis = dHTMLWriterImpl.add.isAdhoc(string, string2);
        return dHTMLWriterImpl;
    }

    public byte[] writeBusinessCubeTree(String string, String string2, String string3, String string4, boolean bl, String[] stringArray, String string5) {
        long l = System.currentTimeMillis();
        ResourceTreeBuilder resourceTreeBuilder = new ResourceTreeBuilder();
        JNode jNode = resourceTreeBuilder.buildReportDSTree(string, string2, string3, string4);
        Properties properties = new Properties();
        properties.setProperty("images.path", this.buildComponentDSTree);
        properties = ResourceTreeBuilder.getDefaultSetting(properties);
        properties.setProperty("root.enableDrag", "true");
        properties.setProperty("root.expandLevel", "1");
        properties.setProperty("root.treeStyle", "1");
        properties.setProperty("detail.hide", bl ? "0" : "1");
        String string6 = "1";
        if (string4 == null || string5 != null && string5.equals("true")) {
            string6 = "0";
        }
        properties.setProperty("handle.hide", string6);
        String string7 = jNode.toXML(properties);
        byte[] byArray = null;
        try {
            byArray = string7.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        long l2 = System.currentTimeMillis();
        if (JDLog.isTrace((int)4)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[DHTML--TIMEELAPSE--writeDSOTree()]").append(" RptSetID=").append(string).append(",cost=").append(l2 - l).append("ms").append(",RptName=").append(string2).append(",bytes=").append(byArray.length);
            JDLog.trace((int)4, (Object)stringBuffer.toString());
        }
        return byArray;
    }

    public byte[] buildTOC(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n) {
        long l = System.currentTimeMillis();
        TOCTreeBuilder tOCTreeBuilder = new TOCTreeBuilder();
        Properties properties = new Properties();
        properties.setProperty("images.path", this.buildComponentDSTree);
        properties = TOCTreeBuilder.getDefaultSetting(properties);
        boolean bl = this.QOIV.getDHTMLConfig().isFeatureEnabled(string, string2, "feature_showgroupbyname");
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.buildReportDSTree).append("builddso.jsp?type=10").append("&").append("sessionid").append("=").append(string).append("&").append("rptsetid").append("=").append(string2).append("&").append("rptname").append("=").append(URLEncoder.encode(string3)).append("&").append("time=").append(Math.random()).append("&");
        properties.setProperty("delay.url", stringBuffer.toString());
        JNode jNode = tOCTreeBuilder.buildTOCTree(string2, string3, bl, string4, properties);
        String string8 = jNode.toXML(properties);
        if (JDLog.isTrace((int)4)) {
            long l2 = System.currentTimeMillis();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("[DHTML--writeTOCTree()]").append(" RptSetID=").append(string2).append(",RptName=").append(string3).append(",cost=").append(l2 - l).append("ms");
            JDLog.trace((int)4, (Object)stringBuffer2.toString());
        }
        return string8.getBytes();
    }

    private byte[] buildTOC(String string, String string2, String string3) {
        TOCNode tOCNode;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        Communicator communicator = this.QOIV.ds.getCommunicator(string2, string3);
        String string4 = null;
        String string5 = null;
        DSTOC dSTOC = communicator.getDSTOC();
        if (dSTOC != null) {
            string4 = this.append(dSTOC);
            string5 = this.booleanValue(dSTOC);
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<jTree enableDrag='false' treeStyle='1' expandLevel='1' resourcePath='" + this.buildComponentDSTree + "'" + (string4 == null ? "" : " treeCSS='" + string4 + "'") + (string5 == null ? "" : " nodeCSS='" + string5 + "'") + ">");
        TOCNode tOCNode2 = tOCNode = dSTOC == null ? null : dSTOC.getTOCNode();
        if (tOCNode != null) {
            boolean bl = this.QOIV.getDHTMLConfig().isFeatureEnabled(string, string2, "feature_showgroupbyname");
            printWriter.println(this.QOIV(string, string2, string3, tOCNode, bl, false, 0));
        }
        printWriter.println("</jTree>");
        printWriter.close();
        return byteArrayOutputStream.toByteArray();
    }

    private String QOIV(String string, String string2, String string3, TOCNode tOCNode, boolean bl, boolean bl2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = tOCNode.getNodeCount();
        String string4 = tOCNode.getNodeDisplayValue();
        String string5 = tOCNode.getValue();
        String string6 = tOCNode.getName();
        String string7 = null;
        if (bl) {
            if (string6 != null && string6.length() > 0) {
                string7 = string6 + ": ";
                if (!string6.equals(string4)) {
                    string7 = string7 + string4;
                }
            } else {
                string7 = string4;
            }
        } else if (string4 != null && string4.length() > 0) {
            string7 = string4;
        }
        if (string4 == null || string4.length() == 0) {
            string7 = string7 + string5;
        } else if (tOCNode.getImg().endsWith("sum.gif")) {
            string7 = string7 + "(" + tOCNode.getValue() + ")";
        }
        string7 = DHTMLUtil.toHtmlString(string7);
        int n3 = tOCNode.getPage();
        int n4 = Unit.convertUnitToPixel((int)tOCNode.getX());
        int n5 = Unit.convertUnitToPixel((int)tOCNode.getY());
        String string8 = this.add(tOCNode);
        if (n2 <= 0) {
            stringBuffer.append("<jTreeNode contractImg='").append(string8).append("' value=\"").append(string7).append("\" text=\"").append(string7).append("\">");
            stringBuffer.append("<p>").append(n3).append("</p><x>").append(n4).append("</x><y>").append(n5).append("</y>");
            stringBuffer.append("</jTreeNode>");
        } else if (n2 > 5 && bl2) {
            StringBuffer stringBuffer2 = new StringBuffer(128);
            stringBuffer2.append(this.buildReportDSTree).append("builddso.jsp?type=10").append("&amp;").append("sessionid").append("=").append(string).append("&amp;").append("rptsetid").append("=").append(string2).append("&amp;").append("rptname").append("=").append(URLEncoder.encode(string3)).append("&amp;NV=").append(URLEncoder.encode(tOCNode.getValue())).append("&amp;P=").append(n3).append("&amp;X=").append(tOCNode.getX()).append("&amp;Y=").append(tOCNode.getY()).append("&amp;level=").append(n).append("&amp;time=").append(Math.random());
            stringBuffer.append("<jTreeNode src='").append(stringBuffer2.toString()).append("' contractImg='").append(string8).append("' value=\"").append(string7).append("\" text=\"").append(string7).append("\">");
            stringBuffer.append("<p>").append(n3).append("</p><x>").append(n4).append("</x><y>").append(n5).append("</y>");
            stringBuffer.append("</jTreeNode>");
        } else {
            Node[] nodeArray = tOCNode.getNodes();
            stringBuffer.append("<jTreeNode contractImg='").append(string8).append("' value=\"").append(string7).append("\" text=\"").append(string7).append("\">");
            boolean bl3 = !bl;
            String string9 = ((TOCNode)nodeArray[0]).getName();
            if (string9 == null || string9.length() <= 0) {
                bl3 = false;
            }
            if (bl3) {
                string9 = DHTMLUtil.toHtmlString(string9);
                stringBuffer.append("<jTreeNode contractImg='").append(this.add((TOCNode)nodeArray[0])).append("' value=\"").append(string9).append("\" text=\"").append(string9).append("\">");
            }
            int n6 = 0;
            while (n6 < n2) {
                TOCNode tOCNode2 = (TOCNode)nodeArray[n6];
                stringBuffer.append(this.QOIV(string, string2, string3, tOCNode2, bl, true, ++n));
                ++n6;
            }
            if (bl3) {
                stringBuffer.append("<p>").append(n3).append("</p><x>").append(n4).append("</x><y>").append(n5).append("</y>");
                stringBuffer.append("</jTreeNode>\n");
            }
            stringBuffer.append("<p>").append(n3).append("</p><x>").append(n4).append("</x><y>").append(n5).append("</y>");
            stringBuffer.append("</jTreeNode>\n");
        }
        return stringBuffer.toString();
    }

    private String add(TOCNode tOCNode) {
        String string = this.buildComponentDSTree;
        if (tOCNode.getImg() == null || tOCNode.getImg().length() <= 0) {
            int n = tOCNode.getObjType();
            switch (n) {
                case 44: 
                case 0x1000000: {
                    string = string + "toc/toc_group.gif";
                    break;
                }
                case 512: {
                    string = string + "toc/toc_section.gif";
                    break;
                }
                case 45: {
                    string = string + "toc/toc_sectionobject.gif";
                    break;
                }
                case 262179: {
                    string = string + "toc/toc_table.gif";
                    break;
                }
                case 257: {
                    string = string + "toc/toc_textfiled.gif";
                    break;
                }
                case 258: {
                    string = string + "toc/toc_dbfield.gif";
                    break;
                }
                case 262178: {
                    string = string + "toc/toc_paragraph.gif";
                    break;
                }
                case 262181: {
                    string = string + "toc/toc_textbox.gif";
                    break;
                }
                case 128: {
                    string = string + "toc/toc_image.gif";
                    break;
                }
                case 46: {
                    string = string + "toc/toc_tabular.gif";
                    break;
                }
                case 47: {
                    string = string + "toc/toc_tabularcell.gif";
                    break;
                }
                case 262177: {
                    string = string + "toc/toc_reportbody.gif";
                    break;
                }
                case 34: {
                    string = string + "toc/toc_crosstable.gif";
                    break;
                }
                default: {
                    string = string + "folder.gif";
                    break;
                }
            }
        } else {
            string = string + "toc/toc_" + tOCNode.getImg().toLowerCase();
        }
        return string;
    }

    private String append(DSTOC dSTOC) {
        String string = null;
        if (dSTOC.getPropertyByName("Background").getObject() instanceof Color) {
            string = this.buildComponentDSTree((Color)dSTOC.getPropertyByName("Background").getObject());
        }
        if (string != null) {
            return "background-color:#" + string + ";";
        }
        return null;
    }

    private String booleanValue(DSTOC dSTOC) {
        String string = null;
        boolean bl = (Boolean)dSTOC.getPropertyByName("StrikeOut").getObject();
        boolean bl2 = (Boolean)dSTOC.getPropertyByName("Underline").getObject();
        boolean bl3 = (Boolean)dSTOC.getPropertyByName("Italic").getObject();
        boolean bl4 = (Boolean)dSTOC.getPropertyByName("Bold").getObject();
        if (dSTOC.getPropertyByName("Foreground").getObject() instanceof Color) {
            string = this.buildComponentDSTree((Color)dSTOC.getPropertyByName("Foreground").getObject());
        }
        String string2 = (String)dSTOC.getPropertyByName("FontFace").getObject();
        int n = Unit.convertUnitToPixel((int)((Integer)dSTOC.getPropertyByName("FontSize").getObject()));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl3 ? "font-style:italic; " : "");
        if (bl || bl2) {
            stringBuffer.append("text-decoration:").append(bl ? " line-through" : "");
            stringBuffer.append(bl2 ? " underline" : "").append("; ");
        }
        stringBuffer.append(bl4 ? "font-weight: bold; " : "");
        stringBuffer.append("font-size:").append(n).append("px; ");
        if (!string2.equals("Default")) {
            stringBuffer.append("font-family: ").append(string2).append("; ");
        }
        if (string != null) {
            stringBuffer.append("color:#").append(string).append("; ");
        }
        return stringBuffer.toString().trim();
    }

    public String writeDSTreeofComponent(String string, String string2, String string3, String string4) {
        ResourceTreeBuilder resourceTreeBuilder = new ResourceTreeBuilder(this.QOIV.getDHTMLRptSheet(string, string2, string3));
        JNode jNode = resourceTreeBuilder.buildComponentDSTree(string2, string3, string4, null);
        Properties properties = new Properties();
        properties.setProperty("images.path", this.buildComponentDSTree);
        properties = ResourceTreeBuilder.getDefaultSetting(properties);
        String string5 = jNode.toXML(properties);
        return string5;
    }

    public String writeDSTreeofComponentByInstanceName(String string, String string2, String string3, String string4) {
        ResourceTreeBuilder resourceTreeBuilder = new ResourceTreeBuilder(this.QOIV.getDHTMLRptSheet(string, string2, string3));
        JNode jNode = resourceTreeBuilder.buildComponentDSTree(string2, string3, null, string4);
        Properties properties = new Properties();
        properties.setProperty("images.path", this.buildComponentDSTree);
        properties = ResourceTreeBuilder.getDefaultSetting(properties);
        String string5 = jNode.toXML(properties);
        return string5;
    }

    private String writeDSTreeofComponent(JetRptObject jetRptObject, String string, String string2, String string3, String string4) {
        int n;
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        JetRptObject jetRptObject2 = RptToolkit.getCrosstabLevelComponentBySubObject(jetRptObject, new String[]{"Crosstab", "Chart"});
        if (jetRptObject2 == null) {
            return "";
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        if (jetRptObject2 instanceof JetRptCTCrossTab) {
            object3 = CrosstableInfo.getCrosstableInfo((JetRptCTCrossTab)((JetRptCTCrossTab)jetRptObject2));
            stringArray = object3.getRowFldInfos();
            object2 = object3.getColumnFldInfos();
            object = object3.getSummaryFldInfos();
            int n2 = 0;
            while (n2 < stringArray.size()) {
                CTHdFldInfo cTHdFldInfo = object3.getRowFldInfo(n2);
                if (cTHdFldInfo.get_blColumnName() != null) {
                    vector.add(cTHdFldInfo.get_blColumnName());
                }
                ++n2;
            }
            n = 0;
            while (n < ((Vector)object2).size()) {
                CTHdFldInfo cTHdFldInfo = object3.getColumnFldInfo(n);
                if (cTHdFldInfo.get_blColumnName() != null) {
                    vector.add(cTHdFldInfo.get_blColumnName());
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                CTSumFldInfo cTSumFldInfo = object3.getSummaryFldInfo(n3);
                if (cTSumFldInfo.get_blColumnName() != null) {
                    vector2.add(cTSumFldInfo.get_blColumnName());
                }
                ++n3;
            }
        } else if (jetRptObject2 instanceof JetRptChartPlatform) {
            object3 = ((JetRptChartPlatform)jetRptObject2).getDefinition();
            vector.add(object3.getCategory());
            vector.add(object3.getSeries());
            stringArray = object3.getIndexedFieldNames();
            int n4 = 0;
            while (n4 < stringArray.length) {
                vector2.add(stringArray[n4]);
                ++n4;
            }
        }
        object3 = new StringBuffer();
        stringArray = jetRptObject2.getInstName();
        ((StringBuffer)object3).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ((StringBuffer)object3).append("<jTree enableDrag='false' expandLevel='0' resourcePath='").append(this.buildComponentDSTree).append("'>");
        ((StringBuffer)object3).append("<jTreeNode  contractImg='").append(this.buildComponentDSTree).append("query.gif' expandImg='").append(this.buildComponentDSTree).append("query.gif' value='").append((String)stringArray).append("' text='").append((String)stringArray).append("'>");
        object2 = null;
        object = null;
        BLNode bLNode = null;
        n = 0;
        while (n < vector.size()) {
            object2 = (String)vector.get(n);
            if (object2 != null) {
                try {
                    bLNode = this.QOIV.ds.getRefDataElement(string2, string3, jetRptObject2.getInstName(), (String)object2, this.QOIV.getSubReportKey(string, string2, string3, string4));
                    object = ((DataElementInfo)bLNode).getDisplayName();
                }
                catch (JRScheduleException jRScheduleException) {
                    object = ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
                }
                object2 = DHTMLUtil.toHtmlString((String)object2);
                object = DHTMLUtil.toHtmlString((String)object);
                ((StringBuffer)object3).append("\r\n<jTreeNode  contractImg='").append(this.buildComponentDSTree).append("dimension.gif").append("' expandImg='").append(this.buildComponentDSTree).append("dimension.gif").append("' value='").append((String)object2).append("' text='").append((String)object).append("' />");
            }
            ++n;
        }
        int n5 = 0;
        while (n5 < vector2.size()) {
            object2 = (String)vector2.get(n5);
            try {
                bLNode = this.QOIV.ds.getRefDataElement(string2, string3, jetRptObject2.getInstName(), (String)object2, this.QOIV.getSubReportKey(string, string2, string3, string4));
                object = ((DataElementInfo)bLNode).getDisplayName();
            }
            catch (JRScheduleException jRScheduleException) {
                object = ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
            }
            object2 = DHTMLUtil.toHtmlString((String)object2);
            object = DHTMLUtil.toHtmlString((String)object);
            ((StringBuffer)object3).append("\r\n<jTreeNode  contractImg='").append(this.buildComponentDSTree).append("measure.gif").append("' expandImg='").append(this.buildComponentDSTree).append("measure.gif").append("' value='").append((String)object2).append("' text='").append((String)object).append("' />");
            ++n5;
        }
        ((StringBuffer)object3).append("</jTreeNode>\r\n");
        ((StringBuffer)object3).append("</jTree>\r\n");
        return ((StringBuffer)object3).toString();
    }

    String buildComponentDSTree(Color color) {
        String string = null;
        if (color != null) {
            string = Integer.toHexString(color.getRGB()).substring(2);
        }
        return string;
    }

    public String writeHeader(String string, boolean bl, String[] stringArray, String[] stringArray2, String string2) {
        try {
            StringBufferStream stringBufferStream = new StringBufferStream(this);
            boolean bl2 = this.add.isLocked(this.ds, this.encode, string);
            int n = this.add.getLockScreenTimeOut(this.ds, this.encode);
            int n2 = this.add.getAutoRefreshInterval(this.ds, this.encode);
            if (bl && !this.convertUnitToPixel) {
                bl = false;
            }
            int n3 = this.add.getLeftPanelWidth(this.ds, this.encode);
            int n4 = this.add.getTocPanelHeight(this.ds, this.encode);
            boolean bl3 = this.add.isComponentVisible(this.ds, this.encode, "component_UserInfoBar ");
            boolean bl4 = this.add.isComponentVisible(this.ds, this.encode, "component_MainMenu");
            boolean bl5 = this.add.isComponentVisible(this.ds, this.encode, "component_TOCTree");
            boolean bl6 = this.add.isComponentVisible(this.ds, this.encode, "component_DSOTree");
            boolean bl7 = this.add.isComponentVisible(this.ds, this.encode, "component_ToolBar");
            boolean bl8 = this.add.isComponentVisible(this.ds, this.encode, "component_RptSetBar");
            boolean bl9 = this.add.isComponentVisible(this.ds, this.encode, "component_LinkPanel");
            stringBufferStream.write("\r\n");
            stringBufferStream.print(DHTMLUtil.scriptBegin(bl));
            stringBufferStream.write("\r\nvar DHTMLConstant =\r\n{\r\n\tDHTMLJSPPATH : \"");
            stringBufferStream.print(this.buildReportDSTree);
            stringBufferStream.write("\",\r\n\tDHTMLIMGPATH : \"");
            stringBufferStream.print(this.buildComponentDSTree);
            stringBufferStream.write("\",\r\n\tDHTMLCSSPATH : \"");
            stringBufferStream.print(this.append);
            stringBufferStream.write("\",\r\n\tDHTMLJSPATH : \"");
            stringBufferStream.print(this.booleanValue);
            stringBufferStream.write("\",\r\n\tDHTMLURL:\"");
            stringBufferStream.print(this.buildTOCTree);
            stringBufferStream.write("?");
            stringBufferStream.print("sessionid");
            stringBufferStream.write("=");
            stringBufferStream.print(this.ds);
            stringBufferStream.write("&");
            stringBufferStream.print("rptsetid");
            stringBufferStream.write("=");
            stringBufferStream.print(this.encode);
            stringBufferStream.write("&");
            stringBufferStream.print("rptname");
            stringBufferStream.write("=");
            stringBufferStream.print(string);
            stringBufferStream.write("\",\r\n\tSESSION_ID:\"");
            stringBufferStream.print(this.ds);
            stringBufferStream.write("\",\r\n\tRPTSET_ID:\"");
            stringBufferStream.print(this.encode);
            stringBufferStream.write("\",\r\n\tRPT_NAME:\"");
            stringBufferStream.print(string);
            stringBufferStream.write("\",\r\n\tDHTML_PREFIX:\"");
            stringBufferStream.print("jro_");
            stringBufferStream.write("\"\r\n}\r\nvar DHTMLComponentVisible = \r\n{\r\n\tUserInfoBar : ");
            stringBufferStream.print(bl3);
            stringBufferStream.write(",\r\n\tMainMenu : ");
            stringBufferStream.print(bl4);
            stringBufferStream.write(",\r\n\tTOCTree : ");
            stringBufferStream.print(bl5);
            stringBufferStream.write(",\r\n\tDSOTree : ");
            stringBufferStream.print(bl6);
            stringBufferStream.write(",\r\n\tToolBar : ");
            stringBufferStream.print(bl7);
            stringBufferStream.write(",\r\n\tRptSetBar : ");
            stringBufferStream.print(bl8);
            stringBufferStream.write(",\r\n\tLinkPanel : ");
            stringBufferStream.print(bl9);
            stringBufferStream.write(",\r\n\tleftPanelWidth : ");
            stringBufferStream.print(n3);
            stringBufferStream.write(",\r\n\ttocPanelHeight : ");
            stringBufferStream.print(n4);
            stringBufferStream.write("\r\n}\r\nvar isNoFrame = ");
            stringBufferStream.print(this.convertUnitToPixel);
            stringBufferStream.write(";\r\nvar isScreenLocked = ");
            stringBufferStream.print(bl2);
            stringBufferStream.write(";\r\nvar isAdhoc = ");
            stringBufferStream.print(this.currentTimeMillis);
            stringBufferStream.write(";\r\nvar lockScrTimeOut = ");
            stringBufferStream.print(n);
            stringBufferStream.write(";\r\nvar autoRefreshInterval = ");
            stringBufferStream.print(n2);
            stringBufferStream.write(";\r\nvar timmer_refresh = null;\r\nvar timmer_lockScr = null;\r\n");
            stringBufferStream.print(DHTMLUtil.scriptEnd(bl));
            stringBufferStream.write("\r\n");
            int n5 = 0;
            while (stringArray2 != null && n5 < stringArray2.length) {
                stringBufferStream.write("\r\n");
                stringBufferStream.write("<link href=\"");
                stringBufferStream.print(this.append + stringArray2[n5]);
                stringBufferStream.write("\" rel=\"stylesheet\" type=\"text/css\">\r\n");
                ++n5;
            }
            stringBufferStream.write("\r\n");
            stringBufferStream.write("<link href=\"");
            stringBufferStream.print(this.close);
            stringBufferStream.write("\" id=\"");
            stringBufferStream.print("jro_");
            stringBufferStream.write("SkinCss\" rel=\"stylesheet\" type=\"text/css\">\r\n");
            int n6 = 0;
            while (stringArray != null && n6 < stringArray.length) {
                stringBufferStream.write("\r\n");
                stringBufferStream.write("<script language=\"javascript\" src=\"");
                stringBufferStream.print(this.booleanValue + stringArray[n6]);
                stringBufferStream.write("\">");
                stringBufferStream.write("</script>\r\n");
                ++n6;
            }
            return stringBufferStream.toString();
        }
        catch (Exception exception) {
            if (JDLog.isError((int)3)) {
                JDLog.error((int)3, (Throwable)exception);
            }
            return null;
        }
    }

    public String getConnectFrame(String string) {
        try {
            StringBufferStream stringBufferStream = new StringBufferStream(this);
            if (this.convertUnitToPixel) {
                stringBufferStream.write("\r\n");
                stringBufferStream.write("<div name=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("connect\" id=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("connect\" style=\"position:absolute; overflow:hidden; top:-100px; left:-100px; width:1px; height:1px;\">");
                stringBufferStream.write("</div>\r\n");
            } else {
                stringBufferStream.write("\r\n");
                stringBufferStream.write("<form action=\"");
                stringBufferStream.print(this.buildTOCTree);
                stringBufferStream.write("\" method=\"POST\" target=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("connect\" name=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("actionform\" id=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("actionform\">\r\n\t");
                stringBufferStream.write("<INPUT TYPE=\"hidden\" name=\"");
                stringBufferStream.print("sessionid");
                stringBufferStream.write("\" id=\"");
                stringBufferStream.print("jro_sessionid");
                stringBufferStream.write("\" value=\"");
                stringBufferStream.print(this.ds);
                stringBufferStream.write("\">\r\n\t");
                stringBufferStream.write("<INPUT TYPE=\"hidden\" name=\"");
                stringBufferStream.print("rptsetid");
                stringBufferStream.write("\" id=\"");
                stringBufferStream.print("jro_rptsetid");
                stringBufferStream.write("\" value=\"");
                stringBufferStream.print(this.encode);
                stringBufferStream.write("\">\r\n\t");
                stringBufferStream.write("<INPUT TYPE=\"hidden\" name=\"");
                stringBufferStream.print("rptname");
                stringBufferStream.write("\" id=\"");
                stringBufferStream.print("jro_rptname");
                stringBufferStream.write("\" value=\"");
                stringBufferStream.print(string);
                stringBufferStream.write("\">\r\n");
                stringBufferStream.write("</form>\r\n");
                stringBufferStream.write("<iframe name=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("connect\" id=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("connect\" src=\"about:blank\" style=\"position:absolute; top:-100px; left:-600px; width:0px; height:0px;\" >\r\n");
                stringBufferStream.write("</iframe>\r\n");
            }
            stringBufferStream.write("\r\n");
            stringBufferStream.write("<div name=\"");
            stringBufferStream.print("jro_");
            stringBufferStream.write("waitingdiv\" id=\"");
            stringBufferStream.print("jro_");
            stringBufferStream.write("waitingdiv\" onmousedown=\"return false;\" onmouseup=\"return false;\" align=\"center\" style=\"position:absolute;top:0px;left:0px;width:1000px; height:1000px;display:none;z-index:5000;\">");
            stringBufferStream.write("<table valign=\"middle\" align=\"center\" width=\"100%\" height=\"100%\">");
            stringBufferStream.write("<tbody align=\"center\">\r\n");
            stringBufferStream.write("<tr>\r\n\t");
            stringBufferStream.write("<td>");
            stringBufferStream.write("<div style=\"width:300px;height:150px;background-color:#FFFFFF;border:1px solid blue;\">");
            stringBufferStream.write("<table width=\"100%\" height=\"100%\" >\r\n\t");
            stringBufferStream.write("<tr>\r\n\t");
            stringBufferStream.write("<td width=\"100px\" align=\"center\">");
            stringBufferStream.write("<img src=\"");
            stringBufferStream.print(this.buildComponentDSTree);
            stringBufferStream.write("waiting.gif\" width=\"40\" height=\"40\" border=\"0\" alt=\"waiting\">");
            stringBufferStream.write("</td>\r\n\t");
            stringBufferStream.write("<td>Processing report...");
            stringBufferStream.write("<br>    Please wait.");
            stringBufferStream.write("</td>\r\n");
            stringBufferStream.write("</tr>");
            stringBufferStream.write("</tbody>\r\n");
            stringBufferStream.write("</table>");
            stringBufferStream.write("</div>");
            stringBufferStream.write("</td>\r\n");
            stringBufferStream.write("</tr>\r\n");
            stringBufferStream.write("</table>");
            stringBufferStream.write("</div>\r\n");
            return stringBufferStream.toString();
        }
        catch (Exception exception) {
            if (JDLog.isError((int)3)) {
                JDLog.error((int)3, (Throwable)exception);
            }
            return null;
        }
    }

    private String buildReportDSTree(int n, int n2, String string, String string2, boolean bl, String string3, String string4) {
        String string5 = "top:" + n2 + ";left:" + n + ";width:" + string + ";height:" + string2 + ";";
        if (n2 > 0) {
            string5 = string5 + "top:" + n2 + ";";
        }
        if (n > 0) {
            string5 = string5 + "left:" + n + ";";
        }
        if (string != null && !string.trim().equals("")) {
            string5 = string5 + "width:" + string + ";";
        }
        if (string2 != null && !string2.trim().equals("")) {
            string5 = string5 + "height:" + string2 + ";";
        }
        if (!bl) {
            string5 = string5 + "display:none;";
        }
        if (string3 != null && !string3.trim().equals("")) {
            string5 = string5 + "background:" + string3 + ";";
        }
        if (string4 != null && !string4.trim().equals("")) {
            string5 = string5 + "position:" + string4 + ";";
        }
        return string5;
    }

    public String getReportBrowser(String string, int n, int n2, String string2, String string3, boolean bl, String string4, String string5) {
        try {
            StringBufferStream stringBufferStream = new StringBufferStream(this);
            String string6 = this.buildReportDSTree(n, n2, string2, string3, bl, string4, string5);
            if (this.convertUnitToPixel) {
                stringBufferStream.write("\r\n");
                stringBufferStream.write("<div style=\"");
                stringBufferStream.print(string6);
                stringBufferStream.write("overflow:auto;border:2px inset #CCCCCC;display:\" id=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("div_report\" onContextmenu=\"");
                if (this.add.isFeatureEnabled(this.ds, this.encode, "feature_PopupMenu")) {
                    stringBufferStream.write("showShortcutMenu(event,");
                    stringBufferStream.print(11);
                    stringBufferStream.write(");");
                }
                stringBufferStream.write("return false;\">\r\n");
                stringBufferStream.write("<div style=\"position:absolute;\">");
                stringBufferStream.write("<!-- dragger begin don't modify!!!!!!!!!!!!!!! -->\r\n\r\n");
                stringBufferStream.write("<DIV id=divHotRectH1\r\nstyle=\"height:1px; Z-INDEX: 100; LEFT: -500px; VISIBILITY: visible;background-color:#0000FF; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"height:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divHotRectH2\r\nstyle=\"height:1px; Z-INDEX: 100; LEFT: -500px; VISIBILITY: visible;background-color:#0000FF; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"height:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divHotRectV1\r\nstyle=\"width:1px; Z-INDEX: 100; LEFT: -500px; VISIBILITY: visible;background-color:#0000FF; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"width:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divHotRectV2\r\nstyle=\"width:1px; Z-INDEX: 100; LEFT: -500px; VISIBILITY: visible;background-color:#0000FF; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"width:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=dragBarV CO=\"[41]\"\r\nstyle=\"border: 1px solid #0000ff; Z-INDEX:150 ; LEFT: -600px; VISIBILITY: visible; POSITION: absolute; TOP: 0px; width: 1px; height: 1px;\">\r\n  ");
                stringBufferStream.write("<table width=\"100%\"  height=\"100%\" bgcolor=\"#FFFFFF\" border=\"0\" cellspacing=\"2\" cellpadding=\"0\">\r\n    ");
                stringBufferStream.write("<tr>\r\n      ");
                stringBufferStream.write("<td bgcolor=\"#0000FF\" >");
                stringBufferStream.write("<img width=\"1\" height=\"1\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</td>\r\n    ");
                stringBufferStream.write("</tr>\r\n  ");
                stringBufferStream.write("</table>\r\n");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=dragBarH CO=\"[42]\"\r\nstyle=\"border: 1px solid #0000ff; Z-INDEX:150 ; LEFT: -600px; VISIBILITY: visible; POSITION: absolute; TOP: 0px; width: 1px; height: 1px;\">\r\n  ");
                stringBufferStream.write("<table width=\"100%\"  height=\"100%\" bgcolor=\"#FFFFFF\" border=\"0\" cellspacing=\"2\" cellpadding=\"0\">\r\n    ");
                stringBufferStream.write("<tr>\r\n      ");
                stringBufferStream.write("<td bgcolor=\"#0000FF\" >");
                stringBufferStream.write("<img width=\"1\" height=\"1\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</td>\r\n    ");
                stringBufferStream.write("</tr>\r\n  ");
                stringBufferStream.write("</table>\r\n");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=divComRectH1\r\nstyle=\"z-INDEX:99; height:1px; LEFT: -500px; VISIBILITY: visible;background-color:#00FF00; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"height:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divComRectH2\r\nstyle=\"z-INDEX:99; height:1px; LEFT: -500px; VISIBILITY: visible;background-color:#00FF00; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"height:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divComRectV1\r\nstyle=\"z-INDEX:99; width:1px; LEFT: -500px; VISIBILITY: visible;background-color:#00FF00; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"width:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divComRectV2\r\nstyle=\"z-INDEX:99; width:1px; LEFT: -500px; VISIBILITY: visible;background-color:#00FF00; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"width:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=divComSeRectH1\r\nstyle=\"z-INDEX:99; height:2px; LEFT: -500px; VISIBILITY: visible;background-color:#000000; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"height:2px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divComSeRectH2\r\nstyle=\"z-INDEX:99; height:2px; LEFT: -500px; VISIBILITY: visible;background-color:#000000; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"height:2px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divComSeRectV1\r\nstyle=\"z-INDEX:99; width:2px; LEFT: -500px; VISIBILITY: visible;background-color:#000000; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"width:2px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divComSeRectV2\r\nstyle=\"z-INDEX:99; width:2px; LEFT: -500px; VISIBILITY: visible;background-color:#000000; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"width:2px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=divFieldRectH1\r\nstyle=\"z-INDEX:100; height:1px; LEFT: -500px; VISIBILITY: visible;background-color:#00FF00; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"height:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divFieldRectH2\r\nstyle=\"z-INDEX:100; height:1px; LEFT: -500px; VISIBILITY: visible;background-color:#00FF00; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"height:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divFieldRectV1\r\nstyle=\"z-INDEX:100; width:1px; LEFT: -500px; VISIBILITY: visible;background-color:#00FF00; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"width:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divFieldRectV2\r\nstyle=\"z-INDEX:100; width:1px; LEFT: -500px; VISIBILITY: visible;background-color:#00FF00; POSITION: absolute; TOP: -500px\">");
                stringBufferStream.write("<IMG style=\"width:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=divComRSZHotH CO=\"[20]\" style=\"position:absolute; z-INDEX:99; left:-600px; top:-600px; background-color:#000000; width:10px; height:6px;\">");
                stringBufferStream.write("<img width=\"1\" height=\"1\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divComRSZHotV CO=\"[21]\" style=\"position:absolute; z-INDEX:99; left:-600px; top:-600px; background-color:#000000; width:6px; height:10px;\">");
                stringBufferStream.write("<img width=\"1\" height=\"1\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divComRSZHotB CO=\"[22]\" style=\"position:absolute; z-INDEX:99; left:-600px; top:-600px; background-color:#000000; width:8px; height:8px;\">");
                stringBufferStream.write("<img width=\"1\" height=\"1\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=divFieldRSZHotH CO=\"[30]\" style=\"position:absolute; z-INDEX:99; left:-600px; top:-600px; background-color:#00FF00; width:6px; height:6px;\">");
                stringBufferStream.write("<img width=\"1\" height=\"1\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divFieldRSZHotV CO=\"[31]\" style=\"position:absolute; z-INDEX:99; left:-600px; top:-600px; background-color:#00FF00; width:6px; height:6px;\">");
                stringBufferStream.write("<img width=\"1\" height=\"1\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=divArea CO=\"[40]\" style=\"position:absolute; z-INDEX:98; left:-600px; top:-600px; background-color:#000000; width:0px; height:0px;\">");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=divResizeCell\r\nstyle=\"border:1px dashed #000000;background-color:#CCCCCC; Z-INDEX:50 ; LEFT: -600px; VISIBILITY: visible; POSITION: absolute; TOP: -500px; width: 1px; height: 1px;\">");
                stringBufferStream.write("<IMG style=\"width:1px;height:1px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV style=\"width:25px; height:25px; position:absolute; Z-INDEX:102; LEFT:-600px; TOP:-600px;\" id=mover>");
                stringBufferStream.write("<IMG src=\"");
                stringBufferStream.print(this.buildComponentDSTree);
                stringBufferStream.write("drag_move.gif\" style=\"width:13p;height:13px;\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV id=divGroup CO=\"[50]\"\r\nstyle=\"Z-INDEX:50 ; LEFT: -600px; VISIBILITY: visible; POSITION: absolute; TOP: -500px;\">");
                stringBufferStream.write("<IMG style=\"cursor:move;\" src=\"");
                stringBufferStream.print(this.buildComponentDSTree);
                stringBufferStream.write("drag_parent.gif\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n");
                stringBufferStream.write("<DIV id=divTableColumn CO=\"[51]\"\r\nstyle=\"Z-INDEX:50 ; LEFT: -600px; VISIBILITY: visible; POSITION: absolute; TOP: -500px;\">");
                stringBufferStream.write("<IMG style=\"cursor:move;\" src=\"");
                stringBufferStream.print(this.buildComponentDSTree);
                stringBufferStream.write("drag_parent.gif\">");
                stringBufferStream.write("</IMG>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<DIV style=\"width:0px; height:0px; position:absolute; Z-INDEX:102; LEFT:-600px; TOP:-600px; backgroundColor:#FF0000\" id=cursor>");
                stringBufferStream.write("</DIV>\r\n\r\n");
                stringBufferStream.write("<!-- init src to catch before using-->\r\n");
                stringBufferStream.write("<IMG src=\"");
                stringBufferStream.print(this.buildComponentDSTree);
                stringBufferStream.write("drag_group.gif\" style=\"position:absolute; left:-20px; top:-20px;\"/>\r\n");
                stringBufferStream.write("<IMG src=\"");
                stringBufferStream.print(this.buildComponentDSTree);
                stringBufferStream.write("drag_dimension.gif\" style=\"position:absolute; left:-20px; top:-20px;\"/>\r\n");
                stringBufferStream.write("<IMG src=\"");
                stringBufferStream.print(this.buildComponentDSTree);
                stringBufferStream.write("drag_measure.gif\" style=\"position:absolute; left:-20px; top:-20px;\"/>\r\n");
                stringBufferStream.write("<IMG src=\"");
                stringBufferStream.print(this.buildComponentDSTree);
                stringBufferStream.write("drag_dbfield.gif\" style=\"position:absolute; left:-20px; top:-20px;\"/>\r\n");
                stringBufferStream.write("<!-- init src to catch before using-->\r\n\r\n");
                stringBufferStream.write("<!-- dragger end don't modify!!!!!!!!!!!!!!! -->\r\n");
                try {
                    stringBufferStream.print(new String(this.QOIV.getDHTMLWriter(this.ds, this.encode).exportReport(this.ds, this.encode, string)));
                }
                catch (Exception exception) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    exception.printStackTrace(new PrintStream(byteArrayOutputStream));
                }
                stringBufferStream.write("\r\n\r\n\r\n");
                stringBufferStream.write("\r\n");
                stringBufferStream.write("</div>\r\n");
            } else {
                stringBufferStream.write("\r\n");
                stringBufferStream.write("<iframe id=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("rptframe\" name=\"");
                stringBufferStream.print("jro_");
                stringBufferStream.write("rptframe\" src=\"");
                stringBufferStream.print(this.buildReportDSTree);
                stringBufferStream.write("/rpt_frame.jsp?");
                stringBufferStream.print("sessionid");
                stringBufferStream.write("=");
                stringBufferStream.print(this.ds);
                stringBufferStream.write("&");
                stringBufferStream.print("rptsetid");
                stringBufferStream.write("=");
                stringBufferStream.print(this.encode);
                stringBufferStream.write("&");
                stringBufferStream.print("rptname");
                stringBufferStream.write("=");
                stringBufferStream.print(string);
                stringBufferStream.write("\" frameborder=\"0\" scrolling=\"no\" style=\"");
                stringBufferStream.print(string6);
                stringBufferStream.write("\" onload=\"window.setTimeout('window.changeRptCss()', 10);\">");
                stringBufferStream.write("</iframe>\r\n");
            }
            return stringBufferStream.toString();
        }
        catch (Exception exception) {
            if (JDLog.isError((int)3)) {
                JDLog.error((int)3, (Throwable)exception);
            }
            return null;
        }
    }

    public byte[] exportReport(String string, String string2, String string3) throws JDException {
        return this.exportReport(string, string2, string3, null);
    }

    public byte[] exportReport(String string, String string2, String string3, Map map) throws JDException {
        byte[] byArray;
        block3: {
            byArray = null;
            try {
                Communicator communicator = this.QOIV.ds.getCommunicator(string2, string3);
                DHTMLRptSheet dHTMLRptSheet = this.QOIV.getDHTMLRptSheet(string, string2, string3);
                byArray = dHTMLRptSheet.exportReport(communicator, map);
            }
            catch (Exception exception) {
                if (!JDLog.isError((int)3)) break block3;
                JDLog.error((int)3, (Throwable)exception);
            }
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public byte[] publishCss(String string, String string2, String string3) throws JDException {
        DHTMLRptSheet dHTMLRptSheet = this.QOIV.getDHTMLRptSheet(string, string2, string3);
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            if (dHTMLRptSheet != null) {
                dHTMLRptSheet.publishCss(printWriter);
            }
            printWriter.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (JDLog.isError((int)3)) {
                JDLog.error((int)3, (Throwable)exception);
            }
            byArray = new byte[]{};
            return byArray;
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    class StringBufferStream {
        private StringBuffer QOIV;
        private final DHTMLWriterImpl this$0;

        public StringBufferStream(DHTMLWriterImpl dHTMLWriterImpl) {
            this.this$0 = dHTMLWriterImpl;
            this.QOIV = null;
            this.QOIV = new StringBuffer();
        }

        public StringBuffer write(String string) {
            return this.QOIV.append(string);
        }

        public StringBuffer print(boolean bl) {
            return this.QOIV.append(bl);
        }

        public StringBuffer print(int n) {
            return this.QOIV.append(n);
        }

        public StringBuffer print(String string) {
            return this.QOIV.append(string);
        }

        public StringBuffer println(String string) {
            return this.QOIV.append(string + "/r/n");
        }

        public String toString() {
            return this.QOIV.toString();
        }
    }
}

