/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import jet.webreport.util.JNode;
import jet.webreport.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class JNode
implements Serializable {
    private static final long serialVersionUID = -7423997138864004151L;
    public static final transient String TAG_SURFIX = ".tag";
    public static final transient String ATT_PREFIX = "att.";
    public static final transient String MAP_SURFIX = ".map";
    public static final transient String HIDE_SURFIX = ".hide";
    public static final transient String NODE_TYPE = "node.type";
    public static final transient String NODE_NAME = "node.name";
    public static final transient String NODE_VALU = "node.value";
    public static final transient String NODE_DESC = "node.desc";
    public static final transient String NODE_PATH = "node.path";
    public static final transient String NODE_ID = "node.id";
    public static final transient String TYPE_ROOT = "root";
    private Properties attrs = new Properties();
    private LinkedList children = new LinkedList();
    private String text;
    private String path_prefix = "/";
    private JNode parent = null;

    public JNode(String string) {
        this.attrs.setProperty(NODE_TYPE, string == null ? "UNKNOWN" : string);
    }

    public JNode(String string, String string2, String string3, String string4) {
        this(string);
        this.setName(string2);
        this.setValue(string3);
        this.setDescription(string4);
    }

    public String getAttribute(String string) {
        return this.attrs.getProperty(string, "");
    }

    public void setAttribute(String string, String string2) {
        if (string2 != null) {
            this.attrs.setProperty(string, string2);
        }
    }

    public Iterator getAttributeNames() {
        return this.attrs.keySet().iterator();
    }

    public String getType() {
        return this.getAttribute(NODE_TYPE);
    }

    public String getName() {
        return this.getAttribute(NODE_NAME);
    }

    public void setName(String string) {
        this.setAttribute(NODE_NAME, string);
    }

    public String getValue() {
        return this.getAttribute(NODE_VALU);
    }

    public void setValue(String string) {
        this.setAttribute(NODE_VALU, string);
    }

    public String getDescription() {
        return this.getAttribute(NODE_DESC);
    }

    public void setDescription(String string) {
        this.setAttribute(NODE_DESC, string);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getPath() {
        if (this.parent == null) {
            return this.path_prefix;
        }
        class Stack
        extends ArrayList {
            private final JNode this$0;

            Stack(JNode jNode) {
                this.this$0 = jNode;
            }

            void I(String string) {
                this.add(0, string);
            }

            String I() {
                return (String)this.remove(0);
            }
        }
        Stack stack = new Stack(this);
        stack.I(this.getName());
        JNode jNode = this.parent;
        while (jNode != null) {
            stack.I(jNode.getName());
            jNode = jNode.parent;
        }
        StringBuffer stringBuffer = new StringBuffer(this.path_prefix);
        while (!stack.isEmpty()) {
            if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                stringBuffer.append("/");
            }
            String string = stack.I();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setPathPrefix(String string) {
        this.path_prefix = string;
    }

    public String getID() {
        return JNode.getPathID(this.getPath());
    }

    public static String getPathID(String string) {
        return Integer.toHexString(string.hashCode());
    }

    public int size() {
        return this.children.size();
    }

    public Iterator getChildren() {
        return this.children.iterator();
    }

    public void addChild(JNode jNode) {
        this.addChild(this.children.size(), jNode);
    }

    public void addChild(int n, JNode jNode) {
        this.children.add(n, jNode);
        jNode.parent = this;
    }

    public JNode getChild(int n) {
        return (JNode)this.children.get(n);
    }

    public JNode getChild(String string) {
        int n = this.indexOfChild(string);
        if (n < 0) {
            return null;
        }
        return this.getChild(n);
    }

    public JNode removeChild(int n) {
        return (JNode)this.children.remove(n);
    }

    public JNode removeChild(String string) {
        int n = this.indexOfChild(string);
        if (n < 0) {
            return null;
        }
        return this.removeChild(n);
    }

    public int indexOfChild(String string) {
        class Dumb {
            String s;
            private final JNode this$0;

            Dumb(JNode jNode, String string) {
                this.this$0 = jNode;
                this.s = string;
            }

            public int hashCode() {
                return this.s.hashCode();
            }

            public boolean equals(Object object) {
                return this.hashCode() == object.hashCode();
            }
        }
        return this.children.indexOf(new Dumb(this, string));
    }

    public String[] getChildNames() {
        int n = this.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getChild(n2).getName();
            ++n2;
        }
        return stringArray;
    }

    public boolean isRoot() {
        return TYPE_ROOT.equals(this.getType());
    }

    public void clear() {
        this.attrs.clear();
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            JNode jNode = (JNode)iterator.next();
            jNode.clear();
            iterator.remove();
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static JNode clone(JNode jNode) {
        String string;
        JNode jNode2 = new JNode(jNode.getType());
        Iterator iterator = jNode.getAttributeNames();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            jNode2.setAttribute(string, jNode.getAttribute(string));
        }
        string = jNode.getText();
        jNode2.setText(string);
        return jNode2;
    }

    public String toXML(Properties properties) {
        return JNode.writeXML(this, properties).toString();
    }

    public static StringBuffer writeXML(JNode jNode, Properties properties) {
        properties = XMLUtil.initProperties(properties);
        StringBuffer stringBuffer = new StringBuffer("");
        if (jNode == null) {
            return stringBuffer;
        }
        String string = properties.getProperty("xml.encoding", XMLUtil.ENCODING);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append(string).append("\"?>");
        JNode.ENCODING(jNode, stringBuffer, 0, properties);
        return stringBuffer;
    }

    private static void ENCODING(JNode jNode, StringBuffer stringBuffer, int n, Properties properties) {
        properties = XMLUtil.initProperties(properties);
        if (jNode == null) {
            return;
        }
        String string = properties.getProperty(jNode.getType() + HIDE_SURFIX, "0");
        int n2 = Integer.parseInt(string);
        switch (n2) {
            case 1: {
                Iterator iterator = jNode.getChildren();
                while (iterator.hasNext()) {
                    JNode jNode2 = (JNode)iterator.next();
                    JNode.ENCODING(jNode2, stringBuffer, n, properties);
                }
                break;
            }
            case 2: {
                break;
            }
            default: {
                JNode.INDENT(jNode, stringBuffer, n, properties);
            }
        }
    }

    private static void INDENT(JNode jNode, StringBuffer stringBuffer, int n, Properties properties) {
        String string;
        Object object;
        String string2;
        boolean bl = Boolean.valueOf(properties.getProperty("xml.indent", Boolean.toString(XMLUtil.INDENT)));
        stringBuffer.append("\r\n");
        if (bl) {
            int n2 = 0;
            while (n2 < n << 2) {
                stringBuffer.append(' ');
                ++n2;
            }
        }
        stringBuffer.append("<");
        String string3 = jNode.getType();
        String string4 = properties.getProperty(string3 + TAG_SURFIX, string3);
        stringBuffer.append(string4).append(" ");
        Iterator iterator = jNode.getAttributeNames();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            object = "src".equals(string2) ? jNode.getAttribute(string2) + jNode.getPath() : jNode.getAttribute(string2);
            object = XMLUtil.normalize((String)object);
            string = properties.getProperty(string2 + MAP_SURFIX, string2);
            stringBuffer.append(string).append("=\"").append((String)object).append("\" ");
        }
        iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.startsWith(ATT_PREFIX)) continue;
            object = properties.getProperty(string2);
            string2 = properties.getProperty(jNode.getType() + "." + (String)object);
            if (string2 == null) continue;
            string = XMLUtil.normalize(string2);
            stringBuffer.append((String)object).append("=\"").append(string).append("\" ");
        }
        stringBuffer.append(NODE_ID).append("=\"").append(jNode.getID()).append("\" ");
        string2 = XMLUtil.normalize(jNode.getText());
        if (string2 != null && string2.length() != 0) {
            stringBuffer.append(">");
            stringBuffer.append(string2);
        }
        if (jNode.size() != 0) {
            stringBuffer.append(">");
            iterator = jNode.getChildren();
            while (iterator.hasNext()) {
                object = (JNode)iterator.next();
                JNode.ENCODING((JNode)object, stringBuffer, n + 1, properties);
            }
            stringBuffer.append("\r\n</").append(string4).append(">");
        } else if (string2 != null && string2.length() != 0) {
            stringBuffer.append("</").append(string4).append(">");
        } else {
            stringBuffer.append("/>");
        }
    }

    public static Document toDocument(JNode jNode, Properties properties) {
        properties = XMLUtil.initProperties(properties);
        if (jNode == null) {
            return null;
        }
        Document document = XMLUtil.newDocument();
        Element element = jNode.QOIV(document, null, properties);
        document.appendChild(element);
        return document;
    }

    private Element QOIV(Document document, Element element, Properties properties) {
        String string = this.getType();
        String string2 = properties.getProperty(string + TAG_SURFIX, string);
        if (element == null) {
            Element element2 = document.createElement(string2);
            this.add(element2, properties);
            Iterator iterator = this.getChildren();
            this.Z(document, element2, iterator, properties);
            return element2;
        }
        String string3 = properties.getProperty(this.getType() + HIDE_SURFIX, "0");
        int n = Integer.parseInt(string3);
        Iterator iterator = null;
        switch (n) {
            case 1: {
                iterator = this.getChildren();
                this.Z(document, element, iterator, properties);
                break;
            }
            case 2: {
                break;
            }
            default: {
                Element element3 = document.createElement(string2);
                this.add(element3, properties);
                element.appendChild(element3);
                iterator = this.getChildren();
                this.Z(document, element3, iterator, properties);
            }
        }
        return null;
    }

    private void Z(Document document, Element element, Iterator iterator, Properties properties) {
        Object object;
        while (iterator.hasNext()) {
            object = (JNode)iterator.next();
            super.QOIV(document, element, properties);
        }
        object = this.getText();
        if (object != null) {
            element.appendChild(document.createTextNode((String)object));
        }
    }

    private void add(Element element, Properties properties) {
        String string;
        String string2;
        Iterator<Object> iterator = this.getAttributeNames();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = this.getAttribute(string2);
            string2 = properties.getProperty(string2 + MAP_SURFIX, string2);
            element.setAttribute(string2, string);
        }
        iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.startsWith(ATT_PREFIX)) continue;
            string = properties.getProperty(string2);
            String string3 = properties.getProperty(this.getType() + "." + string);
            if (string3 == null) continue;
            element.setAttribute(string, string3);
        }
    }
}

