/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLUtil {
    public static final String XML_ENCODING = "xml.encoding";
    public static final String XML_INDENT = "xml.indent";
    public static final String ENCODING = System.getProperty("xml.encoding", "UTF-8");
    public static final boolean INDENT = Boolean.valueOf(System.getProperty("xml.indent", "false"));

    public static Document newDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public static StringBuffer write(Document document, Properties properties) {
        properties = XMLUtil.initProperties(properties);
        StringBuffer stringBuffer = new StringBuffer("");
        XMLUtil.print(document, stringBuffer, 0, properties);
        return stringBuffer;
    }

    public static void write(Document document, String string, Properties properties) throws IOException {
        properties = XMLUtil.initProperties(properties);
        StringBuffer stringBuffer = XMLUtil.write(document, properties);
        String string2 = properties.getProperty(XML_ENCODING, ENCODING);
        XMLUtil.write(string, stringBuffer.toString(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void write(String string, String string2, String string3) throws IOException {
        block8: {
            BufferedWriter bufferedWriter = null;
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(string)), string3));
            bufferedWriter.write(string2);
            Object var6_4 = null;
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
            break block8;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var6_5 = null;
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static void print(Node node, StringBuffer stringBuffer, int n, Properties properties) {
        int n2;
        if (node == null) {
            return;
        }
        String string = properties.getProperty(XML_ENCODING, ENCODING);
        boolean bl = Boolean.valueOf(properties.getProperty(XML_INDENT, Boolean.toString(INDENT)));
        boolean bl2 = true;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append(string).append("\"?>");
                XMLUtil.print(((Document)node).getDocumentElement(), stringBuffer, n, properties);
                break;
            }
            case 1: {
                Object object;
                stringBuffer.append("\r\n");
                if (bl) {
                    n2 = 0;
                    while (n2 < 4 * n) {
                        stringBuffer.append(' ');
                        ++n2;
                    }
                }
                stringBuffer.append("<");
                stringBuffer.append(node.getNodeName());
                Attr[] attrArray = XMLUtil.ENCODING(node.getAttributes());
                int n3 = 0;
                while (n3 < attrArray.length) {
                    object = attrArray[n3];
                    stringBuffer.append(' ');
                    stringBuffer.append(object.getNodeName());
                    stringBuffer.append("=\"");
                    stringBuffer.append(XMLUtil.normalize(object.getNodeValue()));
                    stringBuffer.append('\"');
                    ++n3;
                }
                object = node.getChildNodes();
                if (object == null || object.getLength() == 0) {
                    bl2 = false;
                    stringBuffer.append(' ').append("/>");
                    break;
                }
                stringBuffer.append('>');
                int n4 = object.getLength();
                if (n4 == 1 && object.item(0).getNodeType() == 3) {
                    XMLUtil.print(object.item(0), stringBuffer, 0, properties);
                    stringBuffer.append("</");
                    stringBuffer.append(node.getNodeName());
                    stringBuffer.append('>');
                    bl2 = false;
                    break;
                }
                int n5 = 0;
                while (n5 < n4) {
                    XMLUtil.print(object.item(n5), stringBuffer, n + 1, properties);
                    ++n5;
                }
                break;
            }
            case 5: {
                stringBuffer.append('&');
                stringBuffer.append(node.getNodeName());
                stringBuffer.append(';');
                break;
            }
            case 4: {
                stringBuffer.append("\r\n<![CDATA[");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append("]]>");
                break;
            }
            case 3: {
                stringBuffer.append(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                stringBuffer.append("\r\n");
                if (bl) {
                    n2 = 0;
                    while (n2 < 4 * n) {
                        stringBuffer.append(' ');
                        ++n2;
                    }
                }
                stringBuffer.append("<?");
                stringBuffer.append(node.getNodeName());
                Attr[] attrArray = node.getNodeValue();
                if (attrArray != null && attrArray.length() > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append((String)attrArray);
                }
                stringBuffer.append("?>");
                break;
            }
            case 8: {
                stringBuffer.append("\r\n");
                if (bl) {
                    n2 = 0;
                    while (n2 < 4 * n) {
                        stringBuffer.append(' ');
                        ++n2;
                    }
                }
                stringBuffer.append("<!-- ").append(node.getNodeValue()).append(" -->");
                break;
            }
        }
        if (bl2 && s == 1) {
            stringBuffer.append("\r\n");
            if (bl) {
                n2 = 0;
                while (n2 < 4 * n) {
                    stringBuffer.append(' ');
                    ++n2;
                }
            }
            stringBuffer.append("</");
            stringBuffer.append(node.getNodeName());
            stringBuffer.append('>');
        }
    }

    private static Attr[] ENCODING(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        while (n2 < n) {
            attrArray[n2] = (Attr)namedNodeMap.item(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            Object object;
            Object object2 = null;
            object2 = attrArray[n3].getNodeName();
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n) {
                object = null;
                object = attrArray[n5].getNodeName();
                if (((String)object).compareTo((String)object2) < 0) {
                    object2 = object;
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                object = attrArray[n3];
                attrArray[n3] = attrArray[n4];
                attrArray[n4] = object;
            }
            ++n3;
        }
        return attrArray;
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static Properties initProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
            properties.setProperty(XML_ENCODING, ENCODING);
            properties.setProperty(XML_INDENT, Boolean.toString(INDENT));
        }
        return properties;
    }
}

