/*
 * Decompiled with CFR 0.152.
 */
package jet.ws.xfire.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import jet.server.api.PathInfo;
import jet.server.api.ReportInfo;
import jet.server.api.ResourceManager;
import jet.server.api.RptServerException;
import jet.server.api.VersionRecord;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.resource.PathInfoImpl;
import jet.server.log.ServiceLogger;
import jet.ws.bean.ResourceNodeBean;
import jet.ws.xfire.server.impl.ReportParameters;
import jet.ws.xfire.server.service.JReportServerWs;

public class JReportServerWsImpl
implements JReportServerWs {
    private String QOIV(String string, String string2) throws RptServerException {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ResourceManager resourceManager = httpRptServer.getResourceManager();
        PathInfo pathInfo = resourceManager.getPathInfo(string, string2);
        if (pathInfo.getParentPath() == null) {
            ((PathInfoImpl)pathInfo).setParentPath(pathInfo.getPath().substring(0, pathInfo.getPath().lastIndexOf("/") + 1));
        }
        String string3 = null;
        if (pathInfo.getLinkedCatalog() != null && pathInfo.getLinkedCatalog().length() != 0) {
            string3 = pathInfo.getLinkedCatalog();
        } else {
            Vector vector = resourceManager.getCatalogsInPath(string, pathInfo.getParentPath());
            if (vector != null && vector.size() > 0) {
                string3 = ((PathInfo)vector.get(0)).getPath();
            }
        }
        return string3;
    }

    public Collection getFoldersInPath(String string, String string2) {
        ArrayList<ResourceNodeBean> arrayList = new ArrayList<ResourceNodeBean>();
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        try {
            Vector vector = httpRptServer.getResourceManager().getFoldersInPath(string, string2);
            int n = 0;
            while (n < vector.size()) {
                PathInfo pathInfo = (PathInfo)vector.get(n);
                if (!"/USERFOLDERPATH".equals(pathInfo.getPath())) {
                    ResourceNodeBean resourceNodeBean = new ResourceNodeBean();
                    resourceNodeBean.setAbsolutePath(pathInfo.getPath());
                    resourceNodeBean.setParentPath(pathInfo.getParentPath());
                    resourceNodeBean.setUserID(string);
                    resourceNodeBean.setIsFolder(pathInfo.isDir());
                    resourceNodeBean.setIsReport(pathInfo.isReport());
                    arrayList.add(resourceNodeBean);
                }
                ++n;
            }
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return arrayList;
    }

    public Collection getReportsInPath(String string, String string2) {
        ArrayList<ResourceNodeBean> arrayList = new ArrayList<ResourceNodeBean>();
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        try {
            Vector vector = httpRptServer.getResourceManager().getReportsInPath(string, string2);
            int n = 0;
            while (n < vector.size()) {
                PathInfo pathInfo = (PathInfo)vector.get(n);
                if (this.add(pathInfo)) {
                    ResourceNodeBean resourceNodeBean = new ResourceNodeBean();
                    resourceNodeBean.setAbsolutePath(pathInfo.getPath());
                    resourceNodeBean.setParentPath(pathInfo.getParentPath());
                    resourceNodeBean.setUserID(string);
                    resourceNodeBean.setIsFolder(pathInfo.isDir());
                    resourceNodeBean.setIsReport(pathInfo.isReport());
                    arrayList.add(resourceNodeBean);
                }
                ++n;
            }
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return arrayList;
    }

    private boolean add(PathInfo pathInfo) {
        try {
            String string = pathInfo.getPath();
            String string2 = pathInfo.getUserID();
            String string3 = this.QOIV(string2, string);
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            ReportInfo reportInfo = httpRptServer.getReportInfo(string2, string3, string);
            return reportInfo.isPortletPreferred();
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError(rptServerException);
            return false;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    private String addResource(String string, String string2, String string3, Properties properties) {
        String string4 = null;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        try {
            PathInfo pathInfo = httpRptServer.getResourceManager().getPathInfo(string, string2);
            if (pathInfo.isReport()) {
                String string5 = pathInfo.getRealPath();
                Hashtable[] hashtableArray = new Hashtable[3];
                properties.put("jrs.node_name", pathInfo.getName());
                properties.put("jrs.node_type", String.valueOf(0));
                properties.put("jrs.deploy_from_file", string5);
                VersionRecord versionRecord = httpRptServer.getResourceManager().addResource(string, string3, false, properties, hashtableArray);
                string4 = versionRecord.getResourcePath();
            } else if (pathInfo.isCatalog()) {
                String string6 = pathInfo.getRealPath();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                Hashtable[] hashtableArray = new Hashtable[3];
                hashtable.put("jrs.node_name", pathInfo.getName());
                hashtable.put("jrs.node_type", String.valueOf(2));
                hashtable.put("jrs.deploy_from_file", string6);
                VersionRecord versionRecord = httpRptServer.getResourceManager().addResource(string, string3, false, hashtable, hashtableArray);
                string4 = versionRecord.getResourcePath();
            }
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError(rptServerException);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return string4;
    }

    public void copyReport(String string, String string2, String string3) {
        String string4 = null;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        try {
            PathInfo pathInfo = httpRptServer.getResourceManager().getPathInfo(string, string2);
            if (pathInfo.isReport()) {
                Properties properties = new Properties();
                String string5 = this.QOIV(string, string2);
                properties.put("jrs.enable.linked.catalog", String.valueOf(true));
                properties.put("jrs.linked.catalog", string5);
                string4 = this.addResource(string, string2, string3, properties);
            }
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError(rptServerException);
        }
    }

    public void setNodeProperties(String string, String string2, Hashtable hashtable) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        try {
            httpRptServer.getResourceManager().setNodeProperties(string, string2, hashtable, null);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
        }
        catch (NodeExistsException nodeExistsException) {
            ServiceLogger.logError(nodeExistsException);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
        }
    }

    public void renameNode(String string, String string2, String string3) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        try {
            PathInfo pathInfo = httpRptServer.getResourceManager().getPathInfo(string, string2);
            Properties properties = new Properties();
            properties.put("jrs.node_name", string3);
            properties.put("jrs.node_desc", pathInfo.getDescription());
            properties.put("jrs.enable.linked.catalog", String.valueOf(pathInfo.isEnableLinkedCatalog()));
            properties.put("jrs.is.use.inherited", String.valueOf(pathInfo.isUseInherited()));
            String string4 = pathInfo.getLinkedCatalog();
            if (string4 != null) {
                properties.put("jrs.linked.catalog", string4);
            }
            properties.put("jrs.enable_archive_policy", String.valueOf(pathInfo.isEnableArchivePolicy()));
            properties.put("jrs.archive_new_version", String.valueOf(pathInfo.isArchiveNewVersion()));
            properties.put("jrs.maxversion", String.valueOf(pathInfo.getMaxVersionAmount()));
            String string5 = pathInfo.getProfileName();
            if (string5 != null) {
                properties.put("jrs.profile", string5);
            }
            httpRptServer.getResourceManager().setNodeProperties(string, string2, properties, null);
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError(rptServerException);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
        }
        catch (NodeExistsException nodeExistsException) {
            ServiceLogger.logError(nodeExistsException);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
        }
    }

    public void removeNode(String string, String string2) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        try {
            httpRptServer.getResourceManager().removeNode(string, string2);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
        }
    }

    public DataHandler getParameterPanel(String string, Map map) {
        String string2;
        Object object;
        Properties properties = new Properties();
        if (map != null) {
            object = map.keySet().iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                String string3 = (String)map.get(string2);
                properties.setProperty(string2, string3);
            }
        }
        try {
            if (properties.get("jrs.catalog") == null && (string2 = this.QOIV(string, (String)(object = (String)properties.get("jrs.report")))) != null) {
                properties.put("jrs.catalog", string2);
            }
            object = new ByteArrayDataSource(new ReportParameters().getParameterPanel(string, properties), "text/plain; charset=UTF-8");
            return new DataHandler((DataSource)object);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            return null;
        }
    }

    public boolean hasReportParam(String string, Map map) {
        boolean bl = false;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        String string2 = (String)map.get("jrs.catalog");
        String string3 = (String)map.get("jrs.report");
        try {
            if (string2 == null || string2.length() == 0) {
                string2 = this.QOIV(string, string3);
            }
            ReportInfo reportInfo = httpRptServer.getReportInfo(string, string2, -1, string3, -1, null);
            bl = reportInfo.hasReportParam(1);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            bl = false;
        }
        return bl;
    }

    public String validateParameter(String string, Map map) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        String string2 = null;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        String string3 = (String)properties.get("jrs.catalog");
        String string4 = (String)properties.get("jrs.report");
        try {
            if (string3 == null || string3.length() == 0) {
                string3 = this.QOIV(string, string4);
            }
            ReportInfo reportInfo = httpRptServer.getReportInfo(string, string3, -1, string4, -1, properties);
            string2 = reportInfo.validateParameter(1, properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            string2 = "Error: " + exception.getMessage();
        }
        return string2;
    }

    public boolean isNodeExist(String string, String string2) {
        boolean bl = false;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        bl = httpRptServer.getResourceManager().isNodeExist(string2, string);
        if (bl) {
            try {
                PathInfo pathInfo = httpRptServer.getResourceManager().getPathInfo(string, string2);
                if (pathInfo.isReport() && !this.add(pathInfo)) {
                    bl = false;
                }
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError(rptServerException);
                bl = false;
            }
        }
        return bl;
    }

    public Collection getAllUsers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            Enumeration enumeration = httpRptServer.getAdminService().getSecurityAdminService().getAllUserNames(httpRptServer.getAdminService().getSecurityAdminService().getActiveRealm());
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                arrayList.add(string);
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError(noSuchRealmException);
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError(badRealmException);
        }
        return arrayList;
    }
}

