/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.JSRuntimeException;
import server.servlet.ServletConnection;
import server.servlet.http.CacheControlHeader;
import server.servlet.http.HttpOutputStream;
import server.servlet.http.HttpSessionImpl;
import server.servlet.http.MimeHeaders;
import server.servlet.http.OldCookieExpiry;

public class HttpResponse
implements HttpServletResponse,
Observer,
Cloneable {
    public static boolean KeepAliveInitValue = false;
    public static String outputEncoding = null;
    protected int status;
    protected String reason;
    protected String protocol;
    protected final MimeHeaders headers = new MimeHeaders();
    protected HttpOutputStream out = this.createHttpOutputStream();
    protected HttpOutputStream outHeader = this.createHttpOutputStream();
    protected ByteArrayOutputStream bufHeader = new ByteArrayOutputStream();
    protected ServletConnection con;
    protected int headerBytes;
    protected boolean keepAlive;
    protected boolean printKeepAlive = false;
    protected boolean contentLenSet = false;
    protected HttpSessionImpl session;
    private boolean QOIV = false;
    private String addCookie;
    private PrintWriter addStringDirective;
    private String append;
    private boolean appendHeader;
    private boolean charAt;

    private void KeepAliveInitValue(int n, StringBuffer stringBuffer, String string) {
        if (n == 0 || this.QOIV(string)) {
            stringBuffer.append(string);
            return;
        }
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
    }

    private boolean QOIV(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < ' ' || c >= '\u007f' || "()<>@,;:\\\"/[]?={} \t".indexOf(c) != -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void addCookie(Cookie cookie) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string = cookie.getName();
        String string2 = cookie.getValue();
        String string3 = cookie.getDomain();
        String string4 = cookie.getPath();
        String string5 = cookie.getComment();
        int n = cookie.getMaxAge();
        int n2 = cookie.getVersion();
        boolean bl = cookie.getSecure();
        stringBuffer.append(string);
        stringBuffer.append("=");
        this.KeepAliveInitValue(n2, stringBuffer, string2);
        if (n2 == 1) {
            stringBuffer.append(";Version=1");
            if (string5 != null) {
                stringBuffer.append(";Comment=");
                this.KeepAliveInitValue(n2, stringBuffer, string5);
            }
        }
        if (string3 != null) {
            stringBuffer.append(";Domain=");
            this.KeepAliveInitValue(n2, stringBuffer, string3);
        }
        if (n >= 0) {
            if (n2 == 0) {
                stringBuffer.append(";Expires=");
                new OldCookieExpiry(n).I(stringBuffer);
            } else {
                stringBuffer.append(";MaxAge=");
                stringBuffer.append(n);
            }
        } else if (n2 == 1) {
            stringBuffer.append(";Discard");
        }
        if (string4 != null) {
            stringBuffer.append(";Path=");
            this.KeepAliveInitValue(n2, stringBuffer, string4);
        }
        if (bl) {
            stringBuffer.append(";Secure");
        }
        if (n2 == 1) {
            object = (Cookie)cookie.clone();
            this.appendHeader("Set-Cookie2", stringBuffer.toString());
            object.setVersion(0);
            this.addCookie((Cookie)object);
        } else {
            this.appendHeader("Set-Cookie", stringBuffer.toString());
        }
        object = this.headers.getHeader("Cache-Control");
        CacheControlHeader cacheControlHeader = new CacheControlHeader((String)object);
        Enumeration enumeration = cacheControlHeader.getStringDirective("no-cache");
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            if (!string6.equals("set-cookie")) continue;
            return;
        }
        cacheControlHeader.addStringDirective("no-cache", "set-cookie");
        cacheControlHeader.addStringDirective("no-cache", "set-cookie2");
        this.headers.putHeader("Cache-Control", cacheControlHeader.toString());
        if (this.headers.getHeader("Expires") == null) {
            this.headers.putHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        }
    }

    public void init(ServletConnection servletConnection) throws IOException {
        this.con = servletConnection;
        this.keepAlive = KeepAliveInitValue;
        this.out.init(servletConnection.getOutputStream());
    }

    private void init() {
        this.headers.clear();
        this.addCookie = null;
        this.addStringDirective = null;
        this.append = null;
        this.charAt = false;
        this.appendHeader = false;
        this.session = null;
        this.QOIV = false;
    }

    public void next() {
        this.init();
        this.printKeepAlive = false;
        this.contentLenSet = false;
        this.status = 200;
        this.reason = this.reason(200);
        this.protocol = null;
        this.headerBytes = 0;
        this.out.next();
    }

    public void finish() throws IOException {
        if (this.addStringDirective != null) {
            this.addStringDirective.flush();
        }
        this.out.close();
    }

    public void reset() {
        this.out.resets();
    }

    public int getTotalBytes() {
        return this.out.getTotal();
    }

    public int getEntityBytes() {
        int n = this.contentLenSet ? this.out.getContentLength() : this.out.getTotal() - this.headerBytes;
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public void setProtocol(String string) {
        this.protocol = string;
        this.out.setObserver(this);
    }

    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void printKeepAlive() {
        this.printKeepAlive = true;
    }

    public void setContentLength(int n) {
        this.contentLenSet = true;
        this.setIntHeader("Content-Length", n);
        this.out.setContentLength(n);
    }

    public void setContentType(String string) {
        if (string.equalsIgnoreCase(this.addCookie)) {
            return;
        }
        if (string.endsWith("charset=ISO-8859-1")) {
            int n = string.length() - 18;
            while (string.charAt(n) != ';') {
                --n;
            }
            string = string.substring(0, n);
        }
        this.addCookie = string;
        this.setHeader("Content-Type", string);
    }

    public ServletOutputStream getOutputStream() {
        if (this.appendHeader) {
            throw new IllegalStateException("can't mix text and binary input");
        }
        this.charAt = true;
        return this.out;
    }

    public void reinitStreamState() {
        if (this.appendHeader) {
            throw new IllegalStateException("can't reset stream state, writer's been gotten");
        }
        this.charAt = false;
    }

    /*
     * Unable to fully structure code
     */
    public static String getContentCharset(String var0) {
        var1_1 = HttpResponse.outputEncoding == null ? "ISO-8859-1" : HttpResponse.outputEncoding;
        var2_2 = 0;
        if (var0 != null) ** GOTO lbl23
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var3_3 = (var0 = var0.substring(var2_2 + 1)).substring(0, var2_2 = var0.indexOf(61)).trim().toLowerCase();
            if (!"charset".equals(var3_3)) continue;
            var1_1 = var0.substring(var2_2 + 1);
            if ((var2_2 = var1_1.indexOf(59)) > 0) {
                var1_1 = var1_1.substring(0, var2_2);
            }
            if ((var1_1 = var1_1.trim()).charAt(0) == '\"') {
                var2_2 = 1;
                while ((var2_2 = var1_1.indexOf(34, var2_2)) > 0 && var1_1.charAt(var2_2 - 1) == '\\') {
                }
                if (var2_2 > 0) {
                    var1_1 = var1_1.substring(1, var2_2);
                    break;
                }
                var1_1 = HttpResponse.outputEncoding == null ? "ISO-8859-1" : HttpResponse.outputEncoding;
                break;
            }
            var2_2 = var1_1.indexOf(40);
            if (var2_2 <= 0) break;
            var1_1 = var1_1.substring(0, var2_2).trim();
            break;
lbl23:
            // 2 sources

            ** while ((var2_2 = var0.indexOf((int)59)) > 0)
        }
lbl24:
        // 5 sources

        if (var1_1.equalsIgnoreCase("us-ascii")) {
            var1_1 = "ISO-8859-1";
        }
        return var1_1;
    }

    public String getCharacterEncoding() {
        if (this.append == null) {
            if (this.addCookie == null) {
                this.setContentType("text/plain");
            } else {
                this.append = HttpResponse.getContentCharset(this.addCookie);
            }
        }
        if (this.append == null) {
            StringBuffer stringBuffer = new StringBuffer(this.addCookie);
            this.append = this.chooseCharacterEncoding();
            stringBuffer.append(";charset=\"");
            stringBuffer.append(this.append);
            stringBuffer.append("\"");
            this.addCookie = stringBuffer.toString();
            this.setHeader("Content-Type", this.addCookie);
        }
        return this.append;
    }

    protected String chooseCharacterEncoding() {
        return outputEncoding == null ? "ISO-8859-1" : outputEncoding;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.charAt) {
            throw new IllegalStateException("can't mix text and binary input");
        }
        if (this.addStringDirective == null) {
            this.appendHeader = true;
            this.addStringDirective = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.out), this.getCharacterEncoding()));
        }
        return this.addStringDirective;
    }

    public void setStatus(int n, String string) {
        this.status = n;
        this.reason = string;
    }

    public void setStatus(int n) {
        this.setStatus(n, this.reason(n));
    }

    public int getStatus() {
        return this.status;
    }

    public void appendHeader(String string, String string2) {
        this.headers.I(string, string2);
    }

    public void setHeader(String string, String string2) {
        this.headers.putHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.headers.putIntHeader(string, n);
    }

    public void setDateHeader(String string, long l) {
        this.headers.putDateHeader(string, l);
    }

    public void setDateHeader(String string) {
        this.headers.putDateHeader(string);
    }

    public boolean containsHeader(String string) {
        return this.headers.containsHeader(string);
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    protected String reason(int n) {
        switch (n) {
            case 101: {
                return "Switching Protocols";
            }
            case 100: {
                return "Continue";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 415: {
                return "Unsuppored Media Type";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return "Unknown";
    }

    public void sendError(int n, String string) throws IOException {
        String string2;
        this.keepAlive = false;
        HttpOutputStream httpOutputStream = this.out;
        if (httpOutputStream.isCommitted()) {
            return;
        }
        String string3 = this.headers.getHeader("Server");
        String string4 = this.headers.getHeader("WWW-Authenticate");
        String string5 = this.headers.getHeader("Proxy-Authenticate");
        this.headers.clear();
        httpOutputStream.next();
        httpOutputStream.setObserver(this);
        httpOutputStream.setIOException(null);
        this.setStatus(n);
        if (string3 != null) {
            this.setHeader("Server", string3);
        }
        if (string4 != null) {
            this.setHeader("WWW-Authenticate", string4);
        }
        if (string5 != null) {
            this.setHeader("Proxy-Authenticate", string5);
        }
        this.addCookie = null;
        this.setContentType("text/html");
        String string6 = string2 = n + " " + this.reason(n);
        String string7 = string;
        if (n == 404 || n == 403) {
            string6 = "The specified page does not exist.";
            string7 = "\tThere might be a typing error in the address, if you clicked on a link, it may be out of date. You can retype the address or go back to the previous page.\n";
        }
        StringBuffer stringBuffer = this.addCookie(string6, string6, string7);
        this.setContentLength(stringBuffer.length());
        httpOutputStream.print(stringBuffer.toString());
        httpOutputStream.flush();
        httpOutputStream.finish();
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, this.reason(n));
    }

    public void sendRedirect(String string) throws IOException {
        HttpOutputStream httpOutputStream = this.out;
        if (httpOutputStream.getTotal() != 0) {
            return;
        }
        this.setStatus(302);
        this.addCookie = null;
        this.setContentType("text/html");
        this.setHeader("Location", string);
        StringBuffer stringBuffer = new StringBuffer(140 + string.length());
        stringBuffer.append("<head><title>Document moved</title></head>\n");
        stringBuffer.append("<body><h1>Document moved</h1>\n");
        stringBuffer.append("This document has moved <a href=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">here</a>.<p>\n");
        stringBuffer.append("</body>\n");
        this.setContentLength(stringBuffer.length());
        httpOutputStream.print(stringBuffer.toString());
        httpOutputStream.finish();
    }

    public void update(Observable observable, Object object) {
        HttpOutputStream httpOutputStream;
        try {
            httpOutputStream = (HttpOutputStream)((Object)object);
        }
        catch (ClassCastException classCastException) {
            throw new InternalError("update called with invalid argument type");
        }
        try {
            if (!this.QOIV) {
                this.writeHeaders();
            }
        }
        catch (IOException iOException) {
            httpOutputStream.setIOException(iOException);
        }
    }

    public void setHttpSession(HttpSession httpSession) {
        this.session = (HttpSessionImpl)httpSession;
        if (this.session != null && this.session.isNew() && this.session.isUsingCookies()) {
            this.addCookie(this.session.getCookie());
        }
    }

    public String encodeURL(String string) {
        return this.encodeUrl(string);
    }

    public String encodeUrl(String string) {
        return string;
    }

    public String encodeRedirectURL(String string) {
        return string;
    }

    public String encodeRedirectUrl(String string) {
        return string;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new JSRuntimeException(670017);
        }
    }

    protected HttpOutputStream createHttpOutputStream() {
        return new HttpOutputStream();
    }

    public void unsetContentLength() {
        this.contentLenSet = false;
        this.setKeepAlive(false);
        this.headers.removeHeader("Content-Length");
        this.out.unsetContentLength();
    }

    public void setHeadersWritten() {
        this.QOIV = true;
    }

    protected void writeHeaders() throws IOException {
        this.QOIV = true;
        this.bufHeader.reset();
        this.outHeader.next();
        this.outHeader.init(this.bufHeader);
        this.outHeader.print(this.protocol);
        this.outHeader.write(32);
        if (this.status == 403) {
            this.outHeader.print(404);
        } else {
            this.outHeader.print(this.status);
        }
        this.outHeader.write(32);
        if (this.keepAlive) {
            int n = this.out.getContentLength();
            if (n != -1) {
                if (!this.contentLenSet) {
                    this.headers.putIntHeader("Content-Length", n);
                }
                if (this.printKeepAlive) {
                    this.headers.putHeader("Connection", "Keep-Alive");
                }
            } else {
                this.keepAlive = false;
                this.headers.putHeader("Connection", "close");
            }
        } else {
            this.headers.putHeader("Connection", "close");
        }
        this.headers.putDateHeader("Date");
        if (this.status == 403) {
            this.outHeader.print(this.reason(404));
        } else {
            this.outHeader.println(this.reason);
        }
        this.headers.write(this.outHeader);
        this.outHeader.flush();
        byte[] byArray = this.bufHeader.toByteArray();
        this.headerBytes = byArray.length;
        this.out.setHeader(byArray);
    }

    public void setLogging(boolean bl) {
        this.out.setLogging(bl);
    }

    public byte[] getLog() {
        return this.out.getLog();
    }

    public void addDateHeader(String string, long l) {
    }

    public void addHeader(String string, String string2) {
    }

    public void addIntHeader(String string, int n) {
    }

    public void setBufferSize(int n) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void setLocale(Locale locale) {
    }

    public Locale getLocale() {
        return null;
    }

    private StringBuffer addCookie(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><head><title>");
        stringBuffer.append(string);
        stringBuffer.append("</title>\n");
        stringBuffer.append("<style type=\"text/css\">\n");
        stringBuffer.append("<!--\n");
        stringBuffer.append("body {\n");
        stringBuffer.append("\tfont-family: Tahoma, Verdana, Arial, sans-serif;\n");
        stringBuffer.append("\tfont-size:0.8em;\n");
        stringBuffer.append("\tline-height: 150%;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("DIV.errmsg{\n");
        stringBuffer.append("\tpadding-left: 48px;\n");
        stringBuffer.append("\tcolor: #666666;\n");
        stringBuffer.append("\twidth: 85%;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("H2{\n");
        stringBuffer.append("\tcolor: #555555;\n");
        stringBuffer.append("\tfont-size:180%;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("H3{\n");
        stringBuffer.append("\tfont-size:110%;\n");
        stringBuffer.append("\tcolor:#343434;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("hr.in{\n");
        stringBuffer.append("\t\tborder-top: 1px solid #B5C6D1;\n");
        stringBuffer.append("\t\tborder-bottom: 1px solid #FFFFFF;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("-->\n");
        stringBuffer.append("</style>\n");
        stringBuffer.append("</head><body>\n");
        stringBuffer.append("<div>\n");
        stringBuffer.append("  <h2 style=\"margin-top: 10px; margin-bottom: 0px;\">\n");
        stringBuffer.append("    <img id=\"titleImg\" src=\"/images/exception.gif\" alt=\"Error\"  align=\"absmiddle\" hspace=\"8\"/>\n");
        stringBuffer.append("    <span id=\"divErrorTitle\">" + string2 + "</span>\n");
        stringBuffer.append("\t<div style=\"padding-left:70px\"><hr class=\"in\"/></div>\n");
        stringBuffer.append("  </h2>\n");
        stringBuffer.append("</div>\n");
        if (string3 != null) {
            stringBuffer.append("<div class=\"errmsg\">\n");
            stringBuffer.append("    <h3>General Description</h3>\n");
            stringBuffer.append("    <font>\n");
            stringBuffer.append("    " + string3 + "\n");
            stringBuffer.append("    </font>\n");
            stringBuffer.append("    <p/>\n");
            stringBuffer.append("</div>\n");
        }
        stringBuffer.append("<div class=\"errmsg\">\n");
        stringBuffer.append("    <h3>For additional help</h3>\n");
        stringBuffer.append("    <li>Report this issue to your application administrator.</li>\n");
        stringBuffer.append("\t<li>Visit the Customer Care Portal <a href=\"http://www.jinfonet.com/support/\" target=\"_blank\">http://www.jinfonet.com/support</a> and search the FAQs.</li>\n");
        stringBuffer.append("\t<li>Request help from Jinfonet Support <a href=\"mailto:support@jinfonet.com\">support@jinfonet.com</a>.</li>\n");
        stringBuffer.append("</div>\n");
        stringBuffer.append("</body></html>\n");
        return stringBuffer;
    }
}

