/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.util.HtmlEncoder;
import jet.server.util.ServerUtil;
import server.servlet.http.HttpRequest;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServer;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.MessageBytes;

public class HttpServerHandler
extends HttpServerHandlerBase {
    private String I = null;
    private String QOIV = null;

    protected HttpServerHandler(HttpServer httpServer) {
        super(httpServer);
        this.I = httpServer.I().getJspPath();
        this.QOIV = httpServer.getServerPorps().getProperty("web.dhtml_jsp_path");
    }

    protected void service(HttpRequest httpRequest, HttpResponse httpResponse) throws ServletException, IOException {
        MessageBytes messageBytes = httpRequest.getRequestPath();
        String string = this.parsePath(messageBytes, httpRequest);
        ServiceLogger.logDebug(6680040, string, 6);
        String string2 = this.getValidPath(string);
        if (ServerEnv.isVirtualLicence() && ServerEnv.checkExpired() != null && (string2 == null || !string2.endsWith(".gif") && !string2.endsWith(".css"))) {
            string2 = "/jinfonet/expired.jsp";
        }
        if (string2 == null) {
            httpResponse.sendError(404, "The requested resource (" + messageBytes.toString() + ") is not available.");
            return;
        }
        string = string2;
        httpRequest.setServletPath(string);
        if (string.startsWith("/jradmin") || string.startsWith("/admin")) {
            httpResponse.sendError(403, "Please use http admin server port " + this.server.adminport + " to access it!");
            return;
        }
        if (string.toLowerCase().indexOf("<script>") != -1 || string.toLowerCase().indexOf("%3cscript%3e") != -1 || string.toLowerCase().indexOf("javascript:") != -1 || string.toLowerCase().indexOf("vbscript:") != -1) {
            httpResponse.sendError(404, "File not found!");
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        Properties properties = ((HttpServer)this.server).getMappings();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)properties.get(string3);
            if (string3.startsWith(".")) {
                block15: {
                    if (!string.toLowerCase().endsWith(string3.toLowerCase())) continue;
                    if (!new File(this.server.getRealPath(string)).exists()) {
                        httpResponse.sendError(404, "File not found: " + HtmlEncoder.encode(string));
                        return;
                    }
                    Servlet servlet = ((HttpServer)this.server).getServlet(string4);
                    if (servlet == null) {
                        httpResponse.sendError(404, "Cannot load servlet " + string4 + " for serving request");
                        return;
                    }
                    try {
                        servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    }
                    catch (ServletException servletException) {
                        String string5 = servletException.getMessage();
                        if (string5 == null || string5.indexOf("can't mix text and binary input") >= 0) break block15;
                        throw servletException;
                    }
                }
                bl = true;
                break;
            }
            if (string.startsWith(string3) && !string.startsWith(this.QOIV)) {
                Servlet servlet = null;
                String string6 = string.substring(string3.length());
                if (string6.length() == 0 || string6.charAt(0) == '/' || string6.charAt(0) == '\\') {
                    servlet = ((HttpServer)this.server).getServlet(string4);
                }
                if (servlet == null) {
                    httpResponse.sendError(404, "Cannot load servlet " + string4 + " for serving request");
                    return;
                }
                httpRequest.setServletPath(string3);
                String string7 = string.substring(string3.length());
                if (string7.equals("") || string7.equals("/")) {
                    string7 = null;
                }
                httpRequest.setPathInfo(string7);
                servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                bl = true;
                break;
            }
            if (string == null || !string.startsWith(this.I) && !string.startsWith(this.QOIV)) continue;
            bl2 = true;
        }
        if (!bl) {
            this.I(httpRequest, httpResponse, string);
        }
    }

    private void I(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        Object object;
        ServiceLogger.logDebug(6680041, string, 6);
        if (string == null || string.equals("") || string.equals("/")) {
            string = "/index.htm";
        }
        String string2 = string;
        String string3 = "";
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string3 = string2.substring(n);
        }
        String string4 = ServerEnv.getMimeTypeTable().getMimeType(string3);
        httpServletResponse.setContentType(string4);
        try {
            if (string.endsWith("/") || string.endsWith(File.separator) || string.startsWith("/..") || string.endsWith(".jsp.bak")) {
                httpServletResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (string.indexOf("<script>") > 0 || string.indexOf("javascript:") > 0) {
                httpServletResponse.sendError(404, "File not found!");
                return;
            }
            object = new File(this.server.getRealPath(string));
            if (((File)object).isDirectory()) {
                httpServletResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (ServerUtil.isFileNotModified((File)object, httpServletRequest, httpServletResponse)) {
                HttpSession httpSession = httpServletRequest.getSession(false);
                String string5 = httpSession == null ? null : httpSession.getId();
                ServiceLogger.logAccessSuccessEvent(ServerEnv.getActiveRealm(), httpServletRequest.getRemoteUser(), string5, 5680042, string, 5);
                return;
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        httpServletResponse.setStatus(200);
        object = httpServletResponse.getOutputStream();
        InputStream inputStream = this.server.getResourceAsStream(string);
        if (inputStream == null) {
            httpServletResponse.sendError(404, "File " + string + " not found!");
            return;
        }
        httpServletResponse.setContentLength(inputStream.available());
        byte[] byArray = new byte[8192];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                ((OutputStream)object).write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        inputStream.close();
        ((OutputStream)object).close();
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string6 = httpSession == null ? null : httpSession.getId();
        ServiceLogger.logAccessSuccessEvent(ServerEnv.getActiveRealm(), httpServletRequest.getRemoteUser(), string6, 5680043, string, 6);
    }
}

