/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.fake.UserAccount;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;

public class PassCommandHandler
extends AbstractFakeCommandHandler {
    protected void handle(Command command, Session session) {
        String password = command.getRequiredParameter(0);
        String username = (String)this.getRequiredSessionAttribute(session, "username");
        if (this.validateUserAccount(username, session)) {
            UserAccount userAccount = this.getServerConfiguration().getUserAccount(username);
            if (userAccount.isValidPassword(password)) {
                int replyCode = userAccount.isAccountRequiredForLogin() ? 332 : 230;
                String replyMessageKey = userAccount.isAccountRequiredForLogin() ? "pass.needAccount" : "pass";
                this.login(userAccount, session, replyCode, replyMessageKey);
            } else {
                this.sendReply(session, 530, "pass.loginFailed");
            }
        }
    }
}

