/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;

public class CompositeRegistry
implements Registry {
    private List<Registry> registryList;

    public CompositeRegistry() {
        this.registryList = new ArrayList<Registry>();
    }

    public CompositeRegistry(List<Registry> registries) {
        this.registryList = registries;
    }

    public void addRegistry(Registry registry) {
        this.registryList.add(registry);
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        T answer = null;
        for (Registry registry : this.registryList) {
            try {
                answer = registry.lookup(name, type);
                if (answer == null) continue;
                break;
            }
            catch (Throwable e) {
                if (e instanceof NoSuchBeanException) {
                    throw (NoSuchBeanException)e;
                }
                throw new NoSuchBeanException(name, "Cannot lookup: " + name + " from registry: " + registry + " with expected type: " + type + " due: " + e.getMessage(), e);
            }
        }
        return answer;
    }

    @Override
    public Object lookup(String name) {
        Registry registry;
        Object answer = null;
        Iterator<Registry> i$ = this.registryList.iterator();
        while (i$.hasNext() && (answer = (registry = i$.next()).lookup(name)) == null) {
        }
        return answer;
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        Registry registry;
        Map<Object, Object> answer = Collections.emptyMap();
        Iterator<Registry> i$ = this.registryList.iterator();
        while (i$.hasNext() && (answer = (registry = i$.next()).lookupByType(type)).isEmpty()) {
        }
        return answer;
    }
}

