/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileOnCompletion<T>
implements Synchronization {
    private final transient Logger log = LoggerFactory.getLogger(GenericFileOnCompletion.class);
    private GenericFileEndpoint<T> endpoint;
    private GenericFileOperations<T> operations;
    private ExceptionHandler exceptionHandler;
    private GenericFile<T> file;
    private String absoluteFileName;

    public GenericFileOnCompletion(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations, GenericFile<T> file, String absoluteFileName) {
        this.endpoint = endpoint;
        this.operations = operations;
        this.file = file;
        this.absoluteFileName = absoluteFileName;
    }

    @Override
    public void onComplete(Exchange exchange) {
        this.onCompletion(exchange);
    }

    @Override
    public void onFailure(Exchange exchange) {
        this.onCompletion(exchange);
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompletion(Exchange exchange) {
        GenericFileProcessStrategy<T> processStrategy = this.endpoint.getGenericFileProcessStrategy();
        this.log.debug("Done processing file: {} using exchange: {}", this.file, (Object)exchange);
        boolean committed = false;
        try {
            boolean failed = exchange.isFailed();
            if (!failed) {
                this.processStrategyCommit(processStrategy, exchange, this.file);
                committed = true;
            }
        }
        finally {
            if (!committed) {
                this.processStrategyRollback(processStrategy, exchange, this.file);
            }
            this.endpoint.getInProgressRepository().remove(this.absoluteFileName);
        }
    }

    protected void processStrategyCommit(GenericFileProcessStrategy<T> processStrategy, Exchange exchange, GenericFile<T> file) {
        if (this.endpoint.isIdempotent().booleanValue()) {
            this.endpoint.getIdempotentRepository().add(this.absoluteFileName);
        }
        if (this.endpoint.getDoneFileName() != null) {
            String doneFileName = this.endpoint.createDoneFileName(this.absoluteFileName);
            ObjectHelper.notEmpty(doneFileName, "doneFileName", this.endpoint);
            try {
                boolean deleted = this.operations.deleteFile(doneFileName);
                this.log.trace("Done file: {} was deleted: {}", (Object)doneFileName, (Object)deleted);
                if (!deleted) {
                    this.log.warn("Done file: " + doneFileName + " could not be deleted");
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        try {
            this.log.trace("Commit file strategy: {} for file: {}", processStrategy, file);
            processStrategy.commit(this.operations, this.endpoint, exchange, file);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void processStrategyRollback(GenericFileProcessStrategy<T> processStrategy, Exchange exchange, GenericFile<T> file) {
        if (this.log.isWarnEnabled()) {
            this.log.warn("Rollback file strategy: " + processStrategy + " for file: " + file);
        }
        try {
            processStrategy.rollback(this.operations, this.endpoint, exchange, file);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(newt);
    }

    public String toString() {
        return "GenericFileOnCompletion";
    }
}

