/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.validation.PredicateValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateValidatingProcessor
implements Processor,
Traceable {
    private static final Logger LOG = LoggerFactory.getLogger(PredicateValidatingProcessor.class);
    private final Predicate predicate;

    public PredicateValidatingProcessor(Predicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        boolean matches = this.predicate.matches(exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validation {} for {} with Predicate[{}]", new Object[]{matches ? "succeed" : "failed", exchange, this.predicate});
        }
        if (!matches) {
            throw new PredicateValidationException(exchange, this.predicate);
        }
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return "validate(" + this.predicate + ")";
    }

    @Override
    public String getTraceLabel() {
        return "validate[" + this.predicate + "]";
    }
}

