/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import org.apache.camel.util.jsse.JsseParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandomParameters
extends JsseParameters {
    private static final Logger LOG = LoggerFactory.getLogger(SecureRandomParameters.class);
    protected String algorithm;
    protected String provider;

    public SecureRandom createSecureRandom() throws GeneralSecurityException {
        LOG.debug("Creating SecureRandom from SecureRandomParameters: {}", (Object)this);
        SecureRandom secureRandom = this.getProvider() != null ? SecureRandom.getInstance(this.parsePropertyValue(this.getAlgorithm()), this.parsePropertyValue(this.getProvider())) : SecureRandom.getInstance(this.parsePropertyValue(this.getAlgorithm()));
        return secureRandom;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String value) {
        this.algorithm = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SecureRandomParameters [algorithm=");
        builder.append(this.algorithm);
        builder.append(", provider=");
        builder.append(this.provider);
        builder.append(", getContext()=");
        builder.append(this.getCamelContext());
        builder.append("]");
        return builder.toString();
    }
}

