/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.registry;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;

public class RMIFixedPortFirewallSocketFactory
extends RMISocketFactory {
    private static RMISocketFactory factory = null;
    private static ServerSocket exportedObjectfixedSocket = null;
    private int exportedObjectsPort;

    private RMIFixedPortFirewallSocketFactory(int port) {
        this.exportedObjectsPort = port;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (port == 0 && exportedObjectfixedSocket != null) {
            return exportedObjectfixedSocket;
        }
        ServerSocket ss = new ServerSocket(port);
        if (port == this.exportedObjectsPort) {
            exportedObjectfixedSocket = ss;
        }
        return ss;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    public static RMISocketFactory register(int port) throws RemoteException {
        if (factory == null) {
            factory = new RMIFixedPortFirewallSocketFactory(port);
            try {
                RMISocketFactory.setSocketFactory(factory);
            }
            catch (IOException ioe) {
                throw new RemoteException("Cannot set the default registry factory :", ioe);
            }
        }
        return factory;
    }
}

