/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws UnsupportedEncodingException {
        boolean parseResult;
        block7: {
            parseResult = false;
            try {
                Main.processCommandLine(Main.parseCli(args));
                parseResult = true;
                if (parseResult) break block7;
            }
            catch (ParseException e) {
                block8: {
                    System.err.println("Could not parse parameters: " + e.getMessage());
                    e.printStackTrace();
                    if (parseResult) break block8;
                    Main.usage();
                }
                System.exit(parseResult ? 0 : 1);
            }
            catch (Exception e2) {
                block9: {
                    System.err.println("Could not execute Checkstyle: " + e2.getMessage());
                    e2.printStackTrace();
                    if (parseResult) break block9;
                    {
                        catch (Throwable throwable) {
                            if (!parseResult) {
                                Main.usage();
                            }
                            System.exit(parseResult ? 0 : 1);
                            throw throwable;
                        }
                    }
                    Main.usage();
                }
                System.exit(parseResult ? 0 : 1);
            }
            Main.usage();
        }
        System.exit(parseResult ? 0 : 1);
    }

    private static CommandLine parseCli(String[] args) throws ParseException {
        PosixParser clp = new PosixParser();
        return clp.parse(Main.buildOptions(), args);
    }

    private static void processCommandLine(CommandLine line) throws CheckstyleException, UnsupportedEncodingException {
        if (line.hasOption("v")) {
            System.out.println("Checkstyle version: " + Main.class.getPackage().getImplementationVersion());
            return;
        }
        if (!line.hasOption("c")) {
            System.out.println("Must specify a config XML file.");
            return;
        }
        Properties props = line.hasOption("p") ? Main.loadProperties(new File(line.getOptionValue("p"))) : System.getProperties();
        String configFormat = line.getOptionValue("c");
        Configuration config = Main.loadConfig(configFormat, props);
        OutputStream out = null;
        boolean closeOut = false;
        if (line.hasOption("o")) {
            String fname = line.getOptionValue("o");
            try {
                out = new FileOutputStream(fname);
                closeOut = true;
            }
            catch (FileNotFoundException e) {
                throw new CheckstyleException(String.format("Could not find file '%s': %s ", fname, e.getMessage()));
            }
        } else {
            out = System.out;
            closeOut = false;
        }
        String format = line.hasOption("f") ? line.getOptionValue("f") : "plain";
        AuditListener listener = Main.createListener(format, out, closeOut);
        List<File> files = Main.getFilesToProcess(line.getArgs());
        if (files.isEmpty()) {
            throw new CheckstyleException("Must specify files to process, found 0.");
        }
        Checker checker = Main.createChecker(config, listener);
        int errorCounter = checker.process(files);
        checker.destroy();
        if (errorCounter != 0) {
            throw new CheckstyleException(String.format("Checkstyle ends with %d errors.", errorCounter));
        }
    }

    private Main() {
    }

    private static Checker createChecker(Configuration config, AuditListener auditListener) throws CheckstyleException {
        Checker checker = new Checker();
        ClassLoader moduleClassLoader = Checker.class.getClassLoader();
        checker.setModuleClassLoader(moduleClassLoader);
        checker.configure(config);
        checker.addListener(auditListener);
        return checker;
    }

    private static List<File> getFilesToProcess(String[] filesToProcess) throws CheckstyleException {
        LinkedList<File> files = Lists.newLinkedList();
        for (String element : filesToProcess) {
            files.addAll(Main.listFiles(new File(element)));
        }
        return files;
    }

    private static AuditListener createListener(String format, OutputStream out, boolean closeOut) throws UnsupportedEncodingException, CheckstyleException {
        AutomaticBean listener = null;
        switch (format) {
            case "xml": {
                listener = new XMLLogger(out, closeOut);
                break;
            }
            case "plain": {
                listener = new DefaultLogger(out, closeOut);
                break;
            }
            default: {
                throw new CheckstyleException("Invalid output format. Found '" + format + "' but expected 'plain' or 'xml'.");
            }
        }
        return listener;
    }

    private static Configuration loadConfig(String format, Properties props) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(format, new PropertiesExpander(props));
    }

    private static void usage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp(String.format("java %s [options] -c <config.xml> file...", Main.class.getName()), Main.buildOptions());
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption("c", true, "Sets the check configuration file to use.");
        options.addOption("o", true, "Sets the output file. Defaults to stdout");
        options.addOption("p", true, "Loads the properties file");
        options.addOption("f", true, "Sets the output format. (plain|xml). Defaults to plain");
        options.addOption("v", false, "Print product version and exit");
        return options;
    }

    private static List<File> listFiles(File node) {
        LinkedList<File> files = Lists.newLinkedList();
        if (node.canRead()) {
            if (node.isDirectory()) {
                for (File element : node.listFiles()) {
                    files.addAll(Main.listFiles(element));
                }
            } else if (node.isFile()) {
                files.add(node);
            }
        }
        return files;
    }

    private static Properties loadProperties(File file) throws CheckstyleException {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            properties.load(fis);
        }
        catch (IOException e) {
            throw new CheckstyleException(String.format("Unable to load properties from file '%s'.", file.getAbsolutePath()), e);
        }
        return properties;
    }
}

