/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public final class Utils {
    private Utils() {
    }

    public static boolean fileExtensionMatches(File file, String[] fileExtensions) {
        boolean result = false;
        if (fileExtensions == null || fileExtensions.length == 0) {
            result = true;
        } else {
            String[] withDotExtensions = new String[fileExtensions.length];
            for (int i = 0; i < fileExtensions.length; ++i) {
                String extension = fileExtensions[i];
                withDotExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
            }
            String fileName = file.getName();
            for (String fileExtension : withDotExtensions) {
                if (!fileName.endsWith(fileExtension)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean whitespaceBefore(int index, String line) {
        for (int i = 0; i < index; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int lengthMinusTrailingWhitespace(String line) {
        int len = line.length();
        for (int i = len - 1; i >= 0 && Character.isWhitespace(line.charAt(i)); --i) {
            --len;
        }
        return len;
    }

    public static int lengthExpandedTabs(String string, int toIdx, int tabWidth) {
        int len = 0;
        for (int idx = 0; idx < toIdx; ++idx) {
            if (string.charAt(idx) == '\t') {
                len = (len / tabWidth + 1) * tabWidth;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static boolean isPatternValid(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    public static Pattern createPattern(String pattern) throws ConversionException {
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("Failed to initialise regular expression " + pattern, e);
        }
    }

    public static String baseClassname(String type) {
        int i = type.lastIndexOf(46);
        return i == -1 ? type : type.substring(i + 1);
    }

    public static String relativizeAndNormalizePath(String baseDirectory, String path) {
        if (baseDirectory == null) {
            return path;
        }
        Path pathAbsolute = Paths.get(path, new String[0]).normalize();
        Path pathBase = Paths.get(baseDirectory, new String[0]).normalize();
        return pathBase.relativize(pathAbsolute).toString();
    }
}

