/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TranslationCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "translation.missingKey";
    private static final Log LOG = LogFactory.getLog(TranslationCheck.class);
    private final List<File> propertyFiles = Lists.newArrayList();
    private String basenameSeparator;

    public TranslationCheck() {
        this.setFileExtensions(new String[]{"properties"});
        this.setBasenameSeparator("_");
    }

    @Override
    public void beginProcessing(String charset) {
        super.beginProcessing(charset);
        this.propertyFiles.clear();
    }

    @Override
    protected void processFiltered(File file, List<String> lines) {
        this.propertyFiles.add(file);
    }

    @Override
    public void finishProcessing() {
        super.finishProcessing();
        Map<String, Set<File>> propFilesMap = TranslationCheck.arrangePropertyFiles(this.propertyFiles, this.basenameSeparator);
        this.checkPropertyFileSets(propFilesMap);
    }

    private static String extractPropertyIdentifier(File file, String basenameSeparator) {
        String filePath = file.getPath();
        int dirNameEnd = filePath.lastIndexOf(File.separatorChar);
        int baseNameStart = dirNameEnd + 1;
        int underscoreIdx = filePath.indexOf(basenameSeparator, baseNameStart);
        int dotIdx = filePath.indexOf(46, baseNameStart);
        int cutoffIdx = underscoreIdx != -1 ? underscoreIdx : dotIdx;
        return filePath.substring(0, cutoffIdx);
    }

    public void setBasenameSeparator(String basenameSeparator) {
        this.basenameSeparator = basenameSeparator;
    }

    private static Map<String, Set<File>> arrangePropertyFiles(List<File> propFiles, String basenameSeparator) {
        HashMap<String, Set<File>> propFileMap = Maps.newHashMap();
        for (File f : propFiles) {
            String identifier = TranslationCheck.extractPropertyIdentifier(f, basenameSeparator);
            HashSet<File> fileSet = (HashSet<File>)propFileMap.get(identifier);
            if (fileSet == null) {
                fileSet = Sets.newHashSet();
                propFileMap.put(identifier, fileSet);
            }
            fileSet.add(f);
        }
        return propFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Object> loadKeys(File file) {
        HashSet<Object> keys = Sets.newHashSet();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            Properties props = new Properties();
            props.load(inStream);
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                keys.add(e.nextElement());
            }
        }
        catch (IOException e) {
            try {
                this.logIOException(e, file);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(inStream);
                throw throwable;
            }
            Closeables.closeQuietly(inStream);
        }
        Closeables.closeQuietly(inStream);
        return keys;
    }

    private void logIOException(IOException ex, File file) {
        Object[] args = null;
        String key = "general.fileNotFound";
        if (!(ex instanceof FileNotFoundException)) {
            args = new String[]{ex.getMessage()};
            key = "general.exception";
        }
        LocalizedMessage message = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", key, args, this.getId(), this.getClass(), null);
        TreeSet<LocalizedMessage> messages = Sets.newTreeSet();
        messages.add(message);
        this.getMessageDispatcher().fireErrors(file.getPath(), messages);
        LOG.debug("IOException occured.", ex);
    }

    private void compareKeySets(Set<Object> keys, Map<File, Set<Object>> fileMap) {
        Set<Map.Entry<File, Set<Object>>> fls = fileMap.entrySet();
        for (Map.Entry<File, Set<Object>> entry : fls) {
            File currentFile = entry.getKey();
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            String path = currentFile.getPath();
            dispatcher.fireFileStarted(path);
            Set<Object> currentKeys = entry.getValue();
            HashSet<Object> keysClone = Sets.newHashSet(keys);
            keysClone.removeAll(currentKeys);
            if (!keysClone.isEmpty()) {
                for (Object e : keysClone) {
                    this.log(0, MSG_KEY, e);
                }
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    private void checkPropertyFileSets(Map<String, Set<File>> propFiles) {
        Set<Map.Entry<String, Set<File>>> entrySet = propFiles.entrySet();
        for (Map.Entry<String, Set<File>> entry : entrySet) {
            Set<File> files = entry.getValue();
            if (files.size() < 2) continue;
            HashSet<Object> keys = Sets.newHashSet();
            HashMap<File, Set<Object>> fileMap = Maps.newHashMap();
            for (File file : files) {
                Set<Object> fileKeys = this.loadKeys(file);
                keys.addAll(fileKeys);
                fileMap.put(file, fileKeys);
            }
            this.compareKeySets(keys, fileMap);
        }
    }
}

