/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cmsmetrics.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSMetricRecorder
implements Metric {
    private static final Logger LOGGER = LoggerFactory.getLogger(CMSMetricRecorder.class);
    private Graphite graphite;
    private String contextName;

    public CMSMetricRecorder(Graphite graphite, String contextName) {
        this.graphite = graphite;
        this.contextName = contextName;
    }

    public void recordMetrics(String name, String value) {
        try {
            if (!this.graphite.isConnected()) {
                this.graphite.connect();
            }
            this.graphite.send(MetricRegistry.name((String)this.contextName, (String[])new String[]{name}), value, new Date().getTime() / 1000L);
            this.graphite.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to report to Graphite", (Object)this.graphite, (Object)e);
            try {
                this.graphite.close();
            }
            catch (IOException e1) {
                LOGGER.warn("Error closing Graphite", (Object)this.graphite, (Object)e1);
            }
        }
    }
}

