/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test;

import com.ericsson.cms.test.ITester;
import com.ericsson.cms.test.ResultNotifier;
import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestStatus;
import com.ericsson.cms.test.wo.WOTestResult;
import com.ericsson.cms.test.wo.WOTester;
import java.util.Map;

public class StandardWOTestEntry
implements ITester {
    String templateName;
    Map<String, String> parameters;
    long timeoutSeconds;
    boolean dbBackupRequired = false;

    public StandardWOTestEntry(String templateName, Map<String, String> parameters, long timeoutSeconds) {
        this.templateName = templateName;
        this.parameters = parameters;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public void run(ResultNotifier notifier) {
        WOTestResult result = WOTester.test(this.templateName, this.parameters, this.timeoutSeconds);
        this.parameters.remove("command");
        this.parameters.remove("className");
        String testCaseDescription = "templateName:" + this.templateName + "  Parameters:" + this.parameters.toString();
        if (result.getCode() == WOTestResult.Code.SUCCESS) {
            notifier.logTestCaseResult(new TestResult(testCaseDescription, TestStatus.SUCCESS, null));
        } else if (result.getCode() == WOTestResult.Code.FAILURE) {
            notifier.logTestCaseResult(new TestResult(testCaseDescription, TestStatus.FAILURE, result.getMessage()));
        } else if (result.getCode() == WOTestResult.Code.TIMEOUT) {
            notifier.logTestCaseResult(new TestResult(testCaseDescription, TestStatus.FAILURE, "Exceeded timeout " + this.timeoutSeconds + " seconds" + " , " + result.getMessage()));
        }
        notifier.setDbBackupRequired(this.dbBackupRequired);
        notifier.setReady();
    }
}

