/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test;

import com.ericsson.cms.test.DetailedRunStatus;
import com.ericsson.cms.test.ITester;
import com.ericsson.cms.test.ResultNotifier;
import com.ericsson.cms.test.RunStatus;
import com.ericsson.cms.test.StandardUnitTestEntry;
import com.ericsson.cms.test.StandardWOTestEntry;
import com.ericsson.cms.test.TestManagerException;
import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestResults;
import com.ericsson.cms.test.TestStatus;
import com.ericsson.cms.test.util.StringUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public class TestManager {
    private static TestManager instance = new TestManager();
    protected static Logger logger = Logger.getLogger(TestManager.class);
    private ResultNotifier notifier;

    private TestManager() {
    }

    public static TestManager getInstance() {
        return instance;
    }

    public synchronized void startTest(String className, Map<String, String> parms) throws TestManagerException {
        logger.info((Object)("Starting test with " + className + "  Parameters:" + parms.toString()));
        try {
            Object testerObj;
            String testRunId = parms.get("testRunId");
            if (className.trim().endsWith(StandardUnitTestEntry.class.getSimpleName())) {
                String packageName = parms.get("packageName");
                String componentName = parms.get("componentName");
                String dbBackup = parms.get("dbBackupRequired");
                if (packageName == null || packageName.isEmpty()) {
                    throw new TestManagerException("packageName must be specified for " + StandardUnitTestEntry.class.getSimpleName());
                }
                boolean dbBackupRequired = false;
                if (dbBackup != null && !dbBackup.isEmpty() && dbBackup.trim().toLowerCase().equals("true")) {
                    dbBackupRequired = true;
                }
                testerObj = new StandardUnitTestEntry(componentName, packageName, dbBackupRequired);
            } else if (className.trim().endsWith(StandardWOTestEntry.class.getSimpleName())) {
                String templateName = parms.get("templateName");
                if (templateName == null || templateName.isEmpty()) {
                    throw new TestManagerException("templateName must be specified for " + StandardWOTestEntry.class.getSimpleName());
                }
                String timeOut = parms.get("timeoutSeconds");
                if (timeOut == null || timeOut.isEmpty()) {
                    throw new TestManagerException("timeoutSeconds must be specified for " + StandardWOTestEntry.class.getSimpleName());
                }
                Long timeoutSeconds = Long.parseLong(timeOut.trim());
                parms.remove("testRunId");
                parms.remove("templateName");
                parms.remove("timeoutSeconds");
                testerObj = new StandardWOTestEntry(templateName, parms, timeoutSeconds);
            } else {
                Class<?> testerClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                testerObj = testerClass.newInstance();
            }
            if (!(testerObj instanceof ITester)) {
                throw new TestManagerException("Class " + className + " must implement ITester interface");
            }
            this.startTester((ITester)testerObj, className, testRunId);
        }
        catch (ClassNotFoundException ex) {
            throw new TestManagerException("Could not find class " + className, ex);
        }
        catch (InstantiationException ex) {
            throw new TestManagerException("Could not create an instance of " + className, ex);
        }
        catch (IllegalAccessException ex) {
            throw new TestManagerException("Could not create an instance of " + className, ex);
        }
    }

    public synchronized RunStatus getStatus() {
        return this.notifier == null ? RunStatus.READY : this.notifier.getStatus();
    }

    public synchronized DetailedRunStatus getDetailedStatus() {
        DetailedRunStatus status = new DetailedRunStatus();
        if (this.notifier == null) {
            status.setStatus(RunStatus.READY);
        } else {
            status.setStatus(this.notifier.getStatus());
            status.setDbBackupRequired(this.notifier.isDbBackupRequired());
            status.setTestRunId(this.notifier.getTestRunId());
            status.setTestClassName(this.notifier.getTestClassName());
        }
        return status;
    }

    public synchronized TestResults getTestResults() {
        return this.notifier == null ? new TestResults(null) : this.notifier.getTestResults();
    }

    private void startTester(final ITester tester, final String className, String testRunId) {
        this.notifier = new ResultNotifier(className, testRunId);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    tester.run(TestManager.this.notifier);
                }
                catch (Throwable t) {
                    TestResult result = new TestResult(className, TestStatus.FAILURE, StringUtil.getStackTrace(t));
                    TestManager.this.notifier.logTestCaseResult(result);
                    TestManager.this.notifier.setReady();
                }
            }
        };
        thread.start();
    }
}

