/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client;

import com.ericsson.cms.test.client.CommandException;
import com.ericsson.cms.test.client.TestClientConfig;
import com.ericsson.cms.test.client.TestCommandImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RunTestCommand
extends TestCommandImpl {
    private static Logger logger = Logger.getLogger(RunTestCommand.class);
    private String testClassName;
    private String testPackageName;

    public RunTestCommand(String testClassName, String testPackageName, String componentName, String testRunId, TestClientConfig config) {
        super(componentName, testRunId, config);
        this.testClassName = testClassName;
        this.testPackageName = testPackageName;
    }

    @Override
    public void run() throws CommandException {
        this.startServerIfNeeded();
        boolean shouldWait = this.runTest();
        if (shouldWait) {
            this.waitUntilTestComplete();
        }
    }

    private boolean runTest() {
        logger.info((Object)("Calling " + this.config.getServerConfig().getRemoteControllerUrl() + " to run Unit Test: testRunId=" + this.testRunId + " , testClassName=" + this.testClassName + " packageName=" + this.testPackageName));
        try {
            HashMap<String, String> parms = new HashMap<String, String>();
            parms.put("command", "RunTest");
            parms.put("className", this.testClassName);
            parms.put("testRunId", this.testRunId);
            if (this.testPackageName != null && !this.testPackageName.isEmpty()) {
                parms.put("packageName", this.testPackageName);
            }
            this.client.runTest(parms);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Could not start the test.", (Throwable)ex);
            return false;
        }
    }

    public static Map<String, String> getRunTestParms(String testPackageName, String componentName, String testRunId) throws CommandException {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("command", "RunTest");
        parms.put("testRunId", testRunId);
        if (testPackageName != null && !testPackageName.isEmpty()) {
            parms.put("packageName", testPackageName);
        }
        return parms;
    }
}

