/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client;

import com.ericsson.cms.test.StandardWOTestEntry;
import com.ericsson.cms.test.client.CommandException;
import com.ericsson.cms.test.client.TestClientConfig;
import com.ericsson.cms.test.client.TestCommandImpl;
import com.ericsson.cms.test.jaxb.model.ParameterType;
import com.ericsson.cms.test.jaxb.model.WOTestType;
import com.ericsson.cms.test.jaxb.model.WOTestsType;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class RunWOTestsCommand
extends TestCommandImpl {
    String woTestFile;

    public RunWOTestsCommand(String woTestFile, String componentName, String testRunId, TestClientConfig config) {
        super(componentName, testRunId, config);
        this.woTestFile = woTestFile;
    }

    @Override
    public void run() throws CommandException {
        this.startServerIfNeeded();
        List<WOTestType> woTests = this.getWOTestsFromFile();
        for (WOTestType woTest : woTests) {
            List<ParameterType> parms;
            String timeoutSecs;
            String templateName = woTest.getTemplateName();
            Map<String, String> woParms = RunWOTestsCommand.getAllParametersToRunTest(this.testRunId, templateName, timeoutSecs = woTest.getTimeoutSecs(), parms = woTest.getParameterList());
            boolean shouldWait = this.runTest(woParms);
            if (!shouldWait) continue;
            this.waitUntilTestComplete();
        }
    }

    private List<WOTestType> getWOTestsFromFile() throws CommandException {
        try {
            File file = new File(this.woTestFile);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{WOTestsType.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            WOTestsType woTests = (WOTestsType)jaxbUnmarshaller.unmarshal(file);
            List<WOTestType> tests = woTests.getWOTestList();
            return tests;
        }
        catch (JAXBException e) {
            logger.error((Object)"Error loading parameters for WOTests.", (Throwable)e);
            throw new CommandException(e.getMessage());
        }
    }

    private boolean runTest(Map<String, String> parms) {
        logger.info((Object)("Calling " + this.config.getServerConfig().getRemoteControllerUrl() + " to run WOTest: testRunId=" + this.testRunId + " ,run parameters=" + parms.toString()));
        try {
            this.client.runTest(parms);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Could not start the test.", (Throwable)ex);
            return false;
        }
    }

    private static Map<String, String> getAllParametersToRunTest(String runId, String templateName, String timeoutSecs, List<ParameterType> parms) {
        HashMap<String, String> allParms = new HashMap<String, String>();
        allParms.put("templateName", templateName);
        allParms.put("timeoutSeconds", timeoutSecs);
        allParms.put("command", "RunTest");
        allParms.put("className", StandardWOTestEntry.class.getSimpleName());
        allParms.put("testRunId", runId);
        for (ParameterType parm : parms) {
            allParms.put(parm.getName(), parm.getValue());
        }
        return allParms;
    }

    public static List<Map<String, String>> getWOTestsFromFile(URL testFile, String componentName, String runId) throws CommandException {
        ArrayList<Map<String, String>> woTestParms = new ArrayList<Map<String, String>>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{WOTestsType.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            WOTestsType woTests = (WOTestsType)jaxbUnmarshaller.unmarshal(testFile);
            List<WOTestType> tests = woTests.getWOTestList();
            for (WOTestType test : tests) {
                logger.info((Object)("Parameters for WO test:" + test.toString()));
                List<ParameterType> parms = test.getParameterList();
                String templateName = test.getTemplateName();
                String timeoutSecs = test.getTimeoutSecs();
                Map<String, String> woParms = RunWOTestsCommand.getAllParametersToRunTest(runId, templateName, timeoutSecs, parms);
                woTestParms.add(woParms);
            }
            return woTestParms;
        }
        catch (Exception e) {
            logger.error((Object)"Error loading parameters for WOTests.", (Throwable)e);
            throw new CommandException(e.getMessage());
        }
    }
}

