/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client;

import com.ericsson.cms.test.client.TestClientException;
import com.ericsson.cms.test.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class TestClientConfig {
    private ServerConfig serverConfig = new ServerConfig();
    private DBConfig dbConfig = new DBConfig();
    private EmailConfig emailConfig = new EmailConfig();
    private ReportConfig reportConfig = new ReportConfig();

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public DBConfig getDBConfig() {
        return this.dbConfig;
    }

    public EmailConfig getEmailConfig() {
        return this.emailConfig;
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public void load(File file) throws TestClientException {
        Properties props = new Properties();
        try {
            FileReader rd = new FileReader(file);
            props.load(rd);
            rd.close();
            this.serverConfig.set(props);
            this.dbConfig.set(props);
            this.emailConfig.set(props);
            this.reportConfig.set(props);
        }
        catch (IOException ex) {
            throw new TestClientException("Could not load config file", ex);
        }
    }

    public static class ReportConfig {
        private String reportDir;

        public void set(Properties props) {
            this.reportDir = props.getProperty("report.dir", ".");
        }

        public String getReportDir() {
            return this.reportDir;
        }
    }

    public static class EmailConfig {
        private Properties properties = new Properties();
        private String emailFrom;

        public void set(Properties props) {
            String str = props.getProperty("mail.smtp.host");
            if (str != null) {
                this.properties.setProperty("mail.smtp.host", str);
            }
            this.emailFrom = props.getProperty("mail.email.from");
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getEmailFrom() {
            return this.emailFrom;
        }
    }

    public static class DBConfig {
        private String host;
        private int port;
        private String sid;
        private String username;
        private String password;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getSid() {
            return this.sid;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void set(Properties props) {
            this.host = props.getProperty("log.db.host");
            this.port = StringUtil.parseInt(props.getProperty("log.db.host"), 0);
            this.sid = props.getProperty("log.db.sid");
            this.username = props.getProperty("log.db.username");
            this.password = props.getProperty("log.db.password");
        }
    }

    public static class ServerConfig {
        private String remoteControllerUrl;
        private int serverStartTimeoutMins;
        private int testRunTimeoutMins;
        private String stopJbossCmd;
        private String restartJbossCmd;

        public String getRemoteControllerUrl() {
            return this.remoteControllerUrl;
        }

        public int getServerStartTimeoutMins() {
            return this.serverStartTimeoutMins;
        }

        public int getTestRunTimeoutMins() {
            return this.testRunTimeoutMins;
        }

        public String getReStartJbossCmd() {
            return this.restartJbossCmd;
        }

        public String getStopJbossCmd() {
            return this.stopJbossCmd;
        }

        public void set(Properties props) {
            this.remoteControllerUrl = props.getProperty("server.controller.url");
            String str = props.getProperty("server.start.timeoutMins");
            this.serverStartTimeoutMins = StringUtil.parseInt(str, 10);
            str = props.getProperty("test.run.timeoutMins");
            this.testRunTimeoutMins = StringUtil.parseInt(str, 10);
            this.restartJbossCmd = props.getProperty("jboss.server.restart");
            this.stopJbossCmd = props.getProperty("jboss.server.stop");
        }
    }
}

