/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.util;

import com.ericsson.cms.test.util.ClassesFinder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Test;

public class ClassUtil {
    private static final Logger logger = Logger.getLogger(ClassUtil.class);

    public static List<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String fileName = resource.getFile();
            String fileNameDecoded = URLDecoder.decode(fileName, "UTF-8");
            logger.info((Object)("resourceFile in classloader=" + fileNameDecoded + "    path=" + resource.getPath()));
            dirs.add(new File(fileNameDecoded));
        }
        ArrayList classes = new ArrayList();
        if (dirs.isEmpty()) {
            logger.info((Object)("No resource found by classloader for " + path));
        } else {
            for (File directory : dirs) {
                classes.addAll(ClassUtil.findClasses(directory, packageName));
            }
        }
        return classes;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        List<Object> classNames = new ArrayList();
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            String earFile;
            String warFile;
            logger.debug((Object)("Need to open jar/ear/zip to look for classes,  path=" + directory.getPath()));
            ClassesFinder finder = new ClassesFinder();
            String jarFile = ClassesFinder.getPackageFileFromResource(directory.getPath(), "jar");
            if (!jarFile.isEmpty()) {
                finder.addJar(jarFile);
            }
            if (!(warFile = ClassesFinder.getPackageFileFromResource(directory.getPath(), "war")).isEmpty()) {
                finder.addJar(warFile);
            }
            if (!(earFile = ClassesFinder.getPackageFileFromResource(directory.getPath(), "ear")).isEmpty()) {
                finder.addJar(earFile);
            }
            try {
                String path = ClassesFinder.getFullPathOfRootPackageFileFromResource(directory.getPath());
                logger.debug((Object)("Path of package File = " + path));
                classNames = finder.getClasses(path, packageName, true);
                logger.debug((Object)("Classes found in " + jarFile + " = " + classNames.toString()));
                for (String string : classNames) {
                    Class<?> c = ClassUtil.loadClass(string);
                    if (c == null || !ClassUtil.hasJunitAnnotation(c)) continue;
                    classes.add(c);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            void var10_18;
            String fileName = file.getName();
            if (file.isDirectory()) {
                assert (!fileName.contains("."));
                classes.addAll(ClassUtil.findClasses(file, packageName + "." + fileName));
                continue;
            }
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            Object var10_19 = null;
            try {
                Class<?> clazz = ClassUtil.loadClass(packageName + '.' + fileName.substring(0, fileName.length() - 6));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (var10_18 == null || !ClassUtil.hasJunitAnnotation(var10_18)) continue;
            classes.add((Class<?>)var10_18);
        }
        return classes;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> _class = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        return _class;
    }

    public static boolean isOldJUnitTest(Class<?> c) {
        if (c.getSuperclass().getName().equals("java.lang.Object")) {
            return false;
        }
        if (c.getSuperclass().getName().equals("junit.framework.TestCase")) {
            return true;
        }
        return ClassUtil.isOldJUnitTest(c.getSuperclass());
    }

    public static boolean hasJunitAnnotation(Class<?> c) {
        Method[] mets;
        for (Method m : mets = c.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        logger.info((Object)("No JUnit Test found in class " + c.getName()));
        return false;
    }
}

