/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.wo;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

class Dispatcher {
    private static final Logger logger = Logger.getLogger(Dispatcher.class);

    Dispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowMessage send(WorkflowMessage wfsMessage, String destinationURL) throws Exception {
        Document doc = Marshaller.newMarshaller().marshal(wfsMessage);
        logger.debug((Object)("Making SOAP call to " + destinationURL));
        SOAPMessage message = MessageFactory.newInstance().createMessage();
        MimeHeaders headers = message.getMimeHeaders();
        headers.addHeader("SOAPAction", "");
        SOAPBody requestBody = message.getSOAPBody();
        requestBody.addDocument(doc);
        SOAPConnection connection = null;
        SOAPMessage reply = null;
        try {
            connection = SOAPConnectionFactory.newInstance().createConnection();
            reply = connection.call(message, (Object)destinationURL);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        SOAPBody body = reply.getSOAPBody();
        if (body.getFault() != null) {
            SOAPFault fault = body.getFault();
            throw new SOAPException("Got a soap fault in the response: " + fault.getFaultString());
        }
        Document responseDocument = body.extractContentAsDocument();
        WorkflowMessage responseMessage = Unmarshaller.unmarshal((Document)responseDocument);
        if (responseMessage.getType() == WorkflowMessage.MessageType.nack) {
            throw new RuntimeException("Nack response received | Response Message: " + responseMessage);
        }
        return responseMessage;
    }
}

