/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.auth;

import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.entity.IPermission;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.workflow.auth.AuthorizationConfReader;
import com.tandbergtv.workflow.auth.CredentialException;
import com.tandbergtv.workflow.auth.Credentials;
import com.tandbergtv.workflow.auth.ICredentialsManager;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import com.tandbergtv.workflow.core.service.Service;
import java.io.File;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class CredentialsManager
implements ICredentialsManager,
Service {
    private static final Logger logger = Logger.getLogger(CredentialsManager.class);
    private Map<String, Module> modules = new HashMap<String, Module>();
    private List<File> authFiles;
    private String name;

    public CredentialsManager(List<File> authFiles, String name) {
        this.authFiles = authFiles;
        this.name = name;
    }

    public void start() {
        for (File file : this.authFiles) {
            for (Module module : AuthorizationConfReader.getInstance().read(file)) {
                this.modules.put(module.getName(), module);
            }
            logger.info((Object)("Credentials manager initialized, cached " + this.modules.size() + " modules"));
        }
    }

    public void stop() {
        logger.debug((Object)"Credentials manager destroyed");
    }

    public String getServiceName() {
        return this.name;
    }

    @Override
    public Credentials getCredentials(Principal principal) throws CredentialException {
        HashSet<String> actions = new HashSet<String>();
        HashSet<String> sections = new HashSet<String>();
        HashSet<String> menus = new HashSet<String>();
        try {
            InitialContext context = new InitialContext();
            IAuthorizationService neptuneAuthService = (IAuthorizationService)context.lookup("/cms/AuthorizationService/local");
            Set userModules = neptuneAuthService.getAuthorizedPermissionsByModule();
            logger.debug((Object)("userModules.size()=" + userModules.size()));
            for (IModule userModule : userModules) {
                logger.debug((Object)("userModule = " + userModule.getName()));
                Module module = this.modules.get(userModule.getName());
                if (module != null) {
                    for (IPermission userPermission : userModule.getPermissions()) {
                        logger.debug((Object)("userPermission = " + userPermission.getName()));
                        Permission permission = module.getPermission(userPermission.getName());
                        if (permission == null) continue;
                        actions.addAll(permission.getActions());
                        sections.addAll(permission.getSections());
                        menus.addAll(permission.getMenus());
                    }
                    continue;
                }
                for (IPermission userPermission : userModule.getPermissions()) {
                    sections.add(userPermission.getModuleName() + " " + userPermission.getName());
                }
            }
            logger.debug((Object)("actions = " + actions));
            logger.debug((Object)("sections = " + sections));
            logger.debug((Object)("menus = " + sections));
        }
        catch (Exception e) {
            throw new CredentialException("Failed to get credentials", e);
        }
        return new Credentials(principal, actions, sections, menus);
    }
}

