/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableExtensionBuilder;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableConfigExt
implements Serializable {
    private static final String COLUMN_NAME = "ColumnName";
    private static TableConfigExt tableCofig;
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private static String TABLE_TAG_NAME;
    private static String TABLE_ID;
    private static final String DEFAULT_SORTING_COLUMN_NAME = "defaultSortingColumn";
    private static final String DEFAULT_SORTING_ORDER = "defaultSortingOrder";
    private static final String ACTION_PATH = "actionPath";
    private static final String DEFAULT_COLUMN_WIDTH = "defaultColumnWidth";
    private static final String TABLE_I18N_RESOURCE_GROUP = "table-config";
    private static final String TABLE_I18N_RESOURCE_BASE_NAME = "table-config";

    static {
        logger = Logger.getLogger(TableConfigExt.class);
        TABLE_TAG_NAME = "table";
        TABLE_ID = "id";
    }

    public static synchronized TableConfigExt getInstance() {
        if (tableCofig == null) {
            tableCofig = new TableConfigExt();
        }
        return tableCofig;
    }

    public Table getTable(String tableId, File tableConfigFile) {
        return this.getTable(tableId, tableConfigFile, null);
    }

    public Table getTable(String tableId, File tableConfigFile, Map<String, String> runtimeProperties) {
        Map<String, Table> tables = this.getTables(tableConfigFile);
        Table table = tables.get(tableId);
        ClassLoader cl = this.getClass().getClassLoader();
        LocalizedMessageUtil messageUtil = new LocalizedMessageUtil("table-config", "table-config", cl);
        table.getColumns().forEach(c -> {
            String nameKey = c.getColumnAttribute(COLUMN_NAME);
            if (nameKey != null) {
                String localizedName = messageUtil.getMessageValue(nameKey);
                c.setColumnAttribute(COLUMN_NAME, localizedName);
            }
        });
        TableExtensionBuilder extensionBuilder = new TableExtensionBuilder();
        extensionBuilder.buildTable(table, runtimeProperties);
        return table;
    }

    private Map<String, Table> getTables(File tableConfigFile) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        NodeList nodes = this.getNodes(tableConfigFile);
        if (nodes == null) {
            return tables;
        }
        int i = 0;
        while (i < nodes.getLength()) {
            Table table = this.getTable(nodes.item(i));
            tables.put(table.getId(), table);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            tables.keySet().stream().forEach(tableId -> {
                logger.debug((Object)("Table Name-->" + tableId));
                ((Table)tables.get(tableId)).getColumns().forEach(column -> logger.debug((Object)("maps-->" + column.getColumnAttributesMap())));
            });
        }
        return tables;
    }

    private NodeList getNodes(File tableConfigFile) {
        NodeList nodes = null;
        try {
            Document e = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(tableConfigFile);
            nodes = e.getDocumentElement().getElementsByTagName(TABLE_TAG_NAME);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read the table configuration file", (Throwable)e);
        }
        return nodes;
    }

    private String getNodeValue(NamedNodeMap attributes, String name) {
        return attributes.getNamedItem(name).getNodeValue();
    }

    private Table getTable(Node node) {
        Table table = new Table();
        NamedNodeMap attributes = node.getAttributes();
        table.setId(attributes.getNamedItem(TABLE_ID).getNodeValue());
        table.setDefaultSortingColumn(this.getNodeValue(attributes, DEFAULT_SORTING_COLUMN_NAME));
        table.setDefaultSortingOrder(this.getNodeValue(attributes, DEFAULT_SORTING_ORDER));
        table.setActionPath(this.getNodeValue(attributes, ACTION_PATH));
        table.setDefaultColumnWidth(this.getNodeValue(attributes, DEFAULT_COLUMN_WIDTH));
        ArrayList<Column> columns = new ArrayList<Column>();
        if (node.hasChildNodes()) {
            NodeList columnNodeList = node.getChildNodes();
            int j = 0;
            while (j < columnNodeList.getLength()) {
                NodeList columnParams = columnNodeList.item(j).getChildNodes();
                if (columnParams.getLength() > 0) {
                    Column column = new Column();
                    HashMap<String, String> map = new HashMap<String, String>();
                    int k = 0;
                    while (k < columnParams.getLength()) {
                        Node n = columnParams.item(k);
                        NodeList children = n.getChildNodes();
                        int l = 0;
                        while (l < children.getLength()) {
                            map.put(n.getNodeName(), children.item(l).getNodeValue());
                            ++l;
                        }
                        ++k;
                    }
                    column.setColumnAttributesMap(map);
                    columns.add(column);
                }
                ++j;
            }
            table.setColumns(columns);
        }
        return table;
    }
}

