/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PageSizeHandler {
    public static final String PAGE_SIZE_PARAMETER = "pageSize";
    private final String parameterName;
    private final String cookieName;

    public PageSizeHandler(String cookieName) {
        this(PAGE_SIZE_PARAMETER, cookieName);
    }

    public PageSizeHandler(String parameterName, String cookieName) {
        this.parameterName = parameterName;
        this.cookieName = cookieName;
    }

    public int getPageSize(HttpServletRequest request, HttpServletResponse response) {
        String value = request.getParameter(this.parameterName);
        int pageSize = this.getPageSize(value);
        if (pageSize <= 0) {
            pageSize = this.readPageSizeFromCookie(this.cookieName, request);
        } else {
            Cookie cookie = new Cookie(this.cookieName, Integer.toString(pageSize));
            cookie.setMaxAge(Integer.MAX_VALUE);
            response.addCookie(cookie);
        }
        return pageSize;
    }

    private int getPageSize(String value) {
        int pageSize = -1;
        if (value == null) {
            return pageSize;
        }
        if (!(value = value.trim()).isEmpty()) {
            try {
                pageSize = Integer.parseInt(value);
                if (pageSize <= 0) {
                    pageSize = -1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pageSize;
    }

    private int readPageSizeFromCookie(String cookieName, HttpServletRequest request) {
        String value = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                value = cookie.getValue();
                break;
            }
        }
        return this.getPageSize(value);
    }

    public String getPageSizeParameterName() {
        return this.parameterName;
    }

    public String getCookieName() {
        return this.cookieName;
    }
}

