/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.IProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cluster.IClusterService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import java.io.File;
import org.apache.log4j.Logger;

public abstract class AbstractFileListener
implements IProcess {
    private static final Logger LOGGER = Logger.getLogger(AbstractFileListener.class);
    private IClusterService clusterService;
    private ITemplateLoaderService templateLoaderService;

    protected AbstractFileListener() {
    }

    public void fileCreated(FileInfo fileInfo) {
        String path = fileInfo.getAbsolutePath();
        File file = new File(path);
        if (!this.getClusterService().owner((Object)file.getName())) {
            return;
        }
        this.preCreate(file);
        ITemplateReader reader = this.getReader(file);
        this.getTemplateLoaderService().runCompiler(file, reader);
    }

    public void fileDeleted(FileInfo fileInfo) {
        LOGGER.warn((Object)"Ignoring file deleted event");
    }

    public void fileUpdated(FileInfo fileInfo) {
        LOGGER.warn((Object)"Ignoring file updated event");
    }

    protected void preCreate(File file) {
        LOGGER.info((Object)("New file " + file.getAbsolutePath()));
    }

    protected void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    protected void setTemplateLoaderService(ITemplateLoaderService templateLoaderService) {
        this.templateLoaderService = templateLoaderService;
    }

    protected ITemplateLoaderService getTemplateLoaderService() {
        if (this.templateLoaderService == null) {
            this.templateLoaderService = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        }
        return this.templateLoaderService;
    }

    protected abstract ITemplateReader getReader(File var1);
}

